/****************************** 
 *
 * Name:        pipe_receive.c
 * 
 * Description: Receive a message from the IPC pipe
 * 
 * History:     20-APR-93 -Dave Walton- Original coding 
 * 
 ******************************/

#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#include <string.h>

/* Only receive messages from pipe PIPE_NUMBER */
#ifndef PIPE_NUMBER
#define PIPE_NUMBER 1
#endif

char full_buf[] = "Message buffer overflow.  Extra message text discarded.";

main()
{
  register int c;
  int choice;
  register int i;
  int msgflg;
  struct msgbuf *msgp;
  struct msqid_ds buf;
  int msgsz;
  long msgtyp;
  int msqid;
  int maxmsgsz;
  int rtrn;
  char buffer[256];

  if ((msqid = msgget(ftok("/tmp",'A'),0)) == -1)
  {
    perror("msgget failed");
    exit(1);
  }

  maxmsgsz = 256;
  msgp = (struct msgbuf *)malloc((unsigned)sizeof(struct msgbuf) -
    sizeof(msgp->mtext)+ maxmsgsz);
  if (msgp == NULL)
  {
    printf ("Error allocating memory\n");
    exit(1);
  }

  msgsz = 256;
  msgtyp = PIPE_NUMBER;
  msgflg = MSG_NOERROR;
  do
  {
    rtrn = msgrcv(msqid,msgp,msgsz,msgtyp,msgflg);
    if (rtrn == -1)
      perror("msgrcv failed");
    else
    {
      strncpy(buffer,msgp->mtext,rtrn);
      buffer[rtrn] = NULL;
      printf (">>%s<<\n",buffer);
    }   
  } while (strcmp(buffer,"quit") != 0);
}
