/* GNUPLOT - winmain.c */
/*
 * Copyright (C) 1986, 1987, 1990, 1991, 1992   Thomas Williams, Colin Kelley
 *
 * Permission to use, copy, and distribute this software and its
 * documentation for any purpose with or without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and 
 * that both that copyright notice and this permission notice appear 
 * in supporting documentation.
 *
 * Permission to modify the software is granted, but not the right to
 * distribute the modified code.  Modifications are to be distributed 
 * as patches to released version.
 *  
 * This software is provided "as is" without express or implied warranty.
 * 
 *
 * AUTHORS
 * 
 *   Original Software:
 *     Thomas Williams,  Colin Kelley.
 * 
 *   Gnuplot 2.0 additions:
 *       Russell Lang, Dave Kotz, John Campbell.
 *
 *   Gnuplot 3.0 additions:
 *       Gershon Elber and many others.
 * 
 * Send your comments or suggestions to 
 *  info-gnuplot@ames.arc.nasa.gov.
 * This is a mailing list; to join it send a note to 
 *  info-gnuplot-request@ames.arc.nasa.gov.  
 * Send bug reports to
 *  bug-gnuplot@ames.arc.nasa.gov.
 */

/*
 *   Gnuplot for Windows:
 *       Maurice Castro
 */

/* This file implements the initialization code for running gnuplot   */
/* under Microsoft Windows. The code currently compiles only with the */
/* Borland C++ 3.0 compiler. The proprietry EasyWin library is used   */
/* by this implementation.                                            */
/*                                                                    */
/* The modifications to allow Gnuplot to run under Windows were made  */
/* by Maurice Castro. (maurice@bruce.cs.monash.edu.au)                */
/*                                                                    */
/* This is a test version, it currently operates in both Standard and */
/* Enhanced mode in Windows version 3.0 running on a 386SX clone     */
/* Test Version 5 release 7 May 92              - M. Castro          */
 
#include <windows.h>
#include <dos.h>
#include <stdio.h>
#include <string.h>
#include "wincom.h"

/* limits */
#define MAXSTR 255

/* public handles */
HWND FAR hwndgr;
HWND FAR hwndeasy;
HANDLE FAR phInstance;

/* local */
static char FAR szAppName[] = "gnuplot";

/* Global */
char FAR grpname[] = "gnuplot: graph";
char FAR winhelpname[MAXSTR];

/* state */
int gnuWinInit = 0;	/* zero if graphics window uninitialised */

/* EasyWin */
extern POINT _ScreenSize;
extern BOOL _CheckBreak;

int main(int argc, char *argv[], char *env[]);

extern long far PASCAL WndProc(HWND, WORD, WORD, LONG);

/* make the graphic window - callable by term/win.trm */
makegrwin()
{
	HMENU sysmenu;

	hwndgr = CreateWindow(szAppName, (LPSTR)grpname,
		WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, CW_USEDEFAULT, 
		WIN_INITX, WIN_INITY, 
		NULL, NULL, phInstance, NULL);

	/* modify the menu to have the new items we want */
	sysmenu = GetSystemMenu(hwndgr,0);	/* get the sysmenu */
	AppendMenu(sysmenu, MF_SEPARATOR, 0, NULL);
	AppendMenu(sysmenu, MF_STRING, M_COPY_CLIP, "Copy to Clipboard");
	AppendMenu(sysmenu, MF_STRING, M_PRINT, "Print");
	}

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
		LPSTR lpszCmdLine, int cmdShow)
{
	MSG msg;
	WNDCLASS wndclass;

	char modulename[MAXSTR];
	char *modnamtail;

	/* copy the hInstance into a variable so it can be used */
	phInstance = hInstance;

        /* start up the text window */
	_ScreenSize.y = 60;
	_CheckBreak = FALSE;
	_InitEasyWin();

	/* fix up the EasyWindows window provided by Borland */
	GetModuleFileName(hInstance, (LPSTR) modulename, MAXSTR);
	hwndeasy = FindWindow("BCEasyWin", modulename);
	SetWindowText(hwndeasy, szAppName);            /* change title */
	SetClassWord(hwndeasy, GCW_HICON, LoadIcon(hInstance, "texticon"));

	if (_argc>1)
		ShowWindow(hwndeasy,SW_SHOWMINIMIZED);

	/* if this is the first GNUPLOT then register the window class */
	/* for graphics */
	if (!hPrevInstance)
	{
		wndclass.style = CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc = WndProc;
		wndclass.cbClsExtra = 0;
		wndclass.cbWndExtra = 0;
		wndclass.hInstance = hInstance;
		wndclass.hIcon = LoadIcon(hInstance,"grpicon");
		wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground = GetStockObject(WHITE_BRUSH);
		wndclass.lpszMenuName = NULL;
		wndclass.lpszClassName = szAppName;
		RegisterClass(&wndclass);
		}

	/* bring the text window to the front again */
	BringWindowToTop(hwndeasy);

	/* get full name of help file */
	if ((modnamtail = strrchr(modulename,'\\')) != (char *)NULL)
	{
		modnamtail++;
		*modnamtail = NULL;
		strcat(modulename, HELPFILE);
	}
	else {
		strcpy(modulename, HELPFILE);
	}
	strcpy(winhelpname,modulename);

	main(_argc, _argv, environ);
	fcloseall();
 	WinHelp(hwndeasy,(LPSTR)winhelpname,HELP_QUIT,(DWORD)NULL);
	DestroyWindow(hwndeasy);
	return 0;
	}
