/*
 * initialization of global variables to hold status of 'set' options
 *
 */
#include <stdio.h>
#include "plot.h"
#include "global.h"

void init_gnu();

#define DEF_FORMAT   "%g"

void reset_all();

void init_gnu()
{
  term		= 0;		/* unknown term is 0 */
  term_options[0] = 0x0;

  reset_all();
}

void reset_all()
{
  int i;

  timedate    = FALSE;

  dummy_var[0][0] =  'x';
  dummy_var[1][0] =  'y';

	
  strcpy(outstr, "STDOUT");

  rmin = -0.0;
  rmax	=  10.0;
  tmin	= -5.0;
  tmax	=  5.0;
  umin	= -5.0;
  umax	= 5.0;
  vmin	= -5.0;
  vmax	= 5.0;
  xmin	= -10.0;
  xmax	= 10.0;
  ymin	= -10.0;
  ymax	= 10.0;
  zmin	= -10.0;
  zmax	= 10.0;
  
  for ( i = 0; i < MAX_WIN; i++ )
    {
      strcpy( xformat[i], DEF_FORMAT);
      strcpy( yformat[i], DEF_FORMAT);
      strcpy( zformat[i], DEF_FORMAT);
      boxwidth[i]        = -1.0;
      hidden3d[i]        = FALSE;
      below[i]           = 2;
      below_line[i]      = 2;
      surface_rot_z[i]   = 30.0; /* Default 3d transform. */
      surface_rot_x[i]   = 60.0;
      surface_scale[i]   = 1.0;
      surface_zscale[i]  = 1.0;
      dummy_var_win[i][0][0] = 'x'; 
      dummy_var_win[i][1][0] = 'y'; 
      samples[i]	= SAMPLES;
      iso_samples[i]	= ISO_SAMPLES;
      draw_surface[i]    = TRUE;
      draw_contour[i]	= CONTOUR_NONE;
      mapping3d[i]	= MAP3D_CARTESIAN;
      contour_pts[i]	= 5;
      contour_kind[i]	= CONTOUR_KIND_LINEAR;
      contour_order[i]	= 4;
      contour_levels[i]	= 5;
      levels_kind[i]    = LEVELS_AUTO;
      data_style[i]	= POINTS;
      func_style[i]	= LINES;
      draw_border[i]    = TRUE;
      angles_format[i]  = ANGLES_RADIANS;
      key[i] = -1;	            /* default position */
      clip_points[i] = FALSE;
      clip_lines1[i] = TRUE;      
      clip_lines2[i] = FALSE;
      grid[i] = FALSE;
      autoscale_r[i] = TRUE;
      autoscale_t[i] = TRUE;
      autoscale_u[i] = TRUE;
      autoscale_v[i] = TRUE;
      autoscale_x[i] = TRUE;
      autoscale_y[i] = TRUE;
      autoscale_z[i] = TRUE;
      autoscale_lt[i] = TRUE;
      autoscale_lu[i] = TRUE;
      autoscale_lv[i] = TRUE;
      autoscale_lx[i] = TRUE;
      autoscale_ly[i] = TRUE;
      autoscale_lz[i] = TRUE;
      log_x[i] = FALSE;
      log_y[i] = FALSE;
      log_z[i] = FALSE;
      title[i][0] = 0x0;
      xlabel[i][0] = 0x0;
      ylabel[i][0] = 0x0; 
      zlabel[i][0] = 0x0;
      parametric[i] = FALSE;
      polar[i] = FALSE;
      title_xoffset[i]	= 0;
      title_yoffset[i]	= 0;
      xlabel_xoffset[i]	= 0;
      xlabel_yoffset[i]	= 0;
      ylabel_xoffset[i]	= 0;
      ylabel_yoffset[i]	= 0;
      zlabel_xoffset[i]	= 0;
      zlabel_yoffset[i]	= 0;
      rmin_win[i]	= -0.0;
      rmax_win[i]	=  10.0;
      tmin_win[i]	= -5.0;
      tmax_win[i]	=  5.0;
      umin_win[i]	= -5.0;
      umax_win[i]	= 5.0;
      vmin_win[i]	= -5.0;
      vmax_win[i]	= 5.0;
      xmin_win[i]	= -10.0;
      xmax_win[i]	= 10.0;
      ymin_win[i]	= -10.0;
      ymax_win[i]	= 10.0;
      zmin_win[i]	= -10.0;
      zmax_win[i]	= 10.0;
      xzeroaxis[i]      = TRUE;     
      yzeroaxis[i]      = TRUE;
      tic_in[i]         = TRUE;
      xtics[i]          = TRUE;
      ytics[i]          = TRUE;
      ztics[i]          = TRUE;
      ticslevel[i]      = 0.5;
      loff[i]		= 0.0;
      roff[i]		= 0.0;
      toff[i]		= 0.0;
      boff[i]		= 0.0;
      zero[i]           = ZERO;		/* zero threshold, not 0! */
      xticdef[i].type = TIC_COMPUTED;
      yticdef[i].type = TIC_COMPUTED;
      zticdef[i].type = TIC_COMPUTED;

    };

  time_xoffset	= 0;
  time_yoffset	= 0;

  xsize		= 1.0;  /* scale factor for size */
  ysize		= 1.0;  /* scale factor for size */
  zsize		= 1.0;  /* scale factor for size */

  first_label = NULL;
  first_arrow = NULL;

/* --- prf ---*/                  
  coef[0][0][SX] = 1.0;
  coef[0][0][SY] = 1.0;
  coef[0][0][DX] = 0.0;
  coef[0][0][DY] = 0.0;
  coef[0][1][SX] = 1.0;
  coef[0][1][SY] = 1.0;
  coef[0][1][DX] = 0.0;
  coef[0][1][DY] = 0.5;
  coef[0][2][SX] = 0.5;
  coef[0][2][SY] = 1.0;
  coef[0][2][DX] = 0.0;
  coef[0][2][DY] = 0.5;
  coef[0][3][SX] = 0.5;
  coef[0][3][SY] = 1.0;
  coef[0][3][DX] = 0.0;
  coef[0][3][DY] = 0.5;
  coef[1][1][SX] = 1.0;
  coef[1][1][SY] = 0.5;
  coef[1][1][DX] = 0.0;
  coef[1][1][DY] = 0.0;
  coef[1][2][SX] = 1.0;
  coef[1][2][SY] = 1.0;
  coef[1][2][DX] = 0.5;
  coef[1][2][DY] = 0.5;
  coef[1][3][SX] = 1.0;
  coef[1][3][SY] = 1.0;
  coef[1][3][DX] = 0.5;
  coef[1][3][DY] = 0.5;
  coef[2][2][SX] = 1.0;
  coef[2][2][SY] = 0.5;
  coef[2][2][DX] = 0.0;
  coef[2][2][DY] = 0.0;
  coef[2][3][SX] = 0.5;
  coef[2][3][SY] = 0.5;
  coef[2][3][DX] = 0.0;
  coef[2][3][DY] = 0.0;
  coef[3][3][SX] = 1.0;
  coef[3][3][SY] = 0.5;
  coef[3][3][DX] = 0.5;
  coef[3][3][DY] = 0.0;
}







