#ifndef lint
static char *RCSid = "$Id: gnubin.c,v 3.37 1992/05/28 03:31:19 woo Exp woo $";
#endif

/*
 * $Log: gnubin.c,v $
 * Revision 3.37  1992/05/28  03:31:19  woo
 * bug fix of runaway gnuplot_x11.c, SUN util.c, xlib driver & new hidden line removal routines
 *
 * Revision 3.35  1992/03/31  04:49:54  woo
 * BETA 1 of version 3.3 - bug fixes to binary routines
 *
 * Revision 3.35  1992/03/31  04:49:54  woo
 * BETA 1 of version 3.3 - bug fixes to binary routines
 *
 * Revision 3.34  1992/03/27  06:08:57  woo
 * mods for VMS X11 to gnuplot_x11.c and x11.trm
 *
 */

/*
 * The addition of gnu_binary_files and binary_files, along with a small patch
 * to command.c, will permit gnuplot to plot binary files.
 * gnu_binary_files  - contains the code that relies on gnuplot include files
 *                     and other definitions
 * binary_files      - contains those things that are independent of those 
 *                     definitions and files
 *
 * With these routines, hidden line removal of your binary data is possible!
 *
 * Last update: 3/3/92 for Gnuplot 3.24.
 * Created from code for written by RKC for gnuplot 2.0b.
 *
 * Copyright (c) 1991,1992 Robert K. Cunningham, MIT Lincoln Laboratory
 *
 */
#include <stdio.h>
#include <math.h>
#include "plot.h"
#include "setshow.h"
#include "help.h"

/******************* SHARED INCLUDE FILE--start ***********************
 *  I recommend that these be put into an include file that all
 *  will share -- but I leave it up to the powers that be to do this.
 */
/* Copied from command.c -- this should be put in a shared macro file */
#define inrange(z,min,max) ((min<max) ? ((z>=min)&&(z<=max)) : ((z>=max)&&(z<=min)) )

/* Routines for interfacing with command.c */
float *vector();
float *extend_vector();
float *retract_vector();
float **matrix();
float **extend_matrix();
float **retract_matrix();
void free_matrix();
void free_vector();
/******************* SHARED INCLUDE FILE--end *************************/
/*
  Here we keep putting new plots onto the end of the linked list

  We assume the data's x,y values have x1<x2, x2<x3... and 
                                       y1<y2, y2<y3... .
  Actually, I think the assumption is less stron than that--it looks like
  the direction just has to be the same.

  This routine expects the following to be properly initialized:
      log_x, log_y, and log_z 
      xmin,ymin, and zmin
      xmax,ymax, and zmax
      autoscale_lx, autoscale_ly, and autoscale_lz

*/
int
  get_binary_data(this_plot,fp,p_ret_iso)
struct surface_points *this_plot;
FILE *fp;
struct iso_curve **p_ret_iso;
{

  static char data_file[MAX_LINE_LEN+1], line[MAX_LINE_LEN+1];
  register int i,j;
  float **matrix,*rt,*ct;
  int nr,nc;
  int ndata;
  extern int c_token;
  extern int line_num,point_num;
  struct iso_curve *this_iso;
  float z;

  this_plot->plot_type = DATA3D;
  this_plot->has_grid_topology = TRUE;

  if(!fread_matrix(fp,&matrix,&nr,&nc,&rt,&ct))
    int_error("Binary file read error: format unknown!",NO_CARET);

  /* Now we do some error checking on the x and y axis */
  if(log_x)
    for(i=0; i<nc; i++)
      if(ct[i] < 0.0)
	int_error("X value must be above 0 for log scale!",NO_CARET);
      else
	ct[i] = log10(ct[i]);

  if(log_y)
    for(i=0; i<nr; i++)
      if(rt[i] < 0.0)
	int_error("Y value must be above 0 for log scale!",NO_CARET);
      else
	rt[i] = log10(rt[i]);

  /* Count up the number of used column entries */
  if (autoscale_lx) {
    ndata = nc;
    for(j=0; j< nc; j++){
      if (ct[j] < xmin) xmin = ct[j];
      if (ct[j] > xmax) xmax = ct[j];
    }
  }
  else {
    for(ndata = 0, j = 0; j< nc; j++){
      if (!((ct[j] < xmin) || (ct[j] > xmax)))/*Column is in bounds*/
	ndata++;
    }
  }

  for(i=0; i < nr; i++){
      if (autoscale_ly) {
	if (rt[i] < ymin) ymin = rt[i];
	if (rt[i] > ymax) ymax = rt[i];
      }
      else if ((rt[i] < ymin) || (rt[i] > ymax))/* This row is out of bounds */
	continue;

      this_iso = iso_alloc( ndata );/*Allocate the correct number of entries*/
      for(ndata = 0, j = 0; j< nc; j++){/* Cycle through data */

	if ((ct[j] < xmin) || (ct[j] > xmax))/*Column is out of bounds*/
	  continue;       /* Only affects non-autoscale_lx cases */

	this_iso->points[ndata].x = ct[j];
	this_iso->points[ndata].y = rt[i];
	z = matrix[i][j];
	if(log_z)
	  if (z <= 0.0)
	    int_error("Z value must be above 0 for log scale!",NO_CARET);
	  else
	    z = log10(z);
	this_iso->points[ndata].z = z;
      
	if (autoscale_lz) {
	  if (z < zmin) zmin = z;
	  if (z > zmax) zmax = z;
	}
	ndata++;
      }
      this_iso->p_count = ndata;
      this_iso->next = this_plot->iso_crvs;
      this_plot->iso_crvs = this_iso;
      this_plot->num_iso_read++;
  }
  
  free_matrix(matrix,0,nr-1,0,nc-1);
  free_vector(rt,0,nr-1);
  free_vector(ct,0,nc-1);
  *p_ret_iso = this_iso;
  return(ndata+1);
}
