#ifndef lint
static char *RCSid = "$Id: checkdoc.c,v 3.36 1992/04/18 05:45:23 woo Exp $";
#endif

/*
 * $Log: checkdoc.c,v $
 * Revision 3.36  1992/04/18  05:45:23  woo
 * bug fix of thru mod, new stat.inc and prob.demo
 *
 * Revision 3.36  1992/04/18  05:45:23  woo
 * bug fix of thru mod, new stat.inc and prob.demo
 *
 * Revision 3.35  1992/03/31  04:48:19  woo
 * BETA 1 of version 3.3 - bug fixes to binary routines
 *
 * Revision 3.24  1992/02/29  16:15:57  woo
 * gnuplot3.2, beta 4
 *
 * Revision 3.23  1992/02/21  20:16:48  woo
 * gnuplot3.2, beta 3
 *
 */

/*
 * checkdoc -- check a doc file for correctness of first column. 
 *
 * Prints out lines that have an illegal first character.
 * First character must be space, digit, or ?, @, #, %, 
 * or line must be empty.
 *
 * usage: checkdoc < docfile
 * Modified by Russell Lang from hlp2ms.c by Thomas Williams 
 *
 * Original version by David Kotz used the following one line script!
 * sed -e '/^$/d' -e '/^[ 0-9?@#%]/d' gnuplot.doc
 *
 */

#include <stdio.h>
#include <ctype.h>

#define MAX_LINE_LEN	256
#define TRUE 1
#define FALSE 0

main()
{
	convert(stdin,stdout);
	exit(0);
}

convert(a,b)
	FILE *a,*b;
{
    static char line[MAX_LINE_LEN];

    while (fgets(line,MAX_LINE_LEN,a)) {
	   process_line(line, b);
    }
}

process_line(line, b)
	char *line;
	FILE *b;
{
    switch(line[0]) {		/* control character */
	   case '?': {			/* interactive help entry */
		  break;			/* ignore */
	   }
	   case '@': {			/* start/end table */
		  break;			/* ignore */
	   }
	   case '#': {			/* latex table entry */
		  break;			/* ignore */
	   }
	   case '%': {			/* troff table entry */
		  break;			/* ignore */
	   }
	   case '\n':			/* empty text line */
	   case ' ': {			/* normal text line */
		  break;
	   }
	   default: {
		  if (isdigit(line[0])) { /* start of section */
		  		/* ignore */
		  } else
			fputs(line,b);    /* output bad line */
		  break;
	   }
    }
}

