#ifndef lint
static char    *RCSid = "$Id: command.c,v 3.37 1992/05/28 03:31:19 woo Exp woo $";
#endif

/*
 * $Log: command.c,v $
 * Revision 3.37  1992/05/28  03:31:19  woo
 * bug fix of runaway gnuplot_x11.c, SUN util.c, xlib driver & new hidden line removal routines
 * Revision 3.36  1992/04/18  05:47:28  woo bug fix of
 * thru mod, new stat.inc and prob.demo
 * 
 * Revision 3.35  1992/03/31  04:49:54  woo BETA 1 of version 3.3 - bug fixes to
 * binary routines
 * 
 * Revision 3.33  1992/03/27  05:14:14  woo add binary files, does not work
 * under MSDOS BCC 2.0
 * 
 * Revision 3.32  1992/03/20  04:15:09  woo add atari, metafont, hp2623 mods,
 * more nec, pcl5 options
 * 
 * Revision 3.30  1992/03/17  03:43:08  woo add sgtty readline mods and thru
 * mods, detected CRAY bug
 * 
 * Revision 3.29  1992/03/16  00:10:19  woo add discrete contour levels
 * 
 * Revision 3.28  1992/03/15  16:06:22  woo add calln and probability density
 * mods
 * 
 * Revision 3.25  1992/03/14  21:41:36  woo gnuplot3.2, beta 5
 * 
 * Revision 3.24  1992/02/29  16:23:41  woo gnuplot3.2, beta 4
 * 
 * Revision 3.23  1992/02/21  20:18:16  woo gnuplot3.2, beta 3
 * 
 */

/* GNUPLOT - command.c */
/*
 * Copyright (C) 1986, 1987, 1990, 1991, 1992   Thomas Williams, Colin Kelley
 * 
 * Permission to use, copy, and distribute this software and its documentation
 * for any purpose with or without fee is hereby granted, provided that the
 * above copyright notice appear in all copies and that both that copyright
 * notice and this permission notice appear in supporting documentation.
 * 
 * Permission to modify the software is granted, but not the right to distribute
 * the modified code.  Modifications are to be distributed as patches to
 * released version.
 * 
 * This software is provided "as is" without express or implied warranty.
 * 
 * 
 * AUTHORS
 * 
 * Original Software: Thomas Williams,  Colin Kelley.
 * 
 * Gnuplot 2.0 additions: Russell Lang, Dave Kotz, John Campbell.
 * 
 * Gnuplot 3.0 additions: Gershon Elber and many others.
 * 
 * Changes:
 * 
 * Feb 5, 1992	Jack Veenstra	(veenstra@cs.rochester.edu) Added support to
 * filter data values read from a file through a user-defined function before
 * plotting. The keyword "thru" was added to the "plot" command. Example
 * syntax: f(x) = x / 100 plot "test.data" thru f(x) This example divides all
 * the y values by 100 before plotting. The filter function processes the
 * data before any log-scaling occurs. This capability should be generalized
 * to filter x values as well and a similar feature should be added to the
 * "splot" command.
 * 
 * Send your comments or suggestions to info-gnuplot@ames.arc.nasa.gov. This is
 * a mailing list; to join it send a note to
 * info-gnuplot-request@ames.arc.nasa.gov.  Send bug reports to
 * bug-gnuplot@ames.arc.nasa.gov.
 */

#include <stdio.h>
#include <math.h>
#include <ctype.h>
	
#ifdef vms
#include <stdlib>                      /* atof */
#endif

#ifdef AMIGA_AC_5
#include <time.h>
void            sleep();	/* defined later */
#endif

#ifdef _Windows
#include <windows.h>
#include <alloc.h>
#include <setjmp.h>
#include <ctype.h>  /* isalpha(), toupper() */
#include <dir.h>    /* setdisk() */
void sleep();
extern HANDLE FAR phInstance;
extern HANDLE FAR hwndeasy;
extern HANDLE FAR hwndgr;
extern BOOL _KeyPressed(void);
extern jmp_buf FAR env;       /* from plot.c */
extern char FAR winhelpname[];
#endif


#ifdef MSDOS
#include <process.h>

#ifdef __ZTC__
#define P_WAIT 0
#include <time.h>		/* usleep() */
#else

#ifdef __TURBOC__
#ifndef _Windows
#include <dos.h>		/* sleep() */
#include <conio.h>
#include <dir.h>    /* setdisk() */
#include <ctype.h>  /* isalpha(), toupper() */
extern unsigned _stklen = 16394;/* increase stack size */
#endif

#else				/* must be MSC */
#include <time.h>		/* kludge to provide sleep() */
void            sleep();	/* defined later */
#endif				/* TURBOC */
#endif				/* ZTC */

#endif				/* MSDOS */

#ifdef AMIGA_LC_5_1
#include <proto/dos.h>
void            sleep();
#endif				/* AMIGA_LC_5_1 */

#include "plot.h"
#include "setshow.h"
#ifndef _Windows
#include "help.h"
#else
#define MAXSTR 255
#endif

#ifndef STDOUT
#define STDOUT 1
#endif

#ifndef HELPFILE
#ifdef AMIGA_LC_5_1
#define HELPFILE "S:gnuplot.gih"
#else
#define HELPFILE "docs/gnuplot.gih"	/* changed by makefile */
#endif				/* AMIGA_LC_5_1 */
#endif				/* HELPFILE */

#define inrange(z,min,max) ((min<max) ? ((z>=min)&&(z<=max)) : ((z>=max)&&(z<=min)) )

/*
 * instead of <strings.h>
 */

#ifdef _Windows
#include <string.h>
#include <stdlib.h>
#else
extern char    *gets(), *getenv();
extern char    *strcpy(), *strncpy(), *strcat();
extern int      strlen(), strcmp();
#endif

/*
 * Only reference to contours library.
 */
extern struct gnuplot_contours *contour();

#if defined(unix) && !defined(hpux)
#ifdef GETCWD
extern char    *getcwd();	/* some Unix's use getcwd */
#else
extern char    *getwd();	/* most Unix's use getwd */
#endif
#else
extern char    *getcwd();	/* Turbo C, MSC and VMS use getcwd */
#endif

#ifdef vms
int             vms_vkid;	/* Virtual keyboard id */
#endif

/* --- prf --- */
#ifdef  PC
extern char *malloc();
#endif
extern int num_win;
/* --- prf --- */

#ifdef unix
extern FILE    *popen();
static BOOLEAN  pipe_open = FALSE;
#endif

extern int      chdir();

extern double   magnitude(), angle(), real(), imag();
extern struct value *const_express(), *pop(), *complex();
extern struct at_type *temp_at(), *perm_at();
extern struct udft_entry *add_udf();
extern struct udvt_entry *add_udv();
extern void     squash_spaces();
extern void     lower_case();

/* local functions */
static enum coord_type adjustlog();

extern BOOLEAN  interactive;	/* from plot.c */

/* input data, parsing variables */
struct lexical_unit token[MAX_TOKENS];
char            input_line[MAX_LINE_LEN + 1] = "";
int             num_tokens, c_token;
int             inline_num = 0;	/* input line number */

char            c_dummy_var[MAX_NUM_VAR][MAX_ID_LEN + 1];	/* current dummy vars */

/* the curves/surfaces of the plot */
struct curve_points *first_plot = NULL;
struct surface_points *first_3dplot = NULL;
static struct udft_entry plot_func[MAX_WIN];
struct udft_entry *dummy_func;

/* jev -- for passing data thru user-defined function */
static struct udft_entry ydata_func;

/* support for replot command */
char            replot_line[MAX_LINE_LEN + 1] = "";
static int      plot_token;	/* start of 'plot' command */

/* If last plot was a 3d one. */
BOOLEAN         is_3d_plot = FALSE;

com_line()
{
   if (read_line(PROMPT))
       return(1);

    /* So we can flag any new output: if false at time of error, */
    /* we reprint the command line before printing caret. */
    /* TRUE for interactive terminals, since the command line is typed. */
    /* FALSE for non-terminal stdin, so command line is printed anyway. */
    /* (DFK 11/89) */
    screen_ok = interactive;

    if (do_line())
        return(1);
     else
        return(0);
}


do_line()
{				/* also used in load_file */
    if (is_system(input_line[0])) {
	do_system();
	(void) fputs("!\n", stderr);
	return(0);
    }
    num_tokens = scanner(input_line);
    c_token = 0;
    while (c_token < num_tokens) {
	if (command())
           return(1);
	if (c_token < num_tokens)	/* something after command */
	    if (equals(c_token, ";"))
		c_token++;
	    else
		int_error("';' expected", c_token);
    }
    return(0);
}



command()
{
    int             i;
    char            sv_file[MAX_LINE_LEN + 1];
    /* string holding name of save or load file */

    for (i = 0; i < MAX_NUM_VAR; i++)
	c_dummy_var[i][0] = '\0';	/* no dummy variables */

    if (is_definition(c_token))
	define();
    else if (almost_equals(c_token, "h$elp") || equals(c_token, "?")) {
	c_token++;
	do_help();
    } else if (almost_equals(c_token, "test")) {
	c_token++;
	test_term();
    } else if (almost_equals(c_token, "reset")) {
	c_token++;
	reset_all();
    } else if (almost_equals(c_token, "pa$use")) {
	struct value    a;
	int             stime, text = 0;
	char            buf[MAX_LINE_LEN + 1];

	c_token++;
	stime = (int) real(const_express(&a));
	buf[0]='\0';
	if (!(END_OF_COMMAND)) {
	    if (!isstring(c_token))
		int_error("expecting string", c_token);
	    else {
		quotel_str(buf, c_token);
#ifdef _Windows
		if (stime>=0)
#endif
		(void) fprintf(stderr, "%s", buf);
		text = 1;
	    }
	}
	if (stime < 0)
#ifdef _Windows
        {
            if (MessageBox(hwndeasy,(LPSTR) buf,(LPSTR) "gnuplot", MB_OKCANCEL) == IDCANCEL)
                 longjmp(env, TRUE); /* bail out to command line */
         }
#else
	    (void) fgets(buf, MAX_LINE_LEN, stdin);
	/* Hold until CR hit. */
#endif
#ifdef __ZTC__
	if (stime > 0)
	    usleep((unsigned long) stime);
#else
	if (stime > 0)
	    sleep((unsigned int) stime);
#endif
	if (text != 0 && stime >= 0)
	    (void) fprintf(stderr, "\n");
	c_token++;
	screen_ok = FALSE;
    } else if (almost_equals(c_token, "pr$int")) {
	struct value    a;

	c_token++;
	(void) const_express(&a);
	(void) putc('\t', stderr);
	disp_value(stderr, &a);
	(void) putc('\n', stderr);
	screen_ok = FALSE;
    } else if (almost_equals(c_token, "p$lot")) {
	plot_token = c_token++;
	plotrequest();
    } else if (almost_equals(c_token, "sp$lot")) {
	plot_token = c_token++;
	plot3drequest();
    } else if (almost_equals(c_token, "rep$lot")) {
	if (replot_line[0] == '\0')
	    int_error("no previous plot", c_token);
	c_token++;
	replotrequest();
    } else if (almost_equals(c_token, "se$t"))
	set_command();
    else if (almost_equals(c_token, "sh$ow"))
	show_command();
    else if (almost_equals(c_token, "cl$ear")) {
	if (!term_init) {
	    (*term_tbl[term].init) ();
	    term_init = TRUE;
	}
	(*term_tbl[term].graphics) ();
	(*term_tbl[term].text) ();
	(void) fflush(outfile);
	screen_ok = FALSE;
	c_token++;
    } else if (almost_equals(c_token, "she$ll")) {
	do_shell();
	screen_ok = FALSE;
	c_token++;
    } else if (almost_equals(c_token, "sa$ve")) {
	if (almost_equals(++c_token, "f$unctions")) {
	    if (!isstring(++c_token))
		int_error("expecting filename", c_token);
	    else {
		quote_str(sv_file, c_token);
		save_functions(fopen(sv_file, "w"));
	    }
	} else if (almost_equals(c_token, "v$ariables")) {
	    if (!isstring(++c_token))
		int_error("expecting filename", c_token);
	    else {
		quote_str(sv_file, c_token);
		save_variables(fopen(sv_file, "w"));
	    }
	} else if (almost_equals(c_token, "s$et")) {
	    if (!isstring(++c_token))
		int_error("expecting filename", c_token);
	    else {
		quote_str(sv_file, c_token);
		save_set(fopen(sv_file, "w"));
	    }
	} else if (isstring(c_token)) {
	    quote_str(sv_file, c_token);
	    save_all(fopen(sv_file, "w"));
	} else {
	    int_error(
			 "filename or keyword 'functions', 'variables', or 'set' expected",
			 c_token);
	}
	c_token++;
    } else if (almost_equals(c_token, "l$oad")) {
	if (!isstring(++c_token))
	    int_error("expecting filename", c_token);
	else {
	    quote_str(sv_file, c_token);
	    load_file(fopen(sv_file, "r"), sv_file);
	    /* input_line[] and token[] now destroyed! */
	    c_token = num_tokens = 0;
	}
    } else if (almost_equals(c_token, "cd")) {
	if (!isstring(++c_token))
	    int_error("expecting directory name", c_token);
	else {
	    quotel_str(sv_file, c_token);
#ifdef __TURBOC__
	    if (!((strlen(sv_file)==2) && isalpha(sv_file[0]) && (sv_file[1]==':')))
#endif
	    if (chdir(sv_file)) {
		int_error("Can't change to this directory", c_token);
	    }
#ifdef __TURBOC__
	    if (isalpha(sv_file[0]) && (sv_file[1]==':'))
		(void) setdisk(toupper(sv_file[0])-'A');
#endif
	    c_token++;
	}
    } else if (almost_equals(c_token, "pwd")) {
#if defined(unix) && !defined(hpux)
#ifdef GETCWD
	(void) getcwd(sv_file, MAX_ID_LEN);	/* some Unix's use getcwd */
#else
	(void) getwd(sv_file);	/* most Unix's use getwd */
#endif
#else
	/* Turbo C and VMS have getcwd() */
	(void) getcwd(sv_file, MAX_ID_LEN);
#endif
	fprintf(stderr, "%s\n", sv_file);
	c_token++;
    } else if (almost_equals(c_token, "ex$it") ||
	       almost_equals(c_token, "q$uit")) {
	return(1);
    } else if (!equals(c_token, ";")) {	/* null statement */
	int_error("invalid command", c_token);
    }
    return(0);
}

replotrequest()
{
    char            str[MAX_LINE_LEN + 1];
    if (equals(c_token, "["))
	int_error("cannot set range with replot", c_token);
    if (!END_OF_COMMAND) {
	capture(str, c_token, num_tokens - 1);
	if ((strlen(str) + strlen(replot_line)) <= MAX_LINE_LEN - 1) {
	    (void) strcat(replot_line, ",");
	    (void) strcat(replot_line, str);
	} else {
	    int_error("plot line too long with replot arguments", c_token);
	}
    }
    (void) strcpy(input_line, replot_line);
    screen_ok = FALSE;
    num_tokens = scanner(input_line);
    c_token = 1;		/* skip the 'plot' part */
    is_3d_plot ? plot3drequest() : plotrequest();
}


plotrequest()
/*
 * In the parametric case we can say plot [a= -4:4] [-2:2] [-1:1] sin(a),a**2
 * while in the non-parametric case we would say only plot [b= -2:2] [-1:1]
 * sin(b)
 */
{
    int tmp_win;

    BOOLEAN         changed;
    int             dummy_token = -1;

    is_3d_plot = FALSE;

    for ( tmp_win = 0; tmp_win < MAX_WIN; tmp_win++)
      {
	autoscale_lt[tmp_win] = autoscale_t[tmp_win];
	autoscale_lx[tmp_win] = autoscale_x[tmp_win];
	autoscale_ly[tmp_win] = autoscale_y[tmp_win];
	if (parametric[tmp_win] 
	    && strcmp(dummy_var_win[tmp_win][0], "u") == 0)
	  dummy_var_win[tmp_win][0][0] = 't';
      }

    if (!term)			/* unknown */
	int_error("use 'set term' to set terminal type first", c_token);

    eval_plots();
}

plot3drequest()
/*
 * in the parametric case we would say splot [u= -Pi:Pi] [v= 0:2*Pi] [-1:1]
 * [-1:1] [-1:1] sin(v)*cos(u),sin(v)*cos(u),sin(u) in the non-parametric
 * case we would say only splot [x= -2:2] [y= -5:5] sin(x)*cos(y)
 * 
 */
{
    BOOLEAN         changed;
    int             dummy_token0 = -1, dummy_token1 = -1;
    int tmp_win;

    is_3d_plot = TRUE;

    for ( tmp_win = 0; tmp_win < MAX_WIN; tmp_win++) 
      {
	if (parametric[tmp_win] && strcmp(dummy_var_win[tmp_win][0], "t") == 0) {
	  strcpy (dummy_var_win[tmp_win][0], "u");
	  strcpy (dummy_var_win[tmp_win][1], "v");
	}
	autoscale_lx[tmp_win] = autoscale_x[tmp_win];
	autoscale_ly[tmp_win] = autoscale_y[tmp_win];
	autoscale_lz[tmp_win] = autoscale_z[tmp_win];
      }

    if (!term)			/* unknown */
	int_error("use 'set term' to set terminal type first", c_token);

    eval_3dplots();
}


define()
{
    register int    start_token;/* the 1st token in the function definition */
    register struct udvt_entry *udv;
    register struct udft_entry *udf;

    if (equals(c_token + 1, "(")) {
	/* function ! */
	int             dummy_num = 0;
	start_token = c_token;
	do {
	    c_token += 2;	/* skip to the next dummy */
	    copy_str(c_dummy_var[dummy_num++], c_token);
	} while (equals(c_token + 1, ",") && (dummy_num < MAX_NUM_VAR));
	if (equals(c_token + 1, ","))
	    int_error("function contains too many parameters", c_token + 2);
	c_token += 3;		/* skip (, dummy, ) and = */
	if (END_OF_COMMAND)
	    int_error("function definition expected", c_token);
	udf = dummy_func = add_udf(start_token);
	if (udf->at)		/* already a dynamic a.t. there */
	    free((char *) udf->at);	/* so free it first */
	if ((udf->at = perm_at()) == (struct at_type *) NULL)
	    int_error("not enough memory for function", start_token);
	m_capture(&(udf->definition), start_token, c_token - 1);
    } else {
	/* variable ! */
	start_token = c_token;
	c_token += 2;
	udv = add_udv(start_token);
	(void) const_express(&(udv->udv_value));
	udv->udv_undef = FALSE;
    }
}


get_data(this_plot)
    struct curve_points *this_plot;
{
    register int    i, j, l_num, datum;
    int fcol[5], scol[5], ncol[5], prevmin, col;
    register FILE  *fp;
    char            format[MAX_LINE_LEN + 1], data_file[MAX_LINE_LEN + 1],
                    line[MAX_LINE_LEN + 1];
    int tmp_win;
/* conversion variables */
    int n, m, linestat, using;
    char *s;
#ifdef AMIGA_LC_5_1
    int             num_perc_ast;
    char           *start_search;
    float val[5], v[5];
#else
    double val[5], v[5];
#endif				/* AMIGA_LC_5_1 */

    quote_str(data_file, c_token);
    tmp_win = this_plot->plot_window;
    this_plot->plot_type = DATA;
    if (parametric[tmp_win])
	int_error("Parametric data files not yet implemented", NO_CARET);
#ifdef unix
    if (*data_file == '<') {
	if ((fp = popen(data_file + 1, "r")) == (FILE *) NULL)
	    os_error("cannot create pipe; output not changed", c_token);
	else
	    pipe_open = TRUE;
    } else
#endif
    if ((fp = fopen(data_file, "r")) == (FILE *) NULL)
	os_error("can't open data file", c_token);

    format[0] = '\0';
    for (i=0; i<5; i++)
       fcol[i] = i+1;

    using = 0;
    c_token++;			/* skip data file name */

    /* jev -- support for passing data from file thru user function */
    if (almost_equals(c_token, "thru$")) {
	c_token++;
	if (ydata_func.at)
	    free(ydata_func.at);
	dummy_func = &ydata_func;
	ydata_func.at = perm_at();
    } else {
	if (ydata_func.at)
	    free(ydata_func.at);
	ydata_func.at = NULL;
    }

	if (almost_equals(c_token,"u$sing")) {
		using = 1;
		c_token++;  	/* skip "using" */
			
		if (!END_OF_COMMAND && !isstring(c_token)) {
			struct value a;
			for (i=0; i<5; i++)
				fcol[i] = 0;
			fcol[0] = fcol[1] = (int)magnitude(const_express(&a));
			for (i=1; equals(c_token,":") && i<5; i++) {
				c_token++;      /* skip ":" */
				fcol[i] = (int)magnitude(const_express(&a));
			}
		}

		if (!END_OF_COMMAND && isstring(c_token)) {
			quotel_str(format, c_token);
			c_token++;	/* skip format */
		}
	}
    
	/* sort fcol[] into scol[] removing duplicates */
	prevmin = 0;
	for (i=0; i<5; i++) {
	    col = 10000;
		for (j=0; j<5; j++)
			if ((fcol[j]>prevmin) && (fcol[j]<col))
				col = fcol[j];
		if (col <10000)
   		    prevmin = scol[i] = col;
		else
			scol[i] = 0;
	}
    /* normalise fcol[] into ncol[] */
    for (i=0; i<5; i++) {
		ncol[i] = -1;
		if (fcol[i] > 0)
			for (j=0; j<5; j++) {
				if (fcol[i] == scol[j])
					ncol[i] = j;
			}
	}
	/* set col to highest column number */
	col = 0;
	for (i=0; i<5; i++) 
		if (fcol[i]>col) col=fcol[i];

    l_num = 0;
    datum = 0;
    i = 0;
#ifdef AMIGA_LC_5_1
    num_perc_ast = 0;
    start_search = format;
    while (*start_search != '\0') {
	if (start_search[0] == '%')
	    if (start_search[1] == '*')
		num_perc_ast++;
	start_search++;
    }
#endif				/* AMIGA_LC_5_1 */
    while (fgets(line, MAX_LINE_LEN, fp) != (char *) NULL) {
	l_num++;
	if (is_comment(line[0]))
	    continue;		/* ignore comments */
	if (i >= this_plot->p_max) {
	    /*
	     * overflow about to occur. Extend size of points[] array. We
	     * either double the size, or add 1000 points, whichever is a
	     * smaller increment. Note i=p_max.
	     */
	    cp_extend(this_plot, i + (i < 1000 ? i : 1000));
	}
	if (!line[1]) {		/* is it blank line ? */
	    /* break in data, make next point undefined */
	    this_plot->points[i].type = UNDEFINED;
	    i++;
	    continue;
	}
		if (strlen(format) != 0) {
			/* use old sscanf if a format string was given */
#ifdef AMIGA_LC_5_1
			m = sscanf(line, format, &val[0], &val[1], &val[2], &val[3], &val[4])
				- num_perc_ast;
#else /* AMIGA_LC_5_1 */
			m = sscanf(line, format, &val[0], &val[1], &val[2], &val[3], &val[4]);
#endif /* AMIGA_LC_5_1 */
		}
		else {
			/* implement our own sscanf that skips lines with invalid data 
			 * if a using statement was given */
			/* convert the array to a its constituents */
			for(n=0; n<5; n++)			/* wipe the array */
				val[n] = 0.0;
			n=0;						/* n is column number */
			m=0;						/* m is number of values read */
			linestat = 1;				/* linestat: 1 OK 2 bad value 0 EOL */
			s = line;
			while ((linestat == 1) && (n<col)) {
				while (isspace(*s)) s++;
				if (*s == NULL) {
					linestat = 0;
					break;
				}
				n++;
				if (n == scol[m]) {
					if (isdigit(*s) || *s=='-' || *s=='+' || *s=='.') {
						val[m] = atof(s);
						m++;
					}
					else
						linestat = 2;	/* abort the line non-digit in req loc */
				}
				while ((!isspace(*s)) && (*s != NULL)) s++;
			}

			if (using && (linestat == 2))
				continue;	/* skip lines where a using pattern is present and not met */
		}

		for (j=0; j<5 && ncol[j]>=0 && ncol[j]<m ; j++)
			v[j] = val[ncol[j]];
		switch (j) {
		    case 1: {		/* only one number */
		    	/* x is index, assign number to y */
				v[1]=v[0];
				v[0]=datum;
				/* nobreak */
		    }
		    case 2: {		/* x, y */
				/* ylow and yhigh are same as y */
				datum++;
				store2d_point(this_plot, i++, v[0], v[1], v[1], v[1], -1.0);
				break;
		    }
		    case 3: {		/* x, y, ydelta */
				/* ydelta is in the ylow variable */
				datum++;
				store2d_point(this_plot, i++, v[0], v[1], v[1]-v[2], v[1]+v[2], -1.0);
				break;
		    }
		    case 4: {		/* x, y, ylow, yhigh */
				datum++;
				store2d_point(this_plot, i++, v[0], v[1], v[2], v[3], -1.0);
				break;
		    }
		    case 5: {		/* x, y, ylow, yhigh, width */
				datum++;
				store2d_point(this_plot, i++, v[0], v[1], v[2], v[3], v[4]);
				break;
		    }
		    default: {
			   (void) sprintf(line, "bad data on line %d", l_num);
			   int_error(line,c_token);
		    }
		}
    }
    this_plot->p_count = i;
    cp_extend(this_plot, i);	/* shrink to fit */

#ifdef unix
    if (pipe_open) {
	(void) pclose(fp);
	pipe_open = FALSE;
    } else
#endif
	(void) fclose(fp);
}

/* called by get_data for each point */
store2d_point(this_plot, i, x, y, ylow, yhigh, width)
    struct curve_points *this_plot;
    int             i;		/* point number */
#ifdef AMIGA_LC_5_1
    double          x, y;
    double          ylow, yhigh;
    double          width;
#else
    float           x, y;
    float           ylow, yhigh;
    float           width;
#endif
{
    struct coordinate *cp = &(this_plot->points[i]);
    int tmp_win;

    tmp_win = this_plot->plot_window;

    /* the easy part: */
    cp->type = INRANGE;
    cp->x = x;
    cp->y = y;
    cp->ylow = ylow;
    cp->yhigh = yhigh;
    cp->z = width;

    /* jev -- pass data values thru user-defined function */
    if (ydata_func.at) {
	struct value    val;

	(void) complex(&ydata_func.dummy_values[0], y, 0.0);
	evaluate_at(ydata_func.at, &val);
	cp->y = real(&val);

	(void) complex(&ydata_func.dummy_values[0], ylow, 0.0);
	evaluate_at(ydata_func.at, &val);
	cp->ylow = real(&val);

	(void) complex(&ydata_func.dummy_values[0], yhigh, 0.0);
	evaluate_at(ydata_func.at, &val);
	cp->yhigh = real(&val);
    }
    /* Adjust for log scale. */
    if (log_x[tmp_win]) {
	    cp->type = adjustlog(cp->type, &(cp->x));
        (void) adjustlog(cp->type, &(cp->z));
    }
    if (log_y[tmp_win]) {
	cp->type = adjustlog(cp->type, &(cp->y));
	/* Note ylow,yhigh can't affect cp->type. */
	(void) adjustlog(cp->type, &(cp->ylow));
	(void) adjustlog(cp->type, &(cp->yhigh));
    }
    /* Now adjust the xrange, or declare the point out of range */
    /*
     * The yrange is handled later, once we know whether to include ylow,
     * yhigh in the calculation. See adjust_yrange()
     */
    if (cp->type == INRANGE)
	 if (autoscale_lx[tmp_win] || inrange(x,xmin_win[tmp_win],xmax_win[tmp_win])) {
		if (autoscale_lx[tmp_win]) {
		    if (x < xmin_win[tmp_win]) 
		      xmin_win[tmp_win] = x;
		    if (x > xmax_win[tmp_win]) 
		      xmax_win[tmp_win] = x;
		}

	} else {
	    cp->type = OUTRANGE;
	}
}

/*
 * Adjust for log scale: take the log of the second parameter, in place, if
 * possible. If not possible, return new type for point; if possible, then
 * return old type for point.
 */
static enum coord_type
adjustlog(type, val)
    enum coord_type type;
    coordval       *val;
{
    if (*val < 0.0) {
	return (UNDEFINED);
    } else if (*val == 0.0) {
	*val = -VERYLARGE;
	return (OUTRANGE);
    } else {
	*val = log10(*val);
	return (type);
    }
}


/* now adjust the yrange, or declare the point out of range */
/* this does all points in a curve */
adjust_yrange(curve)
    struct curve_points *curve;
{
    BOOLEAN         ebars = (curve->plot_style == ERRORBARS);
    int             npoints = curve->p_count;	/* number of points */
    coordval        y, ylow, yhigh;	/* one point value */
    struct coordinate *cp;	/* one coordinate */
    int             i;		/* index into points */
    int tmp_win;

    tmp_win = curve->plot_window;

    for (i = 0; i < npoints; i++) {
	cp = &(curve->points[i]);
	if (cp->type == INRANGE) {
	    y = log_y[tmp_win] ? pow(10.0, cp->y) : cp->y;
	    if ((autoscale_ly[tmp_win] ||
	    /*
	     * inrange((log_y ? pow(10.0, y) : y), ymin, ymax) ||
	     */
		 inrange(y, ymin_win[tmp_win], ymax_win[tmp_win]) ||
		 polar[tmp_win])) {
		if (autoscale_ly[tmp_win]) {
		  if (y < ymin_win[tmp_win]) 
		    ymin_win[tmp_win] = y;
		  if (y > ymax_win[tmp_win]) 
		    ymax_win[tmp_win] = y;
		  if (ebars) {
			ylow = log_y[tmp_win] ? pow(10.0, cp->ylow) : cp->ylow;
			yhigh = log_y[tmp_win] ? pow(10.0, cp->yhigh) : cp->yhigh;
			if (ylow < ymin_win[tmp_win]) 
			  ymin_win[tmp_win] = ylow;
			if (ylow > ymax_win[tmp_win]) 
			  ymax_win[tmp_win] = ylow;
			if (yhigh < ymin_win[tmp_win]) 
			  ymin_win[tmp_win] = yhigh;
			if (yhigh > ymax_win[tmp_win]) 
			  ymax_win[tmp_win] = yhigh;
		    }
		}
	    } else {
		cp->type = OUTRANGE;
	    }
	}
    }
}


get_3ddata(this_plot)
    struct surface_points *this_plot;
{
    register int    i, j, l_num, xdatum, ydatum;
    register FILE  *fp;
    float           x, y, z;
    BOOLEAN         only_z = FALSE;
    char            format[MAX_LINE_LEN + 1], data_file[MAX_LINE_LEN + 1],
                    line[MAX_LINE_LEN + 1];
    char           *float_format = "%f", *float_skip = "%*f";
    int             xcol = 1, ycol = 2, zcol = 3, pt_in_iso_crv = 0, maxcol;
    enum XYZ_order_type {
	XYZ, YXZ, ZXY, XZY, ZYX, YZX, XY, YX
    }               xyz_order;
    struct iso_curve *this_iso;
#ifdef AMIGA_LC_5_1
    int             num_perc_ast;
    char           *start_search;
#endif				/* AMIGA_LC_5_1 */
int tmp_win;

    tmp_win = this_plot->plot_window;
    quote_str(data_file, c_token);
    this_plot->plot_type = DATA3D;
    this_plot->has_grid_topology = TRUE;
#ifdef unix
    if (*data_file == '<') {
	if ((fp = popen(data_file + 1, "r")) == (FILE *) NULL)
	    os_error("cannot create pipe; output not changed", c_token);
	else
	    pipe_open = TRUE;
    } else
#endif
    if ((fp = fopen(data_file, "r")) == (FILE *) NULL)
	os_error("can't open data file", c_token);

    format[0] = '\0';
    c_token++;			/* skip data file name */
    if (almost_equals(c_token, "u$sing")) {
	c_token++;		/* skip "using" */
	if (!END_OF_COMMAND && !isstring(c_token)) {
	    struct value    a;
	    zcol = (int) magnitude(const_express(&a));
	    only_z = TRUE;
	    if (equals(c_token, ":")) {
		c_token++;	/* skip ":" */
		only_z = FALSE;
		ycol = zcol;
		zcol = (int) magnitude(const_express(&a));
		if (equals(c_token, ":")) {
		    c_token++;	/* skip ":" */
		    xcol = ycol;
		    ycol = zcol;
		    zcol = (int) magnitude(const_express(&a));
		} else {
		    if (mapping3d[tmp_win] == MAP3D_CARTESIAN)
			int_error("Must specify 1 or 3 columns", c_token);
		    xcol = ycol;
		    ycol = zcol;
		}
	    }
	    if (!only_z)
		if ((xcol == ycol) || (ycol == zcol) || (xcol == zcol))
		    int_error("Columns must be distinct", c_token);
	}
	if (!END_OF_COMMAND && isstring(c_token)) {
	    quotel_str(format, c_token);
	    c_token++;		/* skip format */
	}
    } else {
	if (only_z = !parametric[tmp_win])
	    zcol = 1;
    }

    switch (mapping3d[tmp_win]) {
    case MAP3D_CARTESIAN:
	maxcol = (xcol > ycol) ? xcol : ycol;
	maxcol = (maxcol > zcol) ? maxcol : zcol;
	if (!only_z) {		/* Determine ordering of input columns */
	    if (zcol == maxcol) {
		if (xcol < ycol)
		    xyz_order = XYZ;	/* scanf(x,y,z) */
		else
		    xyz_order = YXZ;	/* scanf(y,x,z) */
	    } else if (ycol == maxcol) {
		if (xcol < zcol)
		    xyz_order = XZY;	/* scanf(x,z,y) */
		else
		    xyz_order = ZXY;	/* scanf(z,x,y) */
	    } else {
		if (ycol < zcol)
		    xyz_order = YZX;	/* scanf(y,z,x) */
		else
		    xyz_order = ZYX;	/* scanf(z,y,x) */
	    }
	}
	if (strlen(format) == 0) {
	    if (only_z) {
		for (i = 1; i <= zcol; i++)
		    if (i == zcol)
			(void) strcat(format, float_format);
		    else
			(void) strcat(format, float_skip);
	    } else {
		for (i = 1; i <= maxcol; i++)
		    if ((i == xcol) || (i == ycol) || (i == zcol))
			(void) strcat(format, float_format);
		    else
			(void) strcat(format, float_skip);
	    }
	}
	break;
    case MAP3D_SPHERICAL:
    case MAP3D_CYLINDRICAL:
	if (only_z)
	    int_error("Two columns for spherical/cylindrical coords.", c_token);
	maxcol = (xcol > ycol) ? xcol : ycol;
	xyz_order = (xcol < ycol) ? XY : YX;
	for (i = 1; i <= maxcol; i++)
	    if ((i == xcol) || (i == ycol))
		(void) strcat(format, float_format);
	    else
		(void) strcat(format, float_skip);
    }
#ifdef AMIGA_LC_5_1
    num_perc_ast = 0;
    start_search = format;
    while (*start_search != '\0') {
	if (start_search[0] == '%')
	    if (start_search[1] == '*')
		num_perc_ast++;
	start_search++;
    }
#endif				/* AMIGA_LC_5_1 */

    l_num = 0;
    xdatum = 0;
    ydatum = 0;
    this_plot->num_iso_read = 0;
    this_plot->has_grid_topology = TRUE;
    if (this_plot->iso_crvs != NULL) {
	struct iso_curve *icrv, *icrvs = this_plot->iso_crvs;

	while (icrvs) {
	    icrv = icrvs;
	    icrvs = icrvs->next;
	    iso_free(icrv);
	}
	this_plot->iso_crvs = NULL;
    }
    if (is_binary_file(fp)) {	/* MOD--RKC */
#ifdef PC
	/* file must be opened with binary flag. why? */
	fp = freopen(data_file, "rb", fp);
#endif
	xdatum = get_binary_data(this_plot, fp, &this_iso);
    } else {
	this_iso = iso_alloc(samples[tmp_win]);

	while (fgets(line, MAX_LINE_LEN, fp) != (char *) NULL) {
	    l_num++;
	    if (is_comment(line[0]))
		continue;	/* ignore comments */
	    if (!line[1]) {	/* is it blank line ? */
		if (pt_in_iso_crv == 0) {
		    if (xdatum == 0)
			continue;
		    pt_in_iso_crv = xdatum;
		}
		if (xdatum > 0) {
		    this_iso->p_count = xdatum;
		    this_iso->next = this_plot->iso_crvs;
		    this_plot->iso_crvs = this_iso;
		    this_plot->num_iso_read++;

		    if (xdatum != pt_in_iso_crv)
			this_plot->has_grid_topology = FALSE;

		    this_iso = iso_alloc(pt_in_iso_crv);
		    xdatum = 0;
		    ydatum++;
		}
		continue;
	    }
	    if (xdatum >= this_iso->p_max) {
		/*
		 * overflow about to occur. Extend size of points[] array. We
		 * either double the size, or add 1000 points, whichever is a
		 * smaller increment. Note i=p_max.
		 */
		iso_extend(this_iso,
			   xdatum + (xdatum < 1000 ? xdatum : 1000));
	    }
#ifdef AMIGA_LC_5_1
	    switch (sscanf(line, format, &x, &y, &z) - num_perc_ast) {
#else
	    switch (sscanf(line, format, &x, &y, &z)) {
#endif
	    case 3:		/* All parameter are specified. */
		if (!only_z) {
		    switch (xyz_order) {
		    case XYZ:	/* scanf(x,y,z) */
			this_iso->points[xdatum].x = x;
			this_iso->points[xdatum].y = y;
			this_iso->points[xdatum].z = z;
			break;
		    case XZY:	/* scanf(x,z,y) */
			this_iso->points[xdatum].x = x;
			this_iso->points[xdatum].y = z;
			this_iso->points[xdatum].z = y;
			break;
		    case YXZ:	/* scanf(y,x,z) */
			this_iso->points[xdatum].x = y;
			this_iso->points[xdatum].y = x;
			this_iso->points[xdatum].z = z;
			break;
		    case ZXY:	/* scanf(z,x,y) */
			this_iso->points[xdatum].x = y;
			this_iso->points[xdatum].y = z;
			this_iso->points[xdatum].z = x;
			break;
		    case YZX:	/* scanf(y,z,x) */
			this_iso->points[xdatum].x = z;
			this_iso->points[xdatum].y = x;
			this_iso->points[xdatum].z = y;
			break;
		    case ZYX:	/* scanf(z,y,x) */
			this_iso->points[xdatum].x = z;
			this_iso->points[xdatum].y = y;
			this_iso->points[xdatum].z = x;
			break;
		    }
		    if (xyz_order != XYZ) {
			x = this_iso->points[xdatum].x;
			y = this_iso->points[xdatum].y;
			z = this_iso->points[xdatum].z;
		    }
		    if (!parametric[tmp_win])
			int_error("Must be in parametric mode.",
				  NO_CARET);
		    break;
		}
	    case 1:		/* only one number on the line */
		if (!only_z)
		    int_error("3 columns expected, only 1 found", c_token);
		/* assign that number to z */
		this_iso->points[xdatum].z = x;
		z = x;
		this_iso->points[xdatum].x = xdatum;
		x = this_iso->points[xdatum].x;
		this_iso->points[xdatum].y = ydatum;
		y = this_iso->points[xdatum].y;
		if (parametric[tmp_win])
		    int_error("Must be in non parametric mode.",
			      NO_CARET);
		break;
	    case 2:
		switch (xyz_order) {
		case YX:
		    z = x;	/* Use z as temp */
		    x = y;
		    y = z;
		    break;
		default:
		    break;
		}
		switch (mapping3d[tmp_win]) {
		case MAP3D_CARTESIAN:
		    int_error("2 columns found, 3 expected",
			      c_token);
		    break;
		case MAP3D_SPHERICAL:
		    if (angles_format[tmp_win] == ANGLES_DEGREES) {
			x *= DEG2RAD;	/* Convert to radians. */
			y *= DEG2RAD;
		    }
		    this_iso->points[xdatum].x = cos(x) * cos(y);
		    this_iso->points[xdatum].y = sin(x) * cos(y);
		    this_iso->points[xdatum].z = sin(y);
		    break;
		case MAP3D_CYLINDRICAL:
		    if (angles_format[tmp_win] == ANGLES_DEGREES)
			x *= DEG2RAD;	/* Convert to radians. */
		    this_iso->points[xdatum].x = cos(x);
		    this_iso->points[xdatum].y = sin(x);
		    this_iso->points[xdatum].z = y;
		    break;
		}
		x = this_iso->points[xdatum].x;
		y = this_iso->points[xdatum].y;
		z = this_iso->points[xdatum].z;
		break;
	    default:
		(void) sprintf(line, "bad data on line %d", l_num);
		int_error(line, c_token);
	    }

	    if (log_x[tmp_win]) {
		if (x < 0.0)
		    int_error("X value must be above 0 for log scale!",
			      NO_CARET);
		else
		    this_iso->points[xdatum].x =
			log10(this_iso->points[xdatum].x);
	    }
	    if (log_y[tmp_win]) {
		if (y < 0.0)
		    int_error("Y value must be above 0 for log scale!",
			      NO_CARET);
		else
		    this_iso->points[xdatum].y =
			log10(this_iso->points[xdatum].y);
	    }
	    if (log_z[tmp_win]) {
		if (z < 0.0)
		    int_error("Z value must be above 0 for log scale!",
			      NO_CARET);
		else
		    this_iso->points[xdatum].z =
			log10(this_iso->points[xdatum].z);
	    }
	    if (autoscale_lx[tmp_win]) {
	      if (x < xmin_win[tmp_win]) 
		xmin_win[tmp_win] = x;
	      if (x > xmax_win[tmp_win]) 
		xmax_win[tmp_win] = x;
	    }
	    if (autoscale_ly[tmp_win]) {
	      if (y < ymin_win[tmp_win]) 
		ymin_win[tmp_win] = y;
	      if (y > ymax_win[tmp_win]) 
		ymax_win[tmp_win] = y;
	    }
	    if (autoscale_lz[tmp_win]) {
	      if (z < zmin_win[tmp_win]) 
		zmin_win[tmp_win] = z;
	      if (z > zmax_win[tmp_win]) 
		zmax_win[tmp_win] = z;
	    }
	    xdatum++;
	}

	if (xdatum > 0) {
	    this_plot->num_iso_read++;	/* Update last iso. */
	    this_iso->p_count = xdatum;

	    this_iso->next = this_plot->iso_crvs;
	    this_plot->iso_crvs = this_iso;

	    if (xdatum != pt_in_iso_crv)
		this_plot->has_grid_topology = FALSE;

	} else {
	    iso_free(this_iso);	/* Free last allocation. */
	}
    }				/* MOD-RKC else of binary */
#ifdef unix
    if (pipe_open) {
	(void) pclose(fp);
	pipe_open = FALSE;
    } else
#endif
	(void) fclose(fp);
    if (this_plot->num_iso_read <= 1)
	this_plot->has_grid_topology = FALSE;
    if (this_plot->has_grid_topology && !hidden3d[tmp_win]) {
	struct iso_curve *new_icrvs = NULL;
	int             num_new_iso = this_plot->iso_crvs->p_count, len_new_iso = this_plot->num_iso_read;

	/* Now we need to set the other direction (pseudo) isolines. */
	for (i = 0; i < num_new_iso; i++) {
	    struct iso_curve *new_icrv = iso_alloc(len_new_iso);

	    new_icrv->p_count = len_new_iso;

	    for (j = 0, this_iso = this_plot->iso_crvs;
		 this_iso != NULL;
		 j++, this_iso = this_iso->next) {
		new_icrv->points[j].x = this_iso->points[i].x;
		new_icrv->points[j].y = this_iso->points[i].y;
		new_icrv->points[j].z = this_iso->points[i].z;
	    }

	    new_icrv->next = new_icrvs;
	    new_icrvs = new_icrv;
	}

	/* Append the new iso curves after the read ones. */
	for (this_iso = this_plot->iso_crvs;
	     this_iso->next != NULL;
	     this_iso = this_iso->next);
	this_iso->next = new_icrvs;
    }
}

/*
 * print_points: a debugging routine to print out the points of a curve, and
 * the curve structure. If curve<0, then we print the list of curves.
 */
static char    *plot_type_names[4] =
{
    "Function", "Data", "3D Function", "3d data"
};
static char    *plot_style_names[6] =
{
    "Lines", "Points", "Impulses", "LinesPoints", "Dots", "Errorbars"
};

print_points(curve)
    int             curve;	/* which curve to print */
{
    register struct curve_points *this_plot;
    int             i;

    if (curve < 0) {
	for (this_plot = first_plot, i = 0;
	     this_plot != NULL;
	     i++, this_plot = this_plot->next_cp) {
	    printf("Curve %d:\n", i);
	    if ((int) this_plot->plot_type >= 0 && (int) (this_plot->plot_type) < 4)
		printf("Plot type %d: %s\n", (int) (this_plot->plot_type),
		       plot_type_names[(int) (this_plot->plot_type)]);
	    else
		printf("Plot type %d: BAD\n", (int) (this_plot->plot_type));
	    if ((int) this_plot->plot_style >= 0 && (int) (this_plot->plot_style) < 6)
		printf("Plot style %d: %s\n", (int) (this_plot->plot_style),
		       plot_style_names[(int) (this_plot->plot_style)]);
	    else
		printf("Plot style %d: BAD\n", (int) (this_plot->plot_style));
	    printf("Plot title: '%s'\n", this_plot->title);
	    printf("Line type %d\n", this_plot->line_type);
	    printf("Point type %d\n", this_plot->point_type);
	    printf("max points %d\n", this_plot->p_max);
	    printf("current points %d\n", this_plot->p_count);
	    printf("\n");
	}
    } else {
	for (this_plot = first_plot, i = 0;
	     i < curve && this_plot != NULL;
	     i++, this_plot = this_plot->next_cp);
	if (this_plot == NULL)
	    printf("Curve %d does not exist; list has %d curves\n", curve, i);
	else {
	    printf("Curve %d, %d points\n", curve, this_plot->p_count);
	    for (i = 0; i < this_plot->p_count; i++) {
		printf("%c x=%g y=%g z=%g ylow=%g yhigh=%g\n",
		       this_plot->points[i].type == INRANGE ? 'i'
		       : this_plot->points[i].type == OUTRANGE ? 'o'
		       : 'u',
		       this_plot->points[i].x,
		       this_plot->points[i].y,
		       this_plot->points[i].z,
		       this_plot->points[i].ylow,
		       this_plot->points[i].yhigh);
	    }
	    printf("\n");
	}
    }
}

print_table()
{
    register struct curve_points *this_plot;
    int             i, curve;

    for (this_plot = first_plot, curve = 0; this_plot != NULL;
	 curve++, this_plot = this_plot->next_cp) {
	fprintf(outfile, "Curve %d, %d points\n", curve, this_plot->p_count);
	for (i = 0; i < this_plot->p_count; i++) {
	    fprintf(outfile, "%c x=%g y=%g\n",
		    this_plot->points[i].type == INRANGE ? 'i'
		    : this_plot->points[i].type == OUTRANGE ? 'o'
		    : 'u',
		    this_plot->points[i].x,
		    this_plot->points[i].y);
	}
	fprintf(outfile, "\n");
    }
    fflush(outfile);
}

print_3dtable()
{
    register struct surface_points *this_3dplot;
    int             i, curve;
    struct gnuplot_contours *contours;	/* Not NULL If have contours. */
    struct iso_curve *isocrv;

    for (this_3dplot = first_3dplot, curve = 0; this_3dplot != NULL;
	 curve++, this_3dplot = this_3dplot->next_sp) {
	isocrv = this_3dplot->iso_crvs;
	fprintf(outfile, "Curve %d, %d points\n", curve, isocrv->p_count);
	for (i = 0; i < isocrv->p_count; i++) {
	    fprintf(outfile, "%c x=%g y=%g z=%g\n",
		    isocrv->points[i].type == INRANGE ? 'i'
		    : isocrv->points[i].type == OUTRANGE ? 'o'
		    : 'u',
		    isocrv->points[i].x,
		    isocrv->points[i].y,
		    isocrv->points[i].z);
	}
	fprintf(outfile, "\n");
    }
    fflush(outfile);
}

/*
 * This parses the plot command after any range specifications. To support
 * autoscaling on the x axis, we want any data files to define the x range,
 * then to plot any functions using that range. We thus parse the input
 * twice, once to pick up the data files, and again to pick up the functions.
 * Definitions are processed twice, but that won't hurt.
 */
eval_plots()
{
    register int    i;
    register struct curve_points *this_plot, **tp_ptr;
    register int    start_token, end_token;
    register int    begin_token;
    double          x_min[MAX_WIN], x_max[MAX_WIN], y_min[MAX_WIN], y_max[MAX_WIN];
    register double x,  temp;
    double xdiff[MAX_WIN];
    static struct value a;
    BOOLEAN         ltmp, some_data_files = FALSE;
    int             plot_num, line_num[MAX_WIN], point_num[MAX_WIN];
    int             xparam[MAX_WIN];
    char           *xtitle;
    void            parametric_fixup();
    BOOLEAN changed;
    int dummy_token = -1;
    double dum1, dum2;
    int tmp_win;

    for (tmp_win = 0; tmp_win < MAX_WIN; tmp_win++)
      {
	xparam[tmp_win] = 0;
	line_num[tmp_win] = 0;
	point_num[tmp_win] = 0;      
      
	if (autoscale_ly[tmp_win]) 
	  {
	    ymin_win[tmp_win] = VERYLARGE;
	    ymax_win[tmp_win] = -VERYLARGE;
	  }
	else 
	  if (log_y[tmp_win] && (ymin_win[tmp_win] <= 0.0 || ymax_win[tmp_win] <= 0.0))
	    int_error("y range must be above 0 for log scale!",
		      NO_CARET);
      }

    num_win = 0;
    tp_ptr = &(first_plot);
    plot_num = 0;

    xtitle = NULL;

    begin_token = c_token;

    /*** First Pass: Read through data files ***/
    /*
     * This pass serves to set the xrange and to parse the command, as well
     * as filling in every thing except the function data. That is done after
     * the xrange is defined.
     */
    while (TRUE) {
	if (END_OF_COMMAND)
	    int_error("function to plot expected", c_token);

      tmp_win = 0;
      strcpy (dummy_var[0], dummy_var_win[tmp_win][0]);
      strcpy(dummy_var[1], dummy_var_win[tmp_win][1]);
      if (equals(c_token,"@"))
	{
	  struct value t;
	  c_token++;
	  tmp_win = (int)real(const_express(&t)) - 1;
	  strcpy (dummy_var[0], dummy_var_win[tmp_win][0]);
	  strcpy (dummy_var[1], dummy_var_win[tmp_win][1]);
	}

      if (equals(c_token,"["))
	{
	  c_token++;
	  if (isletter(c_token))
	    {
	      if (equals(c_token+1,"="))
		{
		  dummy_token = c_token;
		  c_token += 2;
		} else {
		  /* oops; probably an expression with a variable. */
		  /* Parse it as an xmin expression. */
		  /* used to be: int_error("'=' expected",c_token); */
		}
	    }
	  changed = parametric[tmp_win] ? load_range(&tmin_win[tmp_win],&tmax_win[tmp_win])
	                       : load_range(&xmin_win[tmp_win],&xmax_win[tmp_win]);
	  if (!equals(c_token,"]"))
	    int_error("']' expected",c_token);
	  c_token++;
	  if (changed)
	    {
	      if (parametric[tmp_win])
		autoscale_lt[tmp_win] = FALSE;
	      else
		autoscale_lx[tmp_win] = FALSE;
	    }
	}
      
	if (parametric[tmp_win] && equals(c_token,"[")) { /* set optional x ranges */
		c_token++;
		changed = load_range(&xmin_win[tmp_win],&xmax_win[tmp_win]);
		if (!equals(c_token,"]"))
			int_error("']' expected",c_token);
		c_token++;
		if (changed)
		  autoscale_lx[tmp_win] = FALSE;
	}

	if (equals(c_token,"[")) { /* set optional y ranges */
		c_token++;
		changed = load_range(&ymin_win[tmp_win],&ymax_win[tmp_win]);
		if (!equals(c_token,"]"))
			int_error("']' expected",c_token);
		c_token++;
		if (changed)
		  autoscale_ly[tmp_win] = FALSE;
	}

     /* use the default dummy variable unless changed */
        strcpy( dummy_var[0], dummy_var_win[tmp_win][0]);
	if (dummy_token >= 0)
	  copy_str(c_dummy_var[0],dummy_token);
	else
	  (void) strcpy(c_dummy_var[0],dummy_var[0]);


	start_token = c_token;

	if (is_definition(c_token)) {
	    define();
	} else {
	    plot_num++;

	    if (isstring(c_token)) {	/* data file to plot */
		if (parametric[tmp_win] && xparam[tmp_win])
		    int_error("previous parametric function not fully specified",
			      c_token);

		if (!some_data_files && autoscale_lx[tmp_win]) {
		    xmin_win[tmp_win] = VERYLARGE;
		    xmax_win[tmp_win] = -VERYLARGE;
		}
		some_data_files = TRUE;

		if (*tp_ptr)
		    this_plot = *tp_ptr;
		else {		/* no memory malloc()'d there yet */
		    this_plot = cp_alloc(MIN_CRV_POINTS);
		    *tp_ptr = this_plot;
		}
		this_plot->plot_type = DATA;
		this_plot->plot_style = data_style[tmp_win];
		this_plot->plot_window = tmp_win;
		if ( tmp_win > num_win )
		  num_win = tmp_win;
		end_token = c_token;
		get_data(this_plot);	/* this also parses the using option */
	    } else {		/* function to plot */
		if (parametric[tmp_win])	/* working on x parametric function */
		    xparam[tmp_win] = 1 - xparam[tmp_win];
		if (*tp_ptr) {
		    this_plot = *tp_ptr;
		    cp_extend(this_plot, samples[tmp_win] + 1);
		} else {	/* no memory malloc()'d there yet */
		    this_plot = cp_alloc(samples[tmp_win] + 1);
		    *tp_ptr = this_plot;
		}
		this_plot->plot_type = FUNC;
		this_plot->plot_style = func_style[tmp_win];
		this_plot->plot_window = tmp_win;
		if ( tmp_win > num_win )
		  num_win = tmp_win;
		dummy_func = &plot_func[tmp_win];
		plot_func[tmp_win].at = temp_at();
		/* ignore it for now */
		end_token = c_token - 1;
	    }

	    if (almost_equals(c_token, "t$itle")) {
		if (parametric[tmp_win]) {
		    if (xparam[tmp_win])
			int_error(
				     "\"title\" allowed only after parametric function fully specified",
				     c_token);
		    else if (xtitle != NULL)
			xtitle[0] = '\0';	/* Remove default title . */
		}
		c_token++;
		if (isstring(c_token)) {
		    m_quote_capture(&(this_plot->title), c_token, c_token);
		} else {
		    int_error("expecting \"title\" for plot", c_token);
		}
		c_token++;
	    } else {
		m_capture(&(this_plot->title), start_token, end_token);
		if (xparam[tmp_win])
		    xtitle = this_plot->title;
	    }

	    this_plot->line_type = line_num[this_plot->plot_window];
	    this_plot->point_type = point_num[this_plot->plot_window];

	    if (almost_equals(c_token, "w$ith")) {
		if (parametric[tmp_win] && xparam[tmp_win])
		    int_error("\"with\" allowed only after parametric function fully specified",
			      c_token);
		this_plot->plot_style = get_style();
	    }
	    if (!equals(c_token, ",") && !END_OF_COMMAND) {
		struct value    t;
		this_plot->line_type = (int) real(const_express(&t)) - 1;
	    }
	    if (!equals(c_token, ",") && !END_OF_COMMAND) {
		struct value    t;
		this_plot->point_type = (int) real(const_express(&t)) - 1;
	    }
	    if ((this_plot->plot_style == POINTS) ||
		(this_plot->plot_style == LINESPOINTS) ||
		(this_plot->plot_style == ERRORBARS))
		if (!xparam[tmp_win])
		    point_num[this_plot->plot_window]++;
	    if (!xparam[tmp_win])
		line_num[this_plot->plot_window]++;

	    if (this_plot->plot_type == DATA)
		/* now that we know the plot style, adjust the yrange */
		adjust_yrange(this_plot);

	    tp_ptr = &(this_plot->next_cp);
	}

	if (equals(c_token, ","))
	    c_token++;
	else
	    break;
    }

  for ( tmp_win = 0; tmp_win < MAX_WIN; ++tmp_win )
    {
      if (parametric[tmp_win] && xparam[tmp_win]) 
	int_error("parametric function not fully specified", NO_CARET);

      if (parametric[tmp_win]) 
	{
	  /* Swap t and x ranges for duration of these eval_plot computations. */
	  ltmp = autoscale_lx[tmp_win]; 
	  autoscale_lx[tmp_win] = autoscale_lt[tmp_win];
	  autoscale_lt[tmp_win] = ltmp;
	  temp = xmin_win[tmp_win]; 
	  xmin_win[tmp_win] = tmin_win[tmp_win]; 
	  tmin_win[tmp_win] = temp;
	  temp = xmax_win[tmp_win]; 
	  xmax_win[tmp_win] = tmax_win[tmp_win]; 
	  tmax_win[tmp_win] = temp;
	}
    }

    /*** Second Pass: Evaluate the functions ***/
    /*
     * Everything is defined now, except the function data. We expect no
     * syntax errors, etc, since the above parsed it all. This makes the code
     * below simpler. If autoscale_ly, the yrange may still change.
     */

  for (tmp_win = 0; tmp_win < MAX_WIN; tmp_win++)
    {
      if (fabs(xmax_win[tmp_win]-xmin_win[tmp_win]) < zero[tmp_win])
	{
	  if (autoscale_lx[tmp_win]) 
	    {
	      fprintf(stderr, "Warning: empty %c range [%g:%g], ", 
		      parametric[tmp_win] ? 't' 
		      : 'x', xmin_win[tmp_win],xmax_win[tmp_win]);
	      if (fabs(xmin_win[tmp_win]) < zero[tmp_win]) 
		{
		  /* completely arbitrary */
		  xmin_win[tmp_win] = -1.;
		  xmax_win[tmp_win] = 1.;
		} 
	      else 
		{
		  /* expand range by 10% in either direction */
		  xmin_win[tmp_win] = xmin_win[tmp_win] * 0.9;
		  xmax_win[tmp_win] = xmax_win[tmp_win] * 1.1;
		}
	      fprintf(stderr, "adjusting to [%g:%g]\n", xmin_win[tmp_win],xmax_win[tmp_win]);
	    } 
	  else 
	    {
	      int_error("x range is less than `zero`", c_token);
	    }
	}
      
      /* give error if xrange badly set from missing datafile error */
      if (xmin_win[tmp_win] == VERYLARGE || xmax_win[tmp_win] == -VERYLARGE) 
	{
	  int_error("x range is invalid", c_token);
	}
      
      if (log_x[tmp_win]) 
	{
	  if (xmin_win[tmp_win] <= 0.0 || xmax_win[tmp_win] <= 0.0)
	    int_error("x range must be greater than 0 for log scale!",NO_CARET);
	  x_min[tmp_win] = log10(xmin_win[tmp_win]);
	  x_max[tmp_win] = log10(xmax_win[tmp_win]);
	} 
      else 
	{
	  x_min[tmp_win] = xmin_win[tmp_win];
	  x_max[tmp_win] = xmax_win[tmp_win];
	}
      
      xdiff[tmp_win] =
	 (x_max[tmp_win] - x_min[tmp_win]) / (samples[tmp_win] - 1);
    }

    tp_ptr = &(first_plot);
    plot_num = 0;
    this_plot = first_plot;
    c_token = begin_token;	/* start over */

    /* Read through functions */

      while (TRUE) 
	{
	  tmp_win = this_plot->plot_window;
	  strcpy(dummy_var[0], dummy_var_win[tmp_win][0]);
	  strcpy(dummy_var[1], dummy_var_win[tmp_win][1]);
	  if (equals(c_token,"@"))
	    {
	      struct value t;
	      c_token++;
	      (int)real(const_express(&t)) - 1;
	      strcpy(dummy_var[0], dummy_var_win[tmp_win][0]);
	      strcpy(dummy_var[1], dummy_var_win[tmp_win][1]);
	    }
	  
	  if (equals(c_token,"["))
	    {
	      c_token++;
	      if (isletter(c_token))
		{
		  if (equals(c_token+1,"="))
		    {
		      c_token += 2;
		    } else {
		      /* oops; probably an expression with a variable. */
		      /* Parse it as an xmin expression. */
		      /* used to be: int_error("'=' expected",c_token); */
		    }
		}
	      load_range(&dum1,&dum2);
	      c_token++;
	    }
	  
	  if (equals(c_token,"[")) 
	    {
	      c_token++;
	      load_range(&dum1,&dum2);
	      c_token++;
	    }
	  
	  if (equals(c_token,"["))
	    {
	      c_token++;
	      load_range(&dum1, &dum2);
	      c_token++;
	    }
	  strcpy(c_dummy_var[0], dummy_var[0]);
	  strcpy(c_dummy_var[1], dummy_var[1]); 	  

	if (is_definition(c_token)) {
	    define();
	} else {
	    plot_num++;
	    if (isstring(c_token)) {	/* data file to plot */
		/* ignore this now */
		c_token++;

		/*
		 * jev -- support for passing data from file thru user
		 * function
		 */
		if (almost_equals(c_token, "thru$")) {
		    struct udft_entry tmp;
		    c_token++;
		    dummy_func = &tmp;
		    (void) temp_at();
		}
		if (almost_equals(c_token, "u$sing")) {
		    c_token++;	/* skip "using" */
		    if (!isstring(c_token)) {
			struct value    a;
			(void) magnitude(const_express(&a));	/* skip xcol */
			if (equals(c_token, ":")) {
			    c_token++;	/* skip ":" */
			    (void) magnitude(const_express(&a));	/* skip ycol */
			}
			if (equals(c_token, ":")) {
			    c_token++;	/* skip ":" */
			    (void) magnitude(const_express(&a));	/* skip yemin */
			}
			if (equals(c_token, ":")) {
			    c_token++;	/* skip ":" */
			    (void) magnitude(const_express(&a));	/* skip yemax */
			}
			if (equals(c_token, ":")) {
			    c_token++;	/* skip ":" */
			    (void) magnitude(const_express(&a));	/* skip wcol */
			}
		    }
		    if (isstring(c_token))
			c_token++;	/* skip format string */
		}
	    } else {		/* function to plot */
		if (parametric[tmp_win])	/* working on x parametric function */
		    xparam[tmp_win] = 1 - xparam[tmp_win];
		dummy_func = &plot_func[tmp_win];
		plot_func[tmp_win].at = temp_at();	/* reparse function */

		for (i = 0; i < samples[tmp_win]; i++) {
		    x = x_min[tmp_win] + i * xdiff[tmp_win];
		    /* if (log_x) PEM fix logscale x axis */
		    /* x = pow(10.0,x); 26-Sep-89 */
		    (void) complex(&plot_func[tmp_win].dummy_values[0],
				   log_x[tmp_win] ? pow(10.0, x) : x,
				   0.0);

		    evaluate_at(plot_func[tmp_win].at, &a);

		    if (undefined || (fabs(imag(&a)) > zero[tmp_win])) {
			this_plot->points[i].type = UNDEFINED;
			continue;
		    }
		    temp = real(&a);

		    if (log_y[tmp_win] && temp < 0.0) {
			this_plot->points[i].type = UNDEFINED;
			continue;
		    }
		    this_plot->points[i].x = x;
		    this_plot->points[i].z = -1.0;  /* width of box not specified */

		    if (log_y[tmp_win]) {
			if (temp == 0.0) {
			    this_plot->points[i].type = OUTRANGE;
			    this_plot->points[i].y = -VERYLARGE;
			    continue;
			} else {
			    this_plot->points[i].y = log10(temp);
			}
		    } else
			this_plot->points[i].y = temp;

		    if (autoscale_ly[tmp_win] || polar[tmp_win]
			|| inrange(temp, ymin_win[tmp_win], ymax_win[tmp_win])) {
			this_plot->points[i].type = INRANGE;
			/* When xparam is 1 we are not really computing y's! */
			if (!xparam[tmp_win] && autoscale_ly[tmp_win]) {
			  if (temp < ymin_win[tmp_win]) 
			    ymin_win[tmp_win] = temp;
			  if (temp > ymax_win[tmp_win]) 
			    ymax_win[tmp_win] = temp;
			}
		    } else
			this_plot->points[i].type = OUTRANGE;
		}
		this_plot->p_count = i;	/* samples */
	    }

	    /* title was handled above */
	    if (almost_equals(c_token, "t$itle")) {
		c_token++;
		c_token++;
	    }
	    /* style was handled above */
	    if (almost_equals(c_token, "w$ith")) {
		c_token++;
		c_token++;
	    }
	    /* line and point types were handled above */
	    if (!equals(c_token, ",") && !END_OF_COMMAND) {
		struct value    t;
		(void) real(const_express(&t));
	    }
	    if (!equals(c_token, ",") && !END_OF_COMMAND) {
		struct value    t;
		(void) real(const_express(&t));
	    }
	    tp_ptr = &(this_plot->next_cp);	/* used below */
	    this_plot = this_plot->next_cp;
	}

	if (equals(c_token, ","))
	    c_token++;
	else
	    break;
    }

    /* throw out all curve_points at end of list, that we don't need  */
    cp_free(*tp_ptr);
    *tp_ptr = NULL;

      for (tmp_win = 0; tmp_win < MAX_WIN; tmp_win++)
	{
	  if (fabs(ymax_win[tmp_win] - ymin_win[tmp_win]) < zero[tmp_win])
	    {
	      /* if autoscale, widen range */
	      if (autoscale_ly[tmp_win]) 
		{
		  fprintf(stderr, "Warning: empty y range [%g:%g], ", ymin_win[tmp_win], ymax_win[tmp_win]);
		  if (fabs(ymin_win[tmp_win]) < zero[tmp_win]) 
		    {
		      ymin_win[tmp_win] = -1.;
		      ymax_win[tmp_win] = 1.;
		    } 
		  else 
		    {
		      /* expand range by 10% in either direction */
		      ymin_win[tmp_win] = ymin_win[tmp_win] * 0.9;
		      ymax_win[tmp_win] = ymax_win[tmp_win] * 1.1;
		    }
		  fprintf(stderr, "adjusting to [%g:%g]\n", ymin_win[tmp_win], ymax_win[tmp_win]);
		} 
	      else 
		{
		  int_error("y range is less than `zero`", c_token);
		}
	    }
	  
	  /* Now we finally know the real ymin and ymax */
	  if (log_y[tmp_win]) 
	    {
	      y_min[tmp_win] = log10(ymin_win[tmp_win]);
	      y_max[tmp_win] = log10(ymax_win[tmp_win]);
	    } 
	  else 
	    {
	      y_min[tmp_win] = ymin_win[tmp_win];
	      y_max[tmp_win] = ymax_win[tmp_win];
	    };
	  
	  capture(replot_line,plot_token,c_token);
	  
	  if (parametric[tmp_win]) 
	    {
	      /* Now put t and x ranges back before we actually plot anything. */
	      ltmp = autoscale_lx[tmp_win]; 
	      autoscale_lx[tmp_win] = autoscale_lt[tmp_win];
	      autoscale_lt[tmp_win] = ltmp;
	      temp = xmin_win[tmp_win]; 
	      xmin_win[tmp_win] = tmin_win[tmp_win];
	      tmin_win[tmp_win] = temp;
	      temp = xmax_win[tmp_win]; 
	      xmax_win[tmp_win] = tmax_win[tmp_win];
	      tmax_win[tmp_win] = temp;
	      if (some_data_files && autoscale_lx[tmp_win]) 
		{
		  /* 
		    Stop any further autoscaling in this case (may be a mistake, have
		to consider what is really wanted some day in the future--jdc). 
		*/
		  autoscale_lx[tmp_win] = 0;
		}
	      /* Now actually fix the plot pairs to be single plots. */
	      parametric_fixup (tmp_win, first_plot, &plot_num, x_min, x_max);
	    }
	}

    if (strcmp(term_tbl[term].name, "table") == 0)
	print_table();
    else
	do_plot(first_plot, plot_num, x_min, x_max, y_min, y_max);
    cp_free(first_plot);
    first_plot = NULL;
}

/*
 * This parses the splot command after any range specifications. To support
 * autoscaling on the x/z axis, we want any data files to define the x/y
 * range, then to plot any functions using that range. We thus parse the
 * input twice, once to pick up the data files, and again to pick up the
 * functions. Definitions are processed twice, but that won't hurt.
 */
eval_3dplots()
{
    register int    i, j, k;
    register struct surface_points *this_plot, **tp_3d_ptr, *tmp,
             *head_free, *chain;
    register int    start_token, end_token;
    register int    begin_token;
    double          x_min[MAX_WIN], x_max[MAX_WIN], y_min[MAX_WIN], y_max[MAX_WIN], 
                    z_min[MAX_WIN], z_max[MAX_WIN];
    register double x,  y, temp;
    double xdiff[MAX_WIN], xisodiff[MAX_WIN], ydiff[MAX_WIN], yisodiff[MAX_WIN];
    static struct value a;
    BOOLEAN         ltmp, some_data_files = FALSE;
    int             plot_num, line_num[MAX_WIN], point_num[MAX_WIN], 
                    crnt_param[MAX_WIN];	/* 0=x, 1=y, 2=z */
    char           *xtitle;
    char           *ytitle;
    void            parametric_3dfixup();
    BOOLEAN changed;
    int dummy_token0 = -1, dummy_token1 = -1;
    double dum1, dum2;
    int tmp_win;
    int pcount_win[MAX_WIN];
    struct surface_points *(*ppoints);
    int pcount;

    for (tmp_win = 0; tmp_win < MAX_WIN; tmp_win++)
      {
	line_num[tmp_win] = 0;
	point_num[tmp_win] = 0;      
	crnt_param[tmp_win] = 0;
      
	if (autoscale_lz[tmp_win]) 
	  {
	    zmin_win[tmp_win] = VERYLARGE;
	    zmax_win[tmp_win] = -VERYLARGE;
	  } else if (log_z[tmp_win] && (zmin_win[tmp_win] <= 0.0 || zmax_win[tmp_win] <= 0.0))
	    int_error("z range must be above 0 for log scale!",
		      NO_CARET);
      }

    num_win = 0;

    tp_3d_ptr = &(first_3dplot);
    plot_num = 0;

    xtitle = NULL;
    ytitle = NULL;

    begin_token = c_token;

    /*** First Pass: Read through data files ***/
    /*
     * This pass serves to set the x/yranges and to parse the command, as
     * well as filling in every thing except the function data. That is done
     * after the x/yrange is defined.
     */
    while (TRUE) {
	if (END_OF_COMMAND)
	    int_error("function to plt3d expected", c_token);

    tmp_win = 0;
    strcpy( dummy_var[0], dummy_var_win[tmp_win][0]);
    strcpy( dummy_var[1], dummy_var_win[tmp_win][1]);
    if (equals(c_token,"@"))
      {
	struct value t;
	c_token++;
	tmp_win = (int)real(const_express(&t)) - 1;
	strcpy( dummy_var[0], dummy_var_win[tmp_win][0]);
	strcpy( dummy_var[1], dummy_var_win[tmp_win][1]);
      }
    
    if (equals(c_token,"["))
      {
	c_token++;
	if (isletter(c_token))
	  {
	    if (equals(c_token+1,"="))
	      {
		dummy_token0 = c_token;
		c_token += 2;
	      } else {
		/* oops; probably an expression with a variable. */
		/* Parse it as an xmin expression. */
		/* used to be: int_error("'=' expected",c_token); */
	      }
	  }
	changed = parametric[tmp_win] ? load_range(&umin_win[tmp_win],&umax_win[tmp_win])
                                      : load_range(&xmin_win[tmp_win],&xmax_win[tmp_win]);
	if (!equals(c_token,"]"))
	  int_error("']' expected",c_token);
	c_token++;
	if (changed && !parametric[tmp_win])
	  {
	    autoscale_lx[tmp_win] = FALSE;
	  }
      }

    if (equals(c_token,"["))
      {
	c_token++;
	if (isletter(c_token))
	  {
	    if (equals(c_token+1,"="))
	      {
		dummy_token1 = c_token;
		c_token += 2;
	      } else
		{
		  /* oops; probably an expression with a variable. */
		  /* Parse it as an xmin expression. */
		  /* used to be: int_error("'=' expected",c_token); */
		}
	  }
	changed = parametric[tmp_win] ? load_range(&vmin_win[tmp_win],&vmax_win[tmp_win])
                                      : load_range(&ymin_win[tmp_win],&ymax_win[tmp_win]);
	if (!equals(c_token,"]"))
	  int_error("']' expected",c_token);
	c_token++;
	if (changed && !parametric[tmp_win])
	  {
	    autoscale_ly[tmp_win] = FALSE;
	  }
      }

    if (equals(c_token,"["))
      { /* set optional x ranges */
	c_token++;
	changed = load_range(&xmin_win[tmp_win],&xmax_win[tmp_win]);
	if (!equals(c_token,"]"))
	  int_error("']' expected",c_token);
	c_token++;
	if (changed)
	  autoscale_lx[tmp_win] = FALSE;
	}

    if (equals(c_token,"["))
      { /* set optional y ranges */
	c_token++;
	changed = load_range(&ymin_win[tmp_win],&ymax_win[tmp_win]);
	if (!equals(c_token,"]"))
	  int_error("']' expected",c_token);
	c_token++;
	if (changed)
	  autoscale_ly[tmp_win] = FALSE;
      }

    if (equals(c_token,"["))
      { /* set optional z ranges */
	c_token++;
	changed = load_range(&zmin_win[tmp_win],&zmax_win[tmp_win]);
	if (!equals(c_token,"]"))
	  int_error("']' expected",c_token);
	c_token++;
	if (changed)
	  autoscale_lz[tmp_win] = FALSE;
      }

    /* use the default dummy variable unless changed */
    if (dummy_token0 >= 0)
      copy_str(c_dummy_var[0],dummy_token0);
    else
      (void) strcpy(c_dummy_var[0],dummy_var[0]);
    
    if (dummy_token1 >= 0)
      copy_str(c_dummy_var[1],dummy_token1);
    else
      (void) strcpy(c_dummy_var[1],dummy_var[1]);

	start_token = c_token;

	if (is_definition(c_token)) {
	    define();
	} else {
	    plot_num++;

	    if (isstring(c_token)) {	/* data file to plot */
		if (parametric[tmp_win] && crnt_param[tmp_win] != 0)
		    int_error("previous parametric function not fully specified",
			      c_token);

		if (!some_data_files) {
		    if (autoscale_lx[tmp_win]) {
			xmin_win[tmp_win] = VERYLARGE;
			xmax_win[tmp_win] = -VERYLARGE;
		    }
		    if (autoscale_ly[tmp_win]) {
			ymin_win[tmp_win] = VERYLARGE;
			ymax_win[tmp_win] = -VERYLARGE;
		    }
		}
		some_data_files = TRUE;

		if (*tp_3d_ptr)
		    this_plot = *tp_3d_ptr;
		else {		/* no memory malloc()'d there yet */
		    /* Allocate samples * iso_samples twice for */
		    /* Each of the isoparametric direction. */
		    this_plot = sp_alloc(0, 0);
		    *tp_3d_ptr = this_plot;
		}

		this_plot->plot_type = DATA3D;
		this_plot->plot_style = data_style[tmp_win];
		this_plot->plot_window = tmp_win;
		if ( tmp_win > num_win )
		  num_win = tmp_win;
		end_token = c_token;
		get_3ddata(this_plot);	/* this also parses the using option */
	    } else {		/* function to plot */
		if (parametric[tmp_win])	/* Rotate between x/y/z axes */
		    crnt_param[tmp_win] = (crnt_param[tmp_win] + 1) % 3;
		if (*tp_3d_ptr) {
		    this_plot = *tp_3d_ptr;
		    if (!hidden3d[tmp_win])
			sp_replace(this_plot, samples[tmp_win], 2 * iso_samples[tmp_win]);
		    else
			sp_replace(this_plot, samples[tmp_win], iso_samples[tmp_win]);
		} else {	/* no memory malloc()'d there yet */
		    /* Allocate samples * iso_samples twice for */
		    /* Each of the isoparametric direction. */
		    if (!hidden3d[tmp_win])
			this_plot = sp_alloc(samples[tmp_win], 2 * iso_samples[tmp_win]);
		    else
			this_plot = sp_alloc(samples[tmp_win], iso_samples[tmp_win]);
		    *tp_3d_ptr = this_plot;
		}

		this_plot->plot_type = FUNC3D;
		this_plot->has_grid_topology = TRUE;
		this_plot->plot_style = func_style[tmp_win];
		this_plot->plot_window = tmp_win;
		if ( tmp_win > num_win )
		  num_win = tmp_win;
		dummy_func = &plot_func[tmp_win];
		plot_func[tmp_win].at = temp_at();
		/* ignore it for now */
		end_token = c_token - 1;
	    }

	    if (almost_equals(c_token, "t$itle")) {
		if (parametric[tmp_win]) {
		    if (crnt_param[tmp_win])
			int_error(
				     "\"title\" allowed only after parametric function fully specified",
				     c_token);
		    else {
			/* Remove default title */
			if (xtitle != NULL)
			    xtitle[0] = '\0';
			if (ytitle != NULL)
			    ytitle[0] = '\0';
		    }
		}
		c_token++;
		if (isstring(c_token)) {
		    m_quote_capture(&(this_plot->title), c_token, c_token);
		} else {
		    int_error("expecting \"title\" for plot", c_token);
		}
		c_token++;
	    } else {
		m_capture(&(this_plot->title), start_token, end_token);
		if (crnt_param[tmp_win] == 1)
		    xtitle = this_plot->title;
		if (crnt_param[tmp_win] == 2)
		    ytitle = this_plot->title;
	    }

	    this_plot->line_type = line_num[this_plot->plot_window];
	    this_plot->point_type = point_num[this_plot->plot_window];

	    if (almost_equals(c_token, "w$ith")) {
		this_plot->plot_style = get_style();
	    }
	    if (!equals(c_token, ",") && !END_OF_COMMAND) {
		struct value    t;
		this_plot->line_type = (int) real(const_express(&t)) - 1;
	    }
	    if (!equals(c_token, ",") && !END_OF_COMMAND) {
		struct value    t;
		this_plot->point_type = (int) real(const_express(&t)) - 1;
	    }
	    if ((this_plot->plot_style == POINTS) ||
		(this_plot->plot_style == LINESPOINTS) ||
		(this_plot->plot_style == ERRORBARS))
		if (crnt_param[tmp_win] == 0)
		    point_num[this_plot->plot_window] +=
			1 + (draw_contour[this_plot->plot_window] != 0)
			+ (hidden3d[this_plot->plot_window] != 0);
	    if (crnt_param[tmp_win] == 0)
		line_num[this_plot->plot_window] += 1 + (draw_contour[this_plot->plot_window] != 0)
		    + (hidden3d[this_plot->plot_window] != 0);

	    tp_3d_ptr = &(this_plot->next_sp);
	}

	if (equals(c_token, ","))
	    c_token++;
	else
	    break;
    }

  for (tmp_win = 0; tmp_win < MAX_WIN; tmp_win++)
    {
      if (parametric[tmp_win] && crnt_param[tmp_win] != 0)
	int_error("parametric function not fully specified", NO_CARET);
      
      if (parametric[tmp_win]) {
	/* Swap u/v and x/y ranges for duration of these eval_plot computations. */
	ltmp = autoscale_lx[tmp_win]; 
	autoscale_lx[tmp_win] = autoscale_lu[tmp_win];
	autoscale_lu[tmp_win] = ltmp;
	ltmp = autoscale_ly[tmp_win]; 
	autoscale_ly[tmp_win] = autoscale_lv[tmp_win];
	autoscale_lv[tmp_win] = ltmp;
	temp = xmin_win[tmp_win]; 
	xmin_win[tmp_win] = umin_win[tmp_win]; 
	umin_win[tmp_win] = temp;
	temp = xmax_win[tmp_win]; 
	xmax_win[tmp_win] = umax_win[tmp_win]; 
	umax_win[tmp_win] = temp;
	temp = ymin_win[tmp_win]; 
	ymin_win[tmp_win] = vmin_win[tmp_win]; 
	vmin_win[tmp_win] = temp;
	temp = ymax_win[tmp_win]; 
	ymax_win[tmp_win] = vmax_win[tmp_win]; 
	vmax_win[tmp_win] = temp;
      }
    }

    /*** Second Pass: Evaluate the functions ***/
    /*
     * Everything is defined now, except the function data. We expect no
     * syntax errors, etc, since the above parsed it all. This makes the code
     * below simpler. If autoscale_ly, the yrange may still change.
     */

  for (tmp_win = 0; tmp_win < MAX_WIN; tmp_win++)
    {
      if (xmin_win[tmp_win] == xmax_win[tmp_win])
	if (autoscale_lx[tmp_win]) {
	  fprintf(stderr, "Warning: empty x range [%g:%g], ", 
		  xmin_win[tmp_win],xmax_win[tmp_win]);
	  if (xmin_win[tmp_win] == 0.0) {
	    /* completely arbitary */
	    xmin_win[tmp_win] = -1.;
	    xmax_win[tmp_win] = 1.;
	  } else {
	    /* expand range by 10% in either direction */
	    xmin_win[tmp_win] = xmin_win[tmp_win] * 0.9;
	    xmax_win[tmp_win] = xmax_win[tmp_win] * 1.1;
	  }
	  fprintf(stderr, "adjusting to [%g:%g]\n", xmin_win[tmp_win],xmax_win[tmp_win]);
	} else {
	  int_error("x range is empty", c_token);
	}
      
      if (ymin_win[tmp_win] == ymax_win[tmp_win])
	if (autoscale_ly[tmp_win]) {
	  fprintf(stderr, "Warning: empty y range [%g:%g], ", 
		  ymin_win[tmp_win],ymax_win[tmp_win]);
	  if (ymin_win[tmp_win] == 0.0) {
	    /* completely arbitrary */
	    ymin_win[tmp_win] = -1.;
	    ymax_win[tmp_win] = 1.;
	  } else {
	    /* expand range by 10% in either direction */
	    ymin_win[tmp_win] = ymin_win[tmp_win] * 0.9;
	    ymax_win[tmp_win] = ymax_win[tmp_win] * 1.1;
	  }
	  fprintf(stderr, "adjusting to [%g:%g]\n", ymin_win[tmp_win],ymax_win[tmp_win]);
	} else {
	  int_error("y range is empty", c_token);
	}
      
      /* give error if xrange badly set from missing datafile error */
      if (xmin_win[tmp_win] == VERYLARGE || xmax_win[tmp_win] == -VERYLARGE) {
	int_error("x range is invalid", c_token);
      }
      
      if (log_x[tmp_win]) {
	if (xmin_win[tmp_win] <= 0.0 || xmax_win[tmp_win] <= 0.0)
	  int_error("x range must be greater than 0 for log scale!",NO_CARET);
	x_min[tmp_win] = log10(xmin_win[tmp_win]);
	x_max[tmp_win] = log10(xmax_win[tmp_win]);
      } else {
	x_min[tmp_win] = xmin_win[tmp_win];
	x_max[tmp_win] = xmax_win[tmp_win];
      }
      
      if (log_y[tmp_win]) {
	if (ymin_win[tmp_win] <= 0.0 || ymax_win[tmp_win] <= 0.0)
	  int_error("y range must be greater than 0 for log scale!",NO_CARET);
	y_min[tmp_win] = log10(ymin_win[tmp_win]);
	y_max[tmp_win] = log10(ymax_win[tmp_win]);
      } else {
	y_min[tmp_win] = ymin_win[tmp_win];
	y_max[tmp_win] = ymax_win[tmp_win];
      }
      
      if (samples[tmp_win] < 2 || iso_samples[tmp_win] < 2)
	int_error("samples or iso_samples < 2. Must be at least 2.\n");
      
      xdiff[tmp_win] = 
         (x_max[tmp_win] - x_min[tmp_win]) / (samples[tmp_win] - 1);
      ydiff[tmp_win] = 
	 (y_max[tmp_win] - y_min[tmp_win]) / (samples[tmp_win] - 1);
      xisodiff[tmp_win] 
	 = (x_max[tmp_win] - x_min[tmp_win]) / (iso_samples[tmp_win] - 1);
      yisodiff[tmp_win] 
	 = (y_max[tmp_win] - y_min[tmp_win]) / (iso_samples[tmp_win] - 1);
  }      
    plot_num = 0;
    this_plot = first_3dplot;
    c_token = begin_token;	/* start over */

    /* Read through functions */
    while (TRUE) {
      tmp_win = this_plot->plot_window;
      strcpy( dummy_var[0], dummy_var_win[tmp_win][0]);
      strcpy( dummy_var[1], dummy_var_win[tmp_win][1]);
      if (equals(c_token,"@"))
	{
	  struct value t;
	  c_token++;
	  (int)real(const_express(&t)) - 1;
	  strcpy( dummy_var[0], dummy_var_win[tmp_win][0]);
	  strcpy( dummy_var[1], dummy_var_win[tmp_win][1]);
	}
      
      if (equals(c_token,"["))
	{
	  c_token++;
	  if (isletter(c_token))
	    {
	      if (equals(c_token+1,"=")) {
		c_token += 2;
	      } else {
		/* oops; probably an expression with a variable. */
		/* Parse it as an xmin expression. */
		/* used to be: int_error("'=' expected",c_token); */
	      }
	    }
	  load_range(&dum1,&dum2);
	  c_token++;
	}
  
      if (equals(c_token,"["))
	{
	  c_token++;
	  if (isletter(c_token))
	    {
	      if (equals(c_token+1,"="))
		{
		  c_token += 2;
		} else 
		  {
		    /* oops; probably an expression with a variable. */
		    /* Parse it as an xmin expression. */
		    /* used to be: int_error("'=' expected",c_token); */
		  }
	    }
	  load_range(&dum1,&dum2);
	  c_token++;
	}
  
      if (equals(c_token,"["))
	{ /* set optional x ranges */
	  c_token++;
	  load_range(&dum1,&dum2);
	  c_token++;
	}
      
      if (equals(c_token,"["))
	{ /* set optional y ranges */
	  c_token++;
	  load_range(&dum1,&dum2);
	  c_token++;
	}

	if (equals(c_token,"["))
	  { /* set optional z ranges */
	    c_token++;
	    load_range(&dum1,&dum2);
	    c_token++;
	  }
      if (dummy_token0 >= 0)
	copy_str(c_dummy_var[0],dummy_token0);
      else
	(void) strcpy(c_dummy_var[0],dummy_var[0]);
    
      if (dummy_token1 >= 0)
	copy_str(c_dummy_var[1],dummy_token1);
      else
	(void) strcpy(c_dummy_var[1],dummy_var[1]);

      if (is_definition(c_token)) {
	define();
      } else {
	    plot_num++;
	    if (isstring(c_token)) {	/* data file to plot */
		/* ignore this now */
		c_token++;
		if (almost_equals(c_token, "u$sing")) {
		    c_token++;	/* skip "using" */
		    if (!isstring(c_token)) {
			struct value    a;
			(void) magnitude(const_express(&a));	/* skip xcol */
			if (equals(c_token, ":")) {
			    c_token++;	/* skip ":" */
			    (void) magnitude(const_express(&a));	/* skip ycol */
			    if (equals(c_token, ":")) {
				c_token++;	/* skip ":" */
				(void) magnitude(const_express(&a));	/* skip zcol */
			    }
			}
		    }
		    if (isstring(c_token))
			c_token++;	/* skip format string */
		}
	    } else {		/* function to plot */
		struct iso_curve *this_iso = this_plot->iso_crvs;
		struct coordinate *points = this_iso->points;

		if (parametric[tmp_win])
		    crnt_param[tmp_win] = (crnt_param[tmp_win] + 1) % 3;
		dummy_func = &plot_func[tmp_win];
		plot_func[tmp_win].at = temp_at();	/* reparse function */

		for (j = 0; j < iso_samples[tmp_win]; j++) {
		    y = y_min[tmp_win] + j * yisodiff[tmp_win];
		    /* if (log_y) PEM fix logscale y axis */
		    /* y = pow(10.0,y); 26-Sep-89 */
		    (void) complex(&plot_func[tmp_win].dummy_values[1],
				   log_y[tmp_win] ? pow(10.0, y) : y,
				   0.0);

		    for (i = 0; i < samples[tmp_win]; i++) {
			x = x_min[tmp_win] + i * xdiff[tmp_win];
			/* if (log_x) PEM fix logscale x axis */
			/* x = pow(10.0,x); 26-Sep-89 */
			(void) complex(&plot_func[tmp_win].dummy_values[0],
				       log_x[tmp_win] ? pow(10.0, x) : x,
				       0.0);

			points[i].x = x;
			points[i].y = y;

			evaluate_at(plot_func[tmp_win].at, &a);

			if (undefined || (fabs(imag(&a)) > zero[tmp_win])) {
			    points[i].type = UNDEFINED;
			    continue;
			}
			temp = real(&a);

			if (log_z[tmp_win] && temp < 0.0) {
			    points[i].type = UNDEFINED;
			    continue;
			}
			if (log_z[tmp_win]) {
			    if (temp == 0.0) {
				points[i].type = OUTRANGE;
				points[i].z = -VERYLARGE;
				continue;
			    } else {
				points[i].z = log10(temp);
			    }
			} else
			    points[i].z = temp;

			if (autoscale_lz[tmp_win] 
			    || inrange(temp, zmin_win[tmp_win], zmax_win[tmp_win])) {
			  points[i].type = INRANGE;
			  if (autoscale_lz[tmp_win]) {
			    if (temp < zmin_win[tmp_win]) 
			      zmin_win[tmp_win] = temp;
			    if (temp > zmax_win[tmp_win]) 
			      zmax_win[tmp_win] = temp;
			    }
			} else
			    points[i].type = OUTRANGE;
		    }
		    this_iso->p_count = samples[tmp_win];
		    this_iso = this_iso->next;
		    points = this_iso? this_iso->points: NULL;
		}

		if (!(this_plot->has_grid_topology && hidden3d[tmp_win]))
		    for (i = 0; i < iso_samples[tmp_win]; i++) {
			x = x_min[tmp_win] + i * xisodiff[tmp_win];
			/* if (log_x) PEM fix logscale x axis */
			/* x = pow(10.0,x); 26-Sep-89 */
			(void) complex(&plot_func[tmp_win].dummy_values[0],
				       log_x[tmp_win] ? pow(10.0, x) : x,
				       0.0);

			for (j = 0; j < samples[tmp_win]; j++) {
			    y = y_min[tmp_win] + j * ydiff[tmp_win];
			    /* if (log_y) PEM fix logscale y axis */
			    /* y = pow(10.0,y); 26-Sep-89 */
			    (void) complex(&plot_func[tmp_win].dummy_values[1],
					   log_y[tmp_win] ? pow(10.0, y) : y,
					   0.0);

			    points[j].x = x;
			    points[j].y = y;

			    evaluate_at(plot_func[tmp_win].at, &a);

			    if (undefined || (fabs(imag(&a)) > zero[tmp_win])) {
				points[j].type = UNDEFINED;
				continue;
			    }
			    temp = real(&a);

			    if (log_z[tmp_win] && temp < 0.0) {
				points[j].type = UNDEFINED;
				continue;
			    }
			    if (log_z[tmp_win]) {
				if (temp == 0.0) {
				    points[j].type = OUTRANGE;
				    points[j].z = -VERYLARGE;
				    continue;
				} else {
				    points[j].z = log10(temp);
				}
			    } else
				points[j].z = temp;

			    if (autoscale_lz[tmp_win]
				|| inrange(temp, zmin_win[tmp_win], zmax_win[tmp_win])) {
				points[j].type = INRANGE;
				if (autoscale_lz[tmp_win]) {
				  if (temp < zmin_win[tmp_win]) 
				    zmin_win[tmp_win] = temp;
				  if (temp > zmax_win[tmp_win]) 
				    zmax_win[tmp_win] = temp;
				}
			    } else
				points[j].type = OUTRANGE;
			}
			this_iso->p_count = samples[tmp_win];
			this_iso = this_iso->next;
			points = this_iso ? this_iso->points : NULL;
		    }
	    }

	    /* title was handled above */
	    if (almost_equals(c_token, "t$itle")) {
		c_token++;
		c_token++;
	    }
	    /* style was handled above */
	    if (almost_equals(c_token, "w$ith")) {
		c_token++;
		c_token++;
	    }
	    /* line and point types were handled above */
	    if (!equals(c_token, ",") && !END_OF_COMMAND) {
		struct value    t;
		(void) real(const_express(&t));
	    }
	    if (!equals(c_token, ",") && !END_OF_COMMAND) {
		struct value    t;
		(void) real(const_express(&t));
	    }
	    this_plot = this_plot->next_sp;
	}

	if (equals(c_token, ","))
	    c_token++;
	else
	    break;
    }

  for (tmp_win = 0; tmp_win < MAX_WIN; tmp_win++)
    {
      if (fabs(zmax_win[tmp_win] - zmin_win[tmp_win]) < zero[tmp_win])
	/* if autoscale[tmp_win], widen range */
	if (autoscale_lz[tmp_win]) {
	  fprintf(stderr, "Warning: empty z range [%g:%g], ", zmin_win[tmp_win], zmax_win[tmp_win]);
	  if (fabs(zmin_win[tmp_win]) < zero[tmp_win] ) {
	    zmin_win[tmp_win] = -1.;
	    zmax_win[tmp_win] = 1.;
	  } else {
	    /* expand range by 10% in either direction */
	    zmin_win[tmp_win] = zmin_win[tmp_win] * 0.9;
	    zmax_win[tmp_win] = zmax_win[tmp_win] * 1.1;
	  }
	  fprintf(stderr, "adjusting to [%g:%g]\n", zmin_win[tmp_win], zmax_win[tmp_win]);
	} else {
	  int_error("z range is less than `zero`", c_token);
	}
      
      /* Now we finally know the real zmin_win[tmp_win] and zmax_win[tmp_win] */
      if (log_z[tmp_win]) {
	if (zmin_win[tmp_win] <= 0.0 || zmax_win[tmp_win] <= 0.0)
	  int_error("z range must be greater than 0 for log scale!",NO_CARET);
	z_min[tmp_win] = log10(zmin_win[tmp_win]);
	z_max[tmp_win] = log10(zmax_win[tmp_win]);
      } else {
	z_min[tmp_win] = zmin_win[tmp_win];
	z_max[tmp_win] = zmax_win[tmp_win];
      }
      capture(replot_line,plot_token,c_token);
      
      if (parametric[tmp_win]) {
	/* Now put u/v and x/y ranges back before we actually plot anything. */
	ltmp = autoscale_lx[tmp_win]; autoscale_lx[tmp_win] = autoscale_lu[tmp_win];
               autoscale_lu[tmp_win] = ltmp;
	ltmp = autoscale_ly[tmp_win]; autoscale_ly[tmp_win] = autoscale_lv[tmp_win];
               autoscale_lv[tmp_win] = ltmp;
	temp = xmin_win[tmp_win]; xmin_win[tmp_win] = umin_win[tmp_win]; umin_win[tmp_win] = temp;
	temp = xmax_win[tmp_win]; xmax_win[tmp_win] = umax_win[tmp_win]; umax_win[tmp_win] = temp;
	temp = ymin_win[tmp_win]; ymin_win[tmp_win] = vmin_win[tmp_win]; vmin_win[tmp_win] = temp;
	temp = ymax_win[tmp_win]; ymax_win[tmp_win] = vmax_win[tmp_win]; vmax_win[tmp_win] = temp;
	
	/* Now actually fix the plot triplets to be single plots. */
	parametric_3dfixup(tmp_win, first_3dplot, &plot_num,
			   x_min, x_max, y_min, y_max,
			   z_min, z_max);
	if (log_x[tmp_win]) {
	  if (x_min[tmp_win] <= 0.0 || x_max[tmp_win] <= 0.0)
	    int_error("x range must be greater than 0 for log scale!",NO_CARET);
	  x_min[tmp_win] = log10(x_min[tmp_win]);
	  x_max[tmp_win] = log10(x_max[tmp_win]);
	}
	
	if (log_y[tmp_win]) {
	  if (y_min[tmp_win] <= 0.0 || y_max[tmp_win] <= 0.0)
	    int_error("y range must be greater than 0 for log scale!",NO_CARET);
	  y_min[tmp_win] = log10(y_min[tmp_win]);
	  y_max[tmp_win] = log10(y_max[tmp_win]);
	}
	
	if (log_z[tmp_win]) {
	  if (z_min[tmp_win] <= 0.0 || z_max[tmp_win] <= 0.0)
	    int_error("z range must be greater than 0 for log scale!",NO_CARET);
	  z_min[tmp_win] = log10(z_min[tmp_win]);
	  z_max[tmp_win] = log10(z_max[tmp_win]);
	}
      }
    }
   
  for ( i = 0, head_free = first_3dplot; i++ < plot_num;
        head_free = head_free->next_sp);

  ppoints = (struct surface_points **) 
     malloc((unsigned int) sizeof(struct surface_points **)*(plot_num + 1));
  
  for ( i = 0; i < MAX_WIN; i++ )
    {
      pcount_win[i] = 0;
      this_plot = first_3dplot;
      for ( j = 0; j < plot_num; j++)
	{
	  if (this_plot->plot_window == i)
	    {
	      pcount_win[i]++;
	      *ppoints = this_plot;
	      ppoints++;
	      *ppoints = NULL;
	    }
	  this_plot = this_plot->next_sp;
	}
    }

  ppoints -= plot_num;
  first_3dplot = *ppoints;

  for (i = 0; i < MAX_WIN; i++)
    {
      this_plot = *ppoints;
      tmp = this_plot;
      if ( this_plot != NULL )
	{
	  for ( j = 0; j < pcount_win[i]; j++)
	    {
	      this_plot->next_sp = *(++ppoints);
	      this_plot = *ppoints;
	    }
	  this_plot = tmp;
	}
    }
  chain = *(ppoints-1);
  ppoints -= plot_num;
  free (ppoints);
 
    /* Creates contours if contours are to be plotted as well. */
  tmp_win = 0;

  this_plot=first_3dplot;
  for ( tmp_win = 0; tmp_win < MAX_WIN; tmp_win++ )
    {
      if (!draw_contour[tmp_win])
	{
	  for ( i = 0; i < pcount_win[tmp_win]; this_plot=this_plot->next_sp, i++);
	}
      else
	{
	  for ( i = 0; i < pcount_win[tmp_win];  this_plot = this_plot->next_sp, i++) {
	    if (this_plot->contours) {
		struct gnuplot_contours *cntr, *cntrs = this_plot->contours;

		while (cntrs) {
		    cntr = cntrs;
		    cntrs = cntrs->next;
		    free(cntr->coords);
		    free(cntr);
		}
	    }
	    /* Make sure this one can be contoured. */
	    if (!this_plot->has_grid_topology) {
		this_plot->contours = NULL;
		int_error("Can not contour non grid data!", NO_CARET);
	    }
	    if (this_plot->plot_type == DATA3D)
		this_plot->contours = contour(
						 this_plot->num_iso_read,
						 this_plot->iso_crvs,
						 contour_levels[tmp_win],
					         contour_pts[tmp_win],
						 contour_kind[tmp_win], 
					         contour_order[tmp_win],
						 levels_kind[tmp_win], 
					         levels_list[tmp_win]);
	    else
		this_plot->contours = contour(iso_samples[tmp_win],
					      this_plot->iso_crvs,
					      contour_levels[tmp_win], 
					      contour_pts[tmp_win],
					      contour_kind[tmp_win], 
					      contour_order[tmp_win],
					      levels_kind[tmp_win], 
					      levels_list[tmp_win]);
	  }
	}
    }
    if (strcmp(term_tbl[term].name, "table") == 0)
	print_3dtable();
    else
	do_3dplot(first_3dplot, pcount_win, x_min, x_max, y_min, y_max, z_min, z_max);
    chain->next_sp = head_free;
    sp_free(first_3dplot);
    first_3dplot = NULL;
}

done(status)
    int             status;
{
    if (term && term_init)
	(*term_tbl[term].reset) ();
#ifdef vms
    vms_reset();
#endif
    exit(status);
}

void 
parametric_fixup(win_num, start_plot, plot_num, x_min, x_max)
    int win_num;
    struct curve_points *start_plot;
    int            *plot_num;
    double         x_min[MAX_WIN], x_max[MAX_WIN];
/*
 * The hardest part of this routine is collapsing the FUNC plot types in the
 * list (which are gauranteed to occur in (x,y) pairs while preserving the
 * non-FUNC type plots intact.  This means we have to work our way through
 * various lists.  Examples (hand checked): start_plot:F1->F2->NULL ==>
 * F2->NULL start_plot:F1->F2->F3->F4->F5->F6->NULL ==> F2->F4->F6->NULL
 * start_plot:F1->F2->D1->D2->F3->F4->D3->NULL ==> F2->D1->D2->F4->D3->NULL
 * 
 * Of course, the more interesting work is to move the y values of the x
 * function to become the x values of the y function (checking the mins and
 * maxs as we go along).
 */
{
    struct curve_points *xp, *new_list, *yp = start_plot, *tmp, *free_list,
                   *free_head = NULL;
    int             i, tlen, curve, tmp_win;
    char           *new_title;
    double          lxmin[MAX_WIN], lxmax[MAX_WIN], temp;

  for ( i = 0; i < MAX_WIN; i++)
    {
      if (autoscale_lx[i]) {
	lxmin[i] = VERYLARGE;
	lxmax[i] = -VERYLARGE;
      } else {
	lxmin[i] = xmin_win[i];
	lxmax[i] = xmax_win[i];
      }
    }
    /*
     * Ok, go through all the plots and move FUNC types together.  Note: this
     * originally was written to look for a NULL next pointer, but gnuplot
     * wants to be sticky in grabbing memory and the right number of items in
     * the plot list is controlled by the plot_num variable.
     * 
     * Since gnuplot wants to do this sticky business, a free_list of
     * curve_points is kept and then tagged onto the end of the plot list as
     * this seems more in the spirit of the original memory behavior than
     * simply freeing the memory.  I'm personally not convinced this sort of
     * concern is worth it since the time spent computing points seems to
     * dominate any garbage collecting that might be saved here...
     */
    new_list = xp = start_plot;
    yp = xp->next_cp;
    curve = 0;
    for (; curve < *plot_num; xp = xp->next_cp, yp = yp->next_cp, curve++) {
      tmp_win = xp->plot_window;
      if (xp->plot_type != FUNC || tmp_win != win_num) {
	    continue;
	}
	/* Here's a FUNC parametric function defined as two parts. */
	--(*plot_num);
	/*
	 * Go through all the points assigning the y's from xp to be the x's
	 * for yp.  Check max's and min's as you go.
	 */
	for (i = 0; i < yp->p_count; ++i) {
	    /*
	     * Throw away excess xp points, mark excess yp points as
	     * OUTRANGE.
	     */
	    if (i > xp->p_count) {
		yp->points[i].type = OUTRANGE;
		continue;
	    }
	    /*
	     * Just as we had to do when we computed y values--now check that
	     * x's (computed parametrically) are in the permitted ranges as
	     * well.
	     */
	    temp = xp->points[i].y;	/* New x value for yp function. */
	    yp->points[i].x = temp;
	    /* Handle undefined values differently from normal ranges. */
	    if (xp->points[i].type == UNDEFINED)
		yp->points[i].type = xp->points[i].type;
	    if (autoscale_lx[tmp_win] || polar[tmp_win]
		|| inrange(temp, lxmin[tmp_win], lxmax[tmp_win])) {
		if (autoscale_lx[tmp_win] && temp < lxmin[tmp_win])
		    lxmin[tmp_win] = temp;
		if (autoscale_lx[tmp_win] && temp > lxmax[tmp_win])
		    lxmax[tmp_win] = temp;
	    } else
		yp->points[i].type = OUTRANGE;	/* Due to x value. */
	}
	/* Ok, fix up the title to include both the xp and yp plots. */
	if (xp->title && xp->title[0] != '\0') {
	    tlen = strlen(yp->title) + strlen(xp->title) + 3;
	    new_title = alloc((unsigned int) tlen, "string");
	    strcpy(new_title, xp->title);
	    strcat(new_title, ", ");	/* + 2 */
	    strcat(new_title, yp->title);	/* + 1 = + 3 */
	    free(yp->title);
	    yp->title = new_title;
	}
	/* Eliminate the first curve (xparam) and just use the second. */
	if (xp == start_plot) {
	    /* Simply nip off the first element of the list. */
	    new_list = first_plot = yp;
	    xp = xp->next_cp;
	    if (yp->next_cp != NULL)
		yp = yp->next_cp;
	    /* Add start_plot to the free_list. */
	    if (free_head == NULL) {
		free_list = free_head = start_plot;
		free_head->next_cp = NULL;
	    } else {
		free_list->next_cp = start_plot;
		start_plot->next_cp = NULL;
		free_list = start_plot;
	    }
	} else {
	    /* Here, remove the xp node and replace it with the yp node. */
	    tmp = xp;
	    /* Pass over any data files that might have been in place. */
	    while (new_list->next_cp && new_list->next_cp != xp)
		new_list = new_list->next_cp;
	    new_list->next_cp = yp;
	    new_list = new_list->next_cp;
	    xp = xp->next_cp;
	    if (yp->next_cp != NULL)
		yp = yp->next_cp;
	    /* Add tmp to the free_list. */
	    tmp->next_cp = NULL;
	    if (free_head == NULL) {
		free_list = free_head = tmp;
	    } else {
		free_list->next_cp = tmp;
		free_list = tmp;
	    }
	}
    }
    /* Ok, stick the free list at the end of the curve_points plot list. */
    while (new_list->next_cp != NULL)
	new_list = new_list->next_cp;
    new_list->next_cp = free_head;

    /* Report the overall graph mins and maxs. */
    x_min[win_num] = lxmin[win_num];
    x_max[win_num] = lxmax[win_num];
}

void 
parametric_3dfixup(win_num, start_plot, plot_num, x_min, x_max, y_min, y_max,
		   z_min, z_max)
     int win_num;
    struct surface_points *start_plot;
    int            *plot_num;
    double         x_min[MAX_WIN], x_max[MAX_WIN], y_min[MAX_WIN], y_max[MAX_WIN], 
                   z_min[MAX_WIN], z_max[MAX_WIN];
/*
 * The hardest part of this routine is collapsing the FUNC plot types in the
 * list (which are gauranteed to occur in (x,y,z) triplets while preserving
 * the non-FUNC type plots intact.  This means we have to work our way
 * through various lists.  Examples (hand checked):
 * start_plot:F1->F2->F3->NULL ==> F3->NULL
 * start_plot:F1->F2->F3->F4->F5->F6->NULL ==> F3->F6->NULL
 * start_plot:F1->F2->F3->D1->D2->F4->F5->F6->D3->NULL ==>
 * F3->D1->D2->F6->D3->NULL
 */
{
    struct surface_points *xp, *yp, *zp, *new_list, *tmp, *free_list, *free_head = NULL;
    struct iso_curve *icrvs, *xicrvs, *yicrvs, *zicrvs;
    int             i, tlen, surface;
    char           *new_title;
    double          lxmin[MAX_WIN], lxmax[MAX_WIN], lymin[MAX_WIN], lymax[MAX_WIN], 
                    lzmin[MAX_WIN], lzmax[MAX_WIN], temp;
    int tmp_win;

   for ( i = 0; i < MAX_WIN; i++)
     {
	if (autoscale_lx[i]) {
		lxmin[i] = VERYLARGE;
		lxmax[i] = -VERYLARGE;
	} else {
		lxmin[i] = xmin_win[i];
		lxmax[i] = xmax_win[i];
	}

	if (autoscale_ly[i]) {
		lymin[i] = VERYLARGE;
		lymax[i] = -VERYLARGE;
	} else {
		lymin[i] = ymin_win[i];
		lymax[i] = ymax_win[i];
	}

	if (autoscale_lz[i]) {
		lzmin[i] = VERYLARGE;
		lzmax[i] = -VERYLARGE;
	} else {
		lzmin[i] = zmin_win[i];
		lzmax[i] = zmax_win[i];
	}
      }

    /*
     * Ok, go through all the plots and move FUNC3D types together.  Note:
     * this originally was written to look for a NULL next pointer, but
     * gnuplot wants to be sticky in grabbing memory and the right number of
     * items in the plot list is controlled by the plot_num variable.
     * 
     * Since gnuplot wants to do this sticky business, a free_list of
     * surface_points is kept and then tagged onto the end of the plot list
     * as this seems more in the spirit of the original memory behavior than
     * simply freeing the memory.  I'm personally not convinced this sort of
     * concern is worth it since the time spent computing points seems to
     * dominate any garbage collecting that might be saved here...
     */
    new_list = xp = start_plot;
    for (surface = 0; surface < *plot_num; surface++) {
      tmp_win = xp->plot_window;
      if (tmp_win != win_num) {
	xp = xp->next_sp;
	continue;
      }
      if (xp->plot_type != FUNC3D) {
	    icrvs = xp->iso_crvs;

	    while (icrvs) {
		struct coordinate *points = icrvs->points;

		for (i = 0; i < icrvs->p_count; ++i) {
		    if (lxmin[tmp_win] > points[i].x)
			lxmin[tmp_win] = points[i].x;
		    if (lxmax[tmp_win] < points[i].x)
			lxmax[tmp_win] = points[i].x;
		    if (lymin[tmp_win] > points[i].y)
			lymin[tmp_win] = points[i].y;
		    if (lymax[tmp_win] < points[i].y)
			lymax[tmp_win] = points[i].y;
		    if (lzmin[tmp_win] > points[i].z)
			lzmin[tmp_win] = points[i].z;
		    if (lzmax[tmp_win] < points[i].z)
			lzmax[tmp_win] = points[i].z;
		}

		icrvs = icrvs->next;
	    }
	    xp = xp->next_sp;
	    continue;
	}
	yp = xp->next_sp;
	zp = yp->next_sp;

	/* Here's a FUNC3D parametric function defined as three parts. */
	(*plot_num) -= 2;
	/*
	 * Go through all the points and assign the x's and y's from xp and
	 * yp to zp.  Check max's and min's as you go.
	 */
	xicrvs = xp->iso_crvs;
	yicrvs = yp->iso_crvs;
	zicrvs = zp->iso_crvs;
	while (zicrvs) {
	    struct coordinate *xpoints = xicrvs->points, 
	                      *ypoints = yicrvs->points, 
	                      *zpoints = zicrvs->points;
	    for (i = 0; i < zicrvs->p_count; ++i) {
		zpoints[i].x = xpoints[i].z;
		zpoints[i].y = ypoints[i].z;

		if (lxmin[tmp_win] > zpoints[i].x)
		    lxmin[tmp_win] = zpoints[i].x;
		if (lxmax[tmp_win] < zpoints[i].x)
		    lxmax[tmp_win] = zpoints[i].x;
		if (lymin[tmp_win] > zpoints[i].y)
		    lymin[tmp_win] = zpoints[i].y;
		if (lymax[tmp_win] < zpoints[i].y)
		    lymax[tmp_win] = zpoints[i].y;
		if (lzmin[tmp_win] > zpoints[i].z)
		    lzmin[tmp_win] = zpoints[i].z;
		if (lzmax[tmp_win] < zpoints[i].z)
		    lzmax[tmp_win] = zpoints[i].z;
	    }
	    xicrvs = xicrvs->next;
	    yicrvs = yicrvs->next;
	    zicrvs = zicrvs->next;
	}

	/* Ok, fix up the title to include xp and yp plots. */
	if ((xp->title && xp->title[0] != '\0') ||
	    (yp->title && yp->title[0] != '\0')) {
	    tlen = (xp->title ? strlen(xp->title) : 0) +
		(yp->title ? strlen(yp->title) : 0) +
		(zp->title ? strlen(zp->title) : 0) + 5;
	    new_title = alloc((unsigned int) tlen, "string");
	    new_title[0] = 0;
	    if (xp->title) {
		strcat(new_title, xp->title);
		strcat(new_title, ", ");	/* + 2 */
	    }
	    if (yp->title) {
		strcat(new_title, yp->title);
		strcat(new_title, ", ");	/* + 2 */
	    }
	    if (zp->title) {
		strcat(new_title, zp->title);
	    }
	    free(zp->title);
	    zp->title = new_title;
	}
	/*
	 * Eliminate the first two surfaces (xp and yp) and just use the
	 * third.
	 */
	if (xp == start_plot) {
	    /* Simply nip off the first two elements of the list. */
	    new_list = first_3dplot = zp;
	    xp = zp->next_sp;
	    /* Add xp and yp to the free_list. */
	    if (free_head == NULL) {
		free_head = start_plot;
	    } else {
		free_list->next_sp = start_plot;
	    }
	    free_list = start_plot->next_sp;
	    free_list->next_sp = NULL;
	} else {
	    /*
	     * Here, remove the xp,yp nodes and replace them with the zp
	     * node.
	     */
	    tmp = xp;
	    /* Pass over any data files that might have been in place. */
	    while (new_list->next_sp && new_list->next_sp != xp)
		new_list = new_list->next_sp;
	    new_list->next_sp = zp;
	    new_list = zp;
	    xp = zp->next_sp;
	    /* Add tmp to the free_list. */
	    if (free_head == NULL) {
		free_head = tmp;
	    } else {
		free_list->next_sp = tmp;
	    }
	    free_list = tmp->next_sp;
	    free_list->next_sp = NULL;
	}
    }
    /* Ok, stick the free list at the end of the surface_points plot list. */
    while (new_list->next_sp != NULL)
	new_list = new_list->next_sp;
    new_list->next_sp = free_head;

    if (lxmax[win_num] - lxmin[win_num] < zero[win_num]) {
	if (fabs(lxmax[win_num]) < zero[win_num]) {
	    lxmin[win_num] = -1.0;
	    lxmax[win_num] = 1.0;
	} else {
	    lxmin[win_num] *= 0.9;
	    lxmax[win_num] *= 1.1;
	}
    }
    if (lymax[win_num] - lymin[win_num] < zero[win_num]) {
	if (fabs(lymax[win_num]) < zero[win_num]) {
	    lymin[win_num] = -1.0;
	    lymax[win_num] = 1.0;
	} else {
	    lymin[win_num] *= 0.9;
	    lymax[win_num] *= 1.1;
	}
    }
    if (lzmax[win_num] - lzmin[win_num] < zero[win_num]) {
	if (fabs(lzmax[win_num]) < zero[win_num]) {
	    lzmin[win_num] = -1.0;
	    lzmax[win_num] = 1.0;
	} else {
	    lzmin[win_num] *= 0.9;
	    lzmax[win_num] *= 1.1;
	}
    }
    /* Report the overall graph mins and maxs. */

    if (autoscale_lx[win_num]) {
      x_min[win_num] = (log_x[win_num] ? pow(10.0, lxmin[win_num]) : lxmin[win_num]);
      x_max[win_num] = (log_x[win_num] ? pow(10.0, lxmax[win_num]) : lxmax[win_num]);
    }
    else {
      x_min[win_num] = xmin_win[win_num];
      x_max[win_num] = xmax_win[win_num];
    }
    if (autoscale_ly[win_num]) {
      y_min[win_num] = (log_y[win_num] ? pow(10.0, lymin[win_num]) : lymin[win_num]);
      y_max[win_num] = (log_y[win_num] ? pow(10.0, lymax[win_num]) : lymax[win_num]);
    }
    else {
      y_min[win_num] = ymin_win[win_num];
      y_max[win_num] = ymax_win[win_num];
    }
    if (autoscale_lz[win_num]) {
      z_min[win_num] = (log_z[win_num] ? pow(10.0, lzmin[win_num]) : lzmin[win_num]);
      z_max[win_num] = (log_z[win_num] ? pow(10.0, lzmax[win_num]) : lzmax[win_num]);
    }
    else {
      z_min[win_num] = zmin_win[win_num];
      z_max[win_num] = zmax_win[win_num];
    }
}

#ifdef AMIGA_LC_5_1
void 
sleep(delay)
    unsigned int    delay;
{
    Delay(50 * delay);
}
#endif

#ifdef AMIGA_AC_5
void 
sleep(delay)
    unsigned int    delay;
{
    unsigned long   time_is_up;
    time_is_up = time(NULL) + (unsigned long) delay;
    while (time(NULL) < time_is_up)
	 /* wait */ ;
}
#endif

#ifdef MSDOS
#if !defined(__TURBOC__) || defined(_Windows) /* Turbo C already has sleep() */
#ifndef __ZTC__			/* ZTC already has usleep() */
/* kludge to provide sleep() for msc 5.1 */
void 
sleep(delay)
    unsigned int    delay;
{
    unsigned long   time_is_up;
    time_is_up = time(NULL) + (unsigned long) delay;
    while (time(NULL) < time_is_up)
	 /* wait */ ;
}
#endif				/* not ZTC */
#endif				/* not TURBOC */
#endif				/* MSDOS */


/* Support for input, shell, and help for various systems */

#ifdef vms

#include <descrip.h>
#include <rmsdef.h>
#include <errno.h>
#include <smgdef.h>
#include <smgmsg.h>

extern          lib$get_input(), lib$put_output();
extern          smg$read_composed_line();

int             vms_len;

unsigned int    status[2] =
{1, 0};

static char     help[MAX_LINE_LEN + 1] = "gnuplot";

$DESCRIPTOR(prompt_desc, PROMPT);
$DESCRIPTOR(line_desc, input_line);

$DESCRIPTOR(help_desc, help);
$DESCRIPTOR(helpfile_desc, "GNUPLOT$HELP");


read_line(prompt)
    char           *prompt;
{
    int             more, start = 0;
    char            expand_prompt[40];

    prompt_desc.dsc$w_length = strlen(prompt);
    prompt_desc.dsc$a_pointer = prompt;
    (void) strcpy(expand_prompt, "_");
    (void) strncat(expand_prompt, prompt, 38);
    do {
	line_desc.dsc$w_length = MAX_LINE_LEN - start;
	line_desc.dsc$a_pointer = &input_line[start];
	switch (status[1] = smg$read_composed_line(&vms_vkid, 0, &line_desc, &prompt_desc, &vms_len)) {
	case SMG$_EOF:
	    done(IO_SUCCESS);	/* ^Z isn't really an error */
	    break;
	case RMS$_TNS:		/* didn't press return in time * / vms_len--;
				 * /* skip the last character */
	    break;		/* and parse anyway */
	case RMS$_BES:		/* Bad Escape Sequence */
	case RMS$_PES:		/* Partial Escape Sequence */
	    sys$putmsg(status);
	    vms_len = 0;	/* ignore the line */
	    break;
	case SS$_NORMAL:
	    break;		/* everything's fine */
	default:
	    done(status[1]);	/* give the error message */
	}
	start += vms_len;
	input_line[start] = '\0';
	inline_num++;
	if (input_line[start - 1] == '\\') {
	    /* Allow for a continuation line. */
	    prompt_desc.dsc$w_length = strlen(expand_prompt);
	    prompt_desc.dsc$a_pointer = expand_prompt;
	    more = 1;
	    --start;
	} else {
	    line_desc.dsc$w_length = strlen(input_line);
	    line_desc.dsc$a_pointer = input_line;
	    more = 0;
	}
    } while (more);
return(0);
}


do_help()
{
    help_desc.dsc$w_length = strlen(help);
    if ((vaxc$errno = lbr$output_help(lib$put_output, 0, &help_desc,
			   &helpfile_desc, 0, lib$get_input)) != SS$_NORMAL)
	os_error("can't open GNUPLOT$HELP", NO_CARET);
}


do_shell()
{
    if ((vaxc$errno = lib$spawn()) != SS$_NORMAL) {
	os_error("spawn error", NO_CARET);
    }
}


do_system()
{
    input_line[0] = ' ';	/* an embarrassment, but... */

    if ((vaxc$errno = lib$spawn(&line_desc)) != SS$_NORMAL)
	os_error("spawn error", NO_CARET);

    (void) putc('\n', stderr);
}

#else				/* vms */

#ifdef _Windows
do_help()
{
    WinHelp(hwndeasy,(LPSTR)winhelpname,HELP_INDEX,(DWORD)NULL);
}
#else

/*
 * do_help: (not VMS, although it would work) Give help to the user. It
 * parses the command line into helpbuf and supplies help for that string.
 * Then, if there are subtopics available for that key, it prompts the user
 * with this string. If more input is given, do_help is called recursively,
 * with the argument the index of null character in the string. Thus a more
 * specific help can be supplied. This can be done repeatedly. If null input
 * is given, the function returns, effecting a backward climb up the tree.
 * David Kotz (David.Kotz@Dartmouth.edu) 10/89
 */
do_help()
{
    static char    *helpbuf = NULL;
    static char    *prompt = NULL;
    int             base;	/* index of first char AFTER help string */
    int             len;	/* length of current help string */
    BOOLEAN         more_help;
    BOOLEAN         only;	/* TRUE if only printing subtopics */
    int             subtopics;	/* 0 if no subtopics for this topic */
    int             start;	/* starting token of help string */
    char           *help_ptr;	/* name of help file */

    if ((help_ptr = getenv("GNUHELP")) == (char *) NULL)
	/* if can't find environment variable then just use HELPFILE */
	help_ptr = HELPFILE;

    /* Since MSDOS DGROUP segment is being overflowed we can not allow such  */
    /* huge static variables (1k each). Instead we dynamically allocate them */
    /* on the first call to this function...				     */
    if (helpbuf == NULL) {
	helpbuf = alloc(MAX_LINE_LEN, "help buffer");
	prompt = alloc(MAX_LINE_LEN, "help prompt");
	helpbuf[0] = prompt[0] = 0;
    }
    len = base = strlen(helpbuf);

    /* find the end of the help command */
    for (start = c_token; !(END_OF_COMMAND); c_token++);
    /* copy new help input into helpbuf */
    if (len > 0)
	helpbuf[len++] = ' ';	/* add a space */
    capture(helpbuf + len, start, c_token - 1);
    squash_spaces(helpbuf + base);	/* only bother with new stuff */
    lower_case(helpbuf + base);	/* only bother with new stuff */
    len = strlen(helpbuf);

    /* now, a lone ? will print subtopics only */
    if (strcmp(helpbuf + (base ? base + 1 : 0), "?") == 0) {
	/* subtopics only */
	subtopics = 1;
	only = TRUE;
	helpbuf[base] = '\0';	/* cut off question mark */
    } else {
	/* normal help request */
	subtopics = 0;
	only = FALSE;
    }

    switch (help(helpbuf, help_ptr, &subtopics)) {
    case H_FOUND:{
	    /* already printed the help info */
	    /* subtopics now is true if there were any subtopics */
	    screen_ok = FALSE;

	    do {
		if (subtopics && !only) {
		    /* prompt for subtopic with current help string */
		    if (len > 0)
			(void) sprintf(prompt, "Subtopic of %s: ", helpbuf);
		    else
			(void) strcpy(prompt, "Help topic: ");
		    read_line(prompt);
		    num_tokens = scanner(input_line);
		    c_token = 0;
		    more_help = !(END_OF_COMMAND);
		    if (more_help)
			/* base for next level is all of current helpbuf */
			do_help();
		} else
		    more_help = FALSE;
	    } while (more_help);

	    break;
	}
    case H_NOTFOUND:{
	    printf("Sorry, no help for '%s'\n", helpbuf);
	    break;
	}
    case H_ERROR:{
	    perror(help_ptr);
	    break;
	}
    default:{			/* defensive programming */
	    int_error("Impossible case in switch\n", NO_CARET);
	    /* NOTREACHED */
	}
    }

    helpbuf[base] = '\0';	/* cut it off where we started */
}
#endif  /* _Windows */

#ifdef AMIGA_AC_5
char            strg0[256];
#endif
#if defined(ATARI)&&defined(__GNUC__)
#include <osbind.h>
#endif

do_system()
{
#ifdef AMIGA_AC_5
    char           *parms[80];
    void            getparms();

    getparms(input_line + 1, parms);
    if (fexecv(parms[0], parms) < 0)
#else
#if defined(ATARI)&&defined(__GNUC__)
    /* use preloaded shell, if available */
    short           (*shell_p) (char *command);
    void           *ssp;

    ssp = (void *) Super(NULL);
    shell_p = *(short (**) (char *)) 0x4f6;
    Super(ssp);

    /* this is a bit strange, but we have to have a single if */
    if ((shell_p ? (*shell_p) (input_line + 1) : system(input_line + 1)))
#else
#ifdef _Windows
    if (winsystem(input_line + 1))
#else
    if (system(input_line + 1))
#endif
#endif
#endif
	os_error("system() failed", NO_CARET);
}

#ifdef AMIGA_AC_5

/******************************************************************************/
/* */
/* Parses the command string (for fexecv use) and  converts the first token  */
/* to lower case                                                          */
/* */
/******************************************************************************/

void 
getparms(command, parms)
    char           *command;
    char          **parms;
{
    register int    i = 0;	/* A bunch of indices          */
    register int    j = 0;
    register int    k = 0;

    while (*(command + j) != '\0') {	/* Loop on string characters   */
	parms[k++] = strg0 + i;
	while (*(command + j) == ' ')
	    ++j;
	while (*(command + j) != ' ' && *(command + j) != '\0') {
	    if (*(command + j) == '"')	/* Get quoted string           */
		for (*(strg0 + (i++)) = *(command + (j++));
		     *(command + j) != '"';
		     *(strg0 + (i++)) = *(command + (j++)));
	    *(strg0 + (i++)) = *(command + (j++));
	}
	*(strg0 + (i++)) = '\0';/* NUL terminate every token   */
    }
    parms[k] = '\0';

    for (k = strlen(strg0) - 1; k >= 0; --k)	/* Convert to lower case       */
	*(strg0 + k) >= 'A' && *(strg0 + k) <= 'Z' ? *(strg0 + k) |= 32 : *(strg0 + k);
}

#endif				/* AMIGA_AC_5 */

#ifdef READLINE
char           *
rlgets(s, n, prompt)
    char           *s;
    int             n;
    char           *prompt;
{
    char           *readline();
    static char    *line = (char *) NULL;

    /* If we already have a line, first free it */
    if (line != (char *) NULL)
	free(line);

    line = readline((interactive) ? prompt : "");

    /* If it's not an EOF */
    if (line) {
	if (*line)
	    add_history(line);
	strncpy(s, line, n);
	return s;
    }
    return line;
}
#endif				/* READLINE */

#ifdef MSDOS

#ifndef _Windows
#ifdef __TURBOC__ 
/* cgets implemented using dos functions */
/* Maurice Castro 22/5/91 */
char           *
doscgets(s)
    char           *s;
{
    long            datseg;

    /* protect and preserve segments - call dos to do the dirty work */
    datseg = _DS;

    _DX = FP_OFF(s);
    _DS = FP_SEG(s);
    _AH = 0x0A;
    geninterrupt(33);
    _DS = datseg;

    /* check for a carriage return and then clobber it with a null */
    if (s[s[1] + 2] == '\r')
	s[s[1] + 2] = 0;

    /* return the input string */
    return (&(s[2]));
}
#endif				/* __TURBOC__ */
#endif				/* !_Windows */


read_line(prompt)
    char           *prompt;
{
    register int    i;
    int             start = 0, ilen = 0;
    BOOLEAN         more;
    int             last;
    char           *p, *crnt_prompt = prompt;

#ifndef __ZTC__
    if (interactive) {		/* if interactive use console IO so CED will
				 * work */
#ifndef READLINE
#ifdef _Windows
	printf("%s", prompt);
#else
	cputs(prompt);
#endif
#endif				/* READLINE */
	do {
	    ilen = MAX_LINE_LEN - start - 1;
	    input_line[start] = ilen > 126 ? 126 : ilen;
#ifdef READLINE
	    input_line[start + 2] = 0;
	    (void) rlgets(&(input_line[start + 2]), ilen, crnt_prompt);
	    if ((p = strchr(&(input_line[start + 2]), '\r'))!=NULL)
		*p = 0;
	    if ((p = strchr(&(input_line[start + 2]), '\n'))!=NULL)
		*p = 0;
	    input_line[start + 1] = strlen(&(input_line[start + 2]));
#else				/* READLINE */
#ifdef _Windows
	    (void) gets(&(input_line[start+2]));
#else
#ifdef __TURBOC__
	    (void) doscgets(&(input_line[start]));
#else				/* __TURBOC__ */
	    (void) cgets(&(input_line[start]));
#endif				/* __TURBOC__ */
#endif				/* _Windows */
	    (void) putc('\n', stderr);
#endif				/* READLINE */
	    if (input_line[start + 2] == 26) {
		/* end-of-file */
		(void) putc('\n', stderr);
		input_line[start] = '\0';
		inline_num++;
		if (start > 0)	/* don't quit yet - process what we have */
		    more = FALSE;
		else {
		    (void) putc('\n', stderr);
		    return(1); /* exit gnuplot */
		    /* NOTREACHED */
		}
	    } else {
		/* normal line input */
		register        i = start;
		while ((input_line[i] = input_line[i + 2]) != (char) NULL)
		    i++;	/* yuck!  move everything down two characters */

		inline_num++;
		last = strlen(input_line) - 1;
		if (last<0) last=0;  /* stop UAE in Windows */
		if (last + 1 >= MAX_LINE_LEN)
		    int_error("Input line too long", NO_CARET);

		if (input_line[last] == '\\') {	/* line continuation */
		    start = last;
		    more = TRUE;
		} else
		    more = FALSE;
	    }
#ifndef READLINE
	    if (more)
#ifdef _Windows
		printf("> ");
#else
		cputs("> ");
#endif
#else
	    crnt_prompt = "> ";
#endif				/* READLINE */
	} while (more);
    } else {			/* not interactive */
#endif				/* not ZTC */
	if (interactive)
	    fputs(prompt, stderr);
	do {
	    /* grab some input */
	    if (fgets(&(input_line[start]), MAX_LINE_LEN - start, stdin)
		== (char *) NULL) {
		/* end-of-file */
		if (interactive)
		    (void) putc('\n', stderr);
		input_line[start] = '\0';
		inline_num++;
		if (start > 0)	/* don't quit yet - process what we have */
		    more = FALSE;
		else
		    return(1);  /* exit gnuplot */
	    } else {
		/* normal line input */
		last = strlen(input_line) - 1;
		if (input_line[last] == '\n') {	/* remove any newline */
		    input_line[last] = '\0';
		    /* Watch out that we don't backup beyond 0 (1-1-1) */
		    if (last > 0)
			--last;
		    inline_num++;
		} else if (last + 1 >= MAX_LINE_LEN)
		    int_error("Input line too long", NO_CARET);

		if (input_line[last] == '\\') {	/* line continuation */
		    start = last;
		    more = TRUE;
		} else
		    more = FALSE;
	    }
	    if (more && interactive)
		fputs("> ", stderr);
	} while (more);
#ifndef __ZTC__
    }
#endif
    return(0);
}


do_shell()
{
    register char  *comspec;
    if ((comspec = getenv("COMSPEC")) == (char *) NULL)
	comspec = "\command.com";
#ifdef _Windows
    if (WinExec(comspec, SW_SHOWNORMAL) <= 32)
#else
    if (spawnl(P_WAIT, comspec, NULL) == -1)
#endif
	os_error("unable to spawn shell", NO_CARET);
}

#else				/* MSDOS */
/* plain old Unix */

read_line(prompt)
    char           *prompt;
{
    int             start = 0;
    BOOLEAN         more = FALSE;
    int             last = 0;

#ifndef READLINE
    if (interactive)
	fputs(prompt, stderr);
#endif				/* READLINE */
    do {
	/* grab some input */
#ifdef READLINE
	if (((interactive)
	     ? rlgets(&(input_line[start]), MAX_LINE_LEN - start,
		      ((more) ? "> " : prompt))
	     : fgets(&(input_line[start]), MAX_LINE_LEN - start, stdin))
	    == (char *) NULL) {
#else
	if (fgets(&(input_line[start]), MAX_LINE_LEN - start, stdin)
	    == (char *) NULL) {
#endif				/* READLINE */
	    /* end-of-file */
	    if (interactive)
		(void) putc('\n', stderr);
	    input_line[start] = '\0';
	    inline_num++;
	    if (start > 0)	/* don't quit yet - process what we have */
		more = FALSE;
	    else
		return(1); /* exit gnuplot */
	} else {
	    /* normal line input */
	    last = strlen(input_line) - 1;
	    if (input_line[last] == '\n') {	/* remove any newline */
		input_line[last] = '\0';
		/* Watch out that we don't backup beyond 0 (1-1-1) */
		if (last > 0)
		    --last;
	    } else if (last + 1 >= MAX_LINE_LEN)
		int_error("Input line too long", NO_CARET);

	    if (input_line[last] == '\\') {	/* line continuation */
		start = last;
		more = TRUE;
	    } else
		more = FALSE;
	}
#ifndef READLINE
	if (more && interactive)
	    fputs("> ", stderr);
#endif
    } while (more);
    return(0);
}

#ifdef VFORK

do_shell()
{
    register char  *shell;
    register int    p;
    static int      execstat;
    if (!(shell = getenv("SHELL")))
	shell = SHELL;
#ifdef AMIGA_AC_5
    execstat = fexecl(shell, shell, NULL);
#else
    if ((p = vfork()) == 0) {
	execstat = execl(shell, shell, NULL);
	_exit(1);
    } else if (p == -1)
	os_error("vfork failed", c_token);
    else
	while (wait(NULL) != p)
#endif
	    ;
    if (execstat == -1)
	os_error("shell exec failed", c_token);
    (void) putc('\n', stderr);
}
#else				/* VFORK */

#ifdef AMIGA_LC_5_1
do_shell()
{
    register char  *shell;
    if (!(shell = getenv("SHELL")))
	shell = SHELL;

    if (system(shell))
	os_error("system() failed", NO_CARET);

    (void) putc('\n', stderr);
}
#else				/* AMIGA_LC_5_1 */

#define EXEC "exec "
do_shell()
{
    static char     exec[100] = EXEC;
    register char  *shell;
    if (!(shell = getenv("SHELL")))
	shell = SHELL;

    if (system(strncpy(&exec[sizeof(EXEC) - 1], shell,
		       sizeof(exec) - sizeof(EXEC) - 1)))
	os_error("system() failed", NO_CARET);

    (void) putc('\n', stderr);
}
#endif				/* AMIGA_LC_5_1 */
#endif				/* VFORK */
#endif				/* MSDOS */
#endif				/* vms */

#ifdef _Windows
/* there is a system like call on MS Windows but it is a bit difficult to 
   use, so we will invoke the command interpreter and use it to execute the 
   commands */
int winsystem(s)
char *s;
{
	register char *comspec;
	char *execstr;
	char *c;

	/* if the command is blank we must use command.com */
	c = s;
	while ((*c == ' ') || (*c == '\n') || (*c == '\r'))
		c++;
	if (*c == NULL)
	{
		if ((comspec = getenv("COMSPEC")) == (char *)NULL)
			comspec = "\command.com";
		WinExec(comspec, SW_SHOWNORMAL);
		}
	else
	{
		/* attempt to run the windows/dos program via windows */
		if (WinExec(s, SW_SHOWNORMAL) <= 32)
		{
			/* attempt to run it as a dos program from command line */
			if ((comspec = getenv("COMSPEC")) == (char *)NULL)
				comspec = "\command.com";
			execstr = (char *) farmalloc(strlen(s) + strlen(comspec) + 6);
			strcpy(execstr, comspec);
			strcat(execstr, " /c ");
			strcat(execstr, s);
			WinExec(execstr, SW_SHOWNORMAL);
			farfree(execstr);
			}
		}

	/* regardless of the reality return OK - the consequences of */
	/* failure include shutting down Windows */
	return(0);		/* success */
	}
#endif
