/* $Id: matrix.h 1.1 1993/08/01 04:21:55 cg Exp cg $ */

/*
 *	Header file: public functions in matrix.c
 *
 *
 *	Copyright of this module:   Carsten Grammes, 1993
 *      Experimental Physics, University of Saarbruecken, Germany
 *
 *	Internet address: cagr@rz.uni-sb.de
 *
 *	Permission to use, copy, and distribute this software and its
 *	documentation for any purpose with or without fee is hereby granted,
 *	provided that the above copyright notice appear in all copies and
 *	that both that copyright notice and this permission notice appear
 *	in supporting documentation.
 *
 *      This software is provided "as is" without express or implied warranty.
 */


#ifndef MATRIX_H
#define MATRIX_H

#ifdef EXT
#undef EXT
#endif

#ifdef MATRIX_MAIN
#define EXT
#else
#define EXT extern
#endif


/******* public functions ******/

EXT double  *vec (int n);
EXT int     *ivec (int n);
EXT double  **matr (int r, int c);
EXT void    free_matr (double **m, int r);
EXT void    redim_vec (double **v, int n);
EXT void    redim_ivec (int **v, int n);
EXT void    solve (double **a, int n, double **b, int m);
EXT void    inverse (double **src, double **dst, int n);

#endif
