/* Test a Mach thread_state for being in a mach_msg syscall.  Stub version.
Copyright (C) 1994 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#include <hurd.h>
#include <thread_status.h>

/* Return nonzero if STATE indicates a thread
   that is blocked in a mach_msg system call.  */
int
_hurd_thread_state_msging_p (void *state)
{
  if (setjmp (_hurd_sigthread_fault_env))
    /* The PC pointed at bogus memory.  */
    return 0;
  else
    {
      struct hurd_thread_state *ts = state;
      /* Examine the code at the PC value in TS and see if
	 the thread is blocked in a `mach_msg_trap' system call.  */
      #error "Need to write sysdeps/mach/hurd/MACHINE/msging_p.c"
    }
}
