/* Translate Mach exception codes into signal numbers.  Stub version.
Copyright (C) 1991, 1992, 1994 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#include <hurd.h>

/* Translate the Mach exception codes, as received in an `exception_raise' RPC,
   into a signal number and signal subcode.  */

void
_hurd_exception2signal (int exception, int code, int subcode,
			int *signo, int *sigcode)
{
  switch (exception)
    {
    default:
      *signo = SIGIOT;
      *sigcode = exception;
      break;
      
    case EXC_BAD_ACCESS:
      if (code == KERN_PROTECTION_FAILURE)
	*signo = SIGSEGV;
      else
	*signo = SIGBUS;
      *sigcode = subcode;
      break;

    case EXC_BAD_INSTRUCTION:
      *signo = SIGILL;
      *sigcode = 0;
      break;
      
    case EXC_ARITHMETIC:
      *signo = SIGFPE;
      *sigcode = 0;
      break;

    case EXC_EMULATION:		
    case EXC_SOFTWARE:
      *signo = SIGEMT;
      *sigcode = 0;
      break;
      
    case EXC_BREAKPOINT:
      *signo = SIGTRAP;
      *sigcode = 0;
      break;
    }
}
