/* Copyright (C) 1991, 1992, 1993, 1994 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#include <ansidecl.h>
#include <errno.h>
#include <hurd.h>
#include <hurd/signal.h>


/* Change the set of blocked signals to SET,
   wait until a signal arrives, and restore the set of blocked signals.  */
int
DEFUN(sigsuspend, (set), CONST sigset_t *set)
{
  struct hurd_sigstate *ss;
  sigset_t newmask, oldmask;

  if (set != NULL)
    /* Crash before locking.  */
    newmask = *set;

  ss = _hurd_self_sigstate ();
  oldmask = ss->blocked;
  if (set != NULL)
    ss->blocked = newmask & ~_SIG_CANT_MASK;

  /* Set the `suspended' bit and wait for a condition_signal on
     SS->arrived.  When a signal arrives and SS->suspended is set, the
     signal thread does condition_signal (&SS->arrived) after clearing
     SS->suspended.  */
  ss->suspended = 1;
  do
    {
#ifdef noteven
      __condition_wait (&ss->arrived, &ss->lock);
#else  /* XXX */
      __mutex_unlock (&ss->lock); __swtch (); __mutex_lock (&ss->lock);
#endif
    } while (ss->suspended);

  ss->blocked = oldmask;
  __mutex_unlock (&ss->lock);

  /* We've been interrupted!  And a good thing, too.
     Otherwise we'd never return.
     That's right; this function always returns an error.  */
  errno = EINTR;
  return -1;
}
