/* misc.h -- prototypes for the functions in misc.c. */

/* Copyright (C) 1993, 1994, 1995 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Written by Tudor Hulubei and Andrei Pitis.  */


#ifndef _GIT_MISC_H
#define _GIT_MISC_H


#include <sys/types.h>

#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#endif

#include "stdc.h"


extern pid_t pid;
extern char *home;
extern char *program;
extern char *tty_type;

extern char *tty_name;
extern int  tty_name_len;
extern char *login_name;
extern int  login_name_len;

extern char *day_name[];
extern char *month_name[];

extern int SCREEN_X;
extern int SCREEN_Y;

extern char cSection[];
extern char bwSection[];


#define max(a, b) (((a) >= (b)) ? (a) : (b))
#define min(a, b) (((a) <= (b)) ? (a) : (b))


#define close2(fd1, fd2)	\
{				\
     close(fd1);		\
     close(fd2);		\
}


#define xfree2(ptr1, ptr2)	\
{				\
     xfree(ptr1);		\
     xfree(ptr2);		\
}


extern RETSIGTYPE fatal_signal __P((int));
extern void display_exit_message __P((char *));
extern void configuration_help __P((char *));
extern void common_configuration_init __P(());
extern void specific_configuration_init __P(());
extern void use_section __P((char *));
extern int get_int_var __P((char *, int));
extern int get_const_var __P((char *, char *[], int, int));
extern int get_flag_var __P((char *, int));
extern char *get_string_var __P((char *, char *));
extern void get_colorset_var __P((int *, char *[], int));
extern char *clear_path __P((char *));
extern void get_tty_name __P(());
extern void get_login_name __P(());
extern void truncate_long_name __P((char *, char *, int));
extern char *truncate_string __P((char *, char *, unsigned));
extern int get_file_length __P((int));
extern struct tm *get_local_time __P(());
extern char *basename __P((char *));
extern int is_a_bg_command __P((char *));


#endif	/* _GIT_MISC_H */
