#!/bin/sh
#######################################################################
#
#    sh-Script <send_pr>  (by Heinz G. Seidl, hgs@cygnus.com)
#
#    -- create problem report and send it to cygnus-bugs@cygnus.com
#
#    This file is part of the Problem Report Management System (PRMS)
#    Copyright 1992 Cygnus Support
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public
#    License as published by the Free Software Foundation; either
#    version 2 of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    General Public License for more details.
#
#    You should have received a copy of the GNU Library General Public
#    License along with this program; if not, write to the Free
#    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#    $Id: send_pr.sh,v 1.2 1992/05/28 17:56:38 zoo Exp $
#
#######################################################################

#######################################################################
#
# This shell script should be used by Cygnus Support customers, in order
# to obtain support.
#
# It can also be used by users of free software, who would like to submit 
# a bug report to Cygnus Support for software maintained by Cygnus.
#
# Please see the file README for installation information and
# read the man page send_pr.1 for the usage of send_pr.
#
#######################################################################

[ -n "$TRACE" ] && set -x

COM=`basename $0`
U="USAGE: $COM \
[-v] [-request-id] [-t <mail-addr>] [-f <problem-report>] [-p | -P] [-F]"

VERSION="$COM: 1.16"
PRMS_ADM=/s1/PRMS/PRMS.adm

###############################################################################
#
#	The following variables may be customized at the customer's/user's site

###############################################################################
#
#	Each customer must have a unique customer-id.
#	If the variable has the value `unknown' (and you are a Cygnus Support
#	customer), then invoke `send_pr -request-id' to get your customer-id.
#
#	If you are not a Cygnus Support customer, but would like to
#	submit a problem report for free software maintained by Cygnus, then
#	please use the customer-id `net'.
#
#	(can be configured)
#
CUSTOMER_ID=unknown
#
#	The mail address at Cygnus, where the PR is sended to
#	(can be configurated)
#
MAIL_ADDR=cygnus-bugs@cygnus.com
#
#	The mail address to cc to.
#	(can be configured)
#
CC_ADDR=

#
#	Where to find the mail delivery program
#
MAILD_PATH=/usr/lib
#
#	The mail delivery program itself
#
MAILD="sendmail -t -oi"
#
#	The name of the site, where send_pr is invoked (environment var)
#
#HOSTNAME=
if [ -z "$HOSTNAME" ]
then
	if   [ -f /bin/hostname ]     ; then HOSTNAME=`/bin/hostname` 
	elif [ -f /usr/bin/hostname ] ; then HOSTNAME=`/usr/bin/hostname` 
	else echo "$COM: HOSTNAME not set and hostname not found"; exit 1
	fi
fi
#
#	The logname name of the user, who invoked send_pr (environment var)
#
#LOGNAME=
if [ -n "$LOGNAME" ] ; then USER=$LOGNAME ; fi
if [ -z "$USER" ]    ; then echo "$COM: USER|LOGNAME not set"; exit 1 ; fi
#
#	The value of the mail "From:" field
#
FROM="${USER}@${HOSTNAME}"
#
#	The value of the mail "Reply-To:" field
#
REPLY_TO="${USER}@${HOSTNAME}"
#
#	The (full) name of the originator 
#	(`NAME' as used by `pnews'; environment var)
#
if   [ -n "$NAME" ]         ; then THE_ORIGINATOR="$NAME"
elif [ -f $HOME/.fullname ] ; then THE_ORIGINATOR=`sed -e '1q' $HOME/.fullname`
else THE_ORIGINATOR=`awk -F: "\\$1 == \\"$USER\\" {print \\$5}" /etc/passwd | awk -F, '{print $1}'`
fi
#
#	The organization of the originator
#	(`ORGANIZATION' as used by `pnews'; environment var
#	 or ~/.signature)
#
if [ -n "$ORGANIZATION" ]
then
	if   [ -f "$ORGANIZATION" ]
	then THE_ORGANIZATION=`cat $ORGANIZATION`
	else THE_ORGANIZATION="$ORGANIZATION"
	fi
else
	if   [ -f "${HOME}/.signature" ]
	then THE_ORGANIZATION=`cat ${HOME}/.signature`
	fi
fi
#
#	The default editor (environment var)
#
#EDITOR=
if [ -z "$EDITOR" ] ; then EDITOR=vi ; fi
#
#	The environment variable, which can specify a user specific PR-form
#
#PR_FORM=
if [ -z "$PR_FORM" ] ; then PR_FORM="" ; fi
#
#	Some heuristics for a default environment
#
SYSTEM=`( [ -f /bin/uname ] && /bin/uname -a ) || \
        ( [ -f /usr/bin/uname ] && /usr/bin/uname -a ) || echo ""`
ARCH=`[ -f /bin/arch ] && /bin/arch`
MACHINE=`[ -f /bin/machine ] && /bin/machine`
#
#	Directory for temporary files (environment var)
#
#TMP=
if [ -z "$TMP" ] ; then TMP=/tmp ; fi
#
#
#	end of customizable section
#
###############################################################################

TEMP=${TMP}/p$$
BAD=${TMP}/pbad$$
REF=/${TMP}/pf$$

PRINT=false
IN_FILE=""

while [ $# -gt 0 ]
do
case "$1" in
	-v|-V)	echo "$VERSION"; echo "$U"; exit 0
		;;
	-t)	shift			# where to mail the PR
		MAIL_ADDRESS="$1"
		EXPLICIT_MAIL_ADDR=true
		;;
	-f) 	shift			# PR already filled out
		IN_FILE="$1"
		if [ "$IN_FILE" = "-" ]
		then 
			:
		elif [ ! -r "$IN_FILE" ]
		then
			echo "$COM: $IN_FILE not readable"; exit 1
		fi
		;;
	#-s)	shift			# where to find the mailing agent
	#	MAILD_PATH="$1"
	#	;;
	-p)	PRINT_INTERN=true  	# print the (internal) form and exit
		;;
	-P)	PRINT=true  		# print the form and exit
		;;
	-F)	FORCE=true  		# allow unknown categories or cid
		;;
	-r)	REMOVE=true 		# don't preserve bad formats
		;;
	-CL)	PRINT_CATEGORIES=true	# print categories as LISP list
		;;			# and exit
	-request-id) REQUEST_ID=true	# send mail to Cygnus to request a
		;;			# customer id
	*)	echo "$U"; exit 1
		;;
	esac
	shift
done	

if [ $CUSTOMER_ID = unknown -a -z "$REQUEST_ID"  -a -z "$FORCE" ]
then
	cat << 'EOF'
It seems that `send_pr' is not installed with your unique customer id.

If you are a Cygnus Support customer and you have already a customer-id,
then please patch `send_pr' to use your customer-id by running

     install_cid CUSTOMERID

If you don't yet have a customer-id, you can invoke `send_pr -request-id'
to request one from Cygnus.

If you are not a Cygnus Support customer, but would like to submit a problem
report for free software maintained by Cygnus, then please use the 
customer-id `net'.  

EOF
	exit 1
fi

if [ -f "$PRMS_ADM/notify" ] # this works only for Cygnus !
then
	KNOWN_CATEGORIES=`awk -F: '/^[^#]/ {print $1}' $PRMS_ADM/notify`
else
	KNOWN_CATEGORIES='
bfd
binutils
bison
clib
config
cvs
diff
doc
emacs
g++
gas
gcc
gdb
grep
ispell
ld
libg++
libiberty
make
rcs
readline
send_pr
texinfo
other'

fi

if [ -n "$PRINT_CATEGORIES" ]
then
	echo "$KNOWN_CATEGORIES" |
	awk 'BEGIN {printf "("} {printf "(\"%s\") ",$0} END {printf ")\n"}'
	exit 0
fi

#
# comments in the form
#
ORIGINATOR_C='<name of the PR author (one line)>'
ORGANIZATION_C='<organization of PR author (multiple lines)>'
CONFIDENTIAL_C='<[ yes | no ] (one line)>'
SYNOPSIS_C='<synopsis of the problem (one line)>'
SEVERITY_C='<[ non-critical | serious | critical ] (one line)>'
PRIORITY_C='<[ low | medium | high ] (one line)>'
CATEGORY_C='<name of the product (one line)>'
CLASS_C='<[ sw-bug | doc-bug | change-request | support ] (one line)>'
RELEASE_C='<release number or tag (one line)>'
ENVIRONMENT_C='<machine, os, target, libraries (multiple lines)>'
DESCRIPTION_C='<precise description of the problem (multiple lines)>'
HOW_TO_REPEAT_C='<code/input/activities to reproduce the problem (multiple lines)>'

trap 'rm -f $REF $TEMP ; exit 0' 0

trap 'echo "$COM: Aborting ..."; rm -f $REF $TEMP ; exit 1' 1 2 3 13 15


if [ -n "$IN_FILE" ]
then
	#
	#	the user supply an already filled out PR
	#
	if [ "$IN_FILE" = "-" ]
	then
		#
		#	read from stdin
		#
		if [ -n "$EXPLICIT_MAIL_ADDR" ]
		then
			sed -e "s;^[Tt][Oo]:.*;To: ${MAIL_ADDR};" > $TEMP
		else
			cat > $TEMP
		fi
	else
		if [ -n "$EXPLICIT_MAIL_ADDR" ]
		then
			sed -e "s;^[Tt][Oo]:.*;To: ${MAIL_ADDR};" $IN_FILE > $TEMP
		else
			cat $IN_FILE > $TEMP
		fi
	fi

else # {
	#
	#	the user has to fill out a template
	#
if [ -n "$PR_FORM" -a -z "$PRINT_INTERN" ]
then
	#
	#	The user has a "private" template, specified by PR_FORM;
	#	copy the empty form into $TEMP and $REF
	#
	if sed -e "s;^[Tt][Oo]:.*;To: ${MAIL_ADDR};" $PR_FORM > $TEMP \
	&& cp $TEMP $REF
	then
	    : fine
	else
	    echo "$COM: could not copy $PR_FORM, please check the value of PR_FORM" 1>&2
	    exit 1
	fi
else
	#
	#	We have to create the templates from this script
	#
for F in $TEMP $REF
do

# (the EMACS send-pr-mode gets configured)
#
cat > $F << 'EOF'
SEND_PR: -*- send-pr -*-
SEND_PR: Lines starting with `SEND_PR' will be removed automatically as
SEND_PR: well as all comments (the text below enclosed in `<' and `>').
SEND_PR: 
SEND_PR: Please consult the man page `send_pr(1)' if you are not sure,
SEND_PR: how to fill out a problem report.
SEND_PR:
SEND_PR: Choose from the following categories:
SEND_PR:
EOF

#
# We format the categories, so that they fit onto lines
#
echo "$KNOWN_CATEGORIES" | awk '
BEGIN { printf "SEND_PR: "; i = 1 }
      {	printf ("%-10.10s", $0); if ((++i % 7) == 0) { printf "\nSEND_PR: "}}
END   { printf "\nSEND_PR:\n" }' >> $F

cat >> $F << EOF
To: $MAIL_ADDR `[ -n "$CC_ADDR" ] && (echo; echo "CC: $CC_ADDR")`
Subject: 
From: $FROM
Reply-To: $REPLY_TO
X-send-pr-version: $VERSION


>Customer-Id:   ${CUSTOMER_ID}
>Originator: 	`if [ -n "${THE_ORIGINATOR}" ]; then echo ${THE_ORIGINATOR} 
		 else echo "$ORIGINATOR_C"; fi`
>Organization:
`
if [ -n "$THE_ORGANIZATION" ] 
then
    	echo "$THE_ORGANIZATION"
else
	echo "	$ORGANIZATION_C" ;
fi ;
`
>Confidential:  $CONFIDENTIAL_C
>Synopsis:	$SYNOPSIS_C
>Severity:	$SEVERITY_C
>Priority:	$PRIORITY_C
>Category: 	$CATEGORY_C
>Class:		$CLASS_C
>Release:	$RELEASE_C
>Environment:
    	$ENVIRONMENT_C
`[ -n "$SYSTEM" ] && echo System: $SYSTEM`
`[ -n "$ARCH" ] && echo Architecture: $ARCH`
`[ -n "$MACHINE" ] && echo Machine: $MACHINE`
>Description:	 
	$DESCRIPTION_C
>How-To-Repeat:	 
	$HOW_TO_REPEAT_C
EOF

done

fi	# now we have the templates

#
#	Shall we only print the form on standard output ?
#
if [ "$PRINT" = true -o "$PRINT_INTERN" = true ]
then
	cat $TEMP
	exit 0
fi


chmod u+w $TEMP
if [ -z "$REQUEST_ID" ]
then
	#
	#	Invoke the editor on $TEMP
	#
	eval $EDITOR $TEMP
else
	#
	#	Request a Customer id
	#
	ed -s $TEMP << 'EOF'
/^Subject/s/^Subject:.*/Subject: request for a customer id/
/^>Category/s/^>Category:.*/>Category: prms/
w
q
EOF
fi

#
#	Test whether the form was filled out at all
#
if cmp -s $REF $TEMP
then # still empty
	echo \
	"$COM:  Problem report not filled out properly, therefore not sent."
	exit 1
fi

fi # } now we have a filled out PR

#
#	Check the enumeration fields
#
CNT=0
#
# This is a "sed-subroutine" with one keyword parameter 
# (with workaround for Sun sed bug)
#
SED_CMD='
/$PATTERN/{
s|||
s|<.*>||
s|^[ 	]*||
s|[ 	]*$||
p
q
}'
#
# 1) Confidential
#
PATTERN=">Confidential:"
CONFIDENTIAL=`eval sed -n -e "\"$SED_CMD\"" $TEMP`
case "$CONFIDENTIAL" in
	""|yes|no) CNT=`expr $CNT + 1` ;;
	*)  echo "$COM: \`$CONFIDENTIAL' is not a valid value for \`Confidential'."
            ;;
esac
#
# 2) Severity
#
PATTERN=">Severity:"
SEVERITY=`eval sed -n -e "\"$SED_CMD\"" $TEMP`
case "$SEVERITY" in
	""|non-critical|serious|critical) CNT=`expr $CNT + 1` ;;
	*)  echo "$COM: \`$SEVERITY' is not a valid value for \`Severity'."
esac
#
# 3) Priority
#
PATTERN=">Priority:"
PRIORITY=`eval sed -n -e "\"$SED_CMD\"" $TEMP`
case "$PRIORITY" in
	""|low|medium|high) CNT=`expr $CNT + 1` ;;
	*)  echo "$COM: \`$PRIORITY is not a valid value for \`Priority."
esac
#
# 4) Category
#
PATTERN=">Category:"
CATEGORY=`eval sed -n -e "\"$SED_CMD\"" $TEMP`
FOUND=
for C in $KNOWN_CATEGORIES
do
	if [ "$C" = "$CATEGORY" ] ; then FOUND=true ; fi
done
if [ -n "$FOUND" ]
then
	CNT=`expr $CNT + 1`	
else
	echo "$COM: \`$CATEGORY' is not a known category."
fi
#
# 5) Class
#
PATTERN=">Class:"
CLASS=`eval sed -n -e "\"$SED_CMD\"" $TEMP`
case "$CLASS" in
	""|sw-bug|doc|change-request|support ) CNT=`expr $CNT + 1`
		   ;;
	*)  echo "$COM: \`$CLASS' is not a valid value for \`Class'."
esac

if  [ "$CNT" -lt 5 ] && [ -z "$FORCE"  ]
then

	if [ -z "$REMOVE" ]
	then
		echo \
		"$COM: the problem report remains in $BAD and is not sent."
		mv $TEMP $BAD
	else
		echo \
		"$COM: the problem report is not sent."
	fi
	exit 1
fi


#
#	Remove comments and send the problem report
#	(we have to use patterns, where the comment contains regex chars)
#
sed  -e "
/^SEND_PR:/d
/^>Originator:/s;$ORIGINATOR_C;;
/^>Organization:/,/^>[A-Za-z-]*:/s;$ORGANIZATION_C;;
/^>Confidential:/s;<.*>;;
/^>Synopsis:/s;$SYNOPSIS_C;;
/^>Severity:/s;<.*>;;
/^>Priority:/s;<.*>;;
/^>Category:/s;$CATEGORY_C;;
/^>Class:/s;<.*>;;
/^>Release:/,/^>[A-Za-z-]*:/s;$RELEASE_C;;
/^>Environment:/,/^>[A-Za-z-]*:/s;$ENVIRONMENT_C;;
/^>Description:/,/^>[A-Za-z-]*:/s;$DESCRIPTION_C;;
/^>How-To-Repeat:/,/^>[A-Za-z-]*:/s;$HOW_TO_REPEAT_C;;
" $TEMP | eval $MAILD_PATH/$MAILD $MAIL_ADDR

echo "$COM: problem report sent to $MAIL_ADDR"
exit 0
