.\" -*- nroff -*-
.\" ---------------------------------------------------------------------------
.\"    man page which describes the PR_FORM (by Heinz G. Seidl, hgs@cygnus.com)
.\"
.\"    This file is part of the Problem Report Management System (PRMS)
.\"    Copyright 1992 Cygnus Support
.\"
.\"    This program is free software; you can redistribute it and/or
.\"    modify it under the terms of the GNU General Public
.\"    License as published by the Free Software Foundation; either
.\"    version 2 of the License, or (at your option) any later version.
.\"
.\"    This program is distributed in the hope that it will be useful,
.\"    but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
.\"    General Public License for more details.
.\"
.\"    You should have received a copy of the GNU Library General Public
.\"    License along with this program; if not, write to the Free
.\"    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA
.\"
.\"    $Id: pr_form.man,v 1.1 1992/05/28 17:56:31 zoo Exp $
.\" ---------------------------------------------------------------------------
.\"
.\" PR == 1 indicates `send_pr'
.\" 
.so defines.man
.ie !\n(PR==1 \{\
.nh
.TH PR_FORM 5 \\*(Dt \\*(Vs
.SH NAME
pr_form \- format of PRMS problem reports
.SH DESCRIPTION
.\}
.el \{\
.SH PROBLEM REPORT FORM
.\}
.ie \n(PR==1 \{\
The problem report form has two parts: 
.\}
.el \{\
PRs are stored in UNIX mail form and consist of two parts: 
.\}
.I mail header fields
and
.I problem report
.IR fields .
.SS mail header fields
A problem report may contain any mail header field described in 
.BR "RFC 822" .
However, only the fields which identify the sender and his/her mail address
are required:
.TP 1i
.B To:
automatically supplied mail address of PRMS at \*(Ss.
.TP
.B Subject:
mail subject line.
.TP
.B From:
mail address of the sender or report originator.
.TP
.B Reply-To:
mail address where replies from the PRMS manager will go.
.\}
.SS  problem report fields
.PP
Problem report fields start with a keyword (enclosed in
.BR `>' and
.BR `:' )
and have one of these three forms:
.TP
.B ENUM
.RI ( enumeration 
.IR values )
.br
One value out of a specific set of choices.  The value must be on the
same line as the keyword.  For each ENUM keyword, the possible choices
are listed in the form as a comment, as well as in
this man page.
.TP
.B STRING
.RI ( "one line text" )
.br
One line of text, which must begin and end on the same line as the keyword.
.TP
.B TEXT
.RI ( "multiple line text" )
.br
Any kind of text.  TEXT fields may span multiple lines, and may
include blank lines.  A TEXT field ends only when another PR keyword
appears at the beginning of a new line.
.ie n .sp 1v
.el .sp 0.5v
Feel free to structure these fields in any way which seems convenient for you.
In particular you can use TEXT fields to supply information which does
not have a specific field in the PRMS form, but you think should be
part of your problem report.
.if !\n(PR==1 \{.
.SS sender fields
.LP
You must fill out the following fields when originating a PR (cf.
.BR send_pr (1)):
.\}
.TP 1.5i
.I Keyword
.I Explanation
.TP
.B >Customer-Id:
(ENUM) a unique customer id assigned by \*(Ss (or `\|\c
.B net\c
\&\|' for non-customers). It is used to
identify all PRs coming from one customer.
(If you don't have a
customer id, please use `\|\c
.BR "send_pr \-request\-id" \|'
to get one from \*(Ss.)
.TP
.B >Originator:
(STRING) name of the problem report author.
.br
default: value of the environment variable 
.BR NAME .
.TP
.B >Organization:
(TEXT) the address of the originator's organization.
.br
default: value of the environment variable 
.BR ORGANIZATION 
(either taken as file name or literally) or
the contents of the file
.B .signature
in your home directory.
.TP
.B >Confidential:
(ENUM) if the value of this field is
.BR yes ,
then \*(Ss will treat your PR as confidential and, for example, won't
put your code in publicly available regression test suites.
.br
default: 
.BR yes .
.TP
.B >Synopsis:
(STRING) One-line summary of the problem.
.br
default: value of the mail Subject field.
.TP
.B >Severity:
(ENUM) The severity of the problem.
.RS
.TP 1i
.B critical
The product, component or concept is completely non-operational or
some essential functionality is missing. 
.I No workaround is known.
.TP
.B serious
The product, component or concept is not working properly or significant
functionality is missing.  Also otherwise critical problems, where a
workaround is known.
.TP
.B non-critical
The product, component or concept is working in general, but lacks
features, has irritating behaviour, does something wrong, or doesn't
match its documentation.
.RE
.IP
default:
.BR serious .
.TP
.B >Priority:
(ENUM) How soon you need a solution.
.RS
.TP 1i
.B high
A solution is needed as soon as possible.
.TP
.B medium
The problem should be solved in the next release.
.TP
.B low
The problem should be solved in a future release.
.RE
.IP
default:
.BR medium .
.TP
.B >Category:
(ENUM) the name of the product, component or concept where the problem
lies. The following values are currently recognized for this field:
.RS
.TP 1i
.B bfd
GNU binary file descriptor library functions.
.TP
.B binutils
GNU utilities for binary files (\c
.BR ar ,
.BR nm ,
.BR size "\|.\|.\|.\|)."
.TP
.B bison
GNU parser generator.
.TP
.B clib
C library functions.
.TP
.B config
\*(Ss software configuration and installation.
.TP
.B cvs
Concurrent Versions System.
.TP
.B diff
GNU diff program.
.TP 
.B doc
documentation and manuals.
.TP
.B emacs
GNU emacs editor and info program.
.TP
.B g++
GNU C++ compiler.
.TP
.B gas
GNU assembler.
.TP
.B gcc
GNU C compiler.
.TP
.B gdb
GNU source code debugger.
.TP
.B grep
GNU grep program.
.TP
.B ispell
GNU spelling checker.
.TP
.B ld
GNU linker.
.TP
.B libg++
GNU C++ class library.
.TP
.B libiberty
GNU libiberty library.
.TP
.B make
GNU make program.
.if !\n(PR==1 \{.
.TP
.B prms
Problem Report Management System.
.\}
.TP
.B rcs
Revision Control System.
.TP
.B readline
GNU readline library.
.TP
.B send_pr
\*(Ss problem report submitting program.
.TP
.B texinfo
GNU documentation macros.
.TP
.B other
anything which is not covered by the above categories.
.if !\n(PR==1 \{.
.TP
.B nothing
category for improper formatted problem reports.
.\}
.RE
.TP
.B >Class:
(ENUM) the class of a problem can be one of the following:
.RS
.TP 1i
.B support
a question or support problem
.TP 1i
.B sw-bug 
a software bug
.TP 1i
.B doc-bug
a bug in the documentation
.TP 1i
.B change-request
a change request.
.if !\n(PR==1 \{.
.TP
.B mistaken
No bug, user error or misunderstanding.
.TP
.B duplicate (NR)
duplicate PR. NR should be the number of the original PR.
.\}
.RE
.TP
.B >Release:
(STRING) release number or version of the product, component or concept.
.br
If no release number is known, use 
.BR progressive " or " vintage " or " custom " or "
.BR devo .
.br
Note: all GNU tools should accept the option 
.B \-v 
to print the version number.
.TP
.B >Environment:
(TEXT) description of the environment where the problem occured: machine
architecture, operating system, target, host, libraries, pathnames\|.\|.\|.
.TP
.B >Description:
(TEXT) precise description of the problem, including all preconditions, inputs,
outputs, conditions after the problem, and symptoms.
.br
Please feel free to provide any additional information you think is
important.  For example, you can include additional classification
information, or a bug id number from your own bug tracking system. 
.TP
.B >How-To-Repeat:
(TEXT) example code, input, or activities to reproduce the problem.
.br
\*(Ss will use your example code both to reproduce the
problem, and to test whether the problem is fixed.
.if !\n(PR==1 \{.
.SS receiver fields
.LP
The following fields are filled out either automatically by PRMS
programs or by the responsible person when solving the problem.
.TP 1.5i
.B >Number:
Automatically generated, unique number of the problem report.
.TP
.B >Responsible:
E-mail address of the
.I responsible person
for that problem report.
Initially this is the responsible person for the category.
However a PR can be assigned to a different person, who is then
responsible for it.
.TP
.B >State:
A problem report has a 
.IR "life cycle" ,
which has discrete states.
.RS
.TP 1i
.I State
.I Explanation
.TP
.B open
the problem has still to be resolved.
.TP
.B analyzed
the problem is ananlyzed and the originator has gotten the analysis.  The
analysis must happen within the response time for that particular customer.
Together with an estimate when the problem will be solved the analysis should
be recorded in the `\|\c
.BR >Audit-Trail:  \|'
and sent to the originator of the PR.
.TP
.B suspended
the problem is analyzed, however it's resolution is suspended, but will
possibly be resolved in the future (a problem, which will never be resolved
has to be closed).
.TP
.B feedback
The problem is solved, but the originator of the problem has still to
be notified (or to get a patch/new release).
.TP
.B closed
The problem is solved, nothing remains to be done.
.RE
.IP
If a problem solution causes a 
.I external interface
change, which has to be documented, then the responsible person for
documentation has to be notified before closing the PR.
.TP
.B >Audit-Trail:
This field contains sub-fields, which record state- and responsibility-changes.
.RS
.TP
.I State changes
.TP 1.7i
.B State-Changed-From-To:
.IR oldstate \- newstate .
.TP 
.B State-Changed-By:
.IR user-name .
.TP 
.B State-Changed-When:
.IR date .
.TP 
.B State-Changed-Why:
Free format text field, where the reason for the state change is described.
For example, if the state changes from 
.B open
to
.BR analyzed ,
then the 
.IR Why -field
should contain the analysis.
In case a PR changes from 
.B analyzed 
to
.BR feedback,
the
.IR Why -field
should contain a description of the solution and it's version number or cvs tag
or commit date.
.TP
.I Responsibility changes:
.TP 2i
.B Responsible-Changed-From-To:
.IR oldresponsible \- newresponsible .
.TP 
.B Responsible-Changed-By:
.IR user-name .
.TP 
.B Responsible-Changed-When:
.IR date .
.TP 
.B Responsible-Changed-Why:
Reason, why the responsiblity was changed.
.RE
.IP
The EMACS user interface to PRs (\fBprms-mode\fR) provides key-bindings which
insert these three lines automatically and let one fill out the fields
interactively with completion.
.TP
.B >Unformatted:
contains all data, which cannot be stored in another field during
automatic processing of the PR (TEXT).
.\}
