/*
 * written by Mark Eichin for Cygnus Support. Freely Redistributable.
 * 1992 */

/*
FUNCTION
<<rint>>, <<remainder>>---round and  remainder
INDEX
	rint
INDEX
	remainder

ANSI_SYNOPSIS
	#include <math.h>
	double rint(double <[x]>);
	double remainder(double <[x]>, double <[y]>);

TRAD_SYNOPSIS
	#include <math.h>
	double rint(<[x]>)
	double <[x]>;
	double remainder(<[x]>,<[y]>)
	double <[x]>, <[y]>;

DESCRIPTION
<<rint>> returns its argument rounded to the nearest integer.
<<remainder>> finds the remainder of <[x]>/<[y]>; this value is in the
range -<[y]>/2 .. +<[y]>/2.

RETURNS
<<rint>> and <<remainder>> return the integer result as a double.

PORTABILITY
<<rint>> and <<remainder>> are System V release 4.



*/

#include <math.h>

TYPE_RET
_DEFUN(rint, (xa),
       TYPE_ARG xa)
{
  return floor(x+0.5);
}


TYPE_RET
_DEFUN(remainder, (xa,ya),
       TYPE_ARG xa _AND
       TYPE_ARG ya)
{
  /* Careful, otherwise might be passed a double which can't be
     represented in a float */
  TYPE r,w;
  TYPE x;
  TYPE y;

  y = ya;
  x = xa;

  if (y == 0)
    return __matherror(SNAME, x, y, DOMAIN, x);
  if (!finite(y) || !finite(x))
    return infinity();

  w = rint(x/y);
  if(fabs(w-x/y) == 0.5) {
    if (((int) w) & 1) {
      if(w>x/y) w = w - 1.0;
      else w = w + 1.0
    }
  }
  r = x - y * w;
  return r;
}
