#include "funcs.h"
TYPE_RET
_DEFUN(pow, (x, y),
       TYPE_ARG x _AND
       TYPE_ARG y)
{
  TYPE z;
  int sign = 0;

  if (x == 0.0) 
  {
    if (y == 0.0) 
    {
      
      return 1.0;
    }
    
    if (y <= 0.0) 
    {
      return __matherror(SNAME, x,y, DOMAIN, 0.0);
    }
    return 0.0;
  }

  if (!finite(x)) 
  {

    return __matherror(SNAME, x, y, DOMAIN, x);
  }
  if (!finite(y)) 
  {
    return __matherror(SNAME, x, y, DOMAIN, y);
  }
  
  if (y == 0.0)
   return 1.0;
  if (y == 1.0)
   return x;
  
	

  if (modf(y, &z) == 0.0) 
  {	
    /* The power is by an integer, this will be real easy */
    if (z < 0) 
    {
      sign = 1;
      z = -z;
    }
    if (((int)z) == z)
    {
      long c = z;
      TYPE result = 1.0;
      
      while (c) 
      {
	if (c & 1)
	 result *= x;
	x = x * x;
	c >>=1;
      }
      
      if (sign != 0) 
      {
	result = 1.0 / result;
      }
      
      return result;
    }
    else if (x < 0.0) 
    {
      /*
	Integer power is too big, we will have to do it the hard way.
	Fix up any -ve x, the answer will be -ve if the power is odd. */
      
      x = -x;
      if (floor( y/2.0)*2 != y)
      {
	/* Power was was odd */
	sign = 1;
      }
    }
  }
#if 1
{
  double t,s,u;
  
  
  t = log(x);
  s = y *t;
  u = exp(s);
  printf("x is %04x%04x%04x%04x\n", x);
  printf("log(x) is %04x%04x%04x%04x\n", t);
  printf("y is %04x%04x%04x%04x\n", y);
  printf("y *log(x) is %04x%04x%04x%04x\n", s);
  printf("exp  is %04x%04x%04x%04x\n", u);  
  x = u;
  
}

#else
  x = exp( y  * log(x));
#endif
  return sign ? - x : x;
}

							     
							     
							     
							     
							     
