#include "funcs.h"

TYPE_RET
_DEFUN(log,(xa),
       TYPE_ARG xa)
{
  TYPE Rz, f, z, w, znum, zden, xn;
  TYPE x = xa;
  
  int n;

  if (!finite(x))
  {
    return __matherror(SNAME, x, 0.0, DOMAIN, x);
  }
	
	
  if (x <= 0.0) {
      return __matherror(SNAME, x, 0.0, x < 0 ? DOMAIN :
			 OVERFLOW, TYPE_MAX);

    }


  f = frexp(x, &n);

  
  if (f > C0) 
  {
    znum = (znum = f-0.5) - 0.5;
    zden = f*0.5 + 0.5;
  } else 
  {
    --n;
    znum = f - 0.5;
    zden = znum*0.5 + 0.5;
  }
  z = znum/zden;
  w = z*z;
  Rz = z + z * (w * A(w)/B(w));
  xn = n;
  return (xn*C2 + Rz) + xn*C1;
}
