/*
FUNCTION
       <<log>>, <<logf>>---natural logarithms

INDEX
    log
INDEX
    logf

ANSI_SYNOPSIS
       #include <math.h>
       double log(double <[x]>);
       float logf(float <[x]>);

TRAD_SYNOPSIS
       #include <math.h>
       double log(<[x]>);
       double <[x]>;

       float logf(<[x]>);
       float <[x]>;

DESCRIPTION
Return the natural logarithm of <[x]>, that is, its logarithm base e
(where e is the base of the natural system of logarithms, 2.71828@dots{}).
<<log>> and <<logf>> are identical save for the return and argument types.

You can use the (non-ANSI) function <<matherr>> to specify error
handling for these functions. 

RETURNS
Normally, returns the calculated value.  When <[x]> is zero, the
returned value is <<-HUGE_VAL>> for <<log>> (<<-FLT_MAX>> for
<<logf>>), and <<errno>> is set to <<ERANGE>>.  When <[x]> is
negative, the returned value is <<-HUGE_VAL>> or <<-FLT_MAX>>, and
<<errno>> is set to <<EDOM>>.  When <[x]> is NaN (not a number),
<<errno>> is set to <<EDOM>> and the result is <[x]>.  You can control
the error behavior via <<matherr>>.

PORTABILITY
<<log>> is ANSI, <<logf>> is an extension.
**/

#include "mathimpl.h"

#define A0 -0.64124943423745581147e2
#define A1  0.16383943563021534222e2
#define A2 -0.78956112887491257267e0
#define A(w) (((A2*(w))+A1)*(w)+A0)

#define B0 -0.76949932108494879777e+3
#define B1  0.31203222091924532844e+3
#define B2 -0.35667977739034646171e+2
#define B(w) ((((w)+B2)*(w)+B1)*(w)+B0)

#define C0 0.70710678118654752440
#define C1 0.693359375
#define C2 -2.121944400546905827679e-4


#define SNAME "log"
#define DOUBLE
#include "log.h"


#undef SNAME


#define SNAME "logf"
#define FLOAT
#include "log.h"
