/*

FUNCTION
        <<cosh>>, <<coshf>>---hyperbolic cosine

ANSI_SYNOPSIS
        #include <math.h>
        double cosh(double <[x]>);
        float coshf(float <[x]>)

TRAD_SYNOPSIS
        #include <math.h>
        double cosh(<[x]>)
        double <[x]>;

        float coshf(<[x]>)
        float <[x]>;

DESCRIPTION

	<<cosh>> computes the hyperbolic cosine of the argument <[x]>.
	<<cosh(<[x]>)>> is defined as 
	@ifinfo
	. (exp(x) + exp(-x))/2
	@end ifinfo
	@tex
	$${(e^x + e^{-x})} \over 2$$
	@end tex

	Angles are specified in radians.  
		
	<<coshf>> is identical, save that it takes and returns <<float>>.

RETURNS
	The computed value is returned.  When the correct value would create
	an overflow,  <<cosh>> returns the value <<HUGE_VAL>> with the
	appropriate sign, and the global value <<errno>> is set to <<ERANGE>>.

	<<cosh>> and <<coshf>> return <<FLT_MAX>> on overflow.

	You can modify error handling for these functions using the
	function <<matherr>>.


PORTABILITY
	<<cosh>> is ANSI.  
	<<coshf>> is an extension.

QUICKREF
	cosh ansi pure
	coshf - pure
*/


#include "mathimpl.h"



#define SNAME "cosh"
#define DOUBLE
#include "cosh.h"

#undef SNAME
#define SNAME "coshf"
#define FLOAT
#include "cosh.h"
