#include "funcs.h"


static TYPE_RET   
_DEFUN(a0,(arga, pp),   
  TYPE_ARG arga _AND    
  TYPE *pp)   

{    
  TYPE zsq, n, d;    
  TYPE arg = arga;
  
  int i;   
  zsq = 64.0 / (arg*arg);   
  for(n=0,d=0,i=6;i>=0;i--)
  {   
    n = n*zsq + p2__0[i];   
    d = d*zsq + q2__0[i];   
  }    
  *pp = n/d;   
  for(n=0,d=0,i=6;i>=0;i--)
  {   
    n = n*zsq + p3__0[i];   
    d = d*zsq + q3__0[i];   
  }    
  return (8./arg)*(n/d);   
}    
    

TYPE_RET  
_DEFUN(j0,(arga),    
  TYPE_ARG arga)   
{    
  TYPE argsq, n, d;    
  TYPE qzero;   
  TYPE pzero;  
  TYPE arg = arga; 
     
  int i;   
  if (!finite(arg)) 
  {
    return __matherror(J0SNAME, arg, 0.0, DOMAIN, arg);
  }
    
  if(arg < 0.) arg = -arg;   
  if(arg > 8.)
  {   
    qzero = a0(arg, &pzero);  
    n = arg - M_PI_4;    
    return sqrt(M_2_PI/arg)*(pzero*cos(n) - qzero*sin(n)); 
  }    
  argsq = arg * arg;    
  for(n=0,d=0,i=8;i>=0;i--)
  {   
    n = n*argsq + p1__0[i];   
    d = d*argsq + q1__0[i];   
  }    
  return n / d;   
}    
    

TYPE_RET
_DEFUN(y0,(arga),    
  TYPE_ARG arga)   
{    
  TYPE argsq, n, d;    
  TYPE pzero, qzero;    
  TYPE arg = arga;
       
  int i;   
    
  if(arg <= 0.)
  {    
    return __matherror(Y0SNAME, arg, 0.0, DOMAIN, -HUGE_VAL); 
  } 
  if (!finite(arg)) 
  {
    return __matherror(Y0SNAME, arg, 0.0, DOMAIN, arg);
  }
   
  if(arg > 8.)
  {   
    qzero = a0(arg, &pzero);  
    n = arg - M_PI_4;    
    return sqrt(M_2_PI/arg)*(pzero*sin(n) + qzero*cos(n)); 
  }    
  argsq = arg*arg;    
  for(n=0,d=0,i=8;i>=0;i--)   
  {    
    n = n*argsq + p4__0[i];   
    d = d*argsq + q4__0[i];   
  }    
  return n/d + M_2_PI*j0(arg)*log(arg);   
}    


    
/***********************************************************************/





TYPE_RET     
_DEFUN(a1,(arga, pp),    
 TYPE_ARG arga _AND   
 TYPE *pp)    
{     
  TYPE zsq, n, d;   
  TYPE arg = arga;
  
  int i;    
  zsq = 64./(arg*arg);   
  for(n=0,d=0,i=6;i>=0;i--)    
  {     
    n = n*zsq + p2__1[i];    
    d = d*zsq + q2__1[i];    
  }     
  *pp = n/d;    
  for(n=0,d=0,i=6;i>=0;i--)    
  {     
    n = n*zsq + p3__1[i];    
    d = d*zsq + q3__1[i];    
  }     
  return (8./arg)*(n/d);    
}     
     
TYPE_RET     
_DEFUN(j1,(arg),   
       TYPE_ARG arg)    
{     
  TYPE xsq, n, d, x;   
  TYPE qzero, pzero;   
  int i; 
  if (!finite(arg)) 
  {
    return __matherror(J1SNAME, arg, 0.0, DOMAIN, arg);
  }
     
  x = fabs(arg);   
  if(x > 8.)    
  {     
    qzero = a1(x, &pzero);    
    n = x - 3.*M_PI_4;   
    n = sqrt(M_2_PI/x)*(pzero*cos(n) - qzero*sin(n));  
    return arg <0.0 ? -n : n;    
  }     
  xsq = x*x;    
  for(n=0,d=0,i=8;i>=0;i--)    
  {     
    n = n*xsq + p1__1[i];    
    d = d*xsq + q1__1[i];    
  }     
  return arg*n/d;   
}     
     
TYPE_RET     
_DEFUN(y1,(arga),   
       TYPE_ARG arga)    
{     
  TYPE xsq, n, d, x;   
  TYPE arg = arga;

  TYPE pzero, qzero;   
    
  int i;    
  x = arg;    
  if(x <= 0.)    
  {     
    return __matherror(Y1SNAME, arg, 0.0, DOMAIN, -HUGE_VAL);  
  }
 
  if (!finite(x)) 
  {
    return __matherror(Y1SNAME, arg, 0.0, DOMAIN, x);
  }
 
  if(x > 8.)    
  {     
    qzero = a1(x, &pzero);   
    n = x - 3*M_PI_4;   
    return sqrt(M_2_PI/x)*(pzero*sin(n) + qzero*cos(n));  
  }     
  xsq = x*x;    
  for(n=0,d=0,i=9;i>=0;i--)    
  {     
    n = n*xsq + p4__1[i];    
    d = d*xsq + q4__1[i];    
  }     
  return x*n/d + M_2_PI*(j1(x)*log(x)-1.0/x);   
}     
    
     
     
/***********************************************************************/  
     

/*
 floating point Bessel's function of
 the first and second kinds and of
 integer order.

 int n;
 TYPE x;
 jn(n,x);

 returns the value of Jn(x) for all
 integer values of n and all real values
 of x.

 There are no error returns.
 Calls j0, j1.

 For n=0, j0(x) is called,
 for n=1, j1(x) is called,
 for n<x, forward recursion us used starting
 from values of j0(x) and j1(x).
 for n>x, a continued fraction approximation to
 j(n,x)/j(n-1,x) is evaluated and then backward
 recursion is used starting from a supposed value
 for j(n,x). The resulting value of j(0,x) is
 compared with the actual value to correct the
 supposed value of j(n,x).

 yn(n,x) is similar in all respects, except
 that forward recursion is used for all
 values of n>1.
*/




TYPE_RET    
_DEFUN(jn,(n, x),    
 int n _AND    
 TYPE_ARG x)   
{    
  int i;   
  TYPE a, b, temp;    
  TYPE xsq, t;   
    
  if( n < 0 )    
  {    
    n = -n;   
    x = -x;   
  }    
  if (n==0) return j0(x);   
  if (n==1) return j1(x);   
  if (x == 0.) return 0;   
  if (n>x)    
  {    
    xsq = x*x;   
    for(t=0,i=n+16;i>n;i--)   
    {    
      t = xsq/(2.*i - t);   
    }    
    t = x/(2.*n-t);    
    
    a = t;   
    b = 1;   
    for(i=n-1;i>0;i--) {   
	temp = b;    
	b = (2.*i/x)*b - a;   
	a = temp;    
      }    
    return t*j0(x)/b;   
  }    
    
  a = j0(x);    
  b = j1(x);    
  for(i=1;i<n;i++)    
  {    
    temp = b;   
    b = (2.*i/x)*b - a;    
    a = temp;   
  }    
  return b;   
}    
    
TYPE_RET    
_DEFUN(yn, (n, x),    
       int n _AND    
       TYPE_ARG x)   
{    
  int i;   
  int sign;   
  TYPE a, b, temp;    
    
  if (x <= 0) 
  {   
    return __matherror(YNSNAME, x, 0.0, DOMAIN, -HUGE_VAL); 
  }
 
  if (!finite(x)) 
  {
    return __matherror(YNSNAME, x, 0.0, DOMAIN, x);
  }

  sign = 1;   
  if(n<0) 
  {   
    n = -n;   
    if(n % 2 == 1) sign = -1;   
  }    
  if(n==0) return y0(x);   
  if(n==1) return  sign < 0 ? -(y1(x)) : y1(x);   
    
  a = y0(x);    
  b = y1(x);    
  for(i=1; i<n; i++)   
  {    
    temp = b;   
    b = (2.*i/x)*b - a;    
    a = temp;   
  }    
  return sign < 0 ? -b : b;
}    
