/* Startup code needed by GCC C++ output code.  */
/* Copyright (C) 1991 Free Software Foundation, Inc.

This file is part of GNU CC.

GNU CC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU CC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* As a special exception, if you link this file with files
   compiled with GCC to produce an executable, this does not cause
   the resulting executable to be covered by the GNU General Public License.
   This exception does not however invalidate any other reasons why
   the executable file might be covered by the GNU General Public License.  */

/*  init_libs.c: Originally developed by James Kempf for SUN,
 *               adapted and commented for FSF by Heinz Seidl (hgs@cygnus.com)
 */

/* Exports:
 *   void __initialize_libraries()
 *   void __finalize_libraries()
 *
 * When there is no dynamic linked object, then _DYNAMIC = 0 and we return.
 *
 * In case of dynamic shared objects (libraries):
 * The dynamic shared objects are already linked with the main program and 
 * control was passed from `start' (in `crt0.o') to `_main' and from that
 * to `__main' in `ccrt0.o'.
 *
 * The functions here have to do the _initialization_ and _finalization_ of
 * all the dynamic shared objects.
 */


#if ! defined(DYNAMIC_LIBS)
/*
 * No shared libraries
 */

void __initialize_libraries() {}
void __finalize_libraries() {}

#else
/*
 * dynamic shared libraries
 */

#include <sys/types.h>
#include <link.h>
#include <dlfcn.h>
#include <malloc.h>
#include <stdio.h>
#include "init_main.h"

extern struct link_dynamic _DYNAMIC;

/* we have to get the address of __C/DTOR_LIST__ of the shared objects from
 * the runtime linker
 */
const char CTOR_LIST_NAME[] = "___CTOR_LIST__";
const char DTOR_LIST_NAME[] = "___DTOR_LIST__";

extern ep_fp * __function_list_addr;

/* "Handles" to the dynamic shared objects can be obtained via the _DYNAMIC 
 * structure; but since be have to do finalization in the opposite direction
 * as initialization, we construct a doubly linked list of these handles.
 */

struct _sll /* shared_library-descriptor-list */ {
    struct _sll* next;
    struct _sll* prev;
    struct link_map* lmp;
};

#define NULLP (struct _sll*)0
#ifndef NULL
#define NULL (void*)0
#endif

static struct _sll* _sll_head = NULLP;
static struct _sll* _sll_tail = NULLP;

static inline 
void new(struct link_map* nlmp)
{
    struct _sll * this = (struct _sll *) malloc (sizeof (struct _sll));

    this->lmp  = nlmp;
    this->next = NULLP;
    this->prev = NULLP;

    if( !_sll_head ) {
	_sll_head = this;
	_sll_tail = this;
    } else {
	this->prev = _sll_tail;
	_sll_tail->next = this;
	_sll_tail = this;
    }
}

static
void build_sll()
/*
 *  -- Build doubly linked list of dynamic library descriptors (link_maps)
 */
{
    struct link_dynamic_2* ldd;
    struct link_map* lmp;

    ldd  = _DYNAMIC.ld_un.ld_2;

    for( lmp = ldd->ld_loaded; lmp; lmp = lmp->lm_next ) {
	new (lmp);
    }
}

static
void delete_sll()
/*
 *  -- Delete doubly linked list of dynamic library descriptors
 */
{
    struct _sll * this = _sll_tail;
    struct _sll * prev;

    while ( this ) {
    	    prev = this->prev;
	    free ( this);
	    this = prev;
    }
}


static
void __do_dynamic_lib( struct _sll * sll_anchor, const char * fn_name,
		       const char * symb_name, int forward )
/* 
 *   -- get the address of the initialization or finalization function
 *	<fn_name> in all shared objects via `dlsym()' and call them.
 */
{
    struct _sll * sll_ptr   = sll_anchor;
    void *        dobj_handle;
    ep_fp         fn;

    while( sll_ptr ) {

	/* Set up the dl_object first */

	if ( (dobj_handle = dlopen( sll_ptr->lmp->lm_name, 1 )) == NULL)
	   fprintf( stderr, "%s\n", dlerror());

	/* Call dlsym() looking for the function symbol. */

	fn = (ep_fp)dlsym( dobj_handle, fn_name);
	
	__function_list_addr = (ep_fp*)dlsym( (void*)dobj_handle, symb_name);

	/* If nonnull, call the function. */

	if( fn ) fn();

	/* Increment to next list entry, depending on flag. */

	sll_ptr = ( forward ? sll_ptr->next : sll_ptr->prev);
    }
}
	
void __initialize_libraries()
/* 
 *  -- Initialize the dynamically linked libraries.
 */
{
    static struct link_dynamic *DP = &_DYNAMIC;
    if ( DP == 0 ) return; /* nothing to initialize */

    build_sll();

    __do_dynamic_lib( _sll_tail, INITIALIZE_MODULE_NAME, CTOR_LIST_NAME, 0);

    delete_sll();
}


void __finalize_libraries()
/*
 *  -- Finalize the dynamically linked libraries.
 */
{
    static struct link_dynamic *DP = &_DYNAMIC;
    if ( DP == 0 ) return; /* nothing to finalize */

    /* Have to rebuild sll list, the user may have added something */
    _sll_head = _sll_tail = NULLP;

    build_sll();

    __do_dynamic_lib( _sll_head, FINALIZE_MODULE_NAME, DTOR_LIST_NAME, 1);

    delete_sll();
}

#endif /* DYNAMIC_LIBS */
