 define(fclob,   (clobber (reg:HI 0))
   (clobber (reg:HI 1))
   (clobber (reg:HI 4))
   (clobber (reg:HI 5))
)
/* The size of instructions in bytes */
(define_attr "type" "branch,return,call,arith,move,float" (const_string "arith"))
(define_attr "length" "" 
  (cond [(eq_attr "type" "branch")
	 (if_then_else (and (ge (minus (pc) (match_dup 0))
				(const_int -128))
			    (le (minus (pc) (match_dup 0))
				(const_int 128)))
		       (const_int 2)
		       (const_int 6))
	 (eq_attr "type" "move") (const_int 4)
	 (eq_attr "type" "return")	(const_int 2)
	 (eq_attr "type" "float")	(const_int 12)
	 (eq_attr "type" "call")	(const_int 4)]
	(const_int 200)))

(define_insn "movhi"
  [(set (match_operand:HI 0 "general_operand_dst" "=r,r,<,r,>,r,r,g")
	(match_operand:HI 1 "general_operand_src"  "r,I,r,<,r,>,g,r"))]
  ""
  "@
   mov.w	%1,%0
   sub.w	%0,%0
   mov.w	%1,%0
   subs	#2,%R1\;mov.w	@%R1,%0
   mov.w	%1,@%R0\;adds	#2,%R0
   mov.w	%1,%0
   mov.w	%1,%0
   mov.w	%1,%0"
  [(set_attr "type" "move")
   (set_attr "length" "2,2,2,4,4,2,4,4")])

(define_insn "movsi"
 [(set (match_operand:SI 0 "general_operand_dst" "=&r,&r,<,&r,>,r,&r,o")
       (match_operand:SI 1 "general_operand_src"   "r,i,r,>,r,<,o,r"))]
 ""
 "*return gen_move_4bytes(which_alternative,operands);"

 [(set_attr "type" "move"  )
  (set_attr "length" "8")])


(define_insn "movsf"
 [(set (match_operand:SF 0 "float_move_operand_dst" "=&r,&r,<,&r,>,r,&r,o")
       (match_operand:SF 1 "float_operand_src"   "r,i,r,>,r,<,o,r"))]
 ""
 "*return gen_move_4bytes(which_alternative, operands);"
 [(set_attr "type" "move"  )
  (set_attr "length" "8")])



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MOVDF
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(define_insn ""
 [(parallel[(set (match_operand:DF 0 "push_operand" "<")
              (match_operand:DF 1 "general_operand" "fo"))
	    (clobber (reg:HI 0))
	    (clobber (reg:HI 4))
	    (clobber (reg:HI 1))])]

 ""
"*
{
  rtx src = operands[1];
  if (GET_CODE(src) == MEM) 
  {
    if (GET_CODE(XEXP(src,0)) == PLUS)
    {
      operands[1] = XEXP(XEXP(src,0),1);
      operands[2] = XEXP(XEXP(src,0),0);
      output_asm_insn(\"mov.w	%1,r0\", operands);
      output_asm_insn(\"add.w	%2,r0\", operands);
    }
    else 
    {
      operands[1] = XEXP(src,0);
      output_asm_insn(\"mov.w     %1,r0\",operands);
    }    
  }
  else 
  {
    output_asm_insn(\"mov.w	%1,r0\", operands);
  }

  return \"jsr	@__pushdf\";

}"
  [(set_attr "type" "float")
   (set_attr "length" "8")])

(define_insn ""
 [(set (match_operand:DF 0 "float_move_operand_dst" "=fg")
	          (match_operand:DF 1 "float_move_operand_src" "gf"))
	     
   ]
 ""
"jsr	@__movdf_ss\;%Q0\;%Q1"
[(set_attr "type" "float")])


(define_expand "movdf"
 [ (parallel [(set (match_operand:DF 0 "general_operand" "")
       (match_operand:DF 1 "general_operand" ""))
	      (clobber (reg:HI 0))
	      (clobber (reg:HI 4))
	      (clobber (reg:HI 1))])
   ]
 ""
"
{
  if (push_operand(operands[0], DFmode)) {
      /* special case this one */
    }
  else {
      emit_insn (gen_rtx (SET, VOIDmode, operands[0],operands[1]));
      DONE;
    }
}")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MOVDI
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(define_insn ""
 [ (set (match_operand:DI 0 "general_operand" "=fg")
        (match_operand:DI 1 "general_operand" "fg"))]

 ""
"jsr	@__movdi_ss\;%Q1\;%Q0"
[(set_attr "type" "float")])




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; TEST INSTRUCTIONS
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



(define_insn "tstqi"
  [(set (cc0)
	(match_operand:QI 0 "register_operand" "r"))]
  ""
  "cmp.b	#0,%0l"
  [(set_attr "type" "arith")
   (set_attr "length" "2")])


  
(define_insn "cmphi"
  [(set (cc0)
	(compare:HI (match_operand:HI 0 "register_operand" "r")
		 (match_operand:HI 1 "register_operand" "r")))]
  ""
  "cmp.w	%1,%0"
  [(set_attr "type" "arith")
   (set_attr "length" "2")]
)

 

(define_insn "cmpqi"
  [(set (cc0)
	(compare:QI (match_operand:QI 0 "register_operand" "r,r")
		 (match_operand:QI 1 "nonmemory_operand" "r,i")))]
  ""
  "@
	cmp.b	%1l,%0l
	cmp.b	%1,%0l"
  [(set_attr "type" "arith")
   (set_attr "length" "2")])





;; move instructions





;; this is needed to fake out during reload
	



(define_insn "movqi"
  [(set (match_operand:QI 0 "general_operand_dst" "=r,<,r,>,r,r,g")
	(match_operand:QI 1 "general_operand_src"  "r,r,<,r,>,g,r"))]
  ""
  "@
   mov.b	%A1,%A0
   mov%P0	%U1,%0
   subs	#1,%R1\;mov.b	@%R1,%0l
   mov.b	%A1,@%R0\;adds	#1,%R0
   mov%P1	%1,%U0
   mov.b	%1,%A0
   mov.b	%A1,%0"
  [(set_attr "type" "move")
   (set_attr "length" "2,2,4,4,2,4,4")])


(define_insn "movqistrict"
  [(set (strict_low_part (match_operand:HI 0 "register_operand" ""))
	(match_operand:QI 1 "register_operand" ""))]
  ""
  "mov.b	%1l,%0l"
	[(set_attr "type" "move")
	 (set_attr "length" "2")])



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; ADD INSTRUCTIONS
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;




(define_insn ""
  [(parallel[(set (reg:HI 7)
		  (plus:HI (reg:HI 7)
			   (match_operand 2 "immediate_operand" "n")))
	     (clobber (reg:HI 5))
	     ])]
	""
	"mov.w	%2,r5\;add.w	r5,r7"
  [(set_attr "type" "arith")
   (set_attr "length" "6")])
	
(define_insn ""
  [(set (match_operand:HI 0 "register_operand" "=r,r,r,r,r,r")
	(plus:HI (match_operand:HI 1 "register_operand" "%0,0,0,0,0,0")
		 (match_operand:HI 2 "nonmemory_operand" "K,M,L,N,n,r")))

]
  ""
  "@
   adds	%2,%0
   adds	#2,%0\;adds	%C2,%0
   subs	%M2,%0
   subs	#2,%0\;subs	%M2,%0
   add.b	%A2,%0l\;addx	%B2,%0h
   add.w	%2,%0"
  [(set_attr "type" "arith")
  (set_attr "length" "2,4,2,4,4,2")])


(define_expand "addhi3"
  [(set (match_operand:HI 0 "register_operand" "")
	(plus:HI (match_operand:HI 1 "register_operand" "")
		 (match_operand:HI 2 "nonmemory_operand" "")))
  ]
  ""
  "if (addhi3(PLUS, operands)) DONE; ")

  

(define_insn "addqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r")
	(plus:QI (match_operand:QI 1 "register_operand" "%0,0")
		 (match_operand:QI 2 "nonmemory_operand" "ri,J")))]
  ""
  "@
   add.b	%A2,%0l
   dec	%0l")


(define_insn ""
  [(set (reg:SI 0)
	(plus:SI (reg:SI 0)
		 (reg:SI 4)))]
 ""
 "add.w	r5,r1\;addx	r4l,r0l\;addx	r4h,r0h"
  [(set_attr "type" "arith")
   (set_attr "length" "6")])

(define_expand "addsi3"
  [(set (reg:SI 0) (match_operand:SI 1 "general_operand" ""))
   (set (reg:SI 4) (match_operand:SI 2 "general_operand" ""))
   (set (reg:SI 0)
	(plus:SI (reg:SI 0)
		 (reg:SI 4)))
   (set (match_operand:SI 0 "general_operand" "") (reg:SI 0))
  ]

  ""
  "")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; SUBTRACT INSTRUCTIONS
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(define_insn ""
  [(parallel[(set (reg:HI 7)
		  (minus:HI (reg:HI 7)
			   (match_operand 2 "immediate_operand" "n")))
	     (clobber (reg:HI 5))
	     ])]
	""
	"mov.w	%2,r5\;sub.w	r5,r7"
  [(set_attr "type" "arith")
   (set_attr "length" "6")])

(define_insn ""
  [(set (match_operand:HI 0 "register_operand" "=r,r,r,S")
	(minus:HI (match_operand:HI 1 "general_operand" "0,0,0,0")
		  (match_operand:HI 2 "nonmemory_operand" "K,M,r,n")))]
  ""
  "@
   subs	%2,%0
   subs	#2,%0\;subs	%C2,%0
   sub.w	%2,%0
   add.b	%E2,%0l\;addx	%F2,%0h"
  [(set_attr "type" "arith")
   (set_attr "length" "2,4,2,4")])




(define_insn "subqi3"
  [(set (match_operand:QI 0 "register_operand" "=r,r,r")
	(minus:QI (match_operand:QI 1 "register_operand" "0,0,0")
		  (match_operand:QI 2 "nonmemory_operand" "J,r,i")))]
  ""
  "@
	dec	%0l
	sub.b	%2l,%0l
	add.b	%M2,%0l"
  [(set_attr "type" "arith")
   (set_attr "length" "2")])

(define_expand "subhi3"
  [(set (match_operand:HI 0 "register_operand" "")
	(minus:HI (match_operand:HI 1 "register_operand" "")
		  (match_operand:HI 2 "nonmemory_operand" "")))
  ]
  ""
  "if (addhi3(MINUS, operands)) DONE;"
)

(define_insn ""
  [(set (reg:SI 0)
	(minus:SI (reg:SI 0)
		 (reg:SI 4)))]
 ""
 "sub.w	r5,r1\;subx	r4l,r0l\;subx	r4h,r0h")

(define_expand "subsi3"
  [(set (reg:SI 0) (match_operand:SI 1 "general_operand" ""))
   (set (reg:SI 4) (match_operand:SI 2 "general_operand" ""))
   (set (reg:SI 0)
	(minus:SI (reg:SI 0)
		 (reg:SI 4)))
   (set (match_operand:SI 0 "general_operand" "") (reg:SI 0))
  ]

  ""
  "")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; MULTIPLY INSTRUCTIONS
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(define_insn "umulqihi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(mult:HI (match_operand:QI 1 "general_operand" "%0")
		 (match_operand:QI 2 "register_operand" "r")))]
  ""
  "mulxu	%A2,%0")


(define_insn "mulqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	(mult:QI (match_operand:QI 1 "general_operand" "%0")
		 (match_operand:QI 2 "register_operand" "r")))]
  ""
  "mulxu	%2l,%0")


;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; DIVIDE INSTRUCTIONS
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;




(define_insn "udivqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	(udiv:QI (match_operand:HI 1 "general_operand" "0")
		 (match_operand:QI 2 "register_operand" "r")))]
  ""
  "divxu	%2l,%0")

(define_insn "divqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	(div:QI (match_operand:HI 1 "general_operand" "0")
		 (match_operand:QI 2 "register_operand" "r")))]
  ""
  "divxu	%2l,%0")
 


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; AND INSTRUCTIONS
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



(define_insn "andhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(and:HI (match_operand:HI 1 "register_operand" "%0")
		(match_operand:HI 2 "nonmemory_operand" "rn")))]
  ""
  "*return gen_subop(AND, operands);"
	[(set_attr "length" "4")])

(define_insn "andqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	(and:QI (match_operand:QI 1 "register_operand" "%0")
		(match_operand:QI 2 "nonmemory_operand" "rn")))]
  ""
  "and	%A2,%0l")

(define_insn ""
 [(set (match_operand:HI 0 "register_operand" "=r")
       (and:HI (match_operand:QI 1 "register_operand" "0")
	(const_int 255)))]
""
"mov.b	#0,%0h")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; OR INSTRUCTIONS
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define_insn "iorhi3"
  [(set (match_operand:HI 0 "register_operand" "=r,r")
	(ior:HI (match_operand:HI 1 "register_operand" "%0,0")
		(match_operand:HI 2 "nonmemory_operand" "PO,rn")))]
  ""
  "*return gen_subop(IOR, operands);"
	[   (set_attr "length" "4")])






(define_insn "iorqi3"
  [(set (match_operand:QI 0 "general_operand" "=r,U")
	(ior:QI (match_operand:QI 1 "general_operand" "%0,0")
		(match_operand:QI 2 "general_operand" "rn,P")))]
  ""
  "@
   or	%A2,%A0
   bset	%V2,%A0")


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; OR INSTRUCTIONS
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(define_insn "xorhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(xor:HI (match_operand:HI 1 "general_operand" "%0")
		(match_operand:HI 2 "nonmemory_operand" "rn")))]
  ""
  "*return gen_subop(XOR, operands);"
	[(set_attr "length" "4")])


(define_insn "xorqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	(xor:QI (match_operand:QI 1 "general_operand" "%0")
		(match_operand:QI 2 "nonmemory_operand" "rn")))]
  ""
  "xor	%A2,%A0")



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; NEGATION INSTRUCTIONS
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define_insn "negqi2"
  [(set (match_operand:QI 0 "register_operand" "=r")
	(neg:QI (match_operand:QI 1 "general_operand" "0")))]
  ""
  "neg	%0l")

(define_expand "neghi2"
  [ (set (match_operand:HI 0 "register_operand" "=r") 
	 (minus:HI (const_int 0)
		 (match_operand:HI 1 "register_operand" "r")))]
  ""
  "")



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; NOT INSTRUCTIONS
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


(define_insn "one_cmplqi2"
  [(set (match_operand:QI 0 "register_operand" "=r")
	(not:QI (match_operand:QI 1 "general_operand" "0")))]
  ""
  "not	%0l")

(define_insn "one_cmplhi2"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(not:QI (match_operand:HI 1 "general_operand" "0")))]
  ""
  "not	%A0\;not	%B0")


;; All the  conditional jump instructions.



(define_expand "ble"
  [(set (pc)
	(if_then_else (le (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")
(define_expand "bleu"
  [(set (pc)
	(if_then_else (leu (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")
(define_expand "bge"
  [(set (pc)
	(if_then_else (ge (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")
(define_expand "bgeu"
  [(set (pc)
	(if_then_else (geu (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")

(define_expand "blt"
  [(set (pc)
	(if_then_else (lt (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")
(define_expand "bltu"
  [(set (pc)
	(if_then_else (ltu (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")
(define_expand "bgt"
  [(set (pc)
	(if_then_else (gt (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")
(define_expand "bgtu"
  [(set (pc)
	(if_then_else (gtu (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")
(define_expand "beq"
  [(set (pc)
	(if_then_else (eq (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")
(define_expand "bne"
  [(set (pc)
	(if_then_else (ne (cc0)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "")



(define_insn ""
 [(set (pc)
   (if_then_else (match_operator 1 "comparison_operator"
		  [(cc0) (const_int 0)])
    (label_ref (match_operand 0 "" ""))
    (pc)))]
 ""
 "*
{
  if (get_attr_length(insn) == 2) 
    {
      return \"b%j1	%l0\";
    }
  else {
      return \"b%k1	%L0\;jmp	@%l0\;%L0:\";
  }
}" 
 [(set_attr "type" "branch")])


(define_insn ""
 [(set (pc)
   (if_then_else (match_operator 1 "comparison_operator"
		  [(cc0) (const_int 0)])
    (pc)
    (label_ref (match_operand 0 "" ""))))]
 ""
 "*{
    if (get_attr_length(insn) == 2) 
      {
	return \"b%k1	%l0\";
      }
    else {
      return \"b%j1	%L0\;jmp	@%l0\;%L0:\";
    }
  }"
 [(set_attr "type" "branch")] )

;; Unconditional and other jump instructions
(define_insn "jump"
 [(set (pc)
   (label_ref (match_operand 0 "" "")))]
 ""
 "*{
    if (get_attr_length(insn) == 2) 
      {
	return \"bra	%l0\";
      }
    else {
      return \"jmp	@%l0\";
    }
  }"
 [(set_attr "type" "branch")] )

(define_insn "tablejump"
  [(set (pc) (match_operand:HI 0 "register_operand" ""))
   (use (label_ref (match_operand 1 "" "")))]
  ""
  "jmp	@%0")


;; Call subroutine with no return value.
(define_insn "call"
  [(call (match_operand:QI 0 "memory_operand" "o")
	 (match_operand:HI 1 "general_operand" "g"))]
  ;; Operand 1 not really used on the m68000.

  ""
  "jsr	%0"
  [(set_attr "type" "call")
   (set_attr "length" "4")])

;; Call subroutine, returning value in operand 0
;; (which must be a hard register).
(define_insn "call_value"
  [(set (match_operand 0 "" "=r,f")
	(call (match_operand:QI 1 "memory_operand" "o,o")
	      (match_operand:HI 2 "general_operand" "g,g")))]
  ;; Operand 2 not really used on the m68000.
  ""
  "@
   jsr	%1
   mov.w	__fpreg0,r5\;push	r5\;jsr	%1"

  [(set_attr "type" "call")
   (set_attr "length" "4,10")])


(define_insn "nop"
  [(const_int 0)]
  ""
  "nop")

(define_insn "indirect_jump"
  [(set (pc) (match_operand:HI 0 "register_operand" "r"))]
  ""
  "jmp	@%0")



(define_insn "zero_extendqihi2"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(zero_extend:HI
	 (match_operand:QI 1 "register_operand" "0")))]
  ""
"mov.b	#0,%0h")

(define_insn "extendqihi2"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(sign_extend:HI
	 (match_operand:QI 1 "register_operand" "r")))]
  ""
  "mov.b	%1l,%0l\;bld	#7,%0l\;subx	%0h,%0h")







;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; SHIFTS
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; 
;; All H8 shifts go one bit at a time, here they are def ined with names
;; so can use them in the expands..


; QI BIT SHIFTS




(define_insn "ashlqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	(ashift:QI (match_operand:QI 1 "register_operand" "0")
		   (match_operand:QI 2 "nonmemory_operand" "rn")))
   (clobber (match_scratch:QI 3  "=r"))]
  ""
  "*{ return ashift(operands,\"shal %0l\",QImode);}")

(define_insn "ashrqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	(ashiftrt:QI (match_operand:QI 1 "register_operand" "0")
		   (match_operand:QI 2 "nonmemory_operand" "rn")))
   (clobber (match_scratch:QI 3  "=r"))]
  ""
  "*{ return ashift(operands,\"shar %0l\",QImode);}")

(define_insn "lshrqi3"
  [(set (match_operand:QI 0 "register_operand" "=r")
	(lshiftrt:QI (match_operand:QI 1 "register_operand" "0")
		   (match_operand:QI 2 "nonmemory_operand" "rn")))
   (clobber (match_scratch:QI 3  "=r"))]
  ""
  "*{ return ashift(operands,\"shlr %0l\",QImode);}")

; HI BIT SHIFTS

(define_insn ""
  [ (set (reg:HI 0) 
	 (ashift:HI (reg:HI 0)
		    (reg:HI 1)))
]
  ""
  "jsr	@__ashlhi3")

(define_insn ""
  [ (set (reg:HI 0) 
	 (ashift:HI (reg:HI 0)
		    (match_operand:HI 2 "general_operand" "n")))
]
  ""
  "*
{
  if (GET_CODE(operands[2]) != CONST_INT) abort();
  switch (INTVAL(operands[2]) & 0xf) {
    case 0: break;
    case 1: return \"add.w	r0,r0\";
    case 2: return \"add.w	r0,r0\;add.w	r0,r0\";
    case 3: return \"add.w	r0,r0\;add.w	r0,r0\;add.w	r0,r0\";
    default:
      return \"jsr	@__ashlhi3_%c2\";
    }
}
"
  [(set_attr "type" "arith")
   (set_attr "length" "6")])




(define_expand "ashlhi3"
  [(set (reg:HI 0) (match_operand:HI 1 "register_operand" ""))
   (set (reg:HI 0) 
	(ashift:HI (reg:HI 0)
		   (match_operand:HI 2 "general_operand" "")))
   (set (match_operand:HI 0 "register_operand" "") (reg:HI 0))
   (clobber (reg:HI 1))
]
""
"{
if (GET_CODE(operands[2]) != CONST_INT) {
    operands[2] = copy_to_suggested_reg(operands[2], gen_rtx(REG, HImode,1));
 }
}")



(define_insn ""
  [ (set (reg:HI 0) 
	 (ashiftrt:HI (reg:HI 0)
		    (reg:HI 1)))
]
  ""
  "jsr	@__ashrhi3")

(define_insn ""
  [ (set (reg:HI 0) 
	 (ashiftrt:HI (reg:HI 0)
		      (match_operand:HI 2 "general_operand" "n")))
]
  ""
  "*
{
  if (GET_CODE(operands[2]) != CONST_INT) abort();
  switch (INTVAL(operands[2]) & 0xf) {
    case 0: break;
    case 1: return \"shar	r0h\;	rotxr	r0l\";
    case 2: return \"shar	r0h\;	rotxr	r0l\;shar	r0h\;	rotxr	r0l\";
    case 3: return \"shar	r0h\;	rotxr	r0l\;shar	r0h\;	rotxr	r0l\;shar	r0h\;	rotxr	r0l\";
    default:
      return \"jsr	@__ashrhi3_%c2\";
    }
}
")



(define_expand "ashrhi3"
  [(set (reg:HI 0) (match_operand:HI 1 "general_operand" ""))
   (set (reg:HI 0) 
	(ashiftrt:HI (reg:HI 0)
		   (match_operand:HI 2 "nonmemory_operand" "")))
   (set (match_operand:HI 0 "general_operand" "") (reg:HI 0))
   (clobber (reg:HI 1))
]
""
"{
if (GET_CODE(operands[2]) != CONST_INT) {
    operands[2] = copy_to_suggested_reg(operands[2], gen_rtx(REG, HImode,1));
 }
}")




	

(define_insn "lshrhi3"
  [(set (match_operand:HI 0 "register_operand" "=r")
	(lshiftrt:HI (match_operand:HI 1 "register_operand" "0")
		   (match_operand:QI 2 "nonmemory_operand" "rn")))
   (clobber (match_scratch:QI 3  "=r"))]
  ""
  "*{
  if (GET_CODE(operands[2]) == CONST_INT) {
      /* Hmm, this may be better as something else..*/
      switch (INTVAL(operands[2])) 
      {
      case 15:
	output_asm_insn(\"bld	#7,%0h\",operands);
	output_asm_insn(\"mov.b #0,%0l\", operands);
	output_asm_insn(\"mov.b #0,%0h\", operands);
	output_asm_insn(\"bst	#0,%0l\",operands);
	return \"\";
      case 3:
	output_asm_insn(\"shlr	%B0\;rotxr	%A0\",operands);
      case 2:
	output_asm_insn(\"shlr	%B0\;rotxr	%A0\",operands);
      case 1:
	output_asm_insn(\"shlr	%B0\;rotxr	%A0\",operands);
	return \"\";
       default:
	break;
      }
    }

  return ashift(operands,\"shlr	%B0\;rotxr	%A0\",HImode);
}"

)


; SI ONE BIT SHIFTS

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; BIT INSTRUCTIONS
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 (define_insn "bset"
  [(set (match_operand:QI 0 "bit_operand" "=g")
	(ior:QI (match_operand:QI 1 "bit_operand" "0")
		(match_operand:QI 2 "power_of_two_operand" "n")))]
  ""
  "bset %p2,%0l")


(define_insn "bclr"
  [(set (match_operand:QI 0 "bit_operand" "=g")
	(and:QI (match_operand:QI 1 "bit_operand" "0")
		(match_operand:QI 2 "neg_power_of_two_operand" "n")))]
  ""
  "bclr	%O2,%0l")

 


  


;; Used for framless functions which save no regs and allocate no locals.
(define_insn "return"
  [(return)]
  "use_return_insn()"
  "rts")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;; FAKE DOUBLE PRECISION NUMBERS
;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(define_insn "adddf3"
  [
   (set (match_operand:DF 0 "float_operand_dst" "=fo")
	(plus:DF (match_operand:DF 1 "float_operand_src" "%fo")
		 (match_operand:DF 2 "float_operand_src" "fo")))
   fclob
   ]
   ""
  "jsr	@__adddf3_sss\;%Q1\;%Q2\;%Q0"
[(set_attr "type" "float")])

(define_insn "subdf3"
  [
   (set (match_operand:DF 0 "float_operand_dst" "=fo")
	(minus:DF (match_operand:DF 1 "float_operand_src" "fo")
		 (match_operand:DF 2 "float_operand_src" "fo")))
   fclob
   ]
   ""
  "jsr	@__subdf3_sss\;%Q1\;%Q2\;%Q0"
[(set_attr "type" "float")])

(define_insn "muldf3"
  [(set (match_operand:DF 0 "float_operand" "=fo")
	(mult:DF (match_operand:DF 1 "float_operand" "%fo")
		 (match_operand:DF 2 "float_operand" "fo")))
   fclob
   ]
   ""
  "jsr	@__muldf3_sss\;%Q1\;%Q2\;%Q0"
[(set_attr "type" "float")])

(define_insn "divdf3"
  [(set (match_operand:DF 0 "float_operand_dst" "=fo")
	(div:DF (match_operand:DF 1 "float_operand_src" "fo")
		 (match_operand:DF 2 "float_operand_src" "fo")))
   fclob
   ]
   ""
  "jsr	@__divdf3_sss\;%Q1\;%Q2\;%Q0"
  [(set_attr "type" "float")])

(define_insn "negdf2"
  [(set (match_operand:DF 0 "float_operand_dst" "=fo")
	(neg:DF (match_operand:DF 1 "float_operand_src" "fo")))
   fclob
   ]
   ""
  "jsr	@__negdf2_ss\;%Q1\;%Q0"
  [(set_attr "type" "float")])


(define_insn "cmpdf"
  [(set (cc0)
	 (compare (match_operand:DF 0 "float_operand_src" "fo")
   	        (match_operand:DF 1 "float_operand_src" "fo")))
   fclob
   ]
   ""
  "jsr	@__cmpdf2_ss\;%Q1\;%Q0"
  [(set_attr "type" "float")])



(define_insn "extendsfdf2"
  [(set (match_operand:DF 0 "float_operand_dst" "=fo")
	(float_extend:DF (match_operand:SF 1 "float_operand_src" "ro")))
  fclob]
  ""
  "jsr	@__extendsfdf2_ss\;%Q1\;%Q0"
[(set_attr "type" "float")])
	

(define_insn "truncdfsf2"
  [(set (match_operand:SF 0 "float_operand_dst" "=ro")
	(float_truncate:SF
	  (match_operand:DF 1 "float_operand_src" "fo")))
  fclob]
 ""
  "jsr	@__truncdfsf2_ss\;%Q1\;%Q0"
[(set_attr "type" "float")])


(define_insn "floatsidf2"
  [(set (match_operand:DF 0 "float_operand_dst" "=fo")
	(float:DF (match_operand:SI 1 "general_operand_src" "ro")))
  fclob]
  ""
 "jsr	@__floatsidf2_ss\;%Q1\;%Q0"
[(set_attr "type" "float")])

(define_insn "floatsisf2"
  [(set (match_operand:SF 0 "float_operand_dst" "=ro")
	(float:SF (match_operand:SI 1 "general_operand_src" "ro")))
  fclob]
  ""
 "jsr	@__floatsisf2_ss\;%Q1\;%Q0"
[(set_attr "type" "float")])


(define_insn "floatunssidf2"
  [(set (match_operand:DF 0 "float_operand_dst" "=fo")
	(unsigned_float:DF (match_operand:SI 1 "general_operand_src" "ro")))
  fclob]
  ""
 "jsr	@__floatunssidf2_ss\;%Q1\;%Q0"
[(set_attr "type" "float")])

(define_insn "floatunssisf2"
  [(set (match_operand:SF 0 "float_operand_dst" "=ro")
	(unsigned_float:SF (match_operand:SI 1 "float_operand_src" "ro")))
  fclob]
  ""
 "jsr	@__floatunssisf2_ss\;%Q1\;%Q0"
[(set_attr "type" "float")])

;
; SINGLE
;

(define_insn "addsf3"
  [(set (match_operand:SF 0 "float_operand_dst" "=ro")
	(plus:SF (match_operand:SF 1 "float_operand_src" "%ro")
		 (match_operand:SF 2 "float_operand_src" "ro")))
  fclob
   ]
   ""
  "jsr	@__addsf3_sss\;%Q1\;%Q2\;%Q0"
[(set_attr "type" "float")])

(define_insn "subsf3"
  [(set (match_operand:SF 0 "float_operand_dst" "=ro")
	(minus:SF (match_operand:SF 1 "float_operand_src" "ro")
		 (match_operand:SF 2 "float_operand_src" "ro")))
  fclob
   ]
   ""
  "jsr	@__subsf3_sss\;%Q1\;%Q2\;%Q0"
[(set_attr "type" "float")])

(define_insn "mulsf3"
  [(set (match_operand:SF 0 "float_operand_dst" "=ro")
	(mult:SF (match_operand:SF 1 "float_operand_src" "%ro")
		 (match_operand:SF 2 "float_operand_src" "ro")))
  fclob
   ]
   ""
  "jsr	@__mulsf3_sss\;%Q1\;%Q2\;%Q0"
[(set_attr "type" "float")])

(define_insn "divsf3"
  [(set (match_operand:SF 0 "float_operand_dst" "=ro")
	(div:SF (match_operand:SF 1 "float_operand_src" "ro")
		 (match_operand:SF 2 "float_operand_src" "ro")))
  fclob
   ]
   ""
  "jsr	@__divsf3_sss\;%Q1\;%Q2\;%Q0"
[(set_attr "type" "float")])


(define_insn "cmpsf"
  [(set (cc0)
	 (compare (match_operand:SF 0 "float_operand_src" "ro")
   	        (match_operand:SF 1 "float_operand_src" "ro")))
   (clobber (reg:HI 0))
  fclob
   ]
   ""
  "jsr	@__cmpsf2_ss\;%Q1\;%Q0"
[(set_attr "type" "float")])


(define_insn "negsf2"
  [(set (match_operand:SF 0 "float_operand_dst" "=ro")
	(neg:SF (match_operand:SF 1 "float_operand_src" "ro")))
  fclob
   ]
   ""
  "jsr	@__negsf2_ss\;%Q1\;%Q0"
[(set_attr "type" "float")])



(define_insn "fix_truncdfsi2"
  [(set (match_operand:SI 0 "fix_operand_dst" "=ro")
	(fix:SI (fix:DF (match_operand:DF 1 "float_operand_src" "fo"))))
  fclob]
 ""
  "jsr	@__fix_truncdfsi2_ss\;%Q1\;%Q0"
[(set_attr "type" "float")])

(define_insn "fix_truncdfhi2"
  [(set (match_operand:HI 0 "fix_operand_dst" "=ro")
	(fix:HI (fix:DF (match_operand:DF 1 "float_operand_src" "fo"))))
  fclob]
 ""
  "jsr	@__fix_truncdfhi2_ss\;%Q1\;%Q0"
[(set_attr "type" "float")])

(define_insn "fix_truncsfsi2"
  [(set (match_operand:SI 0 "float_operand_dst" "=ro")
	(fix:SI (fix:SF (match_operand:SF 1 "float_operand_src" "ro"))))
  fclob]
 ""
  "jsr	@__fix_truncsfsi2_ss\;%Q1\;%Q0"
[(set_attr "type" "float")])




;; BIT FIELDS
;;
;; The H8/300 has given 1/8th of its opcode space to bitfield
;; instuctions so  let's use them as well as we can


(define_insn ""
  [(set (zero_extract:HI (match_operand:HI 0 "register_operand" "+r")
			 (const_int 1)
			 (match_operand:HI 2 "general_operand" "g"))
	(match_operand:HI 3 "general_operand" "r"))]
 ""
"bld	#0,%3l\;bst	%Z2,%0%Y1"
  [(set_attr "type" "arith")
   (set_attr "length" "4")])


(define_expand "insv"
  [(set (zero_extract:HI (match_operand:HI 0 "register_operand" "+r")
			 (match_operand:HI 1 "general_operand" "g")
			 (match_operand:HI 2 "general_operand" "g"))
	(match_operand:HI 3 "general_operand" "r"))]
  ""
  "
{
  if (INTVAL(operands[1]) != 1)  FAIL;
}")






(define_insn ""
  [(set (match_operand:HI 0 "register_operand" "=&r")
	(zero_extract:HI (match_operand:HI 1 "register_operand" "r")
			 (const_int 1)
			 (match_operand:HI 3 "general_operand" "g")))
   ]
  ""
 "sub.w	%0,%0\;bld	%Z3,%1%Y1\;rotxl	%0l"
  [(set_attr "type" "arith")
   (set_attr "length" "6")])


(define_insn ""
  [(set (match_operand:HI 0 "register_operand" "=r")
	(sign_extract:HI (match_operand:HI 1 "register_operand" "r")
			 (const_int 1)
			 (match_operand:HI 3 "general_operand" "g")))
	]
   ""
   "bld	%Z3,%1%Y1\;sub.x	%0l,%0l\;mov.b	%0l,%0h"
   [(set_attr "type" "arith")
    (set_attr "length" "6")])




(define_expand "extzv"
  [(set (match_operand:HI 0 "register_operand" "")
	(zero_extract:HI (match_operand:HI 1 "register_operand" "")
			 (match_operand:HI 2 "general_operand" "")
			 (match_operand:HI 3 "general_operand" "")))]
  ""
 "{
	if (INTVAL(operands[2]) != 1) FAIL;}")


(define_expand "extv"
  [(set (match_operand:HI 0 "register_operand" "")
	(sign_extract:HI (match_operand:HI 1 "register_operand" "")
			 (match_operand:HI 2 "general_operand" "")
			 (match_operand:HI 3 "immediate_operand" "")))]
  ""
  "{if (INTVAL(operands[2]) != 1) FAIL;}")



;; Peepholes go at the end.
;; 
(define_peephole
  [(set (match_operand:HI 0 "general_operand" "=ro")
	(match_operand:HI 1 "register_operand" "r"))
   (set (match_operand:HI 4 "register_operand" "r")
	(const_int 0))
   (set (cc0)
	(compare:HI (match_operand:HI 2 "register_operand" "r")
		    (match_operand:HI 3 "register_operand" "r")))]
  "rtx_equal_p(operands[4], operands[3]) &&(rtx_equal_p (operands[2], operands[0])
   || rtx_equal_p (operands[2], operands[1]))"
  "mov.w	%1,%0"
  [(set_attr "type" "move")
   (set_attr "length" "2")])
	

;(define_peephole
;  [(set (match_operand:QI 0 "register_operand" "r")
;	(mem:QI (match_operand:HI 1 "register_operand" "r")))
;
;   (set (match_operand:QI 2 "register_operand" "r")
;	(and:QI (match_operand:QI 3 "register_operand" "r")
;		(match_operand:QI 4 "general_operand" "g")))
;
;   (set (mem:QI (match_operand:HI 5 "register_operand" "r"))
;		(match_operand:QI 6 "register_operand" "r"))   ]
;  "rtx_equal_p(operands[1], operands[5]) 
;&& rtx_equal_p(operands[0], operands[2])
;&& rtx_equal_p(operands[0], operands[3])
;&& rtx_equal_p(operands[0], operands[6]) 
;&& dead_or_set_p(insn, operands[0])
;&& GET_CODE(operands[4]) == CONST_INT 
;&& potl8(~INTVAL(operands[4]))
;&& 0"
;  "bclr	%O4,@%1"
;  [(set_attr "type" "move")
;   (set_attr "length" "4")])
