;; Includefile for GCC-1750A assembler files
;;
;; Macros defined:
;;   EFLR.M  #d,#s	Load the three regs starting at R#s to R#d following.
;;   RET.M   #fs	Return from function (uses the framesize #fs)


UC	EQU	15

	STRING ONE(3),TWO(3)

; Return from function ; parameter: framesize
     MACRO RET.M
	IF ~1~ > 0
	    IF ~1~ <= 16
		AISP R14,~1~
	    ELSE
		AIM  R14,~1~
	    ENDIF
	ENDIF
	LR   R15,R14
	URS  R15
     ENDM

; Useful instructions missing from the 1750A standard:

; Extended Float Load from Registers
     MACRO EFLR.M	; args : #1=dest-regno, #2=source-regno
REG1	SET  ~1~ + 2
REG2	SET  ~2~ + 2
ONE	SET  REG1
TWO	SET  REG2
	IF ~1~ >= ~2~ ! ~1~+2 < ~2~
	    LR    R~ONE~,R~TWO~
	    DLR   R~1~,R~2~
	ELSE
	    DLR   R~1~,R~2~
	    LR    R~ONE~,R~TWO~
	    DLR   R~1~,R~1~	; Just to update condition codes
	ENDIF
     ENDM

; The following leave the condition codes haywire. But that is
; accounted for (see notice_update_cc in config/1750a.c.)

; Double ANd Register with Register
     MACRO DANR.M
REG1	SET  ~1~ + 1
REG2	SET  ~2~ + 1
ONE	SET  REG1
TWO	SET  REG2
	ANDR  R~1~,R~2~
	ANDR  R~ONE~,R~TWO~
     ENDM

; Double OR Register with Register
     MACRO DORR.M
REG1	SET  ~1~ + 1
REG2	SET  ~2~ + 1
ONE	SET  REG1
TWO	SET  REG2
	ORR   R~1~,R~2~
	ORR   R~ONE~,R~TWO~
     ENDM

; Double eXoR Register with Register
     MACRO DXRR.M
REG1	SET  ~1~ + 1
REG2	SET  ~2~ + 1
ONE	SET  REG1
TWO	SET  REG2
	XORR  R~1~,R~2~
	XORR  R~ONE~,R~TWO~
     ENDM

