/*****************************************************************************

	bindings.c

	This file contains FWF support code to store and retrieve
	name/value bindings.

 *****************************************************************************/

#include <stdio.h>
#include <X11/Xatom.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>

#include <Xfwf/SupportCode.h>

/*---------------------------------------------------------------------------*

	int BindingLookup(bindings,string)

	This routine looks up the string <string> in the string->integer
	binding table <bindings>.  If the string is bound in the bindings
	(case insensitive), the bound value is returned, else -1 is returned.

 *---------------------------------------------------------------------------*/

int BindingLookup(bindings,string)
Binding *bindings;
String string;
{
	char *s,*t,sc,tc;
	int index;

	index = 0;
	if (string == NULL) return(-1);
	while (bindings[index].name != NULL)
	{
		s = bindings[index].name;
		t = string;
		while (1)
		{
			sc = (isupper(*s) ? tolower(*s) : *s);
			tc = (isupper(*t) ? tolower(*t) : *t);
			if (sc == tc)
			{
				if (sc == '\0') return(index);
			}
			    else
			{
				break;
			}
			++ s;
			++ t;
		}
		++ index;
	}
	return(-1);
} /* End BindingLookup */
