/* MenuBarT -- test program for the MenuBar widget */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xfwf/Board.h>
#include <Xfwf/Label.h>
#include <Xfwf/MenuBar.h>
#include <Xfwf/PullDown.h>
#include <Xfwf/OptButton.h>
#include <Xfwf/TextMenu.h>

static String fallback_resources[] = {
    "MenuBarT.board.width: 450",
    "MenuBarT.board.height: 250",

    "MenuBarT*background: aquamarine",

    /* "*board.frameWidth: 0", */
    /* "*board.frameType: sunken", */
    "*board.highlightThickness: 0",

    "*menubar.location: 0 0 1.0 35",
    "*menubar.frameWidth: 2",
    "*menubar.frameType: raised",
    "*menubar.highlightThickness: 0",
    "*menubar.traversalOn: true",
    "MenuBarT*menubar*background: slateblue",
    "MenuBarT*menubar*foreground: white",
    "MenuBarT*menubar*font: *-helvetica-bold-r-*-140-*",

    "MenuBarT*XfwfTextMenu*background: slateblue",
    "MenuBarT*XfwfTextMenu*foreground: white",
    "MenuBarT*XfwfTextMenu*font: *-helvetica-bold-r-*-140-*",

    "*menu1.label: menu 1",
    "*menu1.hotkey: <Ctrl>1",
    "*menu1.menu:\
	_First item\\n\
	_Second item\\n\
	-----------\\n\
	E_xit",
	    
    "*menu2.label: menu 2",
    "*menu2.hotkey: <Ctrl>2",
    "*menu2.menu:\
_Third item\\n\
_Fourth item",

    "*opt.label: <none>",
    "*opt.menu:\
Sunday\\n\
Monday\\n\
Tuesday\\n\
Wednesday\\n\
Thursday\\n\
Friday\\n\
Saturday",

    "*explain.location: 0 35 1.0 1.0-80",
    "*explain.outerOffset: 5",
    "*explain.alignment: top left",
    "*explain.frameWidth: 2",
    "*explain.frameType: sunken",
    /* "*explain.highlightThickness: 0", */
    "*explain.label: \
This program shows a menubar with three\\n\
pull-down menus. The third menu is actually\\n\
an option button, i.e., it shows the most\\n\
recently chosen item as its label. None of the\\n\
entries does anything, except for `Exit',\\n\
which stops the program.",

    "*status.location: 0 1.0-40 1.0 40",
    "*status.outerOffset: 5",
    "*status.alignment: left",
    "*status.frameWidth: 2",
    "*status.frameType: sunken",

    NULL,
};

static Widget toplevel, board, menubar, menu1, menu2, opt, explain, status;
static XtAppContext app_context;



static void activate1(w, client_data, call_data)
    Widget w;
    XtPointer client_data, call_data;
{
    char s[100];
    XfwfTextMenuData *data = (XfwfTextMenuData *) call_data;

    sprintf(s, "You selected %u: %s", data->n, data->label);
    XtVaSetValues(status, XtNlabel, s, NULL);
    if (data->n == 2) exit(0);
}



static void activate2(w, client_data, call_data)
    Widget w;
    XtPointer client_data, call_data;
{
    char s[100];
    XfwfTextMenuData *data = (XfwfTextMenuData *) call_data;

    sprintf(s, "You selected %u: %s", data->n, data->label);
    XtVaSetValues(status, XtNlabel, s, NULL);
}



static void change1(w, client_data, call_data)
    Widget w;
    XtPointer client_data, call_data;
{
    XfwfTextMenuData *data = (XfwfTextMenuData *) call_data;
    static String s[] = {
	"",					/* -1 */
	"`First' doesn't do anything",		/* 0 */
	"`Second' is unassigned",		/* 1 */
	"`Exit' stops the program"		/* 2 */
	};

    XtVaSetValues(status, XtNlabel, s[data->n + 1], NULL);
}


static void change2(w, client_data, call_data)
    Widget w;
    XtPointer client_data, call_data;
{
    XfwfTextMenuData *data = (XfwfTextMenuData *) call_data;
    static String s[] = {
	"",					/* -1 */
	"`Third' is a no-op",			/* 0 */
	"`Fourth' does nothing"			/* 1 */
	};

    XtVaSetValues(status, XtNlabel, s[data->n + 1], NULL);
}


int main(argc, argv)
    int argc;
    String *argv;
{
    toplevel = XtVaAppInitialize
	(&app_context, "MenuBarT", NULL, 0, &argc, argv,
	 fallback_resources, NULL);
    board = XtVaCreateManagedWidget
	("board", xfwfBoardWidgetClass, toplevel, NULL);
    menubar = XtVaCreateManagedWidget
	("menubar", xfwfMenuBarWidgetClass, board, NULL);
    menu1 = XtVaCreateManagedWidget
	("menu1", xfwfPullDownWidgetClass, menubar, NULL);
    menu2 = XtVaCreateManagedWidget
	("menu2", xfwfPullDownWidgetClass, menubar, NULL);
    opt = XtVaCreateManagedWidget
	("opt", xfwfOptionButtonWidgetClass, menubar, NULL);
    explain = XtVaCreateManagedWidget
	("explain", xfwfLabelWidgetClass, board, NULL);
    status = XtVaCreateManagedWidget
	("status", xfwfLabelWidgetClass, board, NULL);
    XtAddCallback(menu1, XtNactivate, activate1, NULL);
    XtAddCallback(menu2, XtNactivate, activate2, NULL);
    XtAddCallback(menu1, XtNchangeSelection, change1, NULL);
    XtAddCallback(menu2, XtNchangeSelection, change2, NULL);
    XtRealizeWidget(toplevel);
    XtInstallAllAccelerators(toplevel, toplevel);
    XtAppMainLoop(app_context);
}
