'\"
'\" Copyright 1991 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /rel/cvsfiles/devo/tcl/doc/library.man,v 1.1.1.1 1992/11/07 04:46:48 zoo Exp $ SPRITE (Berkeley)
'
.\" The definitions below are for supplemental macros used in Sprite
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Sprite man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.HS library tcl
.BS
.SH NAME
library \- standard library of Tcl procedures
.SH SYNOPSIS
.VS
.nf
\fBauto_execok \fIcmd\fR
\fBauto_load \fIcmd\fR
\fBauto_mkindex \fIdir pattern\fR
\fBauto_reset\fR
\fBparray \fIarrayName\fR
\fBunknown \fIcmd \fR?\fIarg arg ...\fR?
.fi
.BE

.SH INTRODUCTION
.PP
Tcl includes a library of Tcl procedures for commonly-needed functions.
The procedures defined in the Tcl library are generic ones suitable
for use by many different applications.
The location of the Tcl library is returned by the \fBinfo library\fR
command.
In addition to the Tcl library, each application will normally have
its own library of support procedures as well;  the location of this
library is normally given by the value of the \fB$appLibrary\fR
global variable.
.PP
To access the procedures in the Tcl library, an application should
source the file \fBinit.tcl\fR in the library, for example with
the Tcl command
.DS
\fBsource [info library]/init.tcl
.DE
This will define the \fBunknown\fR procedure and arrange for the
other procedures to be loaded on-demand using the auto-load
mechanism defined below.

.SH "COMMAND PROCEDURES"
.PP
The following procedures are provided in the Tcl library:
.TP
\fBauto_execok \fIcmd\fR
Determines whether there is an executable file by the name \fIcmd\fR.
This command examines the directories in the current search path
(given by the PATH enviornment variable) to see if there is an
executable file named \fIcmd\fR in any of those directories.
If so, it returns 1;  if not it returns 0.  \fBAuto_exec\fR
remembers information about previous searches in an array
named \fBauto_execs\fR;  this avoids the path search in
future calls for the same \fIcmd\fR.  The command \fBauto_reset\fR
may be used to force \fBauto_execok\fR to forget its cached
information.
.TP
\fBauto_load \fIcmd\fR
This command attempts to load the definition for a Tcl procedure named
\fIcmd\fR.
To do this, it searches an \fIauto-load path\fR, which is a list of
one or more directories.
The auto-load path is given by the global variable \fB$auto_path\fR
if it exists.
If there is no \fB$auto_path\fR variable, then the TCLLIBPATH environment
variable is used, if it exists.
Otherwise the auto-load path consists of just the Tcl library directory.
Within each directory in the auto-load path there must be a file
\fBtclIndex\fR that describes the procedures defined in that directory
and the file in which each procedure is defined.  The \fBtclIndex\fR
file should be generated with the \fBauto_mkindex\fR command.
If \fIcmd\fR is found in an index file, then the appropriate
script is \fBsource\fRd to create the procedure.
The \fBauto_load\fR command returns 1 if the script was successfully
sourced and \fIcmd\fR now exists.
The command returns 0 if there was no index entry for \fIcmd\fR
or if the script didn't actually define \fIcmd\fR (e.g. because
index information is out of date).
If an error occurs while processing the script, then that error
is returned.
\fBAuto_load\fR only reads the index information once and saves it
in the array \fBauto_index\fR;  future calls to \fBauto_load\fR
check for \fIcmd\fR in the array rather than re-reading the index
files.
The cached index information may be deleted with the command
\fBauto_reset\fR.
This will force the next \fBauto_load\fR command to reload the
index database from disk.
.TP
\fBauto_mkindex \fIdir pattern\fR
Generates an index suitable for use by \fBauto_load\fR.
The command searches \fIdir\fR for all files whose names match
\fIpattern\fR (matching is done with the \fBglob\fR command),
generates an index of all the Tcl command
procedures defined in all the matching files, and stores the
index information in a file named \fBtclIndex\fR in \fIdir\fR.
For example, the command
.RS
.DS
\fBauto_mkindex foo *.tcl\fR
.DE
.LP
will read all the \fB.tcl\fR files in subdirectory \fBfoo\fR
and generate a new index file \fBfoo/tclIndex\fR.
.PP
\fBAuto_mkindex\fR parses the Tcl scripts in a relatively
unsophisticated way:  if any line contains the word \fBproc\fR
as its first characters then it is assumed to be a procedure
definition and the next word of the line is taken as the
procedure's name.
Procedure definitions that don't appear in this way (e.g. they
have spaces before the \fBproc\fR) will not be indexed.
.RE
.TP
\fBauto_reset\fR
Destroys all the information cached by \fBauto_execok\fR and
\fBauto_load\fR.
This information will be re-read from disk the next time it is
needed.
.TP
\fBparray \fIarrayName\fR
Prints on standard output the names and values of all the elements
in the array \fIarrayName\fR.
\fBArrayName\fR must be a global array.
.TP
\fBunknown \fIcmd \fR?\fIarg arg ...\fR?
This procedure is invoked automatically by the Tcl interpreter
whenever the name of a command doesn't exist.
The \fBunknown\fR procedure receives as its arguments the
name and arguments of the missing command.
\fBUnknown\fR first calls \fBauto_load\fR to load a procedure for
the command.
If this succeeds, then it executes the original command with its
original arguments.
If the auto-load fails then \fBunknown\fR calls \fBauto_execok\fR
to see if there is an executable file by the name \fIcmd\fR.
If so, it invokes the Tcl \fBexec\fR command
with \fIcmd\fR and all the \fIargs\fR as arguments.
If \fIcmd\fR can't be auto-executed, \fBunknown\fR checks to see if \fIcmd\fR is
a unique abbreviation for an existing Tcl command.
If so, it expands the command name and executes the command with
the original arguments.
Finally, if none of the above efforts has been able to execute
the command, \fBunknown\fR generates an error return.
If the global variable \fBauto_noload\fR is defined, then the auto-load
step is skipped.
If the global variable \fBauto_noexec\fR is defined then the
auto-exec step is skipped.
Under normal circumstances the return value from \fBunknown\fR
is the return value from the command that was eventually
executed.

.SH "VARIABLES"
.PP
The following global variables are defined or used by the procedures in
the Tcl library:
.TP
\fBauto_execs\fR
Used by \fBauto_execok\fR to record information about whether
particular commands exist as executable files.
.TP
\fBauto_index\fR
Used by \fBauto_load\fR to save the index information read from
disk.
.TP
\fBauto_noexec\fR
If set to any value, then \fBunknown\fR will not attempt to auto-exec
any commands.
.TP
\fBauto_noload\fR
If set to any value, then \fBunknown\fR will not attempt to auto-load
any commands.
.TP
\fBauto_path\fR
If set, then it must contain a valid Tcl list giving directories to
search during auto-load operations.
.TP
\fBenv(TCLLIBPATH)\fR
If set, then it must contain a valid Tcl list giving directories to
search during auto-load operations.
This variable is only used if \fBauto_path\fR is not defined.
.TP
\fBunknown_active\fR
This variable is set by \fBunknown\fR to indicate that it is active.
It is used to detect errors where \fBunknown\fR recurses on itself
infinitely.
The variable is unset before \fBunknown\fR returns.

.SH KEYWORDS
auto-exec, auto-load, library, unknown
.VE
