'\"
'\" Copyright 1989 Regents of the University of California
'\" Permission to use, copy, modify, and distribute this
'\" documentation for any purpose and without fee is hereby
'\" granted, provided that this notice appears in all copies.
'\" The University of California makes no representations about
'\" the suitability of this material for any purpose.  It is
'\" provided "as is" without express or implied warranty.
'\" 
'\" $Header: /rel/cvsfiles/devo/tcl/doc/CrtPipelin.man,v 1.1.1.1 1992/11/07 04:46:43 zoo Exp $ SPRITE (Berkeley)
'\" 
.\" The definitions below are for supplemental macros used in Sprite
.\" manual entries.
.\"
.\" .HS name section [date [version]]
.\"	Replacement for .TH in other man pages.  See below for valid
.\"	section names.
.\"
.\" .AP type name in/out [indent]
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS [type [name]]
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .VS
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
'\"	# Heading for Sprite man pages
.de HS
.if '\\$2'cmds'       .TH \\$1 1 \\$3 \\$4
.if '\\$2'lib'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tcl'        .TH \\$1 3 \\$3 \\$4
.if '\\$2'tk'         .TH \\$1 3 \\$3 \\$4
.if t .wh -1.3i ^B
.nr ^l \\n(.l
.ad b
..
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ie !"\\$3"" \{\
.ta \\n()Au \\n()Bu
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp .5
..
.HS Tcl_CreatePipeline tcl
.VS
.BS
.SH NAME
Tcl_CreatePipeline \- create one or more child processes, with I/O redirection
.SH SYNOPSIS
.nf
\fB#include <tcl.h>\fR
.sp
int
\fBTcl_CreatePipeline\fR(\fIinterp, argc, argv, pidArrayPtr, inPipePtr, outPipePtr, errFilePtr\fR)
.SH ARGUMENTS
.AS Tcl_Interp **pidArrayPtr
.AP Tcl_Interp *interp in
Interpreter to use for error reporting.
.AP int argc in
Number of strings in \fIargv\fR array.
.AP char **argv in
Array of strings describing command(s) and I/O redirection.
.AP int **pidArrayPtr out
The value at \fI*pidArrayPtr\fR is modified to hold a pointer to
an array of process identifiers.  The array is dynamically
allocated and must be freed by the caller.
.AP char *inPipePtr out
If this argument is NULL then standard input for the first command
in the pipeline comes from the current standard input.
If \fIinPipePtr\fR is not NULL then \fBTcl_CreatePipeline\fR will
create a pipe, arrange for it to be used for standard input
to the first command,
and store a file id for writing to that pipe at \fI*inPipePtr\fR.
If the command specified its own input using redirection, then
no pipe is created and -1 is stored at \fI*inPipePtr\fR.
.AP char *outPipePtr out
If this argument is NULL then standard output for the last command
in the pipeline goes to the current standard output.
If \fIoutPipePtr\fR is not NULL then \fBTcl_CreatePipeline\fR will
create a pipe, arrange for it to be used for standard output from
the last command, and store a file id for reading from that
pipe at \fI*outPipePtr\fR.
If the command specified its own output using redirection then
no pipe is created and -1 is stored at \fI*outPipePtr\fR.
.AP char *errFilePtr out
If this argument is NULL then error output for all the commands
in the pipeline will go to the current standard error file.
If \fIerrFilePtr\fR is not NULL, error output from all the commands
in the pipeline will go to a temporary file created by
\fBTcl_CreatePipeline\fR.
A file id to read from that file will be stored at \fI*errFilePtr\fR.
The file will already have been removed, so closing the file
descriptor at \fI*errFilePtr\fR will cause the file to be flushed
completely.
.BE

.SH DESCRIPTION
.PP
\fBTcl_CreatePipeline\fR processes the \fIargv\fR array and sets
up one or more child processes in a pipeline configuration.
\fBTcl_CreatePipeline\fR handles pipes specified with ``|'',
input redirection specified with ``<'' or ``<<'', and output
redirection specified with ``>'';  see the documentation for
the \fBexec\fR command for details on these specifications.
The return value from \fBTcl_CreatePipeline\fR is a count of
the number of child processes created;  the process identifiers
for those processes are stored in a \fImalloc\fR-ed array and
a pointer to that array is stored at \fI*pidArrayPtr\fR.
It is the caller's responsibility to free the array when finished
with it.
.PP
If the \fIinPipePtr\fR, \fIoutPipePtr\fR, and \fIerrFilePtr\fR
arguments are NULL then the pipeline's standard input, standard
output, and standard error are taken from the corresponding
streams of the process.  Non-NULL values may be specified for
these arguments to use pipes for standard input and standard
output and a file for standard error.  \fBTcl_CreatePipeline\fR
will create the requested pipes or file and return file identifiers
that may be used to read or write them.  It is the caller's
responsibility to close all of these files when they are no
longer needed.  If \fIargv\fR specifies redirection for standard
input or standard output, then pipes will not be created even
if requested by the \fIinPipePtr\fR and \fIoutPipePtr\fR
arguments.
.PP
If an error occurs in \fBTcl_CreatePipeline\fR (e.g. ``|'' or
``<'' was the last argument in \fIargv\fR, or it wasn't possible
to fork off a child), then -1 is returned
and \fIinterp->result\fR is set to an error message.

.SH "SEE ALSO"
\fBTcl_WaitPids\fR, \fBTcl_DetachPids\fR

.SH KEYWORDS
background, child, detach, fork, process, status, wait
.VE
