/*
 *  This file is part of ixemul.library for the Amiga.
 *  Copyright (C) 1991, 1992  Markus M. Wild
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  unlink.c,v 1.1.1.1 1994/04/04 04:30:37 amiga Exp
 *
 *  unlink.c,v
 * Revision 1.1.1.1  1994/04/04  04:30:37  amiga
 * Initial CVS check in.
 *
 *  Revision 1.1  1992/05/14  19:55:40  mwild
 *  Initial revision
 *
 */

#define KERNEL
#include "ixemul.h"

#if __GNUC__ != 2
#define alloca __builtin_alloca
#endif

static int
__delete_func (struct StandardPacket *sp, struct MsgPort *handler,
               BPTR parent_lock,
	       BSTR name,
	       void *dummy, int *no_error)
{
  sp->sp_Pkt.dp_Type = ACTION_DELETE_OBJECT;
  sp->sp_Pkt.dp_Arg1 = parent_lock;
  sp->sp_Pkt.dp_Arg2 = name;

  PutPacket (handler, sp);
  __wait_sync_packet (sp);

  *no_error = sp->sp_Pkt.dp_Res1 == -1;
 
  /* stop if we failed because of symlink - reference */
  return 0;
}

int
unlink (char *name)
{
  int err, i;
  struct file **fp;
  int result;

  result = 0;

  /* first try to normally delete the file, if we get an
   * 'object in use' error, we'll try another way out.. */
  if (__plock (name, __delete_func, 0)) goto ret;

  /* so there was an error.. */
  err = IoErr();
  if (err == ERROR_OBJECT_IN_USE)
    {
      /* check whether the name is an absolute filename, if yes, we
       * can walk thru our filetab to see, whether WE have this file
       * open, and set its unlink-flag, if not, return the error */

      /* if we fully and consistent allow Unix-pathnames, we can test
       * for a leading '/' too. */
      if (index(name, ':') || (ix.ix_translate_slash && name[1] && name[0] == '/'))
	{
	  for (fp = u.u_ofile, i=0; i < NOFILE; i++, fp++)
	    if (*fp && (*fp)->f_name && !strcmp((*fp)->f_name, name))
	      {
		(*fp)->f_flags |= FUNLINK;
		goto ret;
	      }
	}
    }
  errno = __ioerr_to_errno(err);
  result = -1;

ret:
  return result;
}
