/*
 *  This file is part of ixemul.library for the Amiga.
 *  Copyright (C) 1991, 1992  Markus M. Wild
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  symlink.c,v 1.1.1.1 1994/04/04 04:30:36 amiga Exp
 *
 *  symlink.c,v
 * Revision 1.1.1.1  1994/04/04  04:30:36  amiga
 * Initial CVS check in.
 *
 *  Revision 1.2  1992/07/04  19:21:58  mwild
 *  cut a possibly leading `./' in symlink contents. This is a kludge, but it's
 *  the only way to get `configure' working without changes.
 *
 * Revision 1.1  1992/05/14  19:55:40  mwild
 * Initial revision
 *
 */

#define KERNEL
#include "ixemul.h"

#if __GNUC__ != 2
#define alloca __builtin_alloca
#endif

#ifndef LINK_SOFT
#define LINK_SOFT 1
#endif

int
symlink (char *old, char *new)
{
  char *lstr;
  int len;

  /* is long-alignment needed here? This is DOS, isn't it... */
  lstr = alloca (strlen (old) + 3);
  lstr = LONG_ALIGN (lstr);

  /* this is a kludge.. but it's the easiest way to get GNU configure
     scripts running without too many changes. */
  if (! strncmp (old, "./", 2))
    strcpy (lstr, old + 2);
  else
    strcpy (lstr, old);

  return __make_link (new, lstr, LINK_SOFT) == -1 ? 0 : -1;
}
