/*
 *  This file is part of ixemul.library for the Amiga.
 *  Copyright (C) 1991, 1992  Markus M. Wild
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  pipe.dos.c,v 1.1.1.1 1994/04/04 04:29:55 amiga Exp
 *
 *  pipe.dos.c,v
 * Revision 1.1.1.1  1994/04/04  04:29:55  amiga
 * Initial CVS check in.
 *
 *  Revision 1.1  1992/05/14  19:55:40  mwild
 *  Initial revision
 *
 */

#define KERNEL
#include "ixemul.h"

extern int __read(), __write(), __ioctl(), __fselect(), __close();

int
pipe (int pv[2])
{
  BPTR bpv[2];
  struct file *f1, *f2;
  int res, err, omask;
  
  omask = syscall (SYS_sigsetmask, ~0);
  res = -1; 
  err = EMFILE;
  if (__pipe (bpv))
    {
      if (! falloc (&f1, pv))
        {
          if (! falloc (&f2, pv+1))
            {
              f1->f_fh = BTOCPTR (bpv[0]);
	      __init_std_packet (& f1->f_sp);
	      __fstat (f1);
	      f1->f_flags  = FREAD;
	      f1->f_type   = DTYPE_FILE;
	      f1->f_read   = __read;
	      f1->f_write  = 0;
	      f1->f_ioctl  = __ioctl;
	      f1->f_close  = __close;
	      f1->f_select = __fselect;

              f2->f_fh = BTOCPTR (bpv[1]);
	      __init_std_packet (& f2->f_sp);
	      __fstat (f2);
	      f2->f_flags  = FWRITE;
	      f2->f_type   = DTYPE_FILE;
	      f2->f_read   = 0;
	      f2->f_write  = __write;
	      f2->f_ioctl  = __ioctl;
	      f2->f_close  = __close;
	      f2->f_select = __fselect;

	      res = err =0;
	      goto ret;
	    }
	  f1->f_count = 0;
	}
      __Close (bpv[0]);
      __Close (bpv[1]);
    }

ret:
  syscall (SYS_sigsetmask, omask);

  errno = err;
  return res;
}
