/*
 *  This file is part of ixemul.library for the Amiga.
 *  Copyright (C) 1991, 1992  Markus M. Wild
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  ix_stubs.c,v 1.1.1.1 1994/04/04 04:29:40 amiga Exp
 *
 *  ix_stubs.c,v
 * Revision 1.1.1.1  1994/04/04  04:29:40  amiga
 * Initial CVS check in.
 *
 *  Revision 1.2  1992/08/09  20:56:15  amiga
 *  add setgid
 *
 *  Revision 1.1  1992/05/22  01:48:08  mwild
 *  Initial revision
 *
 */

#define KERNEL
#include "ixemul.h"

void
endpwent (void) 
{
}

int
sync (void)
{
  /* could probably walk the entire file table and fsync each, but
     this is too much of a nuisance ;-)) */
  errno = ENOSYS;
  return -1;
}

int
fork (void)
{
  errno = ENOSYS;
  return -1;
}

int
mkfifo (const char *path, int mode)
{
  errno = ENOSYS;
  return -1;
}

int
mknod (const char *path, int mode, int dev)
{
  errno = ENOSYS;
  return -1;
}

int
setuid (int uid)
{
  /* just always succeed... */
  return 0;
}

int
setgid (int gid)
{
  /* just always succeed... */
  return 0;
}

int
nice (int niceval)
{
  errno = ENOSYS;
  return -1;
}

