/*
 *  This file is part of ixemul.library for the Amiga.
 *  Copyright (C) 1991, 1992  Markus M. Wild
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  ix_panic.c,v 1.1.1.1 1994/04/04 04:30:39 amiga Exp
 *
 *  ix_panic.c,v
 * Revision 1.1.1.1  1994/04/04  04:30:39  amiga
 * Initial CVS check in.
 *
 *  Revision 1.2  1992/08/09  20:53:58  amiga
 *  add cast
 *
 *  Revision 1.1  1992/05/14  19:55:40  mwild
 *  Initial revision
 *
 */

/*
 * This once was req.c by Markus Wandel. It doesn't look too much like the
 * original version though... Well, it was PD, I used it, so here is his
 * original disclaimer:
 *
 * req.c - by Markus Wandel - 1990
 * Placed in the public domain 7 Oct 1990
 * Please have the courtesy to give credit if you use this code
 * in any program.
 *
 */
#include <exec/types.h>
#include <exec/tasks.h>
#include <exec/execbase.h>
#include <intuition/intuition.h>
#include <sys/types.h>

#define BASE_EXT_DECL
#define BASE_EXT_DECL0
#define BASE_PAR_DECL struct IntuitionBase *IntuitionBase,
#define BASE_PAR_DECL0 struct IntuitionBase *IntuitionBase
#include <inline/intuition.h>

#include <inline/exec.h>

int
ix_panic (const char *msg)
{
  struct IntuiText line, righttext;
  struct IntuitionBase *IntuitionBase;
  int result = -1;
  u_char old_flags;
  struct Task *me = (*(struct ExecBase **)4)->ThisTask;

  /*
   * This function may be called with our signals enabled. So we have to make
   * sure that no signals are processed while in here.
   * Since this function may be called at random points in initialization,
   * it is not safe to call sigsetmask() here, so I have to resort to the
   * more drastic solution of temporarily turning off TF_LAUNCH
   */
  old_flags = me->tc_Flags;
  me->tc_Flags &= ~TF_LAUNCH;

  /* we (re)open intuition, because that way we don't depend on arp.library
   * being available for us to open intuibase */

  if (IntuitionBase = (struct IntuitionBase *)OpenLibrary("intuition.library",0))
    {
      line.FrontPen = AUTOFRONTPEN;
      line.BackPen = AUTOBACKPEN;
      line.DrawMode = AUTODRAWMODE;
      line.ITextFont = AUTOITEXTFONT;
      line.NextText = 0;
      CopyMem(&line, &righttext, sizeof(line));
      righttext.LeftEdge = AUTOLEFTEDGE;
      righttext.TopEdge = AUTOTOPEDGE;
      line.LeftEdge = 15;
      line.TopEdge = 5;

      line.IText = (UBYTE *) msg;
      righttext.IText = (UBYTE *) "Abort";
      result = AutoRequest(IntuitionBase,0L,&line,0L,&righttext,0L,0L,320L,72L);
      CloseLibrary ((struct Library *) IntuitionBase);
   }

  me->tc_Flags = old_flags;

  return result;
}
