/*
 *  This file is part of ixemul.library for the Amiga.
 *  Copyright (C) 1991, 1992  Markus M. Wild
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  ix_expunge.c,v 1.1.1.1 1994/04/04 04:30:27 amiga Exp
 *
 *  ix_expunge.c,v
 * Revision 1.1.1.1  1994/04/04  04:30:27  amiga
 * Initial CVS check in.
 *
 *  Revision 1.4  1992/08/09  20:48:13  amiga
 *  change to new way of remembering open libraries
 *  get prepared to deal with ttys
 *
 *  Revision 1.3  1992/05/22  01:43:58  mwild
 *  when debugging, check whether buddy allocator clean
 *
 * Revision 1.2  1992/05/17  21:21:56  mwild
 * changed async mp to be global
 *
 * Revision 1.1  1992/05/14  19:55:40  mwild
 * Initial revision
 *
 */

#define KERNEL
#include "ixemul.h"

#undef DEBUG

#ifdef DEBUG
#define DP(a) kprintf a
#else
#define DP(a)
#endif

extern struct MsgPort *ix_async_mp;
extern struct MsgPort *ix_tty_mp;

void
ix_expunge (struct ixemul_base *ixbase)
{
  if (ix_async_mp) DeleteInterruptPort (ix_async_mp);
  if (ix_tty_mp)   DeleteInterruptPort (ix_tty_mp);

#ifdef DEBUG
  check_empty (1);
#endif

  close_libraries (ixbase->ix_libs);
  
DP(("ix_expunge: freeing file table\n"));
  FreeMem (ixbase->ix_file_tab, NOFILE * sizeof (struct file));
DP(("ix_expunge: done\n"));
}
