#define KERNEL
#include "ixemul.h"

#include "devices.h"

/* since this has library scope, not just process scope, it can be global */
struct vdevice *vdevices = 0;
int		num_vdev = 0;

int
ix_config_vdevices (struct vdevice *devs)
{
  int num_dev;
  struct vdevice *vd, *d;

  /* count the number of given devices */
  for (vd = devs, num_dev = 0; vd->vd_name; vd++, num_dev++)
    if (vd->vd_type > VDEV_TYPE_MAX)
      {
        errno = EINVAL;
        return -1;
      }

  d = (struct vdevice *) kmalloc (num_dev * sizeof (struct vdevice));
  if (! d)
    {
outofmem:
      errno = ENOMEM;
      return -1;
    }

  for (vd = d; devs->vd_name; devs++)
    {
      vd->vd_name = (char *) kmalloc (strlen (devs->vd_name) + 1);
      if (! vd->vd_name)
        goto outofmem;
        
      strcpy (vd->vd_name, devs->vd_name);
      vd->vd_type = devs->vd_type;
   }

  ix_lock_base ();
  if (num_vdev) kfree (vdevices);
  vdevices = d;
  num_vdev = num_dev;
  ix_unlock_base ();

  return 0;
}
