/*
 *  This file is part of ixemul.library for the Amiga.
 *  Copyright (C) 1991, 1992  Markus M. Wild
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  getrlimit.c,v 1.1.1.1 1994/04/04 04:30:24 amiga Exp
 *
 *  getrlimit.c,v
 * Revision 1.1.1.1  1994/04/04  04:30:24  amiga
 * Initial CVS check in.
 *
 *  Revision 1.1  1992/05/14  19:55:40  mwild
 *  Initial revision
 *
 */

#define KERNEL
#include "ixemul.h"

#include <sys/time.h>
#include <sys/resource.h>

int
getrlimit(int resource, struct rlimit *rlp)
{
  struct Task *task = (struct Task *) FindTask (0);

  if (resource < RLIMIT_CPU || resource > RLIMIT_RSS || !rlp)
    {
      errno = EINVAL;
      return -1;
    }

  if (task->tc_Node.ln_Type == NT_PROCESS)
    {
      /* in that case, we're not a task, but a process */
      struct Process *proc = (struct Process *)task;
	
      switch (resource)
        {
        case RLIMIT_CPU:
	case RLIMIT_FSIZE:
	case RLIMIT_CORE:
	case RLIMIT_RSS:
        case RLIMIT_DATA:
	  rlp->rlim_cur = rlp->rlim_max = RLIM_INFINITY;
	  break;
	case RLIMIT_STACK:
	  rlp->rlim_cur = rlp->rlim_max = proc->pr_StackSize;
	  break;
	}
    }	
  else
    {
      /* so this is a task, and it has the stack-data somewhere else.. */
      switch (resource)
        {
        case RLIMIT_CPU:
	case RLIMIT_FSIZE:
	case RLIMIT_CORE:
	case RLIMIT_RSS:
        case RLIMIT_DATA:
	  rlp->rlim_cur = rlp->rlim_max = RLIM_INFINITY;
	  break;
	case RLIMIT_STACK:
	  rlp->rlim_cur = rlp->rlim_max = task->tc_SPUpper-task->tc_SPLower;
	  break;
	}
    }

  return 0;
}
