# use a proj-data file to generate a version.h header file, that can be
# included in either assembly or C sources. Generate a version.c file as
# well, that should include a Commodore conform $VER(sion) tag.
#

# I put an example line before each parser

#VERSION 37
($1 == "VERSION")	{ version  = $2; next }

#REVISION 1
($1 == "REVISION")	{ revision = $2; next }

#LIBNAME ixemul.library
($1 == "LIBNAME")	{ libname  = $2; next }

#ID ixemullib
($1 == "ID")		{ id = $2; 	 next }

#ABBREVS IX ix
($1 == "ABBREVS")	{ mac_abbrev = $2; 
			  c_abbrev = $3; next }

#comment
/^#.*/			{ next; }


			{ printf "Unknown keyword: %s, ignoring.\n", $1; next }

END {	if (version == "")
	  print "Need VERSION"
	else if (revision == "")
	  print "Need REVISION"
	else if (libname == "")
	  print "Need LIBNAME"
	else if (id == "")
	  print "Need ID"
	else if (mac_abbrev == "" || c_abbrev == "")
	  print "Need ABBREV"
	else
	  {
	    # first generate the version.h file

	    now = strftime("%e %h %Y")

	    printf "/*\n * version.h file. Automatically generated by genvers.awk.\n */\n\n"	>  "version.h"
	    printf "#define %s_NAME\t\t\"%s\"\n",
		   mac_abbrev, libname								>> "version.h"
	    printf "#define %s_IDSTRING\t\"%s %d.%d (%s)\\r\\n\"\n",
		   mac_abbrev, id, version+0, revision+0, now					>> "version.h"
	    printf "#define %s_VERSION\t%d\n", mac_abbrev, version+0				>> "version.h"
	    printf "#define %s_REVISION\t%d\n", mac_abbrev, revision+0				>> "version.h"
	    printf "#define %s_PRIORITY\t0\n", mac_abbrev					>> "version.h"

	    # oky, then generate the line used in version.c

	    printf "/*\n * version.c file. Automatically generated by genvers.awk.\n */\n\n"	>  "version.c"
	    printf "static const char version_id[] = \"\0$VER: %s %d.%d (%s)\";\n",
		   libname, version, revision, now						>> "version.c"
	  }
    }
