/*
 *  This file is part of ixemul.library for the Amiga.
 *  Copyright (C) 1991, 1992  Markus M. Wild
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  chmod.c,v 1.1.1.1 1994/04/04 04:30:15 amiga Exp
 *
 *  chmod.c,v
 * Revision 1.1.1.1  1994/04/04  04:30:15  amiga
 * Initial CVS check in.
 *
 *  Revision 1.3  1993/11/05  21:52:05  mw
 *  grp/oth support
 *
 *  Revision 1.2  1992/05/18  12:19:34  mwild
 *  now completely ignore FIBF_DELETE, correctly set errno in case of failure
 *
 * Revision 1.1  1992/05/14  19:55:40  mwild
 * Initial revision
 *
 */

#define KERNEL
#include "ixemul.h"

#if __GNUC__ != 2
#define alloca __builtin_alloca
#endif

/* not static because also used in nodspecial.c */
int
__chmod_func (struct StandardPacket *sp, struct MsgPort *handler,
              BPTR parent_lock,
	      BSTR name,
	      int mask, int *no_error)
{
  sp->sp_Pkt.dp_Type = ACTION_SET_PROTECT;
  sp->sp_Pkt.dp_Arg1 = 0;
  sp->sp_Pkt.dp_Arg2 = parent_lock;
  sp->sp_Pkt.dp_Arg3 = name;
  sp->sp_Pkt.dp_Arg4 = mask;
  
  PutPacket (handler, sp);
  __wait_sync_packet (sp);
  
  *no_error = sp->sp_Pkt.dp_Res1 == -1;
  return 1;
}


int
chmod(char *name, int mode)
{
  long amiga_mode = FIBF_READ|FIBF_WRITE|FIBF_EXECUTE;
  /* RWED-permissions are "lo-active", if cleared they allow the operation */
  int result;

#ifdef FIBF_GRP_EXECUTE
  amiga_mode |=   FIBF_GRP_READ | FIBF_GRP_WRITE | FIBF_GRP_EXECUTE
		| FIBF_OTR_READ | FIBF_OTR_WRITE | FIBF_OTR_EXECUTE;
#endif

  if (mode & S_IXUSR) amiga_mode &= ~FIBF_EXECUTE;
  if (mode & S_IWUSR) amiga_mode &= ~FIBF_WRITE;
  if (mode & S_IRUSR) amiga_mode &= ~FIBF_READ;
#ifdef FIBF_GRP_EXECUTE
  if (mode & S_IXGRP) amiga_mode &= ~FIBF_GRP_EXECUTE;
  if (mode & S_IWGRP) amiga_mode &= ~FIBF_GRP_WRITE;
  if (mode & S_IRGRP) amiga_mode &= ~FIBF_GRP_READ;
  if (mode & S_IXOTH) amiga_mode &= ~FIBF_OTR_EXECUTE;
  if (mode & S_IWOTH) amiga_mode &= ~FIBF_OTR_WRITE;
  if (mode & S_IROTH) amiga_mode &= ~FIBF_OTR_READ;
#endif

  result = __plock (name, __chmod_func, amiga_mode);
  if (result == 0)
    errno = __ioerr_to_errno (IoErr ());

  return result == -1 ? 0 : -1;
}


/* a signal proof SetProtection(), nothing more ;-) */
int
achmod (char *name, int mode)
{
  int result;

  result = __plock (name, __chmod_func, mode) == -1 ? 0 : -1;
  if (result == 0)
    errno = __ioerr_to_errno (IoErr ());

  return result;
}
