/*
 *  This file is part of ixemul.library for the Amiga.
 *  Copyright (C) 1991, 1992  Markus M. Wild
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  chdir.c,v 1.1.1.1 1994/04/04 04:30:15 amiga Exp
 *
 *  chdir.c,v
 * Revision 1.1.1.1  1994/04/04  04:30:15  amiga
 * Initial CVS check in.
 *
 *  Revision 1.3  1992/08/09  20:43:22  amiga
 *  change to use 2.x header files by default
 *
 *  Revision 1.2  1992/05/22  01:45:51  mwild
 *  remove ix_panic call, seems to happen more than I thought
 *
 * Revision 1.1  1992/05/14  19:55:40  mwild
 * Initial revision
 *
 */

#define KERNEL
#include "ixemul.h"

#ifdef DEBUG
#define DP(a) kprintf a
#else
#define DP(a)
#endif

/* if we change our directory, we have to remember the original cd, when
 * the process was started, because we're not allowed to unlock this
 * lock, since we didn't obtain it. */
/* BPTR __startup_cd = -1; */
#define __startup_cd (u.u_startup_cd)

int
chdir (char *path)
{
  BPTR oldlock, newlock;
  int error;
  int omask;
  
  /* Sigh... CurrentDir() is a DOS-library function, it would probably be
   * ok to just use pr_CurrentDir, but alas, this way we're conformant to
   * programming style guidelines, but we pay the overhead of locking dosbase
   */
  omask = syscall (SYS_sigsetmask, ~0);

  newlock = __lock (path, ACCESS_READ);

  if (newlock)
    {
      char *buf;

      oldlock = CurrentDir (newlock);
      if (__startup_cd == (BPTR)-1) __startup_cd = oldlock;
      else __unlock (oldlock);

      /* this one is for Mike B. Smith ;-) */
      /* kmalloc is lots cheaper than malloc */
      buf = (char *) kmalloc (MAXPATHLEN);
      if (buf)
	{
	  /* NOTE: this shortcuts any symlinks. But then, Unix does the
	   *       same, and a shell that wants to smart about symlinks,
	   *       has to track chdir()s itself as well */
	  if (NameFromLock (newlock, buf, MAXPATHLEN))
	    if (!SetCurrentDirName (buf))
#if 0
	      /* annoyed people... */
	      ix_panic ("chdir: couldn't set current directory name!");
#else
	  ;
#endif
	  kfree (buf);
	}
      /* but no matter what happened above, I consider the chdir() to have
       * succeeded, whether the stored name is correct or not. */
      syscall (SYS_sigsetmask, omask);
      return 0;
    }
  error = __ioerr_to_errno (IoErr ());

  syscall (SYS_sigsetmask, omask);
  errno = error;
  return -1;
}
