/*
 *  This file is part of ixemul.library for the Amiga.
 *  Copyright (C) 1991, 1992  Markus M. Wild
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  __read.c,v 1.1.1.1 1994/04/04 04:30:12 amiga Exp
 *
 *  __read.c,v
 * Revision 1.1.1.1  1994/04/04  04:30:12  amiga
 * Initial CVS check in.
 *
 *  Revision 1.1  1992/05/14  19:55:40  mwild
 *  Initial revision
 *
 */

#define KERNEL
#include "ixemul.h"

#ifdef DEBUG
#define DP(a) kprintf a
#else
#define DP(a)
#endif

int
__read(struct file *f, char *buf, int len)
{
  int err=errno, res = 0;
  int omask;

  /* always return EOF */
  if (HANDLER_NIL(f)) return 0;

  omask = syscall (SYS_sigsetmask, ~0);
  __get_file (f);
  /* just to make sure, this packet is really free, it could have
   * been used by a semi-async write, eg. */
  __wait_packet(&f->f_sp);

  if (len > 0)
    {
      if (f->f_flags & FNDELAY)
	{
	  /* shudder.. this is the most inefficient part of the whole
	   * library, but I don't know of another way of doing it... */
	  while (res < len)
            {
              SendPacket1(f,__rwport,ACTION_WAIT_CHAR,10);
              __wait_packet(&f->f_sp);
              if (! LastResult(f)) break;
	      SendPacket3(f,__rwport,ACTION_READ,f->f_fh->fh_Arg1,(long)buf,1);
	      __wait_packet(&f->f_sp);
	      if (LastResult(f) != 1) 
		{
		  err = __ioerr_to_errno(LastError(f));
		  /* if there really was no character to read, we should
		   * have escaped already at the 'if WaitForChar' line */
		  if (!res) res = -1;
		  break;
		}
	      buf++;
	      res++;
	    }
	}	  
      else
	{
	  SendPacket3(f,__rwport,ACTION_READ,f->f_fh->fh_Arg1,(long)buf,len);
	  __wait_packet(&f->f_sp);
	  res = LastResult(f);
	  if (res == -1) err = __ioerr_to_errno(LastError(f));
	}
   }

  LastResult(f) = 0;
  __release_file (f);
  syscall (SYS_sigsetmask, omask);
  errno = err;
  return res;
}
