/*
 *  This file is part of ixemul.library for the Amiga.
 *  Copyright (C) 1991, 1992  Markus M. Wild
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  __open.c,v 1.1.1.1 1994/04/04 04:30:11 amiga Exp
 *
 *  __open.c,v
 * Revision 1.1.1.1  1994/04/04  04:30:11  amiga
 * Initial CVS check in.
 *
 *  Revision 1.3  1992/08/09  20:38:07  amiga
 *  change to use 2.x header files by default
 *
 *  Revision 1.2  1992/07/28  02:51:41  mwild
 *  call AllocDosObject instead of rolling my own when > 1.3
 *
 *  Revision 1.1  1992/05/14  19:55:40  mwild
 *  Initial revision
 *
 */

#define KERNEL
#include "ixemul.h"

#include <utility/tagitem.h>
#include <dos/dostags.h>

#if __GNUC__ != 2
#define alloca __builtin_alloca
#endif

struct open_vec {
  int action;
  struct FileHandle *fh;
};

static int
__open_func (struct StandardPacket *sp, struct MsgPort *handler,
             BPTR parent_lock,
	     BSTR name,
	     struct open_vec *ov, int *no_error)
{
  sp->sp_Pkt.dp_Type = ov->action;
  sp->sp_Pkt.dp_Arg1 = CTOBPTR (ov->fh);
  sp->sp_Pkt.dp_Arg2 = parent_lock;
  sp->sp_Pkt.dp_Arg3 = name;

  PutPacket (handler, sp);
  __wait_sync_packet (sp);

  *no_error = sp->sp_Pkt.dp_Res1 == -1;
 
  /* handler is supposed to supply this, but if it didn't... */
  if (*no_error && !ov->fh->fh_Type) ov->fh->fh_Type = handler;
 
  /* continue if we failed because of symlink - reference */
  return 1;
}

BPTR
__open (char *name, int action)
{
  unsigned long *fh;
  struct open_vec ov;
  BPTR res;

  /* Needed to get berserk ReadArgs() to behave sane, GRRR */
  fh = AllocDosObjectTags (DOS_FILEHANDLE, ADO_FH_Mode, action, TAG_DONE);
  if (! fh)
    return 0;
  ov.fh = (struct FileHandle *) fh;
  ov.action = action;

  res = __plock (name, __open_func, &ov);
  /* check for opening of NIL:, in which case we just return
     a filehandle with a zero handle field */
  if (! res && IoErr() == 4242)
    res = -1;
  
  if (! res)
    FreeDosObject (DOS_FILEHANDLE, fh);
  return res ? CTOBPTR (ov.fh) : 0;
}
