/*
 *  This file is part of ixemul.library for the Amiga.
 *  Copyright (C) 1991, 1992  Markus M. Wild
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  __lock.c,v 1.1.1.1 1994/04/04 04:30:10 amiga Exp
 *
 *  __lock.c,v
 * Revision 1.1.1.1  1994/04/04  04:30:10  amiga
 * Initial CVS check in.
 *
 *  Revision 1.1  1992/05/14  19:55:40  mwild
 *  Initial revision
 *
 */

#define KERNEL
#include "ixemul.h"

#if __GNUC__ != 2
#define alloca __builtin_alloca
#endif

struct lock_vec {
  int    mode;
  int    resolve_last;
#ifdef LOCK2
  BPTR  *dup_parent;
  char **base_name;
#endif
};

static int
__lock_func (struct StandardPacket *sp, struct MsgPort *handler,
             BPTR parent_lock,
	     BSTR name,
	     struct lock_vec *lv, int *no_error)
{
  sp->sp_Pkt.dp_Type = ACTION_LOCATE_OBJECT;
  sp->sp_Pkt.dp_Arg1 = parent_lock;
  sp->sp_Pkt.dp_Arg2 = name;
  sp->sp_Pkt.dp_Arg3 = lv->mode;

  PutPacket (handler, sp);
  __wait_sync_packet (sp);
  
  *no_error = sp->sp_Pkt.dp_Res1 > 0;
  
#ifdef LOCK2
  if (*no_error && lv->dup_parent)
    *lv->dup_parent = DupLock (parent_lock);
  if (*no_error && lv->base_name)
    {
      u_char *tmp = BTOCPTR (name);
    
      *(lv->base_name) = syscall (SYS_malloc, tmp[0] + 1);
      bcopy (tmp+1, *lv->base_name, tmp[0]);
      (*(lv->base_name))[tmp[0]] = 0;
    }
#endif

  /* continue if we failed because of symlink - reference ? */
  return lv->resolve_last;
}

BPTR
__lock (char *name, int mode)
{
  struct lock_vec lv;

  lv.mode = mode;
  lv.resolve_last = 1;
#ifdef LOCK2
  lv.dup_parent = 0;
  lv.base_name = 0;
#endif
  
  return __plock (name, __lock_func, &lv);
}

BPTR
__llock (char *name, int mode)
{
  struct lock_vec lv;

  lv.mode = mode;
  lv.resolve_last = 0;
#ifdef LOCK2
  lv.dup_parent = 0;
  lv.base_name = 0;
#endif

  return __plock (name, __lock_func, &lv);
}

#ifdef LOCK2
BPTR
__lock2 (char *name, int mode, BPTR *parent_lock, char **base_name)
{
  struct lock_vec lv;
  BPTR res;

  lv.mode = mode;
  lv.resolve_last = 1;
  lv.dup_parent = parent_lock;
  lv.base_name  = base_name;
  
  res = __plock (name, __lock_func, &lv);
  
#if 0
  /* disabled currently, because the only client was __load_seg(), and I
   * did a cleaner solution by CurrentDir()'ing to the file itself. */

  if (res >= 0)
    {
      /* If you __lock2("device:file"), then you always get a parent lock
       * of zero, which just means in this case, that the file is in the
       * root directory of the file system. However, functions that use 
       * __lock2() want to be able to CurrentDir to this lock, so 0 won't work.
       * So if parent_lock is 0, and the specified file really is such a 
       * one-level file, then we __lock() the device explicitly */

      if (parent_lock && !*parent_lock)
	{
	  char *cp, c;
	  
	  cp = index (name, ':');
	  if (cp && !index (cp, '/'))	/* is it a first-level file ? */
	    {
	      cp++;
	      c = *cp;
	      *cp = 0;	/* temporarily terminate the string after the colon */
	      *parent_lock = __lock (name, ACCESS_READ);
	      *cp = c;
	    }
	}
    }

#endif

  return res;
}
#endif /* LOCK2 */
