;;; DO NOT MODIFY THIS FILE
(if (featurep 'vm-autoloads) (error "Already loaded"))

;;;### (autoloads nil "_pkg" "lisp/_pkg.el")

(package-provide 'vm :version 8.039999999999999 :author-version "8.0.10-devo" :type 'regular)

;;;***

;;;### (autoloads (tapestry-replace-tapestry-element tapestry-nullify-tapestry-elements tapestry-remove-frame-parameters set-tapestry tapestry) "tapestry" "lisp/tapestry.el")

(autoload 'tapestry "tapestry" "\
Returns a list containing complete information about the current
configuration of Emacs frames, windows, buffers and cursor
positions.  Call the function set-tapestry with the list that this function
returns to restore the configuration.

Optional first arg FRAME-LIST should be a list of frames; only
configuration information about these frames will be returned.

The configuration information is returned in a form that can be saved and
restored across multiple Emacs sessions." nil nil)

(autoload 'set-tapestry "tapestry" "\
Restore the frame/window/buffer configuration described by MAP,
which should be a list previously returned by a call to
tapestry.

Optional second arg N causes frame reconfiguration to be skipped
and the windows of the current frame will configured according to
the window map of the Nth frame in MAP.

Optional third arg ROOT-WINDOW-EDGES non-nil should be a list
containing the edges of a window in the current frame.  This list
should be in the same form as returned by the `window-edges'
function.  The window configuration from MAP will be restored in
this window.  If no window with these exact edges exists, a
window that lies entirely within the edge coordinates will be
expanded until the edge coordinates match or the window bounded by
ROOT-WINDOW-EDGES is entirely contained within the expanded
window.  If no window entirely within the ROOT-WINDOW-EDGES edge
coordinates can be found, the window with the greatest overlap of
ROOT-WINDOW-EDGES will be used." nil nil)

(autoload 'tapestry-remove-frame-parameters "tapestry" nil nil nil)

(autoload 'tapestry-nullify-tapestry-elements "tapestry" nil nil nil)

(autoload 'tapestry-replace-tapestry-element "tapestry" nil nil nil)

;;;***

;;;### (autoloads (vm-virtual-make-folder-persistent vm-virtual-auto-archive-messages vm-virtual-save-message vm-sort-insert-auto-folder-names vm-virtual-auto-select-folder vm-virtual-auto-delete-messages vm-virtual-auto-delete-message vm-virtual-omit-message vm-virtual-update-folders vm-virtual-apply-function vmpc-virtual-check-selector vm-virtual-check-selector-interactive vm-virtual-check-selector vm-virtual-get-selector vm-spam-words-rebuild vm-add-spam-word vm-avirtual-check-for-missing-selectors) "vm-avirtual" "lisp/vm-avirtual.el")

(autoload 'vm-avirtual-check-for-missing-selectors "vm-avirtual" "\
Check if there are selectors missing for either vm-mode or mail-mode." t nil)

(autoload 'vm-add-spam-word "vm-avirtual" "\
Add a new word to the list of spam words." t nil)

(autoload 'vm-spam-words-rebuild "vm-avirtual" "\
Discharge the internal cached data about spam words." t nil)

(autoload 'vm-virtual-get-selector "vm-avirtual" "\
Return the selector of virtual folder VFOLDER for VALID-FOLDER-LIST." t nil)

(autoload 'vm-virtual-check-selector "vm-avirtual" "\
Return t if SELECTOR matches the message MSG.
If VIRTUAL is true we check the current message and not the real one." nil nil)

(autoload 'vm-virtual-check-selector-interactive "vm-avirtual" "\
Return t if SELECTOR matches the current message.
Called with an prefix argument we display more diagnostics about the selector
evaluation.  Information is displayed in the order of evaluation and indented
according to the level of recursion. The displayed information is has the
format: 
	FATHER-SELECTOR: RESULT CHILD-SELECTOR" t nil)

(autoload 'vmpc-virtual-check-selector "vm-avirtual" "\
Checks SELECTOR based on the state of vmpc on the original or current." nil nil)

(autoload 'vm-virtual-apply-function "vm-avirtual" "\
Apply a FUNCTION to the next COUNT messages matching SELECTOR." t nil)

(autoload 'vm-virtual-update-folders "vm-avirtual" "\
Updates all virtual folders.
E.g. when creating a folder of all marked messages one can call this
function in order to add newly marked messages to the virtual folder
without recreating it." t nil)

(autoload 'vm-virtual-omit-message "vm-avirtual" "\
Omits a meassage from a virtual folder.
IMHO allowing it for real folders makes no sense.  One rather should create a
virtual folder of all messages." t nil)

(autoload 'vm-virtual-auto-delete-message "vm-avirtual" "\
*Mark messages matching a virtual folder selector for deletion.
The virtual folder selector can be configured by the variable
`vm-virtual-auto-delete-message-selector'.

This function does not visit the virtual folder, but checks only the current
message, therefore it is much faster and not so disturbing like the method
described in the VM-FAQ.

In order to automatically mark spam for deletion use the function
`vm-virtual-auto-delete-messages'.  See its documentation on how to hook it
into VM!" t nil)

(autoload 'vm-virtual-auto-delete-messages "vm-avirtual" "\
*Mark all messages from the current upto the last for (spam-)deletion.
Add this to `vm-arrived-messages-hook'!

See the function `vm-virtual-auto-delete-message' for details.

 (add-hook 'vm-arrived-messages-hook 'vm-virtual-auto-delete-messages)
" t nil)

(defcustom vm-virtual-auto-folder-alist nil "*Non-nil value should be an alist that VM will use to choose a default\nfolder name when messages are saved.  The alist should be of the form\n        ((VIRTUAL-FOLDER-NAME . FOLDER-NAME)\n          ...)\nwhere VIRTUAL-FOLDER-NAME is a string, and FOLDER-NAME\nis a string or an s-expression that evaluates to a string.\n\nThis allows you to extend `vm-virtual-auto-select-folder' to generate\na folder name.  Your function may use `folder' to get the currently choosen\nfolder name and `mp' (a vm-pessage-pointer) to access the message. \n\nExample:\n (setq vm-virtual-auto-folder-alist\n       '((\"spam\" (concat folder \"-\"\n                           (format-time-string \"%y%m\" (current-time))))))\n\nThis will return \"spam-0008\" as a folder name for messages matching the\nvirtual folder selector of the virtual folder \"spam\" during August in year\n2000." :type 'sexp :group 'vm-avirtual)

(autoload 'vm-virtual-auto-select-folder "vm-avirtual" "\
Return the first matching virtual folder.
This can be seen as an more powerful replacement of `vm-auto-select-folder'
and it is used by `vm-virtual-save-message'.  It might also be applied to
messages which are composed in order to find the right FCC." nil nil)

(defvar vm-sort-compare-auto-folder-cache nil)

(autoload 'vm-sort-insert-auto-folder-names "vm-avirtual" nil t nil)

(autoload 'vm-virtual-save-message "vm-avirtual" "\
Save the current message to a mail folder.
Like `vm-save-message' but the default folder it guessed by
`vm-virtual-auto-select-folder'." t nil)

(autoload 'vm-virtual-auto-archive-messages "vm-avirtual" "\
With a prefix ARG ask user before saving." t nil)

(autoload 'vm-virtual-make-folder-persistent "vm-avirtual" "\
Save all mails of current virtual folder to the real folder with the same
name." t nil)

;;;***

;;;### (autoloads (vm-biff-popup vm-biff-delete-popup vm-biff-fvwm-focus-vm-folder-frame vm-biff-select-message-mouse vm-biff-select-message) "vm-biff" "lisp/vm-biff.el")

(autoload 'vm-biff-select-message "vm-biff" "\
Put focus on the folder frame and select the appropiate message." t nil)

(autoload 'vm-biff-select-message-mouse "vm-biff" nil t nil)

(autoload 'vm-biff-fvwm-focus-vm-folder-frame "vm-biff" "\
Jumps to the frame containing the folder for the selected message.

1) Your Emacs frame needs to have the folder name in its title, see the
   variable `frame-title-format' on how to set this up.

2) You need to define the FVWM2 function SelectWindow and start the
   FvwmCommandS module.  Therefore, you will need the following lines
   in your .fvwm2rc file. 

AddToFunc InitFunction
+ I Module FvwmCommandS

AddToFunc RestartFunction
+ I Module FvwmCommandS

AddToFunc SelectWindow
+ I Next ($0) Iconify false
+ I Next ($0) Raise
+ I Next ($0) WarpToWindow 10p 10p
" t nil)

(autoload 'vm-biff-delete-popup "vm-biff" nil t nil)

(autoload 'vm-biff-popup "vm-biff" "\
Scan the current VM folder for new messages and popup a summary frame." t nil)

;;;***

;;;### (autoloads (vm-stunnel-configuration-args vm-tear-down-stunnel-random-data vm-setup-stunnel-random-data-if-needed vm-setup-ssh-tunnel vm-xor-string vm-md5-raw-string vm-md5-string vm-md5-region) "vm-crypto" "lisp/vm-crypto.el")

(autoload 'vm-md5-region "vm-crypto" nil nil nil)

(autoload 'vm-md5-string "vm-crypto" nil nil nil)

(autoload 'vm-md5-raw-string "vm-crypto" nil nil nil)

(autoload 'vm-xor-string "vm-crypto" nil nil nil)

(autoload 'vm-setup-ssh-tunnel "vm-crypto" nil nil nil)

(autoload 'vm-setup-stunnel-random-data-if-needed "vm-crypto" nil nil nil)

(autoload 'vm-tear-down-stunnel-random-data "vm-crypto" nil nil nil)

(autoload 'vm-stunnel-configuration-args "vm-crypto" nil nil nil)

;;;***

;;;### (autoloads (vm-expunge-folder vm-delete-duplicate-messages vm-kill-subject vm-undelete-message vm-delete-message-backward vm-delete-message) "vm-delete" "lisp/vm-delete.el")

(autoload 'vm-delete-message "vm-delete" "\
Add the `deleted' attribute to the current message.

The message will be physically deleted from the current folder the next
time the current folder is expunged.

With a prefix argument COUNT, the current message and the next
COUNT - 1 messages are deleted.  A negative argument means
the current message and the previous |COUNT| - 1 messages are
deleted.

When invoked on marked messages (via `vm-next-command-uses-marks'),
only marked messages are deleted, other messages are ignored." t nil)

(autoload 'vm-delete-message-backward "vm-delete" "\
Like vm-delete-message, except the deletion direction is reversed." t nil)

(autoload 'vm-undelete-message "vm-delete" "\
Remove the `deleted' attribute from the current message.

With a prefix argument COUNT, the current message and the next
COUNT - 1 messages are undeleted.  A negative argument means
the current message and the previous |COUNT| - 1 messages are
deleted.

When invoked on marked messages (via `vm-next-command-uses-marks'),
only marked messages are undeleted, other messages are ignored." t nil)

(autoload 'vm-kill-subject "vm-delete" "\
Delete all messages with the same subject as the current message.
Message subjects are compared after ignoring parts matched by
the variables vm-subject-ignored-prefix and vm-subject-ignored-suffix.

The optional prefix argument ARG specifies the direction to move
if vm-move-after-killing is non-nil.  The default direction is
forward.  A positive prefix argument means move forward, a
negative arugment means move backward, a zero argument means
don't move at all." t nil)

(autoload 'vm-delete-duplicate-messages "vm-delete" "\
Delete duplicate messages in the current folder.
This command works by computing an MD5 hash for the body ofeach
non-deleted message in the folder and deleting messages that have
a hash that has already been seen.  Messages that already deleted
are never hashed, so VM will never delete the last copy of a
message in a folder.  'Deleting' means flagging for deletion; you
will have to expunge the messages with `vm-expunge-folder' to
really get rid of them, as usual.

When invoked on marked messages (via `vm-next-command-uses-marks'),
only duplicate messages among the marked messages are deleted,
unmarked messages are not hashed or considerd for deletion." t nil)

(autoload 'vm-expunge-folder "vm-delete" "\
Expunge messages with the `deleted' attribute.
For normal folders this means that the deleted messages are
removed from the message list and the message contents are
removed from the folder buffer.

For virtual folders, messages are removed from the virtual
message list.  If virtual mirroring is in effect for the virtual
folder, the corresponding real messages are also removed from real
message lists and the message contents are removed from real folders.

When invoked on marked messages (via `vm-next-command-uses-marks'),
only messages both marked and deleted are expunged, other messages are
ignored." t nil)

;;;***

;;;### (autoloads (vm-burst-digest-to-temp-folder vm-burst-mime-digest vm-burst-rfc1153-digest vm-burst-rfc934-digest vm-burst-digest vm-rfc1153-encapsulate-messages vm-rfc934-encapsulate-messages vm-mime-burst-layout vm-mime-encapsulate-messages vm-no-frills-encapsulate-message) "vm-digest" "lisp/vm-digest.el")

(autoload 'vm-no-frills-encapsulate-message "vm-digest" "\
Encapsulate a message M for forwarding, simply.
No message encapsulation standard is used.  The message is
inserted at point in the current buffer, surrounded by two dashed
start/end separator lines.  Point is not moved.

M should be a message struct for a real message, not a virtual message.
This is the message that will be encapsulated.
KEEP-LIST should be a list of regexps matching headers to keep.
DISCARD-REGEXP should be a regexp that matches headers to be discarded.
KEEP-LIST and DISCARD-REGEXP are used to order and trim the headers
to be forwarded.  See the docs for vm-reorder-message-headers
to find out how KEEP-LIST and DISCARD-REGEXP are used." nil nil)

(autoload 'vm-mime-encapsulate-messages "vm-digest" "\
Encapsulate the messages in MESSAGE-LIST as per the MIME spec.
The resulting digest is inserted at point in the current buffer.
Point is not moved.

MESSAGE-LIST should be a list of message structs (real or virtual).
These are the messages that will be encapsulated.
KEEP-LIST should be a list of regexps matching headers to keep.
DISCARD-REGEXP should be a regexp that matches headers to be discarded.
KEEP-LIST and DISCARD-REGEXP are used to order and trim the headers
to be forwarded.  See the docs for vm-reorder-message-headers
to find out how KEEP-LIST and DISCARD-REGEXP are used.

If ALWAYS-USE-DIGEST is non-nil, always encapsulate for a multipart/digest.
Otherwise if there is only one message to be encapsulated
leave off the multipart boundary strings.  The caller is assumed to
be using message/rfc822 or message/news encoding instead.

If multipart/digest encapsulation is done, the function returns
the multipart boundary parameter (string) that should be used in
the Content-Type header.  Otherwise nil is returned." nil nil)

(autoload 'vm-mime-burst-layout "vm-digest" nil nil nil)

(autoload 'vm-rfc934-encapsulate-messages "vm-digest" "\
Encapsulate the messages in MESSAGE-LIST as per RFC 934.
The resulting digest is inserted at point in the current buffer.
Point is not moved.

MESSAGE-LIST should be a list of message structs (real or virtual).
These are the messages that will be encapsulated.
KEEP-LIST should be a list of regexps matching headers to keep.
DISCARD-REGEXP should be a regexp that matches headers to be discarded.
KEEP-LIST and DISCARD-REGEXP are used to order and trim the headers
to be forwarded.  See the docs for vm-reorder-message-headers
to find out how KEEP-LIST and DISCARD-REGEXP are used." nil nil)

(autoload 'vm-rfc1153-encapsulate-messages "vm-digest" "\
Encapsulate the messages in MESSAGE-LIST as per RFC 1153.
The resulting digest is inserted at point in the current buffer.
Point is not moved.

MESSAGE-LIST should be a list of message structs (real or virtual).
These are the messages that will be encapsulated.
KEEP-LIST should be a list of regexps matching headers to keep.
DISCARD-REGEXP should be a regexp that matches headers to be discarded.
KEEP-LIST and DISCARD-REGEXP are used to order and trim the headers
to be forwarded.  See the docs for vm-reorder-message-headers
to find out how KEEP-LIST and DISCARD-REGEXP are used." nil nil)

(autoload 'vm-burst-digest "vm-digest" "\
Burst the current message (a digest) into its individual messages.
The digest's messages are assimilated into the folder as new mail
would be.

Optional argument DIGEST-TYPE is a string that tells VM what kind
of digest the current message is.  If it is not given the value
defaults to the value of vm-digest-burst-type.  When called
interactively DIGEST-TYPE will be read from the minibuffer.

If invoked on marked messages (via vm-next-command-uses-marks),
all marked messages will be burst." t nil)

(autoload 'vm-burst-rfc934-digest "vm-digest" "\
Burst an RFC 934 style digest" t nil)

(autoload 'vm-burst-rfc1153-digest "vm-digest" "\
Burst an RFC 1153 style digest" t nil)

(autoload 'vm-burst-mime-digest "vm-digest" "\
Burst a MIME digest" t nil)

(autoload 'vm-burst-digest-to-temp-folder "vm-digest" "\
Burst the current message (a digest) into a temporary folder.
The digest's messages are copied to a buffer and vm-mode is
invoked on the buffer.  There is no file associated with this
buffer.  You can use `vm-write-file' to save the buffer, or
`vm-save-message' to save individual messages to a real folder.

Optional argument DIGEST-TYPE is a string that tells VM what kind
of digest the current message is.  If it is not given the value
defaults to the value of vm-digest-burst-type.  When called
interactively DIGEST-TYPE will be read from the minibuffer.

If invoked on marked messages (via vm-next-command-uses-marks),
all marked messages will be burst." t nil)

;;;***

;;;### (autoloads (vm-edit-message-end vm-discard-cached-data vm-edit-message-other-frame vm-edit-message) "vm-edit" "lisp/vm-edit.el")

(autoload 'vm-edit-message "vm-edit" "\
Edit the current message.  Prefix arg means mark as unedited instead.
If editing, the current message is copied into a temporary buffer, and
this buffer is selected for editing.  The major mode of this buffer is
controlled by the variable vm-edit-message-mode.  The hooks specified
in vm-edit-message-hook are run just prior to returning control to the user
for editing.

Use C-c ESC when you have finished editing the message.  The message
will be inserted into its folder replacing the old version of the
message.  If you don't want your edited version of the message to
replace the original, use C-c C-] and the edit will be aborted." t nil)

(autoload 'vm-edit-message-other-frame "vm-edit" "\
Like vm-edit-message, but run in a newly created frame." t nil)

(autoload 'vm-discard-cached-data "vm-edit" "\
Discard cached information about the current message.
When VM gathers information from the headers of a message, it stores it
internally for future reference.  This command causes VM to forget this
information, and VM will be forced to search the headers of the message
again for these data.  VM will also have to decide again which headers
should be displayed and which should not.  Therefore this command is
useful if you change the value of vm-visible-headers or
vm-invisible-header-regexp in the midst of a VM session.

Numeric prefix argument N means to discard data from the current message
plus the next N-1 messages.  A negative N means discard data from the
current message and the previous N-1 messages.

When invoked on marked messages (via vm-next-command-uses-marks),
data is discarded only from the marked messages in the current folder." t nil)

(autoload 'vm-edit-message-end "vm-edit" "\
End the edit of a message and copy the result to its folder." t nil)

;;;***

;;;### (autoloads (vm-change-folder-type vm-toggle-read-only vm-get-new-mail vm-spool-move-mail vm-help vm-recover-file vm-revert-buffer vm-save-and-expunge-folder vm-save-folder vm-write-file vm-save-buffer vm-quit vm-quit-no-change vm-quit-just-iconify vm-quit-just-bury vm-unread-message) "vm-folder" "lisp/vm-folder.el")

(autoload 'vm-unread-message "vm-folder" "\
Set the `unread' attribute for the current message.  If the message is
already new or unread, then it is left unchanged.

Numeric prefix argument N means to unread the current message plus the
next N-1 messages.  A negative N means unread the current message and
the previous N-1 messages.

When invoked on marked messages (via vm-next-command-uses-marks),
all marked messages are affected, other messages are ignored." t nil)

(autoload 'vm-quit-just-bury "vm-folder" "\
Bury the current VM folder and summary buffers.
The folder is not altered and Emacs is still visiting it.  You
can switch back to it with switch-to-buffer or by using the
Buffer Menu." t nil)

(autoload 'vm-quit-just-iconify "vm-folder" "\
Iconify the frame and bury the current VM folder and summary buffers.
The folder is not altered and Emacs is still visiting it." t nil)

(autoload 'vm-quit-no-change "vm-folder" "\
Quit visiting the current folder without saving changes made to the folder." t nil)

(autoload 'vm-quit "vm-folder" "\
Quit visiting the current folder, saving changes.  Deleted messages are not expunged." t nil)

(autoload 'vm-save-buffer "vm-folder" nil t nil)

(autoload 'vm-write-file "vm-folder" nil t nil)

(autoload 'vm-save-folder "vm-folder" "\
Save current folder to disk.
Deleted messages are not expunged.
Prefix arg is handled the same as for the command `save-buffer'.

When applied to a virtual folder, this command runs itself on
each of the underlying real folders associated with the virtual
folder." t nil)

(autoload 'vm-save-and-expunge-folder "vm-folder" "\
Expunge folder, then save it to disk.
Prefix arg is handled the same as for the command save-buffer.
Expunge won't be done if folder is read-only.

When applied to a virtual folder, this command works as if you had
run vm-expunge-folder followed by vm-save-folder." t nil)

(autoload 'vm-revert-buffer "vm-folder" nil t nil)

(autoload 'vm-recover-file "vm-folder" nil t nil)

(autoload 'vm-help "vm-folder" "\
Display help for various VM activities." t nil)

(autoload 'vm-spool-move-mail "vm-folder" nil nil nil)

(autoload 'vm-get-new-mail "vm-folder" "\
Move any new mail that has arrived in any of the spool files for the
current folder into the folder.  New mail is appended to the disk
and buffer copies of the folder.

Prefix arg means to gather mail from a user specified folder, instead of
the usual spool files.  The file name will be read from the minibuffer.
Unlike when getting mail from a spool file, the source file is left
undisturbed after its messages have been copied.

When applied to a virtual folder, this command runs itself on
each of the underlying real folders associated with this virtual
folder.  A prefix argument has no effect when this command is
applied to virtual folder; mail is always gathered from the spool
files." t nil)

(autoload 'vm-toggle-read-only "vm-folder" nil t nil)

(autoload 'vm-change-folder-type "vm-folder" "\
Change folder type to TYPE.
TYPE may be one of the following symbol values:

    From_
    From_-with-Content-Length
    BellFrom_
    mmdf
    babyl

Interactively TYPE will be read from the minibuffer." t nil)

;;;***

;;;### (autoloads (vm-grepmail) "vm-grepmail" "lisp/vm-grepmail.el")

(defcustom vm-grepmail-command "grepmail" "*Path to the program." :group 'vm-grepmail :type 'file)

(defcustom vm-grepmail-arguments (list "-q" "-m" "-R" "-e" (format "%S" user-full-name)) "*Arguments for grepmail program." :group 'vm-grepmail :type '(repeat (string)))

(autoload 'vm-grepmail "vm-grepmail" "\
A not so excellent interface to grepmail.
Grepmail is a fast perl-script for finding mails which got lost in the
folder jungle.  End your input or folders and directories with an empty sting
or the default folder.

ARGUMENTS the command line aruments to grepmail.
FOLDERS should be a list of files/directories to search in." t nil)

;;;***

;;;### (autoloads (vm-rename-imap-folder vm-delete-imap-folder vm-create-imap-folder vm-read-imap-folder-name vm-imap-parse-spec-to-list vm-imap-make-filename-for-spec vm-imap-find-spec-for-buffer vm-imap-folder-check-for-mail vm-imap-synchronize-folder vm-imap-save-message vm-imap-end-session vm-imap-make-session vm-imap-move-mail) "vm-imap" "lisp/vm-imap.el")

(autoload 'vm-imap-move-mail "vm-imap" nil nil nil)

(autoload 'vm-imap-make-session "vm-imap" nil nil nil)

(autoload 'vm-imap-end-session "vm-imap" nil nil nil)

(autoload 'vm-imap-save-message "vm-imap" nil nil nil)

(autoload 'vm-imap-synchronize-folder "vm-imap" nil nil nil)

(autoload 'vm-imap-folder-check-for-mail "vm-imap" nil nil nil)

(autoload 'vm-imap-find-spec-for-buffer "vm-imap" nil nil nil)

(autoload 'vm-imap-make-filename-for-spec "vm-imap" nil nil nil)

(autoload 'vm-imap-parse-spec-to-list "vm-imap" nil nil nil)

(autoload 'vm-read-imap-folder-name "vm-imap" "\
Read an IMAP server and mailbox, return an IMAP mailbox spec." nil nil)

(autoload 'vm-create-imap-folder "vm-imap" "\
Create a folder on an IMAP server.
First argument FOLDER is read from the minibuffer if called
interactively.  Non-interactive callers must provide an IMAP
maildrop specification for the folder as described in the
documentation for `vm-spool-files'." t nil)

(autoload 'vm-delete-imap-folder "vm-imap" "\
Delete a folder on an IMAP server.
First argument FOLDER is read from the minibuffer if called
interactively.  Non-interactive callers must provide an IMAP
maildrop specification for the folder as described in the
documentation for `vm-spool-files'." t nil)

(autoload 'vm-rename-imap-folder "vm-imap" "\
Rename a folder on an IMAP server.
Argument SOURCE and DEST are read from the minibuffer if called
interactively.  Non-interactive callers must provide full IMAP
maildrop specifications for SOURCE and DEST as described in the
documentation for `vm-spool-files'." t nil)

;;;***

;;;### (autoloads (vm-show-no-warranty vm-show-copying-restrictions) "vm-license" "lisp/vm-license.el")

(autoload 'vm-show-copying-restrictions "vm-license" "\
Show VM's license, i.e. the GPL." t nil)

(autoload 'vm-show-no-warranty "vm-license" "\
Display \"NO WARRANTY\" section of the GNU General Public License." t nil)

;;;***

;;;### (autoloads (vm-mark-help vm-marked-messages vm-next-command-uses-marks vm-unmark-matching-messages-with-virtual-folder vm-mark-matching-messages-with-virtual-folder vm-unmark-messages-same-author vm-mark-messages-same-author vm-unmark-messages-same-subject vm-mark-messages-same-subject vm-unmark-thread-subtree vm-mark-thread-subtree vm-unmark-matching-messages vm-mark-matching-messages vm-unmark-summary-region vm-mark-summary-region vm-unmark-message vm-mark-message vm-mark-all-messages vm-toggle-all-marks vm-clear-all-marks) "vm-mark" "lisp/vm-mark.el")

(autoload 'vm-clear-all-marks "vm-mark" "\
Removes all message marks in the current folder." t nil)

(autoload 'vm-toggle-all-marks "vm-mark" "\
Toggles all message marks in the current folder.
Messages that are unmarked will become marked and messages that are
marked will become unmarked." t nil)

(autoload 'vm-mark-all-messages "vm-mark" "\
Mark all messages in the current folder." t nil)

(autoload 'vm-mark-message "vm-mark" "\
Mark the current message.
Numeric prefix argument N means mark the current message and the next
N-1 messages.  A negative N means mark the current message and the
previous N-1 messages." t nil)

(autoload 'vm-unmark-message "vm-mark" "\
Remove the mark from the current message.
Numeric prefix argument N means unmark the current message and the next
N-1 messages.  A negative N means unmark the current message and the
previous N-1 messages." t nil)

(autoload 'vm-mark-summary-region "vm-mark" "\
Mark all messages with summary lines contained in the region." t nil)

(autoload 'vm-unmark-summary-region "vm-mark" "\
Remove marks from messages with summary lines contained in the region." t nil)

(autoload 'vm-mark-matching-messages "vm-mark" "\
Mark messages matching some criterion.
You can use any of the virtual folder selectors, except for the
`and', `or' and `not' selectors.  See the documentation for the
variable vm-virtual-folder-alist for more information." t nil)

(autoload 'vm-unmark-matching-messages "vm-mark" "\
Unmark messages matching some criterion.
You can use any of the virtual folder selectors, except for the
`and', `or' and `not' selectors.  See the documentation for the
variable vm-virtual-folder-alist for more information." t nil)

(autoload 'vm-mark-thread-subtree "vm-mark" "\
Mark all messages in the thread tree rooted at the current message." t nil)

(autoload 'vm-unmark-thread-subtree "vm-mark" "\
Unmark all messages in the thread tree rooted at the current message." t nil)

(autoload 'vm-mark-messages-same-subject "vm-mark" "\
Mark all messages with the same subject as the current message." t nil)

(autoload 'vm-unmark-messages-same-subject "vm-mark" "\
Unmark all messages with the same subject as the current message." t nil)

(autoload 'vm-mark-messages-same-author "vm-mark" "\
Mark all messages with the same author as the current message." t nil)

(autoload 'vm-unmark-messages-same-author "vm-mark" "\
Unmark all messages with the same author as the current message." t nil)

(autoload 'vm-mark-matching-messages-with-virtual-folder "vm-mark" "\
Mark messages that are matched by the selectors of virtual folder NAME." t nil)

(autoload 'vm-unmark-matching-messages-with-virtual-folder "vm-mark" "\
Unmark messages that are matched by the selectors of virtual folder NAME." t nil)

(autoload 'vm-next-command-uses-marks "vm-mark" "\
Does nothing except insure that the next VM command will operate only
on the marked messages in the current folder.  This only works for
commands bound to key, menu or button press events.  M-x vm-command will
not work." t nil)

(autoload 'vm-marked-messages "vm-mark" nil nil nil)

(autoload 'vm-mark-help "vm-mark" nil t nil)

;;;***

;;;### (autoloads (vm-message-history-browse vm-message-history-forward vm-message-history-backward vm-message-history-add) "vm-message-history" "lisp/vm-message-history.el")

(autoload 'vm-message-history-add "vm-message-history" "\
Add the selected message to `vm-message-history'.
\(Unless the message was selected via \\[vm-message-history-backward] or
\\[vm-message-history-forward].)" nil nil)

(autoload 'vm-message-history-backward "vm-message-history" "\
Select the previous message in the current folder's history.
With prefix ARG, select the ARG'th previous message." t nil)

(autoload 'vm-message-history-forward "vm-message-history" "\
Select the next message in the current folder's history.
With prefix ARG, select the ARG'th next message." t nil)

(autoload 'vm-message-history-browse "vm-message-history" "\
Select a message from a popup menu of the current folder's history." t nil)

;;;***

;;;### (autoloads (vm-mime-encode-composition vm-delete-mime-object vm-mime-change-content-disposition vm-mime-attach-object-from-message vm-mime-attach-message vm-mime-attach-buffer vm-mime-attach-mime-file vm-mime-attach-file vm-mime-reader-map-display-object-as-type vm-mime-reader-map-display-using-default vm-mime-reader-map-display-using-external-viewer vm-mime-reader-map-pipe-to-printer vm-mime-reader-map-pipe-to-command vm-mime-reader-map-save-message vm-mime-reader-map-save-file vm-mime-run-display-function-at-point vm-decode-mime-message) "vm-mime" "lisp/vm-mime.el")

(autoload 'vm-decode-mime-message "vm-mime" "\
Decode the MIME objects in the current message.

The first time this command is run on a message, decoding is done.
The second time, buttons for all the objects are displayed instead.
The third time, the raw, undecoded data is displayed.

If decoding, the decoded objects might be displayed immediately, or
buttons might be displayed that you need to activate to view the
object.  See the documentation for the variables

    vm-auto-displayed-mime-content-types
    vm-auto-displayed-mime-content-type-exceptions
    vm-mime-internal-content-types
    vm-mime-internal-content-type-exceptions
    vm-mime-external-content-types-alist

to see how to control whether you see buttons or objects.

If the variable vm-mime-display-function is set, then its value
is called as a function with no arguments, and none of the
actions mentioned in the preceding paragraphs are taken.  At the
time of the call, the current buffer will be the presentation
buffer for the folder and a copy of the current message will be
in the buffer.  The function is expected to make the message
`MIME presentable' to the user in whatever manner it sees fit." t nil)

(autoload 'vm-mime-run-display-function-at-point "vm-mime" "\
Display the MIME object at point according to its type." t nil)

(autoload 'vm-mime-reader-map-save-file "vm-mime" "\
Write the MIME object at point to a file." t nil)

(autoload 'vm-mime-reader-map-save-message "vm-mime" "\
Save the MIME object at point to a folder." t nil)

(autoload 'vm-mime-reader-map-pipe-to-command "vm-mime" "\
Pipe the MIME object at point to a shell command." t nil)

(autoload 'vm-mime-reader-map-pipe-to-printer "vm-mime" "\
Print the MIME object at point." t nil)

(autoload 'vm-mime-reader-map-display-using-external-viewer "vm-mime" "\
Display the MIME object at point with an external viewer." t nil)

(autoload 'vm-mime-reader-map-display-using-default "vm-mime" "\
Display the MIME object at point using the `default' face." t nil)

(autoload 'vm-mime-reader-map-display-object-as-type "vm-mime" "\
Display the MIME object at point as some other type." t nil)

(autoload 'vm-mime-attach-file "vm-mime" "\
Attach a file to a VM composition buffer to be sent along with the message.
The file is not inserted into the buffer and MIME encoded until
you execute `vm-mail-send' or `vm-mail-send-and-exit'.  A visible tag
indicating the existence of the attachment is placed in the
composition buffer.  You can move the attachment around or remove
it entirely with normal text editing commands.  If you remove the
attachment tag, the attachment will not be sent.

First argument, FILE, is the name of the file to attach.  Second
argument, TYPE, is the MIME Content-Type of the file.  Optional
third argument CHARSET is the character set of the attached
document.  This argument is only used for text types, and it is
ignored for other types.  Optional fourth argument DESCRIPTION
should be a one line description of the file.  Nil means include
no description.  Optional fifth argument NO-SUGGESTED-FILENAME non-nil
means that VM should not add a filename to the Content-Disposition
header created for the object.

When called interactively all arguments are read from the
minibuffer.

This command is for attaching files that do not have a MIME
header section at the top.  For files with MIME headers, you
should use vm-mime-attach-mime-file to attach such a file.  VM
will extract the content type information from the headers in
this case and not prompt you for it in the minibuffer." t nil)

(autoload 'vm-mime-attach-mime-file "vm-mime" "\
Attach a MIME encoded file to a VM composition buffer to be sent
along with the message.

The file is not inserted into the buffer until you execute
vm-mail-send or vm-mail-send-and-exit.  A visible tag indicating
the existence of the attachment is placed in the composition
buffer.  You can move the attachment around or remove it entirely
with normal text editing commands.  If you remove the attachment
tag, the attachment will not be sent.

The first argument, FILE, is the name of the file to attach.
When called interactively the FILE argument is read from the
minibuffer.

The second argument, TYPE, is the MIME Content-Type of the object.

This command is for attaching files that have a MIME
header section at the top.  For files without MIME headers, you
should use vm-mime-attach-file to attach the file." t nil)

(autoload 'vm-mime-attach-buffer "vm-mime" "\
Attach a buffer to a VM composition buffer to be sent along with
the message.

The buffer contents are not inserted into the composition
buffer and MIME encoded until you execute `vm-mail-send' or
`vm-mail-send-and-exit'.  A visible tag indicating the existence
of the attachment is placed in the composition buffer.  You
can move the attachment around or remove it entirely with
normal text editing commands.  If you remove the attachment
tag, the attachment will not be sent.

First argument, BUFFER, is the buffer or name of the buffer to
attach.  Second argument, TYPE, is the MIME Content-Type of the
file.  Optional third argument CHARSET is the character set of
the attached document.  This argument is only used for text
types, and it is ignored for other types.  Optional fourth
argument DESCRIPTION should be a one line description of the
file.  Nil means include no description.

When called interactively all arguments are read from the
minibuffer.

This command is for attaching files that do not have a MIME
header section at the top.  For files with MIME headers, you
should use vm-mime-attach-mime-file to attach such a file.  VM
will extract the content type information from the headers in
this case and not prompt you for it in the minibuffer." t nil)

(autoload 'vm-mime-attach-message "vm-mime" "\
Attach a message from a folder to a VM composition buffer
to be sent along with the message.

The message is not inserted into the buffer and MIME encoded until
you execute `vm-mail-send' or `vm-mail-send-and-exit'.  A visible tag
indicating the existence of the attachment is placed in the
composition buffer.  You can move the attachment around or remove
it entirely with normal text editing commands.  If you remove the
attachment tag, the attachment will not be sent.

First argument, MESSAGE, is either a VM message struct or a list
of message structs.  When called interactively a message number is read
from the minibuffer.  The message will come from the parent
folder of this composition.  If the composition has no parent,
the name of a folder will be read from the minibuffer before the
message number is read.

If this command is invoked with a prefix argument, the name of a
folder is read and that folder is used instead of the parent
folder of the composition.

If this command is invoked on marked message (via
`vm-next-command-uses-marks') the marked messages in the selected
folder will be attached as a MIME message digest.

Optional second argument DESCRIPTION is a one-line description of
the message being attached.  This is also read from the
minibuffer if the command is run interactively." t nil)

(autoload 'vm-mime-attach-object-from-message "vm-mime" "\
Attach a object from the current message to a VM composition buffer.

The object is not inserted into the buffer and MIME encoded until
you execute `vm-mail-send' or `vm-mail-send-and-exit'.  A visible tag
indicating the existence of the object is placed in the
composition buffer.  You can move the object around or remove
it entirely with normal text editing commands.  If you remove the
object tag, the object will not be sent.

First argument COMPOSITION is the buffer into which the object
will be inserted.  When this function is called interactively
COMPOSITION's name will be read from the minibuffer." t nil)

(autoload 'vm-mime-change-content-disposition "vm-mime" nil t nil)

(autoload 'vm-delete-mime-object "vm-mime" "\
Delete the contents of MIME object referred to by the MIME button at point.
The MIME object is replaced by a text/plain object that briefly
describes what was deleted." t nil)

(autoload 'vm-mime-encode-composition "vm-mime" "\
MIME encode the current mail composition buffer.
Attachment tags added to the buffer with `vm-mime-attach-file' are expanded
and the approriate content-type and boundary markup information is added." t nil)

;;;***

;;;### (autoloads (vm-previous-message-same-subject vm-next-message-same-subject vm-previous-unread-message vm-next-unread-message vm-previous-message-no-skip vm-next-message-no-skip vm-previous-message vm-next-message vm-goto-parent-message vm-goto-message-last-seen vm-goto-message) "vm-motion" "lisp/vm-motion.el")

(autoload 'vm-goto-message "vm-motion" "\
Go to the message numbered N.
Interactively N is the prefix argument.  If no prefix arg is provided
N is prompted for in the minibuffer.

If vm-follow-summary-cursor is non-nil this command will go to
the message under the cursor in the summary buffer if the summary
window is selected.  This only happens if no prefix argument is
given." t nil)

(autoload 'vm-goto-message-last-seen "vm-motion" "\
Go to the message last previewed." t nil)

(autoload 'vm-goto-parent-message "vm-motion" "\
Go to the parent of the current message." t nil)

(autoload 'vm-next-message "vm-motion" "\
Go forward one message and preview it.
With prefix arg (optional first argument) COUNT, go forward COUNT
messages.  A negative COUNT means go backward.  If the absolute
value of COUNT is greater than 1, then the values of the variables
vm-skip-deleted-messages and vm-skip-read-messages are ignored.

When invoked on marked messages (via vm-next-command-uses-marks)
this command 'sees' marked messages as it moves." t nil)

(autoload 'vm-previous-message "vm-motion" "\
Go back one message and preview it.
With prefix arg COUNT, go backward COUNT messages.  A negative COUNT
means go forward.  If the absolute value of COUNT > 1 the values of the
variables vm-skip-deleted-messages and vm-skip-read-messages are
ignored." t nil)

(autoload 'vm-next-message-no-skip "vm-motion" "\
Like vm-next-message but will not skip deleted or read messages." t nil)

(autoload 'vm-previous-message-no-skip "vm-motion" "\
Like vm-previous-message but will not skip deleted or read messages." t nil)

(autoload 'vm-next-unread-message "vm-motion" "\
Move forward to the nearest new or unread message, if there is one." t nil)

(autoload 'vm-previous-unread-message "vm-motion" "\
Move backward to the nearest new or unread message, if there is one." t nil)

(autoload 'vm-next-message-same-subject "vm-motion" "\
Move forward to the nearest message with the same subject.
vm-subject-ignored-prefix and vm-subject-ignored-suffix will apply
to the subject comparisons." t nil)

(autoload 'vm-previous-message-same-subject "vm-motion" "\
Move backward to the nearest message with the same subject.
vm-subject-ignored-prefix and vm-subject-ignored-suffix will apply
to the subject comparisons." t nil)

;;;***

;;;### (autoloads (vm-mouse-read-string-quit-handler vm-mouse-read-file-name-quit-handler vm-mouse-install-mouse vm-mouse-send-url-at-event vm-mouse-popup-or-select vm-mouse-button-3 vm-mouse-button-2) "vm-mouse" "lisp/vm-mouse.el")

(autoload 'vm-mouse-button-2 "vm-mouse" nil t nil)

(autoload 'vm-mouse-button-3 "vm-mouse" nil t nil)

(autoload 'vm-mouse-popup-or-select "vm-mouse" nil t nil)

(autoload 'vm-mouse-send-url-at-event "vm-mouse" nil t nil)

(autoload 'vm-mouse-install-mouse "vm-mouse" nil nil nil)

(autoload 'vm-mouse-read-file-name-quit-handler "vm-mouse" nil t nil)

(autoload 'vm-mouse-read-string-quit-handler "vm-mouse" nil t nil)

;;;***

;;;### (autoloads (vm-move-to-previous-button vm-move-to-next-button vm-end-of-message vm-beginning-of-message vm-expose-hidden-headers vm-energize-urls-in-message-region vm-energize-urls vm-scroll-backward-one-line vm-scroll-forward-one-line vm-scroll-backward vm-scroll-forward) "vm-page" "lisp/vm-page.el")

(autoload 'vm-scroll-forward "vm-page" "\
Scroll forward a screenful of text.
If the current message is being previewed, the message body is revealed.
If at the end of the current message, moves to the next message iff the
value of vm-auto-next-message is non-nil.
Prefix argument N means scroll forward N lines." t nil)

(autoload 'vm-scroll-backward "vm-page" "\
Scroll backward a screenful of text.
Prefix N scrolls backward N lines." t nil)

(autoload 'vm-scroll-forward-one-line "vm-page" "\
Scroll forward one line.
Prefix arg N means scroll forward N lines.
Negative arg means scroll backward." t nil)

(autoload 'vm-scroll-backward-one-line "vm-page" "\
Scroll backward one line.
Prefix arg N means scroll backward N lines.
Negative arg means scroll forward." t nil)

(autoload 'vm-energize-urls "vm-page" nil t nil)

(autoload 'vm-energize-urls-in-message-region "vm-page" nil t nil)

(autoload 'vm-expose-hidden-headers "vm-page" "\
Toggle exposing and hiding message headers that are normally not visible." t nil)

(autoload 'vm-beginning-of-message "vm-page" "\
Moves to the beginning of the current message." t nil)

(autoload 'vm-end-of-message "vm-page" "\
Moves to the end of the current message, exposing and flagging it read
as necessary." t nil)

(autoload 'vm-move-to-next-button "vm-page" "\
Moves to the next button in the current message.
Prefix argument N means move to the Nth next button.
Negative N means move to the Nth previous button.
If there is no next button, an error is signaled and point is not moved.

A button is a highlighted region of text where pressing RETURN
will produce an action.  If the message is being previewed, it is
exposed and marked as read." t nil)

(autoload 'vm-move-to-previous-button "vm-page" "\
Moves to the previous button in the current message.
Prefix argument N means move to the Nth previous button.
Negative N means move to the Nth next button.
If there is no previous button, an error is signaled and point is not moved.

A button is a highlighted region of text where pressing RETURN
will produce an action.  If the message is being previewed, it is
exposed and marked as read." t nil)

;;;***

;;;### (autoloads (vmpc-automorph vmpc-toggle-no-automorph vmpc-run-action) "vm-pcrisis" "lisp/vm-pcrisis.el")

(autoload 'vmpc-run-action "vm-pcrisis" "\
Run all actions with names matching the ACTION-REGEXP.
If called interactivly it promts for the regexp.  You may also use
completion." t nil)

(autoload 'vmpc-toggle-no-automorph "vm-pcrisis" "\
Disable automorph for the current buffer.
When automorph is not doing the right thing and you want to disable it for the
current composition, then call this function." t nil)

(autoload 'vmpc-automorph "vm-pcrisis" "\
*Change contents of the current mail message based on its own headers.
Unless `vmpc-current-state' is 'no-automorph, headers and signatures can be
changed; pre-signatures added; functions called.

Call `vmpc-no-automorph' to disable it for the current buffer." t nil)

;;;***

;;;### (autoloads (vm-mail-to-fcc vm-mail-select-folder vm-mail-get-header-contents vm-mail-auto-fcc vm-mail-fcc vm-mail-priority vm-mail-notice-requested-upon-delivery-to vm-mail-return-receipt-to vm-continue-what-message-other-frame vm-continue-what-message-other-window vm-continue-what-message vm-postpone-message vm-reply-by-continue-postponed-message vm-continue-postponed-message vm-summary-function-p vm-summary-function-f) "vm-pine" "lisp/vm-pine.el")

(autoload 'vm-summary-function-f "vm-pine" "\
Return the recipient or newsgroup for uninteresting senders.
If the \"From:\" header contains the user login or full name then
this function returns the \"To:\" or \"Newsgroups:\" header field with a
\"To:\" as prefix.

For example the outgoing message box will now list to whom you sent the
messages.  Use `vm-fix-summary!!!' to update the summary of a folder! With
loaded BBDB it uses `vm-summary-function-B' to obtain the full name of the
sender.  The only difference to VMs default behavior is the honoring of
messages sent to news groups. ;c)

See also:    `vm-summary-uninteresting-senders'" t nil)

(defcustom vm-postponed-header "X-VM-postponed-data: " "Additional header which is inserted to postponed messages.\nIt is used for internal things and should not be modified. \nIt is a lisp list which currently contains the following items:\n <date of the postponing>\n <reply references list>\n <forward references list>\n <redistribute references list>\nwhile the last three are set by `vm-get-persistent-message-ids-for'." :type 'string :group 'vm-pine)

(defcustom vm-postponed-attribute "P" "Summary string that will be inserted by `vm-summary-function-p' for\npostponed messages." :type 'string :group 'vm-pine)

(autoload 'vm-summary-function-p "vm-pine" "\
Return 'P' for postponed messages." t nil)

(defcustom vm-postponed-folder "postponed" "The name of the folder where postponed messages are saved." :type 'string :group 'vm-pine)

(defcustom vm-postponed-message-headers '("From:" "Organization:" "Reply-To:" "To:" "Newsgroups:" "CC:" "BCC:" "FCC:" "In-Reply-To:" "References:" "Subject:" "X-Priority:" "Priority:") "Similar to `vm-forwarded-headers'.\nA list of headers that should be kept, when continuing a postponed message.\n\nThe following mime headers should not be kept, since this breaks things:\nMime-Version, Content-Type, Content-Transfer-Encoding." :type '(repeat (string)) :group 'vm-pine)

(defcustom vm-postponed-message-discard-header-regexp nil "Similar to `vm-unforwarded-header-regexp'.\nA regular expression matching all headers that should be discard when\nwhen continuing a postponed message." :type 'regexp :group 'vm-pine)

(defcustom vm-continue-postponed-message-hook nil "List of hook functions to be run after continuing a postponed message." :type 'hook :group 'vm-pine)

(defcustom vm-postpone-message-hook nil "List of hook functions to be run before postponing a message." :type 'hook :group 'vm-pine)

(autoload 'vm-continue-postponed-message "vm-pine" "\
Continue composing of the currently selected message.
Before continuing the composition you may decode the presentation as
you like, by pressing [D] and viewing part of the message!
Then current message is copied to a new buffer and the vm-mail-mode is
entered.  When every thing is finished the hook functions in
`vm-mail-mode-hook' and `vm-continue-postponed-message-hook' are
executed.  When called with a prefix argument it will not switch to
the composition buffer, this may be used for automatic editing of
messages.

The variables `vm-postponed-message-headers' and
`vm-postponed-message-discard-header-regexp' control which
headers are copied to the composition buffer.

In `vm-mail-mode' this is bound to [C].
If optional argument SILENT is positive then act in background (no frame
creation)." t nil)

(autoload 'vm-reply-by-continue-postponed-message "vm-pine" "\
Like `vm-reply' but preserves attachments." t nil)

(autoload 'vm-postpone-message "vm-pine" "\
Save the current composition as a draft.
Before saving the composition the `vm-postpone-message-hook' functions
are executed and it is written into the FOLDER `vm-postponed-folder'.
When called with a prefix argument you will be asked for
the folder.
Optional argument DONT-KILL is positive, then do not kill source message." t nil)

(autoload 'vm-continue-what-message "vm-pine" "\
Continue compositions or postponed messages if there are some.

With a prefix arg, call `vm-continue-postponed-message', i.e. continue the
currently selected message.

See `vm-continue-what-message' and `vm-zero-drafts-start-compose' for
configuration." t nil)

(autoload 'vm-continue-what-message-other-window "vm-pine" "\
Ask for continuing of postponed messages if there are some." t nil)

(autoload 'vm-continue-what-message-other-frame "vm-pine" "\
Ask for continuing of postponed messages if there are some." t nil)

(defcustom vm-mail-return-receipt-to (concat (user-full-name) " <" user-mail-address ">") "The address where return receipts should be sent to." :type 'string :group 'vm-pine)

(autoload 'vm-mail-return-receipt-to "vm-pine" "\
Insert the \"Return-Receipt-To\" header into a `vm-mail-mode' buffer.
See the variable `vm-mail-return-receipt-to'." t nil)

(autoload 'vm-mail-notice-requested-upon-delivery-to "vm-pine" "\
Notice-Requested-Upon-Delivery-To:" t nil)

(defcustom vm-mail-priority "Priority: urgent\nImportance: High\nX-Priority: 1" "The priority headers." :type 'string :group 'vm-pine)

(autoload 'vm-mail-priority "vm-pine" "\
Insert priority headers into a `vm-mail-mode' buffer.
See the variable `vm-mail-priority'." t nil)

(defcustom vm-mail-folder-alist (if (boundp 'vm-auto-folder-alist) vm-auto-folder-alist) "Like `vm-auto-folder-alist' but for outgoing messages.\nIt should be fed to `vm-mail-select-folder'!" :type 'list :group 'vm-pine)

(defcustom vm-mail-fcc-default '(or (vm-mail-select-folder vm-mail-folder-alist) (vm-mail-to-fcc nil t) mail-archive-file-name) "A list which is evaluated to return a folder name.\nBy reordering the elements of this list or adding own functions you\ncan control the behavior of vm-mail-fcc and `vm-mail-auto-fcc'.\nYou may allow a sophisticated decision for the right folder for your\noutgoing message." :type 'list :group 'vm-pine)

(autoload 'vm-mail-fcc "vm-pine" "\
Insert the FCC-header into a `vm-mail-mode' buffer.
Like `mail-fcc', but honors VM variables and offers a default folder
according to `vm-mail-folder-alist'.
Called with prefix ARG it just removes the FCC-header." t nil)

(autoload 'vm-mail-auto-fcc "vm-pine" "\
Add a new FCC field, with file name guessed by `vm-mail-folder-alist'.
You likely want to add it to `vm-reply-hook' by
   (add-hook 'vm-reply-hook 'vm-mail-auto-fcc)
or if sure about what you are doing you can add it to mail-send-hook!" t nil)

(autoload 'vm-mail-get-header-contents "vm-pine" "\
Return the contents of the header(s) matching HEADER-NAME-REGEXP.
This function is a slightly changed version of `vm-get-header-contents'.
Optional argument CLUMP-SEP usually a \",\"." nil nil)

(autoload 'vm-mail-select-folder "vm-pine" "\
Return a folder according to FOLDER-ALIST for the current message.
This function is a slightly changed version of `vm-auto-select-folder'." t nil)

(defcustom vm-mail-to-regexp "\\([^<	\n ]+\\)@" "A regexp matching the part of an email address to use as FCC-folder.\nThe string enclosed in \"\\\\(\\\\)\" is used as folder name." :type 'regexp :group 'vm-pine)

(defcustom vm-mail-to-headers '("To:" "CC:" "BCC:") "A list of headers for finding the email address to use as FCC-folder." :type '(repeat (string)) :group 'vm-pine)

(autoload 'vm-mail-to-fcc "vm-pine" "\
Insert a FCC-header into a `vm-mail-mode' buffer.
Like `mail-fcc', but honors VM variables and inserts the first email
address (or the like matched by `vm-mail-to-regexp') found in the headers
listed in `vm-mail-to-headers'.
Called with prefix ARG it just removes the FCC-header.
If optional argument RETURN-ONLY is t just returns FCC." t nil)

;;;***

;;;### (autoloads (vm-pop-make-filename-for-spec vm-pop-find-name-for-buffer vm-pop-find-name-for-spec vm-pop-find-spec-for-name vm-pop-folder-check-for-mail vm-pop-synchronize-folder vm-expunge-pop-messages vm-pop-move-mail) "vm-pop" "lisp/vm-pop.el")

(autoload 'vm-pop-move-mail "vm-pop" nil nil nil)

(autoload 'vm-expunge-pop-messages "vm-pop" "\
Deletes all messages from POP mailbox that have already been retrieved
into the current folder.  VM sends POP DELE commands to all the
relevant POP servers to remove the messages." t nil)

(autoload 'vm-pop-synchronize-folder "vm-pop" nil nil nil)

(autoload 'vm-pop-folder-check-for-mail "vm-pop" nil nil nil)

(autoload 'vm-pop-find-spec-for-name "vm-pop" nil nil nil)

(autoload 'vm-pop-find-name-for-spec "vm-pop" nil nil nil)

(autoload 'vm-pop-find-name-for-buffer "vm-pop" nil nil nil)

(autoload 'vm-pop-make-filename-for-spec "vm-pop" nil nil nil)

;;;***

;;;### (autoloads (vm-ps-print-marked vm-ps-print-message-infect-vm vm-ps-print-message-fix-menu vm-ps-print-message-presentation vm-ps-print-each-message vm-ps-print-message) "vm-ps-print" "lisp/vm-ps-print.el")

(defcustom vm-ps-print-message-function 'ps-print-buffer-with-faces "*This should point to the function which is used for ps-printing.\nThe function should accept one optional argument which is a filename." :group 'vm-psprint :type 'function)

(defcustom vm-ps-print-message-separater "\n" "*The separator between messages when printing multiple messages." :group 'vm-psprint :type 'string)

(defcustom vm-ps-print-message-font-size 10 "*The font size for the PS-output of the message text." :group 'vm-psprint :type 'integer)

(defcustom vm-ps-print-message-header-lines 2 "*See `ps-header-lines'." :group 'vm-psprint :type 'integer)

(defcustom vm-ps-print-message-left-header '(list (format "(Folder `%s')" folder-name) (format "(%d message%s printed)" mcount (if (= mcount 1) "" "s"))) "*This variable should contain a command returning a valid `ps-left-header'." :group 'vm-psprint :type 'sexp)

(defcustom vm-ps-print-message-right-header '(list "/pagenumberstring load" 'dd-mon-yyyy) "*This variable should contain a command returning a valid `ps-right-header'.\nThe defaults to the number of pages and the date of the printout." :group 'vm-psprint :type 'sexp)

(defcustom vm-ps-print-message-summary-format (concat "******************************************************************************\n" (if (boundp 'vm-summary-format) vm-summary-format "%n %*%a %-17.17F %-3.3m %2d %4l/%-5c %I\"%s\"\n") "******************************************************************************\n") "*The summary line before a message.\nSee `vm-summary-format' for a description of the conversion specifiers." :group 'vm-psprint :type 'string)

(defcustom vm-ps-print-each-message-header-lines 2 "*See `ps-header-lines'." :group 'vm-psprint :type 'integer)

(defcustom vm-ps-print-each-message-left-header '(list (format "(Folder `%s')" folder-name) (format "(%s)" (vm-ps-print-tokenized-summary msg (vm-summary-sprintf vm-ps-print-each-message-summary-format msg t)))) "*This command should return a valid `ps-left-header'.\nThe default is to have the folder name and a summary according to the\nvariable `vm-ps-print-each-message-summary-format' in the left header." :group 'vm-psprint :type 'sexp)

(defcustom vm-ps-print-each-message-right-header '(list "/pagenumberstring load" 'dd-mon-yyyy) "*This variable should contain a command returning a valid `ps-right-header'.\nThe defaults to the number of pages and the date of the printout." :group 'vm-psprint :type 'sexp)

(defcustom vm-ps-print-each-message-summary-format "Message# %n, Lines %l, Characters %c" "*The summary line for the postscript header.\nSee `vm-summary-format' for a description of the conversion specifiers." :group 'vm-psprint :type 'string)

(autoload 'vm-ps-print-message "vm-ps-print" "\
PS-Print the current message.

A positive COUNT arg N means print the current message and the next
N-1 messages and a negative one print the current message and the
previous N-1 messages.

If FILENAME is specified then write PS into that file.

When printing a single message it acts like `vm-ps-print-each-message'.
When printing multiple messages it will insert a summary line according
to the variable `vm-ps-print-message-summary-format' and a separator
according to the variable `vm-ps-print-message-separater' between
messages.  You might force the printing of one job per message, by
giving a t EACH argument.

See: `vm-ps-print-message-function'
     `vm-ps-print-message-font-size'
     `vm-ps-print-message-summary-format'
     `vm-ps-print-message-separater'
     `vm-ps-print-message-left-header'
     `vm-ps-print-message-right-header'
for customization of the output." t nil)

(autoload 'vm-ps-print-each-message "vm-ps-print" "\
PS-Print the current message.
A positive COUNT arg N means print the current message and the next
N-1 messages and a negative one print the current message and the
previous N-1 messages.

If FILENAME is specified then write PS into that file.

This function acts like `vm-ps-print-message', but it will generate a
separate print job for each message and it does not generate the
summary lines between messages.

See: `vm-ps-print-message-function'
     `vm-ps-print-message-font-size'
     `vm-ps-print-each-message-separater'
     `vm-ps-print-each-message-left-header'
     `vm-ps-print-each-message-right-header'
     `vm-ps-print-each-message-summary-format'
for customization of the output." t nil)

(autoload 'vm-ps-print-message-presentation "vm-ps-print" "\
PS-Print the currently presented message.
When called with a numeric prefix argument, prompts the user for the
name of a file to save the PostScript image in, instead of sending it
to the printer.

More specifically, the FILENAME argument is treated as follows: if it
is nil, send the image to the printer.  If FILENAME is a string, save
the PostScript image in a file with that name.  If FILENAME is a
number, prompt the user for the name of the file to save in.

See: `vm-ps-print-message-function'
     `vm-ps-print-message-font-size'
     `vm-ps-print-each-message-separater'
     `vm-ps-print-each-message-left-header'
     `vm-ps-print-each-message-right-header'
     `vm-ps-print-each-message-summary-format'
for customization of the output." t nil)

(autoload 'vm-ps-print-message-fix-menu "vm-ps-print" "\
Fix VM-menu MENU.
If EACH it t, then replace `vm-print-message' by
'vm-ps-print-each-message', otherwise by `vm-ps-print-message'." nil nil)

(autoload 'vm-ps-print-message-infect-vm "vm-ps-print" "\
Call this function to hook the ps-printing functions into VM.
Arranges that the usual VM printing commands in menus and the
toolbar use `vm-ps-print-message' or `vm-ps-print-each-message'
\(when EACH is t) instead of `vm-print-message'." t nil)

(autoload 'vm-ps-print-marked "vm-ps-print" "\
Postscript print all marked emails in mail Summary. If no messages marked,
print just the current message.
Optionally write postscript output to FILENAME (default is to spool
to printer). 
Optionally force SEPERATE printing of each message by setting to 't'. 
Optionally also print NUP pages per sheet.
Optionally also print in COLOR by setting to non-nil.

Note when run interactively setting a positive prefix number prints
NUP pages per sheet to  the printer, while negative number prints NUP
pages per sheet to queried FILENAME. No prefix prints 1 page per sheet
to printer while prefix without numerical argument simply queries for
filename and formats 1 page per sheet. (JJK)" t nil)

;;;***

;;;### (autoloads (vm-mail-mode-remove-tm-hooks vm-preview-composition vm-send-mime-digest-other-frame vm-send-rfc1153-digest-other-frame vm-send-rfc934-digest-other-frame vm-send-digest-other-frame vm-resend-bounced-message-other-frame vm-resend-message-other-frame vm-forward-message-other-frame vm-forward-message-all-headers-other-frame vm-followup-include-text-other-frame vm-followup-other-frame vm-reply-include-text-other-frame vm-reply-other-frame vm-mail-internal vm-mail-to-mailto-url vm-continue-composing-message vm-send-mime-digest vm-send-rfc1153-digest vm-send-rfc934-digest vm-send-digest vm-resend-message vm-resend-bounced-message vm-forward-message vm-forward-message-all-headers vm-followup-include-text vm-followup vm-reply-include-text vm-reply vm-mail-mode-remove-header vm-mail-mode-get-header-contents vm-mail-send vm-mail-send-and-exit vm-yank-message vm-yank-message-other-folder vm-mail-yank-default vm-do-reply) "vm-reply" "lisp/vm-reply.el")

(autoload 'vm-do-reply "vm-reply" nil nil nil)

(autoload 'vm-mail-yank-default "vm-reply" nil nil nil)

(autoload 'vm-yank-message-other-folder "vm-reply" "\
Like vm-yank-message except the message is yanked from a folder other
than the one that spawned the current Mail mode buffer.  The name of the
folder is read from the minibuffer.

Don't call this function from a program." t nil)

(autoload 'vm-yank-message "vm-reply" "\
Yank message number N into the current buffer at point.
When called interactively N is always read from the minibuffer.  When
called non-interactively the first argument is expected to be a
message struct.

This command is meant to be used in VM created Mail mode buffers; the
yanked message comes from the mail buffer containing the message you
are replying to, forwarding, or invoked VM's mail command from.

All message headers are yanked along with the text.  Point is
left before the inserted text, the mark after.  Any hook
functions bound to `mail-citation-hook' are run, after inserting
the text and setting point and mark.  For backward compatibility,
if mail-citation-hook is set to nil, `mail-yank-hooks' is run
instead.

If mail-citation-hook and mail-yank-hooks are both nil, this
default action is taken: the yanked headers are trimmed as
specified by `vm-included-text-headers' and
`vm-included-text-discard-header-regexp', and the value of
`vm-included-text-prefix' is prepended to every yanked line." t nil)

(autoload 'vm-mail-send-and-exit "vm-reply" "\
Send message and maybe delete the composition buffer.
The value of `vm-keep-sent-mesages' determines whether the composition buffer
is deleted.  If the composition is a reply to a message in a currently visited
folder, that message is marked as having been replied to." t nil)

(autoload 'vm-mail-send "vm-reply" "\
Just like mail-send except that VM flags the appropriate message(s)
as replied to, forwarded, etc, if appropriate." t nil)

(autoload 'vm-mail-mode-get-header-contents "vm-reply" nil nil nil)

(autoload 'vm-mail-mode-remove-header "vm-reply" nil nil nil)

(autoload 'vm-reply "vm-reply" "\
Reply to the sender of the current message.
Numeric prefix argument N means to reply to the current message plus the
next N-1 messages.  A negative N means reply to the current message and
the previous N-1 messages.

If invoked on marked messages (via vm-next-command-uses-marks),
all marked messages will be replied to.

You will be placed into a standard Emacs Mail mode buffer to compose and
send your message.  See the documentation for the function `mail' for
more info.

Note that the normal binding of C-c C-y in the reply buffer is
automatically changed to vm-yank-message during a reply.  This
allows you to yank any message from the current folder into a
reply.

Normal VM commands may be accessed in the reply buffer by prefixing them
with C-c C-v." t nil)

(autoload 'vm-reply-include-text "vm-reply" "\
Reply to the sender (only) of the current message and include text
from the message.  See the documentation for function vm-reply for details." t nil)

(autoload 'vm-followup "vm-reply" "\
Reply to all recipients of the current message.
See the documentation for the function vm-reply for details." t nil)

(autoload 'vm-followup-include-text "vm-reply" "\
Reply to all recipients of the current message and include text from
the message.  See the documentation for the function vm-reply for details." t nil)

(autoload 'vm-forward-message-all-headers "vm-reply" "\
Like vm-forward-message but always forwards all the headers." t nil)

(autoload 'vm-forward-message "vm-reply" "\
Forward the current message to one or more recipients.
You will be placed in a Mail mode buffer as you would with a
reply, but you must fill in the To: header and perhaps the
Subject: header manually." t nil)

(autoload 'vm-resend-bounced-message "vm-reply" "\
Extract the original text from a bounced message and resend it.
You will be placed in a Mail mode buffer with the extracted message and
you can change the recipient address before resending the message." t nil)

(autoload 'vm-resend-message "vm-reply" "\
Resend the current message to someone else.
The current message will be copied to a Mail mode buffer and you
can edit the message and send it as usual.

NOTE: since you are doing a resend, a Resent-To header is provided
for you to fill in the new recipient list.  If you don't fill in
this header, what happens when you send the message is undefined.
You may also create a Resent-Cc header." t nil)

(autoload 'vm-send-digest "vm-reply" "\
Send a digest of all messages in the current folder to recipients.
The type of the digest is specified by the variable vm-digest-send-type.
You will be placed in a Mail mode buffer as is usual with replies, but you
must fill in the To: and Subject: headers manually.

Prefix arg means to insert a list of preamble lines at the beginning of
the digest.  One line is generated for each message being digestified.
The variable vm-digest-preamble-format determines the format of the
preamble lines.

If invoked on marked messages (via vm-next-command-uses-marks),
only marked messages will be put into the digest." t nil)

(autoload 'vm-send-rfc934-digest "vm-reply" "\
Like vm-send-digest but always sends an RFC 934 digest." t nil)

(autoload 'vm-send-rfc1153-digest "vm-reply" "\
Like vm-send-digest but always sends an RFC 1153 digest." t nil)

(autoload 'vm-send-mime-digest "vm-reply" "\
Like vm-send-digest but always sends an MIME (multipart/digest) digest." t nil)

(autoload 'vm-continue-composing-message "vm-reply" "\
Find and select the most recently used mail composition buffer.
If the selected buffer is already a Mail mode buffer then it is
buried before beginning the search.  Non Mail mode buffers and
unmodified Mail buffers are skipped.  Prefix arg means unmodified
Mail mode buffers are not skipped.  If no suitable buffer is
found, the current buffer remains selected." t nil)

(autoload 'vm-mail-to-mailto-url "vm-reply" nil nil nil)

(autoload 'vm-mail-internal "vm-reply" "\
Create a message buffer and set it up according to args.
Fills in the headers as given by the arguments.
Binds the `vm-mail-mode-map' and hooks" nil nil)

(autoload 'vm-reply-other-frame "vm-reply" "\
Like vm-reply, but run in a newly created frame." t nil)

(autoload 'vm-reply-include-text-other-frame "vm-reply" "\
Like vm-reply-include-text, but run in a newly created frame." t nil)

(autoload 'vm-followup-other-frame "vm-reply" "\
Like vm-followup, but run in a newly created frame." t nil)

(autoload 'vm-followup-include-text-other-frame "vm-reply" "\
Like vm-followup-include-text, but run in a newly created frame." t nil)

(autoload 'vm-forward-message-all-headers-other-frame "vm-reply" "\
Like vm-forward-message-all-headers, but run in a newly created frame." t nil)

(autoload 'vm-forward-message-other-frame "vm-reply" "\
Like vm-forward-message, but run in a newly created frame." t nil)

(autoload 'vm-resend-message-other-frame "vm-reply" "\
Like vm-resend-message, but run in a newly created frame." t nil)

(autoload 'vm-resend-bounced-message-other-frame "vm-reply" "\
Like vm-resend-bounced-message, but run in a newly created frame." t nil)

(autoload 'vm-send-digest-other-frame "vm-reply" "\
Like vm-send-digest, but run in a newly created frame." t nil)

(autoload 'vm-send-rfc934-digest-other-frame "vm-reply" "\
Like vm-send-rfc934-digest, but run in a newly created frame." t nil)

(autoload 'vm-send-rfc1153-digest-other-frame "vm-reply" "\
Like vm-send-rfc1153-digest, but run in a newly created frame." t nil)

(autoload 'vm-send-mime-digest-other-frame "vm-reply" "\
Like vm-send-mime-digest, but run in a newly created frame." t nil)

(autoload 'vm-preview-composition "vm-reply" "\
Show how the current composition buffer might be displayed
in a MIME-aware mail reader.  VM copies and encodes the current
mail composition buffer and displays it as a mail folder.
Type `q' to quit this temp folder and return to composing your
message." t nil)

(autoload 'vm-mail-mode-remove-tm-hooks "vm-reply" nil nil nil)

;;;***

;;;### (autoloads (vm-delete-message-action vm-mail-mode-comment-region vm-install-rf-faces vm-assimilate-outlook-message vm-mime-display-internal-multipart/mixed vm-save-message-preview vm-get-all-new-mail vm-save-everything vm-mail-mode-elide-reply-region vm-mail-mode-install-open-line vm-delete-quit vm-summary-function-A vm-summary-function-S vm-assimilate-html-message vm-shrunken-headers vm-shrunken-headers-toggle-this vm-shrunken-headers-toggle-this-widget vm-shrunken-headers-toggle-this-mouse vm-shrunken-headers-toggle vm-mime-encode-headers vm-mail-check-for-empty-subject vm-mail-check-recipients vm-mime-save-all-attachments vm-mime-delete-all-attachments vm-mime-auto-save-all-attachments-delete-external vm-mime-auto-save-all-attachments vm-mime-attach-files-in-directory vm-mime-display-button-message/external-body vm-switch-to-folder vm-fill-paragraphs-containing-long-lines-by-longlines vm-fill-paragraphs-containing-long-lines-faster vm-unfill-paragraphs-containing-long-lines-faster vm-fill-paragraphs-containing-long-lines-toggle vm-fill-long-lines-in-reply vm-do-fcc-before-mime-encode vm-followup-include-presentation vm-reply-include-presentation vm-rfaddons-infect-vm) "vm-rfaddons" "lisp/vm-rfaddons.el")

(autoload 'vm-rfaddons-infect-vm "vm-rfaddons" "\
This function will setup the key bindings, advices and hooks
necessary to use all the function of vm-rfaddons.el!

SIT-FOR specifies the number of seconds to display the infection message!
The OPTION-LIST can be use to select individual option.
The EXCLUDE-OPTION-LIST can be use to exclude individual option.

The following options are possible.

`general' options:
 - rf-faces: change some faces

`vm-mail-mode' options:
 - attach-save-files: bind [C-c C-a] to `vm-mime-attach-files-in-directory' 
 - check-recipients: add `vm-mail-check-recipients' to `mail-send-hook' in
   order to check if the recipients headers are correctly.
 - encode-headers: add `vm-mime-encode-headers' to `mail-send-hook' in
   order to encode the headers before sending.
 - fake-date: if enabled allows you to fake the date of an outgoing message.

`vm-mode' options:
 - save-all-attachments: in vm-mail-mode and [C-c C-s] to the function
   `vm-mime-save-all-attachments' 
 - shrunken-headers: enable shrunken-headers by advising several functions 
 - take-action-on-attachment: bind [.] to `vm-mime-take-action-on-attachment'

Other EXPERIMENTAL options:
 - auto-save-all-attachments: add `vm-mime-auto-save-all-attachments' to
   `vm-select-new-message-hook' for automatic saving of attachments and define
   an advice for `vm-set-deleted-flag-of' in order to automatically delete
   the files corresponding to MIME objects of type message/external-body when
   deleting the message.
 - return-receipt-to

If you want to use only a subset of the options then call
`vm-rfaddons-infect-vm' like this:
        (vm-rfaddons-infect-vm 2 '(general vm-mail-mode shrunken-headers)
                                 '(fake-date))
This will enable all `general' and `vm-mail-mode' options plus the
`shrunken-headers' option, but it will exclude the `fake-date' option of the
`vm-mail-mode' options.

or do the binding and advising on your own." t nil)

(autoload 'vm-reply-include-presentation "vm-rfaddons" "\
Include presentation instead of text.
This does only work with my modified VM, i.e. a hacked `vm-yank-message'." t nil)

(autoload 'vm-followup-include-presentation "vm-rfaddons" "\
Include presentation instead of text.
This does not work when replying to multiple messages." t nil)

(autoload 'vm-do-fcc-before-mime-encode "vm-rfaddons" "\
The name says it all.
Sometimes you may want to save a message unencoded, specifically not to waste
storage for attachments which are stored on disk anyway." t nil)

(autoload 'vm-fill-long-lines-in-reply "vm-rfaddons" nil t nil)

(autoload 'vm-fill-paragraphs-containing-long-lines-toggle "vm-rfaddons" nil t nil)

(autoload 'vm-unfill-paragraphs-containing-long-lines-faster "vm-rfaddons" "\
Sometimes filling long lines is the wrong thing!
Call this function, if you want to see the message unfilled." t nil)

(autoload 'vm-fill-paragraphs-containing-long-lines-faster "vm-rfaddons" nil nil nil)

(autoload 'vm-fill-paragraphs-containing-long-lines-by-longlines "vm-rfaddons" "\
Uses `longlines.el' for filling." nil nil)

(autoload 'vm-switch-to-folder "vm-rfaddons" "\
Switch to another opened VM folder and rearrange windows as with a scroll." t nil)

(autoload 'vm-mime-display-button-message/external-body "vm-rfaddons" "\
Return a button usable for viewing message/external-body MIME parts.
When you apply `vm-mime-send-body-to-file' with `vm-mime-delete-after-saving'
set to t one will get theses message/external-body parts which point
to the external file.
In order to view these we search for the right viewer hopefully listed
in `vm-mime-external-content-types-alist' and invoke it as it would
have happened before saving.  Otherwise we display the contents as text/plain.
Probably we should be more clever here in order to fake a layout if internal
displaying is possible ...

But nevertheless this allows for keeping folders smaller without
loosing basic functionality when using `vm-mime-auto-save-all-attachments'." nil nil)

(defcustom vm-mime-all-attachments-directory nil "*Directory to where the attachments should go or come from." :group 'vm-rfaddons :type '(choice (directory :tag "Directory:") (const :tag "Use `vm-mime-attachment-save-directory'" nil)))

(autoload 'vm-mime-attach-files-in-directory "vm-rfaddons" "\
Attach all files in DIRECTORY matching REGEXP.
The optional argument MATCH might specify a regexp matching all files
which should be attached, when empty all files will be attached.

When called with a prefix arg it will do a literal match instead of a regexp
match." t nil)

(autoload 'vm-mime-auto-save-all-attachments "vm-rfaddons" "\
Save all attachments to a subdirectory.
Root directory for saving is `vm-mime-attachment-save-directory'.

You might add this to `vm-select-new-message-hook' in order to automatically
save attachments.

    (add-hook 'vm-select-new-message-hook 'vm-mime-auto-save-all-attachments)
" t nil)

(autoload 'vm-mime-auto-save-all-attachments-delete-external "vm-rfaddons" "\
Deletes the external attachments created by `vm-mime-save-all-attachments'.
You may want to use this function in order to get rid of the external files
when deleting a message.

See the advice in `vm-rfaddons-infect-vm'." t nil)

(autoload 'vm-mime-delete-all-attachments "vm-rfaddons" nil t nil)

(autoload 'vm-mime-save-all-attachments "vm-rfaddons" "\
Save all MIME-attachments to DIRECTORY.
When directory does not exist it will be created." t nil)

(autoload 'vm-mail-check-recipients "vm-rfaddons" "\
Check if the recipients are specifiey correctly.
Actually it checks only if there are any missing commas or the like in the
headers." t nil)

(autoload 'vm-mail-check-for-empty-subject "vm-rfaddons" "\
Check if the subject line is empty and issue an error if so." t nil)

(autoload 'vm-mime-encode-headers "vm-rfaddons" "\
Encodes the headers of a message.

Only the words containing a non 7bit ASCII char are encoded, but not the whole
header as this will cause trouble for the recipients and authors headers.

Whitespace between encoded words is trimmed during decoding and thus those
should be encoded together." t nil)

(autoload 'vm-shrunken-headers-toggle "vm-rfaddons" "\
Toggle display of shrunken headers." t nil)

(autoload 'vm-shrunken-headers-toggle-this-mouse "vm-rfaddons" "\
Toggle display of shrunken headers!" t nil)

(autoload 'vm-shrunken-headers-toggle-this-widget "vm-rfaddons" nil nil nil)

(autoload 'vm-shrunken-headers-toggle-this "vm-rfaddons" "\
Toggle display of shrunken headers!" t nil)

(autoload 'vm-shrunken-headers "vm-rfaddons" "\
Hide or show headers which occupy more than one line.
Well, one might do it more precisely with only some headers,
but it is sufficient for me!

If the optional argument TOGGLE, then hiding is toggled.

The face used for the visible hidden regions is `vm-shrunken-headers-face' and
the keymap used within that region is `vm-shrunken-headers-keymap'." t nil)

(autoload 'vm-assimilate-html-message "vm-rfaddons" "\
Try to assimilate a message which is only in html format.
When called with a prefix argument then it will replace the message
with the PLAIN text version otherwise it will create a text/mixed or
text/alternative message depending on the value of the variable
`vm-assimilate-html-mixed'." t nil)

(autoload 'vm-summary-function-S "vm-rfaddons" "\
Return the size of a message in bytes, kilobytes or megabytes.
You may add this to the summary line by \"%US\".
Argument MSG is a message pointer." nil nil)

(autoload 'vm-summary-function-A "vm-rfaddons" "\
Indicate if there are attachments in a message.
The summary displays a `vm-summary-attachment-indicator', wich is a $ by
default.  In order to get this working, add an \"%1UA\" to your
`vm-summary-format' and call `vm-fix-my-summary!!!'.

As an sideeffect a label can be added to new messages.  Setting 
`vm-summary-attachment-label' to a string (the label) enables this.
If you just want the label, then set `vm-summary-attachment-indicator' to nil
and add an \"%0UA\" to your `vm-summary-format'." nil nil)

(autoload 'vm-delete-quit "vm-rfaddons" "\
Delete mails and quit.  Expunge only if it's not the primary inbox!" t nil)

(autoload 'vm-mail-mode-install-open-line "vm-rfaddons" "\
Install the open-line hooks for `vm-mail-mode'.
Add this to `vm-mail-mode-hook'." nil nil)

(autoload 'vm-mail-mode-elide-reply-region "vm-rfaddons" "\
Replace marked region or current line with `vm-mail-elide-reply-region'.
B and E are the beginning and end of the marked region or the current line." t nil)

(autoload 'vm-save-everything "vm-rfaddons" "\
Save all VM folder buffers, BBDB and newsrc if GNUS is started." t nil)

(autoload 'vm-get-all-new-mail "vm-rfaddons" "\
Get mail for all opened VM folders." t nil)

(autoload 'vm-save-message-preview "vm-rfaddons" "\
Save preview of a message in FILE.
It saves the decoded message and not the raw message like `vm-save-message'!" t nil)

(autoload 'vm-mime-display-internal-multipart/mixed "vm-rfaddons" "\
A replacement for VMs default function adding separators.
LAYOUT specifies the layout." nil nil)

(autoload 'vm-assimilate-outlook-message "vm-rfaddons" "\
Assimilate a message which has been forwarded by MS Outlook.
You will need vm-pine.el in order to get this work." t nil)

(autoload 'vm-install-rf-faces "vm-rfaddons" nil nil nil)

(autoload 'vm-mail-mode-comment-region "vm-rfaddons" "\
Comment or uncomment each line in the region BEG to END.
With just a non-nil prefix ARG, uncomment each line in region.
Numeric prefix arg ARG means use ARG comment characters.
If ARG is negative, delete that many comment characters instead.
Comments are terminated on each line, even for syntax in which newline does
not end the comment.  Blank lines do not get comments." t nil)

(autoload 'vm-delete-message-action "vm-rfaddons" "\
Delete current message and perform some action after it, e.g. move to next.
Call it with a prefix ARG to change the action." t nil)

;;;***

;;;### (autoloads (vm-save-message-to-imap-folder vm-print-message vm-pipe-messages-to-command-discard-output vm-pipe-messages-to-command vm-pipe-message-to-command-discard-output vm-pipe-message-to-command vm-save-message-sans-headers vm-save-message-to-local-folder vm-save-message vm-auto-archive-messages vm-auto-select-folder vm-match-data) "vm-save" "lisp/vm-save.el")

(autoload 'vm-match-data "vm-save" nil nil nil)

(autoload 'vm-auto-select-folder "vm-save" nil nil nil)

(autoload 'vm-auto-archive-messages "vm-save" "\
Save all unfiled messages that auto-match a folder via
vm-auto-folder-alist to their appropriate folders.  Messages that
are flagged for deletion are not saved.

Prefix arg means to ask user for confirmation before saving each message.

When invoked on marked messages (via vm-next-command-uses-marks),
only marked messages are checked against vm-auto-folder-alist.

The saved messages are flagged as `filed'." t nil)

(autoload 'vm-save-message "vm-save" "\
Save the current message.  This may be done either by saving it
to an IMAP folder or by saving it to a local filesystem folder.
Which is done is controlled by the type of the current vm-folder
buffer and the variable `vm-imap-save-to-server'." t nil)

(autoload 'vm-save-message-to-local-folder "vm-save" "\
Save the current message to a mail folder.
If the folder already exists, the message will be appended to it.

Prefix arg COUNT means save this message and the next COUNT-1
messages.  A negative COUNT means save this message and the
previous COUNT-1 messages.

When invoked on marked messages (via vm-next-command-uses-marks),
all marked messages in the current folder are saved; other messages are
ignored.

The saved messages are flagged as `filed'." t nil)

(autoload 'vm-save-message-sans-headers "vm-save" "\
Save the current message to a file, without its header section.
If the file already exists, the message body will be appended to it.
Prefix arg COUNT means save the next COUNT message bodiess.  A
negative COUNT means save the previous COUNT bodies.

When invoked on marked messages (via vm-next-command-uses-marks),
only the next COUNT marked messages are saved; other intervening
messages are ignored.

The saved messages are flagged as `written'.

This command should NOT be used to save message to mail folders; use
vm-save-message instead (normally bound to `s')." t nil)

(autoload 'vm-pipe-message-to-command "vm-save" "\
Runs a shell command with contents from the current message as input.
By default, the entire message is used.
With one \\[universal-argument] the text portion of the message is used.
With two \\[universal-argument]'s the header portion of the message is used.
With three \\[universal-argument]'s the visible header portion of the message
plus the text portion is used.

When invoked on marked messages (via vm-next-command-uses-marks),
each marked message is successively piped to the shell command,
one message per command invocation.

Output, if any, is displayed.  The message is not altered." t nil)

(autoload 'vm-pipe-message-to-command-discard-output "vm-save" "\
Run a shell command with contents from the current message as input.
This function is like `vm-pipe-message-to-command', but will not display the
output of the command." t nil)

(autoload 'vm-pipe-messages-to-command "vm-save" "\
Run a shell command with contents from messages as input.

Similar to `vm-pipe-message-to-command', but it will call process
just once and pipe all messages to it.  For bulk operations this
is much faster than calling the command on each message.  This is
more like saving to a pipe.

Before a message it will insert `vm-pipe-messages-to-command-start'
and after a message `vm-pipe-messages-to-command-end'.

Output, if any, is displayed unless DISCARD-OUTPUT is t.

If NO-WAIT is t, then do not wait for process to finish, if it is
a function then call it with the COMMAND and OUTPUT-BUFFER as
arguments after the command finished." t nil)

(autoload 'vm-pipe-messages-to-command-discard-output "vm-save" "\
Runs a shell command with contents from the current message as input.
This function is like `vm-pipe-messages-to-command', but will not display the
output of the command." t nil)

(autoload 'vm-print-message "vm-save" "\
Print the current message
Prefix arg N means print the current message and the next N - 1 messages.
Prefix arg -N means print the current message and the previous N - 1 messages.

The variable `vm-print-command' controls what command is run to
print the message, and `vm-print-command-switches' is a list of switches
to pass to the command.

When invoked on marked messages (via vm-next-command-uses-marks),
each marked message is printed, one message per vm-print-command invocation.

Output, if any, is displayed.  The message is not altered." t nil)

(autoload 'vm-save-message-to-imap-folder "vm-save" "\
Save the current message to an IMAP folder.
Prefix arg COUNT means save this message and the next COUNT-1
messages.  A negative COUNT means save this message and the
previous COUNT-1 messages.

When invoked on marked messages (via vm-next-command-uses-marks),
all marked messages in the current folder are saved; other messages are
ignored.

The saved messages are flagged as `filed'." t nil)

;;;***

;;;### (autoloads (vm-isearch-backward vm-isearch-forward) "vm-search" "lisp/vm-search.el")

(autoload 'vm-isearch-forward "vm-search" "\
Incrementally search forward through the current folder's messages.
Usage is identical to the standard Emacs incremental search.
When the search terminates the message containing point will be selected.

If the variable vm-search-using-regexps is non-nil, regular expressions
are understood; nil means the search will be for the input string taken
literally.  Specifying a prefix ARG interactively toggles the value of
vm-search-using-regexps for this search." t nil)

(autoload 'vm-isearch-backward "vm-search" "\
Incrementally search backward through the current folder's messages.
Usage is identical to the standard Emacs incremental search.
When the search terminates the message containing point will be selected.

If the variable vm-search-using-regexps is non-nil, regular expressions
are understood; nil means the search will be for the input string taken
literally.  Specifying a prefix ARG interactively toggles the value of
vm-search-using-regexps for this search." t nil)

;;;***

;;;### (autoloads (vm-sort-compare-physical-order-r vm-sort-compare-physical-order vm-sort-compare-xxxxxx vm-sort-messages vm-so-sortable-subject vm-so-sortable-datestring vm-move-message-backward-physically vm-move-message-forward-physically vm-move-message-backward vm-move-message-forward) "vm-sort" "lisp/vm-sort.el")

(autoload 'vm-move-message-forward "vm-sort" "\
Move a message forward in a VM folder.
Prefix arg COUNT causes the current message to be moved COUNT messages forward.
A negative COUNT causes movement to be backward instead of forward.
COUNT defaults to 1.  The current message remains selected after being
moved.

If vm-move-messages-physically is non-nil, the physical copy of
the message in the folder is moved.  A nil value means just
change the presentation order and leave the physical order of
the folder undisturbed." t nil)

(autoload 'vm-move-message-backward "vm-sort" "\
Move a message backward in a VM folder.
Prefix arg COUNT causes the current message to be moved COUNT
messages backward.  A negative COUNT causes movement to be
forward instead of backward.  COUNT defaults to 1.  The current
message remains selected after being moved.

If vm-move-messages-physically is non-nil, the physical copy of
the message in the folder is moved.  A nil value means just
change the presentation order and leave the physical order of
the folder undisturbed." t nil)

(autoload 'vm-move-message-forward-physically "vm-sort" "\
Like vm-move-message-forward but always move the message physically." t nil)

(autoload 'vm-move-message-backward-physically "vm-sort" "\
Like vm-move-message-backward but always move the message physically." t nil)

(autoload 'vm-so-sortable-datestring "vm-sort" nil nil nil)

(autoload 'vm-so-sortable-subject "vm-sort" nil nil nil)

(autoload 'vm-sort-messages "vm-sort" "\
Sort message in a folder by the specified KEYS.
You may sort by more than one particular message key.  If
messages compare equal by the first key, the second key will be
compared and so on.  When called interactively the keys will be
read from the minibuffer.  Valid keys are

\"date\"		\"reversed-date\"
\"author\"		\"reversed-author\"
\"full-name\"		\"reversed-full-name\"
\"subject\"		\"reversed-subject\"
\"recipients\"		\"reversed-recipients\"
\"line-count\"		\"reversed-line-count\"
\"byte-count\"		\"reversed-byte-count\"
\"physical-order\"	\"reversed-physical-order\"
\"spam-score\"		\"reversed-spam-score\"

Optional second arg (prefix arg interactively) means the sort
should change the physical order of the messages in the folder.
Normally VM changes presentation order only, leaving the
folder in the order in which the messages arrived." t nil)

(autoload 'vm-sort-compare-xxxxxx "vm-sort" nil nil nil)

(autoload 'vm-sort-compare-physical-order "vm-sort" nil nil nil)

(autoload 'vm-sort-compare-physical-order-r "vm-sort" nil nil nil)

;;;***

;;;### (autoloads (vm-summary-faces-mode vm-summary-faces-add vm-summary-faces-hide) "vm-summary-faces" "lisp/vm-summary-faces.el")

(autoload 'vm-summary-faces-hide "vm-summary-faces" "\
Toggle visibility of messages with FACE.
When called with a prefix arg prompt for the face." t nil)

(autoload 'vm-summary-faces-add "vm-summary-faces" "\
Add a face to a summary entry according to `vm-summary-faces-alist'." nil nil)

(autoload 'vm-summary-faces-mode "vm-summary-faces" "\
Toggle `vm-summary-faces-mode'.
Remove/add the `vm-summary-fontify-buffer' hook from the hook variable
`vm-summary-mode-hook' and when in a summary buffer, then toggle the
`font-lock-mode'." t nil)

;;;***

;;;### (autoloads (vm-fix-my-summary!!! vm-summarize-other-frame vm-summarize) "vm-summary" "lisp/vm-summary.el")

(autoload 'vm-summarize "vm-summary" "\
Summarize the contents of the folder in a summary buffer.
The format is as described by the variable `vm-summary-format'.  Generally
one line per message is most pleasing to the eye but this is not
mandatory." t nil)

(autoload 'vm-summarize-other-frame "vm-summary" "\
Like vm-summarize, but run in a newly created frame." t nil)

(autoload 'vm-fix-my-summary!!! "vm-summary" "\
Rebuilts the summary.
Call this function if you made changes to `vm-summary-format'." t nil)

;;;***

;;;### (autoloads (vm-th-thread-list vm-th-thread-indentation vm-unthread-message vm-build-thread-lists vm-build-threads vm-toggle-threads-display) "vm-thread" "lisp/vm-thread.el")

(autoload 'vm-toggle-threads-display "vm-thread" "\
Toggle the threads display on and off.
When the threads display is on, the folder will be sorted by
thread and thread indentation (via the %I summary format specifier)
will be visible." t nil)

(autoload 'vm-build-threads "vm-thread" nil nil nil)

(autoload 'vm-build-thread-lists "vm-thread" nil nil nil)

(autoload 'vm-unthread-message "vm-thread" nil nil nil)

(autoload 'vm-th-thread-indentation "vm-thread" nil nil nil)

(autoload 'vm-th-thread-list "vm-thread" nil nil nil)

;;;***

;;;### (autoloads (vm-toolbar-autofile-message vm-toolbar-can-autofile-p vm-toolbar-delete/undelete-message vm-toolbar-helper-command) "vm-toolbar" "lisp/vm-toolbar.el")

(autoload 'vm-toolbar-helper-command "vm-toolbar" nil t nil)

(autoload 'vm-toolbar-delete/undelete-message "vm-toolbar" nil t nil)

(autoload 'vm-toolbar-can-autofile-p "vm-toolbar" nil t nil)

(autoload 'vm-toolbar-autofile-message "vm-toolbar" nil t nil)

;;;***

;;;### (autoloads (vm-delete-message-labels vm-add-existing-message-labels vm-add-message-labels vm-set-message-attributes vm-undo) "vm-undo" "lisp/vm-undo.el")

(autoload 'vm-undo "vm-undo" "\
Undo last change to message attributes in the current folder.
Consecutive invocations of this command cause sequentially earlier
changes to be undone.  After an intervening command between undos,
the undos themselves become undoable." t nil)

(autoload 'vm-set-message-attributes "vm-undo" "\
Set message attributes.
Use this command to change attributes like `deleted' or
`replied'.  Interactively you will be prompted for the attributes
to be changed, and only the attributes you enter will be altered.
You can use completion to expand the attribute names.  The names
should be entered as a space separated list.

A numeric prefix argument COUNT causes the current message and
the next COUNT-1 message to have their attributes altered.  A
negative COUNT arg causes the current message and the previous
COUNT-1 messages to be altered.  COUNT defaults to one." t nil)

(autoload 'vm-add-message-labels "vm-undo" "\
Attach some labels to a message.
These are arbitrary user-defined labels, not to be confused with
message attributes like `new' and `deleted'.  Interactively you
will be prompted for the labels to be added.  You can use
completion to expand the label names, with the completion list
being all the labels that have ever been used in this folder.
The names should be entered as a space separated list.  Label
names are compared case-insensitively.

A numeric prefix argument COUNT causes the current message and
the next COUNT-1 message to have the labels added.  A
negative COUNT arg causes the current message and the previous
COUNT-1 messages to be altered.  COUNT defaults to one." t nil)

(autoload 'vm-add-existing-message-labels "vm-undo" "\
Attach some already existing labels to a message.
Only labels that are currently attached to some message in this
folder or labels that have previously been attached to messages
in this folder will be added.  Other labels will be silently
ignored.

These are arbitrary user-defined labels, not to be confused with
message attributes like `new' and `deleted'.  Interactively you
will be prompted for the labels to be added.  You can use
completion to expand the label names, with the completion list
being all the labels that have ever been used in this folder.
The names should be entered as a space separated list.  Label
names are compared case-insensitively.

A numeric prefix argument COUNT causes the current message and
the next COUNT-1 messages to have the labels added.  A
negative COUNT arg causes the current message and the previous
COUNT-1 messages to be altered.  COUNT defaults to one." t nil)

(autoload 'vm-delete-message-labels "vm-undo" "\
Delete some labels from a message.
These are arbitrary user-defined labels, not to be confused with
message attributes like `new' and `deleted'.  Interactively you
will be prompted for the labels to be deleted.  You can use
completion to expand the label names, with the completion list
being all the labels that have ever been used in this folder.
The names should be entered as a space separated list.  Label
names are compared case-insensitively.

A numeric prefix argument COUNT causes the current message and
the next COUNT-1 message to have the labels deleted.  A
negative COUNT arg causes the current message and the previous
COUNT-1 messages to be altered.  COUNT defaults to one." t nil)

;;;***

;;;### (autoloads (vm-mime-display-internal-text/x-vcard) "vm-vcard" "lisp/vm-vcard.el")

(defvar vm-vcard-format-function nil "\
*Function to use for formatting vcards; if nil, use default.")

(defvar vm-vcard-filter nil "\
*Filter function to use for formatting vcards; if nil, use default.")

(autoload 'vm-mime-display-internal-text/x-vcard "vm-vcard" nil nil nil)

;;;***

;;;### (autoloads (vm-make-virtual-copy vm-virtual-get-new-mail vm-virtual-save-folder vm-virtual-quit vm-read-virtual-selector vm-virtual-help vm-create-virtual-folder-same-author vm-create-virtual-folder-same-subject vm-apply-virtual-folder vm-create-virtual-folder vm-build-virtual-message-list) "vm-virtual" "lisp/vm-virtual.el")

(autoload 'vm-build-virtual-message-list "vm-virtual" "\
Builds a list of messages matching the virtual folder definition
stored in the variable vm-virtual-folder-definition.

If the NEW-MESSAGES argument is nil, the message list is
derived from the folders listed in the virtual folder
definition and selected by the various selectors.  The
resulting message list is assigned to vm-message-list unless
DONT-FINALIZE is non-nil.

If NEW-MESSAGES is non-nil then it is a list of messages to
be tried against the selector parts of the virtual folder
definition.  Matching messages are added to vm-message-list,
instead of replacing it.

The messages in the NEW-MESSAGES list, if any, must all be in the
same real folder.

The list of matching virtual messages is returned.

If DONT-FINALIZE is nil, in addition to vm-message-list being
set, the virtual messages are added to the virtual message
lists of their real messages, the current buffer is added to
vm-virtual-buffers list of each real folder buffer represented
in the virtual list, and vm-real-buffers is set to a list of
all the real folder buffers involved." nil nil)

(autoload 'vm-create-virtual-folder "vm-virtual" "\
Create a new virtual folder from messages in the current folder.
The messages will be chosen by applying the selector you specify,
which is normally read from the minibuffer.

Prefix arg means the new virtual folder should be visited read only." t nil)

(autoload 'vm-apply-virtual-folder "vm-virtual" "\
Apply the selectors of a named virtual folder to the current folder
and create a virtual folder containing the selected messages.

Prefix arg means the new virtual folder should be visited read only." t nil)

(autoload 'vm-create-virtual-folder-same-subject "vm-virtual" nil t nil)

(autoload 'vm-create-virtual-folder-same-author "vm-virtual" nil t nil)

(autoload 'vm-virtual-help "vm-virtual" nil t nil)

(autoload 'vm-read-virtual-selector "vm-virtual" nil nil nil)

(autoload 'vm-virtual-quit "vm-virtual" nil nil nil)

(autoload 'vm-virtual-save-folder "vm-virtual" nil nil nil)

(autoload 'vm-virtual-get-new-mail "vm-virtual" nil nil nil)

(autoload 'vm-make-virtual-copy "vm-virtual" nil nil nil)

;;;***

;;;### (autoloads (vm-apply-window-configuration vm-delete-window-configuration vm-save-window-configuration) "vm-window" "lisp/vm-window.el")

(autoload 'vm-save-window-configuration "vm-window" "\
Name and save the current window configuration.
With this command you associate the current window setup with an
action.  Each time you perform this action VM will duplicate this
window setup.

Nearly every VM command can have a window configuration
associated with it.  VM also allows some category configurations,
`startup', `reading-message', `composing-message', `editing-message',
`marking-message' and `searching-message' for the commands that
do these things.  There is also a `default' configuration that VM
will use if no other configuration is applicable.  Command
specific configurations are searched for first, then the category
configurations and then the default configuration.  The first
configuration found is the one that is applied.

The value of vm-mutable-windows must be non-nil for VM to use
window configurations." t nil)

(autoload 'vm-delete-window-configuration "vm-window" "\
Delete the configuration saved for a particular action.
This action will no longer have an associated window configuration.
The action will be read from the minibuffer." t nil)

(autoload 'vm-apply-window-configuration "vm-window" "\
Change the current window configuration to be one
associated with a particular action.  The action will be read
from the minibuffer." t nil)

;;;***

;;;### (autoloads (vm-submit-bug-report vm-compose-mail vm-folders-summarize vm-mail-other-window vm-mail-other-frame vm-mail vm-visit-virtual-folder-other-window vm-visit-virtual-folder-other-frame vm-visit-virtual-folder vm-visit-imap-folder-other-window vm-visit-imap-folder-other-frame vm-visit-imap-folder vm-visit-pop-folder-other-window vm-visit-pop-folder-other-frame vm-visit-pop-folder vm-visit-folder-other-window vm-visit-folder-other-frame vm-visit-folder vm-mode vm-other-window vm-other-frame vm vm-recover-folder) "vm" "lisp/vm.el")

(autoload 'vm-recover-folder "vm" "\
Recover the autosave file for the current folder." t nil)

(autoload 'vm "vm" "\
Read mail under Emacs.
Optional first arg FOLDER specifies the folder to visit.  It defaults
to the value of vm-primary-inbox.  The folder buffer is put into VM
mode, a major mode for reading mail.

Prefix arg or optional second arg READ-ONLY non-nil indicates
that the folder should be considered read only.  No attribute
changes, message additions or deletions will be allowed in the
visited folder.

Visiting the primary inbox normally causes any contents of the system mailbox to
be moved and appended to the resulting buffer.  You can disable this automatic fetching of mail by setting `vm-auto-get-new-mail' to nil.

All the messages can be read by repeatedly pressing SPC.  Use `n'ext and
`p'revious to move about in the folder.  Messages are marked for
deletion with `d', and saved to another folder with `s'.  Quitting VM
with `q' saves the buffered folder to disk, but does not expunge
deleted messages.  Use `###' to expunge deleted messages.

See the documentation for vm-mode for more information." t nil)

(autoload 'vm-other-frame "vm" "\
Like vm, but run in a newly created frame." t nil)

(autoload 'vm-other-window "vm" "\
Like vm, but run in a different window." t nil)

(autoload 'vm-mode "vm" "\
Major mode for reading mail.

This is VM.

Use M-x vm-submit-bug-report to submit a bug report.

Commands:
\\{vm-mode-map}


Customize VM by setting variables and store them in the file ~/.vm.
" t nil)

(autoload 'vm-visit-folder "vm" "\
Visit a mail file.
VM will parse and present its messages to you in the usual way.

First arg FOLDER specifies the mail file to visit.  When this
command is called interactively the file name is read from the
minibuffer.

Prefix arg or optional second arg READ-ONLY non-nil indicates
that the folder should be considered read only.  No attribute
changes, messages additions or deletions will be allowed in the
visited folder." t nil)

(autoload 'vm-visit-folder-other-frame "vm" "\
Like vm-visit-folder, but run in a newly created frame." t nil)

(autoload 'vm-visit-folder-other-window "vm" "\
Like vm-visit-folder, but run in a different window." t nil)

(autoload 'vm-visit-pop-folder "vm" "\
Visit a POP mailbox.
VM will present its messages to you in the usual way.  Messages
found in the POP mailbox will be downloaded and stored in a local
cache.  If you expunge messages from the cache, the corresponding
messages will be expunged from the POP mailbox.

First arg FOLDER specifies the name of the POP mailbox to visit.
You can only visit mailboxes that are specified in `vm-pop-folder-alist'.
When this command is called interactively the mailbox name is read from the
minibuffer.

Prefix arg or optional second arg READ-ONLY non-nil indicates
that the folder should be considered read only.  No attribute
changes, messages additions or deletions will be allowed in the
visited folder." t nil)

(autoload 'vm-visit-pop-folder-other-frame "vm" "\
Like vm-visit-pop-folder, but run in a newly created frame." t nil)

(autoload 'vm-visit-pop-folder-other-window "vm" "\
Like vm-visit-pop-folder, but run in a different window." t nil)

(autoload 'vm-visit-imap-folder "vm" "\
Visit a IMAP mailbox.
VM will present its messages to you in the usual way.  Messages
found in the IMAP mailbox will be downloaded and stored in a local
cache.  If you expunge messages from the cache, the corresponding
messages will be expunged from the IMAP mailbox.

First arg FOLDER specifies the IMAP mailbox to visit.  You can only
visit mailboxes on servers that are listed in `vm-imap-server-list'.
When this command is called interactively the server and mailbox
names are read from the minibuffer.

Prefix arg or optional second arg READ-ONLY non-nil indicates
that the folder should be considered read only.  No attribute
changes, messages additions or deletions will be allowed in the
visited folder." t nil)

(autoload 'vm-visit-imap-folder-other-frame "vm" "\
Like vm-visit-imap-folder, but run in a newly created frame." t nil)

(autoload 'vm-visit-imap-folder-other-window "vm" "\
Like vm-visit-imap-folder, but run in a different window." t nil)

(autoload 'vm-visit-virtual-folder "vm" nil t nil)

(autoload 'vm-visit-virtual-folder-other-frame "vm" "\
Like vm-visit-virtual-folder, but run in a newly created frame." t nil)

(autoload 'vm-visit-virtual-folder-other-window "vm" "\
Like vm-visit-virtual-folder, but run in a different window." t nil)

(autoload 'vm-mail "vm" "\
Send a mail message from within VM, or from without.
Optional argument TO is a string that should contain a comma separated
recipient list." t nil)

(autoload 'vm-mail-other-frame "vm" "\
Like vm-mail, but run in a newly created frame.
Optional argument TO is a string that should contain a comma separated
recipient list." t nil)

(autoload 'vm-mail-other-window "vm" "\
Like vm-mail, but run in a different window.
Optional argument TO is a string that should contain a comma separated
recipient list." t nil)

(autoload 'vm-folders-summarize "vm" "\
Generate a summary of the folders in your folder directories.
Set `vm-folders-summary-directories' to specify the folder directories.
Press RETURN or click mouse button 2 on an entry in the folders
summary buffer to select a folder." t nil)

(autoload 'vm-compose-mail "vm" nil t nil)

(autoload 'vm-submit-bug-report "vm" "\
Submit a bug report, with pertinent information to the VM bug list." t nil)

(if (fboundp 'define-mail-user-agent) (define-mail-user-agent 'vm-user-agent (function vm-compose-mail) (function vm-mail-send-and-exit) nil nil))

;;;***

(provide 'vm-autoloads)
