;; Light Weight Editor Integration for Sparcworks.
;; "Era on Sparcworks" (EOS)
;;
;; Author: Eduardo Pelegri-Llopart
;;
;; Please send feedback to eduardo.pelegri-llopart@eng.sun.com

;; Provides a "toolbar" buffer based on extents.

(defvar eos::toolbar-buffer "*Eos Toolbar*"
  "name of buffer faking a toolbar")

(defvar eos::xref-map (let ((map (make-sparse-keymap)))
			 (define-key map 'button1 'eos::act-on-xref)
			 (define-key map 'button2 'eos::act-on-xref)
			 map))

(defun eos::face (text face)
  (let ((p (point))
	e)
    (insert text)
    (setq e (make-extent p (point)))
    (set-extent-face e face)
    e))

(defun eos::xref (text xref)
  (let ((e (eos::face text 'bold)))
    (set-extent-property e 'keymap eos::xref-map)
    (set-extent-property e 'highlight t)
    (set-extent-property e 'xref xref)
    e))

(defun eos::act-on-xref (e)
  (interactive "@e")
  (let* ((extent (or (event-glyph e)
 		     (extent-at (event-point e)
				(window-buffer (event-window e))
				'xref)))
	 (xref (extent-property extent 'xref))
	 )
    (cond
     ((eq xref 'cont) (eos::cont))
     ((eq xref 'next) (eos::next))
     ((eq xref 'step) (eos::step))
     ((eq xref 'run) (eos::run))
     ((eq xref 'stop-at) (eos2::stop-at))
     ((eq xref 'stop-in) (eos2::stop-in))
     ((eq xref 'clear-at) (eos2::clear-at))
     ((eq xref 'func) (eos2::func))
     ((eq xref 'cont-to) (eos2::cont-to))
     ((eq xref 'print) (eos2::print))
     ((eq xref 'print*) (eos2::print*))
     )
    ))
  
(defun eos2::stop-at ()
  (interactive)
  (select-screen eos::debugger-screen)
  (eos::dbx-cmd
   (format "stop at \"%s\":%d"
	   (buffer-file-name)
	   (eos::line-at (point)))
   ))

(defun eos2::clear-at ()
  (interactive)
  (select-screen eos::debugger-screen)
  (eos::dbx-cmd
   (format "clear \"%s\":%d"
	   (buffer-file-name)
	   (eos::line-at (point))
   )))

(defun eos2::stop-in ()
  (interactive)
  (select-screen eos::debugger-screen)
  (eos::dbx-cmd
   (format "stop in %s"
	   (buffer-substring (point) (mark)))
   ))

(defun eos2::func ()
  (interactive)
  (select-screen eos::debugger-screen)
  (eos::dbx-cmd
   (format "func %s"
	   (buffer-substring (point) (mark)))
   ))

(defun eos2::cont-to ()
  (interactive)
  (select-screen eos::debugger-screen)
  (eos::dbx-cmd
   (format "stop at \"%s\":%d -temp; cont"
	(buffer-file-name)
	(eos::line-at (point))
	)))

(defun eos2::print () (interactive)
  (select-screen eos::debugger-screen)
  (eos::send-spider-print-msg
   (buffer-substring (point) (mark))))

(defun eos2::print* () (interactive)
  (select-screen eos::debugger-screen)
  (eos::send-spider-print*-msg
   (buffer-substring (point) (mark))))

(defun eos::add-toolbar-buffer ()
  (switch-to-buffer eos::toolbar-buffer)
  (eos::xref "Cont" 'cont)
  (insert "  ") (eos::xref "Next" 'next)
  (insert "  ") (eos::xref "Step" 'step)
  (insert "  ") (eos::xref "Stop-At" 'stop-at)
  (insert "  ") (eos::xref "Stop-In" 'stop-in)
  (insert "  ") (eos::xref "Clear-At" 'clear-at)
  (insert "  ") (eos::xref "Func" 'func)
  (insert "  ") (eos::xref "Cont-To" 'cont-to)
  (beginning-of-line) (center-line)
  (end-of-line) (insert "\n")
  (eos::xref "Run" 'run) (insert "  ")
  (eos::xref "Print" 'print) (insert "  ")
  (eos::xref "Print*" 'print*)
  (beginning-of-line) (center-line)
  )

;; (eos::add-toolbar-buffer)

