/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Alan Carroll (carroll@cs.uiuc.edu)
 *      Modified by: Doug Bogia (bogia@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/*	ws.c: Main file for Biscuit */

/* Main routines for the widget server */
/* $Source: /export/kaplan/stable/sun4.os4.1/cb-2.0/src/data/node125.text,v $ */

static char rcsid[] = "ws.c $Revision: 1.0.1.3 $ $Date: 92/05/08 15:24:52 $ $State: Exp $ $Author: CBmgr $";

/* ------------------------------------------------------------------------- */
#include <stdio.h>
#include "header.h"
#include "getopt.h"
#include "version.h"
#include "cb-defs.h"
#include <signal.h>
#include <Xm/MessageB.h>
/* ------------------------------------------------------------------------ */
/* Global Variables */

int MBLogLevel = 1;

t_mb_connection mbus = NULL;			/* connection to the MBus */

char *host;
int port = DEF_MBUS_PORT;
char *cb_base_domain = NULL;
char *cb_server_domain = NULL;
char *cb_ui_domain = NULL;
char *cb_user = NULL;
char *cb_ws_domain = NULL;
char *connect_message = NULL;

#define APP_NAME	"biscuit"
#define APP_CLASS	"CBServer"

XtAppContext app_context;		/* application context */
Display *dpy;				/* display */
Widget toplevel_widget;		/* anchor widget */
Widget control_panel;			/* the control panel for the WS */
t_generic_widget toplevel_shells = NULL; /* list of top level shells */

Atom xa_cb_hscrollbar;
Atom xa_cb_vscrollbar;
Atom xa_cb_editable;
Atom xa_cb_terminate;
Atom xa_cb_dropchild;
Atom xa_cb_true;
Atom xa_cb_false;
Atom xa_wm_delete_window;

/* class records */
extern struct widget_class_struct ButtonClassRecord;
extern struct widget_class_struct ShellClassRecord;
extern struct widget_class_struct MenuBarClassRecord;
extern struct widget_class_struct MenuClassRecord;
extern struct widget_class_struct FieldClassRecord;
extern struct widget_class_struct BoxClassRecord;
extern struct widget_class_struct ListClassRecord;
extern struct widget_class_struct ContainerClassRecord;
extern struct widget_class_struct AreaClassRecord;
extern struct widget_class_struct PromptClassRecord;
extern struct widget_class_struct TextClassRecord;
extern struct widget_class_struct RadioClassRecord;
extern struct widget_class_struct ToggleClassRecord;
extern struct widget_class_struct ArrayClassRecord;
extern struct widget_class_struct FileClassRecord;
extern struct widget_class_struct OptionClassRecord;
extern struct widget_class_struct LabelClassRecord;
extern struct widget_class_struct SeparatorClassRecord;

/* this is an array of _pointers_ to the class records */
t_widget_class class[] =
{
  &ButtonClassRecord,
  &ShellClassRecord,
  &MenuBarClassRecord,
  &MenuClassRecord,
  &FieldClassRecord,
  &BoxClassRecord,
  &ListClassRecord,
  &ContainerClassRecord,
  &AreaClassRecord,
  &PromptClassRecord,
  &TextClassRecord,
  &RadioClassRecord,
  &ToggleClassRecord,
  &ArrayClassRecord,
  &FileClassRecord,
  &OptionClassRecord,
  &LabelClassRecord,
  &SeparatorClassRecord,
};

#define N_CLASSES (sizeof(class) / sizeof(t_widget_class))

extern void ShellPrepareTransmit();
extern void ShellTerminate();
extern Widget PopupError(), PopupInfo(), PopupMessage(), PopupWarning();
/* ------------------------------------------------------------------------ */
void
Quit(w, stuff, data)
     Widget w;
     caddr_t stuff;
     XmAnyCallbackStruct *data;
{
  t_generic_widget item;

  /* We don't actually care about freeing the memory, but we do need to
   * fire off any closing messages, and reparent any windows from other
   * clients.
   */
  for ( item = toplevel_shells ; NULL != item ; item = item->next )
    item->class->remove(item);

  if (NULL != mbus)
  {
    MBtransmit_Cstring(mbus, "(close)");
    MBClose(mbus);
  }

  XCloseDisplay(XtDisplay(w));
  exit(0);
}
/* ------------------------------------------------------------------------ */
void
ConfirmDialog(w, dialog, data)
     Widget w;
     Widget dialog;
     XmAnyCallbackStruct *data;
{
  XtManageChild(dialog);
}
/* ------------------------------------------------------------------------ */
void
DestroyShells(w, stuff, data)
     Widget w;
     caddr_t stuff;
     XmAnyCallbackStruct *data;
{
  t_generic_widget item = toplevel_shells, next;

  /* Toast all the shells, depend on destroy callbacks to do memory
   * cleanup
   */
  while (NULL != item)
    {
      next = item->next;
      XtDestroyWidget(item->widget);
      item = next;
    }
}
/* ------------------------------------------------------------------------ */
void
SendConnect(w, stuff, data)
     Widget w;
     caddr_t stuff;
     XmAnyCallbackStruct *data;
{
  if (NULL != mbus) MBtransmit_Cstring(mbus, connect_message);
}
/* ------------------------------------------------------------------------ */
void
SendSaveSystem(w, stuff, data)
     Widget w;
     caddr_t stuff;
     XmAnyCallbackStruct *data;
{
  char buf[512];
  if (NULL != mbus)
  {
    sprintf(buf,"(\"CB\" \"%s.%s\" save-system)",
	    cb_server_domain, cb_base_domain);
    MBtransmit_Cstring(mbus,buf);
  }
}
/* ------------------------------------------------------------------------ */
void
SendDisconnect(w, stuff, data)
     Widget w;
     caddr_t stuff;
     XmAnyCallbackStruct *data;
{
  char buf[512];
  if (NULL != mbus)
  {
    sprintf(buf,"(\"CB\" \"%s.%s\" (U-disconnect :user \"%s\"))",
	    cb_server_domain, cb_base_domain,
	    cb_user);
    MBtransmit_Cstring(mbus,buf);
    /* Sending all of this may be redundant if we are shutting down because
     * of this message.  However, since the user can punch a button to
     * call this routine, we want to be safe.
     */
    sprintf(buf,"(\"shutdown\" \"%s.%s.%s\" (shutdown))",
	    cb_user, cb_ui_domain, cb_base_domain);
    MBtransmit_Cstring(mbus,buf);
    Quit(w, stuff, data);
  }
}
/* ------------------------------------------------------------------------ */
void
InitializeControlPanel()
{
  Widget title_b,quit_b,quit_d,shutdown_d,save_d,w,ds_d;
  XmString xm_str;
  int n;
  char buf[80];
  Arg argl[2];

  control_panel = XtCreateManagedWidget("controlPanel", xmRowColumnWidgetClass,
					toplevel_widget, NULL, 0);

  sprintf (buf, "%s's Control Panel", cb_user);
  XtManageChild(CreateTitle(buf, control_panel));
  XtCreateManagedWidget("separator", xmSeparatorGadgetClass,
			control_panel, NULL, 0);

  CreatePushButton("Connect", control_panel, SendConnect, NULL);

  xm_str = CtoXmString("Shut down the User Interface?");
  XtSetArg(argl[0], XmNmessageString, xm_str);
  shutdown_d = XmCreateWarningDialog(toplevel_widget, "Shutdown UI", argl, 1);
  XtAddCallback(shutdown_d, XmNokCallback, SendDisconnect, NULL);
  w = XmMessageBoxGetChild(shutdown_d, XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(w);
  XtSetArg(argl[0], XmNtitle, "Shutdown User Interface");
  XtSetValues(XtParent(shutdown_d), argl, 1);
  XtFree(xm_str);
  CreatePushButton("Shutdown UI", control_panel, ConfirmDialog, shutdown_d);

  xm_str = CtoXmString("Shut down the Widget Server?");
  XtSetArg(argl[0], XmNmessageString, xm_str);
  quit_d = XmCreateWarningDialog(toplevel_widget, "Quit", argl, 1);
  XtAddCallback(quit_d, XmNokCallback, Quit, NULL);
  w = XmMessageBoxGetChild(quit_d, XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(w);
  XtSetArg(argl[0], XmNtitle, "Quit Widget Server");
  XtSetValues(XtParent(quit_d), argl, 1);
  XtFree(xm_str);

  xm_str = CtoXmString("Destroy all shells?");
  XtSetArg(argl[0], XmNmessageString, xm_str);
  ds_d = XmCreateWarningDialog(toplevel_widget, "Destroy", argl, 1);
  XtAddCallback(ds_d, XmNokCallback, DestroyShells, NULL);
  w = XmMessageBoxGetChild(ds_d, XmDIALOG_HELP_BUTTON);
  XtUnmanageChild(w);
  XtSetArg(argl[0], XmNtitle, "Destroy Shells");
  XtSetValues(XtParent(ds_d), argl, 1);
  XtFree(xm_str);
  CreatePushButton("Destroy Shells", control_panel, ConfirmDialog, ds_d);

  CreatePushButton("Save System", control_panel, SendSaveSystem, NULL);
  CreatePushButton("Quit", control_panel, ConfirmDialog, quit_d);

}
/* ------------------------------------------------------------------------ */
t_generic_widget
FindToplevelShellID(s_id) t_sexp s_id;
{
  t_generic_widget shell;

  for ( shell = toplevel_shells ; NULL != shell ; shell = shell->next )
    if (MBequal(s_id, shell->id))
      return shell;
  return NULL;
}
/* ------------------------------------------------------------------------ */
t_generic_widget
HandleBusItem(parent, sexp)
     t_generic_widget parent;
     t_sexp sexp;
{
  t_sexp tag = MB_CAR(sexp);
  t_sexp id = MBnth(sexp,1);
  t_widget_class c;
  int i;

  if (!MB_NAMEP(tag) || !MB_CHUNKP(id))
    {
      if (MBLogLevel > 1) fprintf(stderr, "Malformed widget\n");
      return NULL;
    }

  for ( i = 0 ; i < N_CLASSES ; ++i )
    {
      c = class[i];
      if (!MBcompare_Cstring(tag, c->tag)) return c->handle(parent, sexp);
    }
  
  return NULL;
}
/* ------------------------------------------------------------------------ */
/* sexp is assumed to be an sexp that describes the new shell. In particular,
 * the cadr must be a string identifying the new shell.
 */
void
HandleNewShell(sexp) t_sexp sexp;
{
  t_generic_widget shell;

  shell = HandleBusItem(NULL, sexp);
  if (NULL != shell)
    {
      /* insert into top level list */
      shell->next = toplevel_shells;
      toplevel_shells = shell;

      /* Moved the XtRealizeWidget and shell->class->realized lines
       * from here into ShellHandle.  Needed to have the shell realized
       * in order to fix sizes on it and such.
       */
      if (WS_SHELL == shell->type
	  && SHELL_PROMPT == ((t_shell_widget)shell)->stype)
	{
	  /*
	  XtPopup(shell->widget, XtGrabNone);
	  */
	}
      else
	{
	  XtManageChild(shell->widget);
	}
      if (WS_SHELL != shell->type
	  || SHELL_PERSISTENT != ((t_shell_widget)shell)->stype)
	XtVaSetValues(shell->widget, XmNmappedWhenManaged, True, NULL);
    }
}
/* ------------------------------------------------------------------------ */
void
HandleBusMessage(item) t_sexp item;
{
  t_sexp tag;
  t_generic_widget shell, next, prompt, menu;
  Widget w;

  tag = MB_CAR(item);

  /* check the various allowed top level commands */

  if (!MBcompare_Cstring(tag, ShellClassRecord.tag)) HandleNewShell(item);

  /* everybody gets the update message, in case a sub item needs
   * to see it
   */
  else if (!MBcompare_Cstring(tag, "update")
	   || !MBcompare_Cstring(tag, "action")
	   )
    {
      /* Take care for action removing a shell in the middle here */
      shell = toplevel_shells;
      while (NULL != shell)
	{
	  next = shell->next;
	  shell->class->update(shell, item);
	  shell = next;
	}
    }
  else if (!MBcompare_Cstring(tag, "transmit"))
    {
      t_sexp id = MBnth(item, 1);
      for ( shell = toplevel_shells ; NULL != shell
	   ; shell = shell->next )
	if (MBequal(id, shell->id))
	  {
	    ShellPrepareTransmit(shell, item);
	    break;
	  }
    }
  else if (!MBcompare_Cstring(tag, "terminate"))
    {
      /* gotta be a little careful, because ShellTerminate can
       * remove the shell from the list we're traversing
       */
      shell = toplevel_shells;
      while (NULL != shell)
	{
	  next = shell->next;
	  ShellTerminate(shell, item);
	  shell = next;
	}
    }
  else if (!MBcompare_Cstring(tag, "error"))
    {
      w = PopupError(item);
      if (NULL != w) XtManageChild(w);
    }
  else if (!MBcompare_Cstring(tag, "message"))
    {
      w = PopupMessage(item);
      if (NULL != w) XtManageChild(w);
    }
  else if (!MBcompare_Cstring(tag, "warning"))
    {
      if (NULL != (w = PopupWarning(item)))
	XtManageChild(w);
    }
  else if (!MBcompare_Cstring(tag, "info"))
    {
      w = PopupInfo(item);
      if (NULL != w) XtManageChild(w);
    }
  else if (!MBcompare_Cstring(tag, MenuClassRecord.tag))
    {
      menu = HandleBusItem(NULL, item);
      if (NULL != menu)
	{
	  XtManageChild(menu->widget);
	  XtRealizeWidget(menu->widget);
	  menu->class->realized(menu);
	}
    }
  else if (!MBcompare_Cstring(tag, "ungrab"))
    XUngrabPointer(XtDisplay(toplevel_widget), CurrentTime);
  else if (!MBcompare_Cstring(tag, "shutdown"))
      SendDisconnect(toplevel_widget, NULL, NULL);
}
      
/* ------------------------------------------------------------------------ */
void
HandleMBus(data,fd,id)
     caddr_t data;
     int *fd;
     XtInputId *id;
{
  t_sexp mesg, m, item, tag;
  t_generic_widget shell, next, prompt;
  Widget w;

  while (NULL != (mesg = MBNextMessage(mbus)))
    {
      for ( m = MBnthcdr(mesg,2) ; MB_CONSP(m) ; m = MB_CDR(m))
	  HandleBusMessage(MB_CAR(m));
      MBfree(mesg);
      XSync(XtDisplay(toplevel_widget), False); /* don't run on too fast */
    }
}
/* ------------------------------------------------------------------------ */
int
DealWithCommandLineOptions(argc,argv)
     int argc;
     char **argv;
{
  int opt;
  char *tmp;
  char Usage = 0;
  extern char *getenv(), *GetUserName();

  /* environment variable checks */
  host = getenv(ENV_MBUS_HOST);
  if (NULL != (tmp = getenv(ENV_MBUS_PORT))) port = strtol(tmp, NULL, 0);
  if (NULL != (tmp = getenv("CB_CONNECT"))) connect_message = tmp;
  cb_base_domain = getenv(ENV_BASE_DOMAIN);
  cb_server_domain = getenv(ENV_SERVER_DOMAIN);
  cb_ui_domain = getenv(ENV_UI_DOMAIN);
  cb_ws_domain = getenv(ENV_WS_DOMAIN);
  
  while ( (opt = getopt(argc,argv,"b:s:i:u:h:p:L;")) != EOF)
    switch (opt)
      {
      case '?' :
	fprintf (stderr, "Unknown option -%c.\n", opt_err_char);
	Usage = 1;
	break;
      case 'b':
	cb_base_domain = optarg; break;
      case 's':
	cb_server_domain = optarg; break;
      case 'i':
	cb_ui_domain = optarg; break;
      case 'u':
	cb_user = optarg; break;
      case 'L' :
	if (NULL == optarg) MBLogLevel = 1;
	else MBLogLevel = strtol(optarg, NULL, 0);
	break;
      case 'h' : host = optarg; break;
      case 'p' :
	{
	  int n;
	  char *s;
	  n = strtol(optarg, &s, 0);
	  if (s != optarg) port = n;
	}
	break;
      }

  if (Usage)
  {
    printf ("Usage:  %s -b b_domain -s s_domain -i i_domain\n",
	    argv[0]);
    printf ("           -u u_domain -h host -p port -L [loglevel]\n");
    printf ("where:  b_domain is the base domain (default \"%s\")\n",
	    DEF_BASE_DOMAIN);
    printf ("        i_domain is the user interface domain (default \"%s\")\n",
	    DEF_UI_DOMAIN);
    printf ("        u_domain is the user domain (default $USER)\n");
    printf ("        host is the host of the message bus\n");
    printf ("        port is the port of the message bus\n");
    printf ("        loglevel is the logging level to print\n");
    printf ("\nEnvironment variables used:\n");
    printf ("CB_BASE_DOMAIN     the base domain\n");
    printf ("CB_SERVER_DOMAIN   the server domain\n");
    printf ("CB_UI_DOMAIN       the user interface domain\n");
    printf ("CB_USER            the user domain\n");
    printf ("CB_WS_DOMAIN       the local domain\n");
    printf ("MBUS_HOST          the message bus host\n");
    printf ("MBUS_PORT          the message bus port\n");
    printf ("CB_CONNECT         the message to send to the bus for connection\n");
    exit(1);
  }
  
  if (NULL == cb_base_domain) cb_base_domain = DEF_BASE_DOMAIN;
  if (NULL == cb_server_domain) cb_server_domain = DEF_SERVER_DOMAIN;
  if (NULL == cb_ui_domain) cb_ui_domain = DEF_UI_DOMAIN;
  if (NULL == cb_user) cb_user = GetUserName();
  if (NULL == cb_ws_domain) cb_ws_domain = DEF_WS_DOMAIN;
  
  if (NULL == connect_message)
  {
    connect_message = XtMalloc(64);
    sprintf(connect_message,
	    "(\"CB\" \"%s.%s\" (u-connect :user \"%s\"))",
	    cb_server_domain, cb_base_domain,
	    cb_user);
  }

  return optind;
}
/* ------------------------------------------------------------------------ */
void
InitializeMBus()
{
  char buff[512];

  /* Need a cast, because of the screwey way different systems define
   * malloc functions. I can't get a cast to a function pointer to work,
   * so I'll just cast to void * and bypass the problem.
   */
  MBmalloc_func = (void *)XtMalloc;

  if (NULL == (mbus = MBConnect(host,port))) exit(1);

  sprintf(buff, "(id \"Widget Server for %s\") (accept \".*\" (\"%s.%s.%s.%s\" \"%s.%s.%s\" \"%s.%s\" \"%s.%s.%s\"))",
	  cb_user,
	  cb_ws_domain, cb_user, cb_ui_domain, cb_base_domain,
	  cb_user, cb_ui_domain, cb_base_domain,
	  cb_ui_domain, cb_base_domain,
	  cb_ws_domain, cb_ui_domain, cb_base_domain);
  MBtransmit_buffer(mbus, buff, strlen(buff));
}
/* ------------------------------------------------------------------------ */
void
main(argc,argv)
     int argc;
     char *argv[];
{
  int n;
  Arg argl[4];
  Dimension width, height;
  int skip;
  char buf[80];
#ifndef _NO_PROTO
  extern int WXErrorHandler(Display *, XErrorEvent *);
#else
  extern int WXErrorHandler();
#endif

#ifdef SYSV_R4
  /* Learn to write code, you twits. */
  signal(SIGPOLL, SIG_IGN);
#endif

  /*
  toplevel_widget = XtInitialize(argv[0], "biscuit", argl, n, &argc, argv);
  */
  XtToolkitInitialize();

  app_context = XtCreateApplicationContext();

  dpy = XtOpenDisplay(app_context,		/* application context */
		NULL,			/* dislay name */
		APP_NAME, APP_CLASS,	/* name and class of program */
		NULL, 0,		/* command line options */
		&argc, argv);

  if (NULL == dpy)
    {
      fprintf(stderr, "Cannot open display");
      exit(1);
    }

  n = 0;
  toplevel_widget = XtAppCreateShell(APP_NAME, APP_CLASS,
				     applicationShellWidgetClass,
				     dpy,
				     argl, n);

  /* Have to reset the title afterwards, doesn't take otherwise */
  sprintf (buf, "Biscuit %s.%s.%s.%s", MAJOR_NUM, MINOR_NUM, CHANGE_NUM,
	   COMPILATION_NUM);
  n = 0;
  XtSetArg(argl[n], XmNtitle, buf), ++n;
  XtSetValues(toplevel_widget, argl, n);

  XSetErrorHandler(WXErrorHandler);

  skip = DealWithCommandLineOptions(argc,argv);

  InitializeMBus();
  InitializeControlPanel();

  xa_cb_hscrollbar =
    XInternAtom(XtDisplay(toplevel_widget), "_CB_HSCROLLBAR", False);
  xa_cb_vscrollbar =
    XInternAtom(XtDisplay(toplevel_widget), "_CB_VSCROLLBAR", False);
  xa_cb_editable =
    XInternAtom(XtDisplay(toplevel_widget), "_CB_EDITABLE", False);
  xa_cb_terminate =
    XInternAtom(XtDisplay(toplevel_widget), "_CB_TERMINATE", False);
  xa_cb_dropchild =
    XInternAtom(XtDisplay(toplevel_widget), "_CB_DROPCHILD", False);
  xa_cb_true =
    XInternAtom(XtDisplay(toplevel_widget), "_CB_TRUE", False);
  xa_cb_false =
    XInternAtom(XtDisplay(toplevel_widget), "_CB_FALSE", False);
  xa_wm_delete_window =
    XInternAtom(XtDisplay(toplevel_widget), "WM_DELETE_WINDOW", False);

  XtRealizeWidget(toplevel_widget); 

  /* Lock in the current size */
  XtSetArg(argl[0], XmNheight, &height);
  XtSetArg(argl[1], XmNwidth, &width);
  XtGetValues(toplevel_widget, argl, 2);
  n = 0;
  XtSetArg(argl[n], XmNminHeight, height), ++n;
  XtSetArg(argl[n], XmNminWidth, width), ++n;
  XtSetArg(argl[n], XmNmaxWidth, width), ++n;
  XtSetArg(argl[n], XmNmaxHeight, height), ++n;
  XtSetValues(toplevel_widget, argl, n);

  /* Listen to the MBus */
  XtAppAddInput(app_context,
		MBconnection_fd(mbus), XtInputReadMask,
		HandleMBus, NULL);

  XtAppMainLoop(app_context);
}
/* ------------------------------------------------------------------------ */
