/* This file is part of the 
 *
 *	Delta Project  (ConversationBuilder)  
 *	Human-Computer Interaction Laboratory
 *	University of Illinois at Urbana-Champaign
 *	Department of Computer Science
 *	1304 W. Springfield Avenue
 *	Urbana, Illinois 61801
 *	USA
 *
 *	c 1989,1990,1991,1992 Board of Trustees
 *		University of Illinois
 *		All Rights Reserved
 *
 * This code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY. No author or distributor accepts
 * responsibility to anyone for the consequences of using this code
 * or for whether it serves any particular purpose or works at all,
 * unless explicitly stated in a written agreement.
 *
 * Everyone is granted permission to copy, modify and redistribute
 * this code, except that the original author(s) must be given due credit,
 * and this copyright notice must be preserved on all copies.
 *
 *	Author:  Alan Carroll (carroll@cs.uiuc.edu)
 *      Modified:  Doug Bogia (bogia@cs.uiuc.edu)
 *
 *	Project Leader:  Simon Kaplan (kaplan@cs.uiuc.edu)
 *	Direct enquiries to the project leader please.
 */

/*	label.c: The label widget */
/* widget server label support */
/* $Source: /export/kaplan/stable/sun4.os4.1/cb-2.0/src/data/node113.text,v $ */

static char rcsid[] = "label.c $Revision: 1.1 $ $Date: 92/05/08 15:25:58 $ $State: Exp $ $Author: CBmgr $";

/* ------------------------------------------------------------------------ */
#include "header.h"
/* This used to be a LabelG.  Changed to a Label in order to have
 * colors on our labels
 */
#include <Xm/Label.h>
#include <Xm/Frame.h>
/* ------------------------------------------------------------------------ */
extern void
  LabelRemove(), LabelUpdate(), LabelReply(), LabelEditable(),
  LabelRealized(), LabelTransmit();

extern t_generic_widget LabelHandle();

extern Pixel GetColor();
extern XFontStruct *GetFont();

struct widget_class_struct LabelClassRecord =
{
  WS_LABEL, "label",
  LabelHandle, LabelRemove, NULL, LabelUpdate, LabelReply, LabelRealized,
  LabelTransmit, LabelEditable,
} ;
/* ------------------------------------------------------------------------ */
typedef struct label_widget_struct
{
  DECLARE_STANDARD_WIDGET_SLOTS;
  Widget w_label;
  Widget w_frame;
  XmFontList font_list;
} * t_label_widget;

/* ------------------------------------------------------------------------ */
/* sexp should be (label "id" "label" :frame :align) */
static struct keyword_entry_struct LabelKeywords[] =
{
  { ":frame", (void *)KEYWORD_NONE, KEYWORD_FLAG },
  { ":align", NULL, KEYWORD_SEXP },
  { ":foreground", NULL, KEYWORD_COOKED },
  { ":font", NULL, KEYWORD_COOKED },
};

t_generic_widget
LabelHandle(parent,sexp)
     t_generic_widget parent;
     t_sexp sexp;
{
  t_label_widget label;
  t_sexp s_text, s_align;
  Boolean f_frame;
  XmString xm_string;
  char *text, *foreground_name, *font_name;
  int n;
  Arg argl[10];
  Pixel foreground;
  XFontStruct * font;
  XmFontList font_list = NULL;

  /* check things to see if they're in the right format */
  if (NULL == parent || NULL == sexp) return NULL;
  s_text = MBnth(sexp, 2);
  if (!MB_CHUNKP(s_text)) return NULL;

  label = NEW_STRUCT(label_widget_struct);
  label->type = WS_LABEL;
  label->class = &LabelClassRecord;
  label->parent = parent;
  label->top = parent->top;
  label->id = Getnth(sexp, 1);
  label->w_frame = NULL;

  MBparse_keywords(MBnthcdr(sexp, 3), LabelKeywords,
		   ARRAY_SIZE(LabelKeywords));
  n = 0;
  f_frame = KEYWORD_TRUE == (t_keyword_flag)LabelKeywords[n++].result;
  s_align = (t_sexp)LabelKeywords[n++].result;
  foreground_name = (char *)LabelKeywords[n++].result;
  font_name = (char *)LabelKeywords[n++].result;

  if (f_frame)
    {
      label->w_frame = XtCreateWidget("frame", xmFrameWidgetClass,
				      parent->widget, NULL, 0);
      label->widget = label->w_frame;
    }

  text = MBCstring(s_text);
  xm_string = XmStringCreateLtoR(text, XmSTRING_DEFAULT_CHARSET);
  n = 0;
  XtSetArg(argl[n], XmNlabelString, xm_string), ++n;

  if (!MBcompare_Cstring(s_align, ":begin"))
    XtSetArg(argl[n], XmNalignment, XmALIGNMENT_BEGINNING), ++n;
  else if (!MBcompare_Cstring(s_align, ":center"))
    XtSetArg(argl[n], XmNalignment, XmALIGNMENT_CENTER), ++n;
  else if (!MBcompare_Cstring(s_align, ":end"))
    XtSetArg(argl[n], XmNalignment, XmALIGNMENT_END), ++n;

  if (foreground_name)
  {
    foreground = GetColor(toplevel_widget, foreground_name);
    XtSetArg(argl[n], XmNforeground, foreground), ++n;
    FREE(foreground_name);
  }
  label->font_list = NULL;
  if (font_name)
  {
    font = GetFont(toplevel_widget, font_name);
    if (font)
    {
      /* Don't know here if we can simply free the font_list as soon as
       * we give it to motif.  Thus, we will keep it with the label and
       * free it when the label goes away.  We know that is safe.
       */
      label->font_list = XmFontListCreate (font, XmSTRING_DEFAULT_CHARSET);
      XtSetArg(argl[n], XmNfontList, label->font_list), ++n;
    }
    FREE(font_name);
  }

  /* This used to be a xmLabelGadgetClass.  Changed to the LabelWidget
   * class to have colors on our labels.
   */
  label->w_label = XtCreateWidget("label", xmLabelWidgetClass,
				  NULL == label->w_frame
				  ? parent->widget : label->w_frame,
				  argl, n);
  if (NULL != label->w_frame) XtManageChild(label->w_label);
  else label->widget = label->w_label;

  XmStringFree(xm_string);
  XtFree(text);

  return (t_generic_widget)label;
}
/* ------------------------------------------------------------------------ */
void
LabelRemove(self) t_label_widget self;
{
  if (self->font_list) XmFontListFree(self->font_list);
  MBfree(self->id);
  XtFree(self);
}
/* ------------------------------------------------------------------------ */
/* Accept an update message and update the label */
static struct keyword_entry_struct LabelUpdateKeys[] =
{
  { ":label", NULL, KEYWORD_COOKED },
};

void
LabelUpdate(self,sexp)
     t_label_widget self;
     t_sexp sexp;
{
  char *label;

  if (!MBequal(MBnth(sexp,1), self->id)) return;

  MBparse_keywords(MBnthcdr(sexp,2), LabelUpdateKeys,
		ARRAY_SIZE(LabelUpdateKeys));
  label = (char *)LabelUpdateKeys[0].result;

  if (NULL != label) SetTitle(self->w_label, label);

  XtFree(label);
}
/* ------------------------------------------------------------------------ */
void
LabelReply(self, reply)
     t_label_widget self;
     t_mbus_reply reply;
{
  self->parent->class->reply(self->parent, reply);
}
/* ------------------------------------------------------------------------ */
void
LabelRealized(self) t_label_widget self;
{
}
/* ------------------------------------------------------------------------ */
void
LabelEditable(self, flag)
     t_label_widget self;
     int flag;
{
}
/* ------------------------------------------------------------------------ */
void
LabelTransmit(message, orig_reply, self)
  t_sexp message;
  t_mbus_reply orig_reply;
  t_label_widget self;
{
}
/* ------------------------------------------------------------------------ */
