;;; DO NOT MODIFY THIS FILE
(if (featurep 'xwem-autoloads) (error "Already loaded"))

;;;### (autoloads nil "_pkg" "lisp/_pkg.el")

(package-provide 'xwem :version 1.21 :author-version "lg@xwem.org--2005/xwem--main--2.1--versionfix-1" :type 'regular)

;;;***

;;;### (autoloads nil "xwem-appcollect" "lisp/xwem-appcollect.el")
(autoload 'xwem-appcollect "xwem-appcollect" nil nil)

;;;***

;;;### (autoloads (xwem-battery) "xwem-battery" "lisp/xwem-battery.el")

(autoload 'xwem-battery "xwem-battery" "\
Start xwem apm battery monitor in system tray." t nil)
(autoload 'xwem-battery-status "xwem-battery" nil t)
(autoload 'xwem-battery-popup-menu "xwem-battery" nil t)

;;;***

;;;### (autoloads (xwem-manage-generic) "xwem-clgen" "lisp/xwem-clgen.el")

(defvar xwem-clgen-map (let ((map (make-sparse-keymap))) (define-key map (kbd "H-c H-o") 'xwem-clgen-toggle-other-on-split) map) "\
Local keymap for generic clients.")
(autoload 'xwem-clgen-turn-on-other-on-split "xwem-clgen" "" t)
(autoload 'xwem-clgen-turn-off-other-on-split "xwem-clgen" "" t)
(autoload 'xwem-clgen-toggle-other-on-split "xwem-clgen" "" t)

(autoload 'xwem-manage-generic "xwem-clgen" "\
Manage method for generic clients." nil nil)

;;;***

;;;### (autoloads (xwem-make-variable-client-local xwem-set-default) "xwem-clients" "lisp/xwem-clients.el")

(defcustom xwem-client-default-properties '(x-border-width 2) "*Default properties for newly managed clients." :type 'list :group 'xwem-cl)

(defcustom xwem-cl-create-hook nil "Hook to call when creating new client." :type 'hook :group 'xwem-cl)

(defcustom xwem-cl-destroy-hook nil "Hooks called with one argument - cl, when cl destroyed.\nNOT USED YET." :type 'hook :group 'xwem-hooks)

(defcustom xwem-cl-manage-hook nil "*Hooks to be called with just managed CL as argument." :type 'hook :group 'xwem-hooks)

(defcustom xwem-cl-activate-hook nil "*Hooks to call when client activates.\nCalled with two arguments:\n CL   - Activated client\n TYPE - Activation type - either 'activate or 'select" :type 'hook :group 'xwem-hooks)

(defcustom xwem-cl-deactivate-hook nil "*Hooks to call when client deactivates.\nCalled with two arguments:\n CL   - Deactivated client\n TYPE - Deactivation type - either 'deactivate or 'deselect" :type 'hook :group 'xwem-hooks)

(defcustom xwem-cl-refit-hook nil "Hooks called when CL just refited." :type 'hook :group 'xwem-hooks)

(defcustom xwem-cl-iconify-hook nil "Hooks called when CL just iconified." :type 'hook :group 'xwem-hooks)

(defcustom xwem-cl-withdraw-hook nil "*Hooks to call when CL moved to withdrawn state." :type 'hook :group 'xwem-hooks)

(defcustom xwem-cl-change-hook nil "Hooks called when something changed in CL." :type 'hook :group 'xwem-hooks)

(defcustom xwem-cl-state-change-hook nil "*Hooks to run when state of client changes.\nEvery hook called with three args - CL OLD-STATE NEW-STATE." :type 'hook :group 'xwem-hooks)

(defcustom xwem-client-select-hook nil "*Hooks called when new client just selected.\nIt is pretty guarantied that `xwem-selected-client' is valid xwem-cl\nstructure at time of hook execution." :type 'hook :group 'xwem-hooks)

(defcustom xwem-client-deselect-hook nil "Hooks called with one arg - cl, when cl deselected.\nIt is pretty guarantied that `xwem-selected-client' is valid xwem-cl\nstructure at time of hook execution." :type 'hook :group 'xwem-hooks)

(defvar xwem-cl-mark-ring nil "\
The list of marked clients.")
(autoload 'xwem-client-iconify "xwem-clients" "" t)
(autoload 'xwem-switch-client "xwem-clients" "" t)
(autoload 'xwem-switch-other-client "xwem-clients" "" t)
(autoload 'xwem-attach-client "xwem-clients" "" t)
(autoload 'xwem-cl-switch-other-win "xwem-clients" "" t)
(autoload 'xwem-cl-switch-other-frame "xwem-clients" "" t)
(autoload 'xwem-cl-switch-to-other "xwem-clients" "" t)
(autoload 'xwem-cl-switch-to-other-in-other-win "xwem-clients" "" t)
(autoload 'xwem-kill-cl-and-window "xwem-clients" "" t)
(autoload 'xwem-cl-transpose "xwem-clients" "" t)
(autoload 'xwem-client-kill "xwem-clients" "" t)
(autoload 'xwem-client-query-kill "xwem-clients" "" t)
(autoload 'xwem-client-demanage-others "xwem-clients" "" t)
(autoload 'xwem-client-run-copy "xwem-clients" "" t)
(autoload 'xwem-client-run-copy-other-win "xwem-clients" "" t)
(autoload 'xwem-client-run-copy-other-frame "xwem-clients" "" t)
(autoload 'xwem-client-info "xwem-clients" "" t)
(autoload 'xwem-cl-pop-to-client "xwem-clients" "" t)
(autoload 'xwem-cl-set-title "xwem-clients" "" t)
(autoload 'xwem-client-unset-mark "xwem-clients" "" t)
(autoload 'xwem-client-set-mark "xwem-clients" "" t)
(autoload 'xwem-client-exchange-selected-and-mark "xwem-clients" "" t)
(autoload 'xwem-client-imove "xwem-clients" nil t)
(autoload 'xwem-client-iresize "xwem-clients" nil t)
(autoload 'xwem-client-idestroy "xwem-clients" nil t)
(autoload 'xwem-forward-application "xwem-clients" "Select ARGs next application." t)
(autoload 'xwem-backward-application "xwem-clients" "Select previous application." t)

(autoload 'xwem-set-default "xwem-clients" "\
Set default VAR's value to VAL.
If client does not have its own value, default value will be used." nil nil)

(autoload 'xwem-make-variable-client-local "xwem-clients" "\
Make variable symbol VAR to be client local." nil nil)

;;;***

;;;### (autoloads nil "xwem-clswi" "lisp/xwem-clswi.el")
(autoload 'xwem-clswi-next "xwem-clswi" nil t)
(autoload 'xwem-clswi-prev "xwem-clswi" nil t)
(autoload 'xwem-clswi-next-other-window "xwem-clswi" nil t)
(autoload 'xwem-clswi-prev-other-window "xwem-clswi" nil t)

;;;***

;;;### (autoloads nil "xwem-desktop" "lisp/xwem-desktop.el")
(autoload 'xwem-desktop-save "xwem-desktop" nil t)
(autoload 'xwem-desktop-load "xwem-desktop" nil t)
(autoload 'xwem-desktop-save-onetime "xwem-desktop" nil t)
(autoload 'xwem-desktop-load-onetime "xwem-desktop" nil t)

;;;***

;;;### (autoloads nil "xwem-edmacro" "lisp/xwem-edmacro.el")
(autoload 'xwem-edmacro-edit-kbd-macro "xwem-edmacro" "" t)

;;;***

;;;### (autoloads nil "xwem-edprops" "lisp/xwem-edprops.el")
(autoload 'xwem-edit-client-properties "xwem-edprops" "Interactively edit client's properties." t)

;;;***

;;;### (autoloads nil "xwem-focus" "lisp/xwem-focus.el")

(defcustom xwem-default-focus-mode 'generic "*Default CL's focus mode." :type '(choice (const :tag "Generic mode" generic) (const :tag "Click to focus" click-focus) (const :tag "Follow mouse" follow-mouse)) :group 'xwem)
(autoload 'xwem-focus-click-on "xwem-focus" nil t)

;;;***

;;;### (autoloads nil "xwem-frame" "lisp/xwem-frame.el")

(defcustom xwem-frame-default-properties (list 'inner-border-width 3 'inner-border-thickness 1 'outer-border-width 0 'background "gray60" 'title-height 18) "*Default properties list for xwem frames." :type '(restricted-sexp :match-alternatives (valid-plist-p)) :group 'xwem-frame)

(defcustom xwem-embedded-frame-default-properties (list 'inner-border-width 0 'inner-border-thickness 0 'outer-border-width 0) "*Default properties for embedded xwem frames.\nValues in `xwem-embedded-frame-default-properties' overrides values in\n`xwem-frame-default-properties'." :type '(restricted-sexp :match-alternatives (valid-plist-p)) :group 'xwem-frame)

(defcustom xwem-dedicated-frame-defalut-properties (list 'inner-border-width 2 'inner-border-thickness 1 'outer-border-width 0) "*Default properties for dedicated xwem frames.\nValues in `xwem-dedicated-frame-defalut-properties' overrides values in\n`xwem-frame-default-properties'." :type '(restricted-sexp :match-alternatives (valid-plist-p)) :group 'xwem-frame)
(autoload 'xwem-frame-lower "xwem-frame" "" t)
(autoload 'xwem-frame-raise "xwem-frame" "" t)
(autoload 'xwem-make-frame "xwem-frame" "" t)
(autoload 'xwem-frame-next "xwem-frame" "" t)
(autoload 'xwem-frame-previous "xwem-frame" "" t)
(autoload 'xwem-frame-switch "xwem-frame" "Switch to frame by name." t)
(autoload 'xwem-frame-switch-nth "xwem-frame" "" t)
(autoload 'xwem-frame-switch-nth-linkage "xwem-frame" "" t)
(autoload 'xwem-frame-destroy "xwem-frame" "" t)
(autoload 'xwem-frame-goto-next "xwem-frame" "" t)
(autoload 'xwem-frame-goto-prev "xwem-frame" "" t)
(autoload 'xwem-frame-goto-next-vert "xwem-frame" "" t)
(autoload 'xwem-frame-goto-next-hor "xwem-frame" "" t)
(autoload 'xwem-frame-goto-prev-vert "xwem-frame" "" t)
(autoload 'xwem-frame-goto-prev-hor "xwem-frame" "" t)
(autoload 'xwem-frame-split-sbs "xwem-frame" "" t)
(autoload 'xwem-frame-sbs-hor-split "xwem-frame" "" t)
(autoload 'xwem-frame-sbs-vert-split "xwem-frame" "" t)
(autoload 'xwem-frame-fit-screen "xwem-frame" "" t)
(autoload 'xwem-frame-transpose "xwem-frame" "" t)
(autoload 'xwem-frame-showroot "xwem-frame" "" t)
(autoload 'xwem-frame-hide "xwem-frame" "" t)
(autoload 'xwem-transpose-frames "xwem-frame" "" t)
(autoload 'xwem-frame-set-name "xwem-frame" "" t)
(autoload 'xwem-frame-on-delim-resize "xwem-frame" "" t)
(autoload 'xwem-frame-on-delim-menu "xwem-frame" "" t)
(autoload 'xwem-frame-imove "xwem-frame" "" t)
(autoload 'xwem-frame-iresize "xwem-frame" "" t)

;;;***

;;;### (autoloads (xwem-framei-dockapp xwem-framei-init) "xwem-framei" "lisp/xwem-framei.el")

(autoload 'xwem-framei-init "xwem-framei" "\
Initialize xwem frame indicator on display XDPY." nil nil)

(autoload 'xwem-framei-dockapp "xwem-framei" "\
Start frame indicator dockapp." nil nil)
(autoload 'xwem-framei-dockapp-popup-menu "xwem-framei" nil t)
(autoload 'xwem-framei-dockapp-popup-alt-menu "xwem-framei" nil t)

;;;***

;;;### (autoloads nil "xwem-frametrans" "lisp/xwem-frametrans.el")
(autoload 'xwem-frame-transparency "xwem-frametrans" nil t)

;;;***

;;;### (autoloads nil "xwem-help" "lisp/xwem-help.el")
(autoload 'xwem-help "xwem-help" "" t)
(autoload 'xwem-help-for-help "xwem-help" "" t)
(autoload 'xwem-describe-prefix-bindings "xwem-help" "" t)
(autoload 'xwem-help-describe-bindings "xwem-help" "" t)
(autoload 'xwem-help-describe-key1 "xwem-help" "" t)
(autoload 'xwem-help-mode "xwem-help" "" t)
(autoload 'xwem-help-describe-key "xwem-help" "" t)
(autoload 'xwem-help-frames "xwem-help" "" t)
(autoload 'xwem-help-wins "xwem-help" "" t)
(autoload 'xwem-help-clients "xwem-help" "" t)
(autoload 'xwem-help-where-is "xwem-help" "" t)

;;;***

;;;### (autoloads nil "xwem-holer" "lisp/xwem-holer.el")
(autoload 'xwem-holer-prefix "xwem-holer" nil nil 'keymap)

;;;***

;;;### (autoloads nil "xwem-icons" "lisp/xwem-icons.el")

(defcustom xwem-icons-dir (locate-data-directory "xwem") "Directory where icons for use by XWEM lies." :type 'directory :group 'xwem)

(defcustom xwem-icons-list '(("mini-display.xpm" (class-inst "^Terminal$") (class-name "^Terminal$")) ("mini-clock.xpm" (application "xclock")) ("mini-measure.xpm" (application "xload")) ("mini-calc.xpm" (or (buffer-major-mode calc-mode) (class-name "[cC]alc"))) ("mini-xkeycaps.xpm" (application "xkeycaps")) ("mini-xv.xpm" (application "xv")) ("mini-imagemagic.xpm" (application "display")) ("mini-xdvi.xpm" (class-inst "^xdvi$") (class-name "^XDvi$")) ("mini-acroread.xpm" (class-name "^AcroRead\\|Xpdf$")) ("mini-info.xpm" (class-name "Xman")) ("mini-gimp.xpm" (class-name "^Gimp$")) ("mini-djvu.xpm" (class-inst "^djview$") (class-name "^Djview$")) ("mini-xemacstex.xpm" (or (buffer-major-mode plain-tex-mode) (buffer-major-mode texinfo-mode) (and (application "xemacs") (name "\\.tex")))) ("mini-xemacsC.xpm" (or (buffer-major-mode c-mode) (and (application "xemacs") (name "\\.[ch]")))) ("mini-xemacsgnus.xpm" (or (buffer-major-mode gnus-group-mode) (buffer-major-mode gnus-article-mode) (buffer-major-mode gnus-summary-mode) (and (application "xemacs") (name "\\(Group\\|Summary\\|Article\\)")))) ("mini-xemacspy.xpm" (or (buffer-major-mode python-mode) (and (application "xemacs") (name "\\.py")))) ("mini-links.xpm" (application "links")) ("mini-ddd.xpm" (application "ddd")) ("mini-vnc.xpm" (application "vncviewer")) ("mini-firefox.xpm" (application "firefox")) ("mini-mozilla.xpm" (application "mozilla")) ("mini-opera.xpm" (application "opera")) ("mini-gv.xpm" (or (application "gv") (application "ghostview"))) ("mini-xfig.xpm" (application "xfig")) ("mini-ethereal.xpm" (application "ethereal")) ("mini-font.xpm" (or (application "xfd") (application "xfontsel"))) ("mini-sh1.xpm" (or (buffer-major-mode eshell-mode) (buffer-major-mode shell-mode) (buffer-major-mode term-mode) (buffer-major-mode terminal-mode) (and (class-inst "x?console") (class-name "[Xx]?[Cc]onsole")))) ("mini-colors.xpm" (or (buffer-name "\\*Colors\\*") (and (class-inst "x?colors?") (class-name "[Xx]?colors?")) (name "^xcmap$"))) ("mini-xchat.xpm" (application "xchat")) ("mini-diag.xpm" (application "gnumeric")) ("mini-xemacs.xpm" (application "xemacs")) ("mini-zoom.xpm" (or (class-inst "^Xmag$") (name "^Lupe$"))) ("mini-graph.xpm" (application "gnuplot")) ("mini-icq.xpm" (or (buffer-major-mode eicq-buddy-mode) (buffer-major-mode eicq-log-mode) (and (application "xemacs") (name "\\*Status\\*")) (application "licq") (name "[LlMmVv][Ii][Cc][Qq]"))) ("mini-term.xpm" (and (class-name "^.[tT]erm$") (or (class-inst "^.term$") (class-inst "^rxvt$")))) ("mini-x2.xpm" (eval t))) "Icons matching list in `xwem-manage-list' format." :type '(repeat (cons :tag "Icon specifier" (string :tag "Icon name") (repeat (cons (choice (const :tag "Application" application) (const :tag "Class name" class-name) (const :tag "Class instance" class-inst) (const :tag "Name" name) (const :tag "Buffer Major Mode" buffer-major-mode) (const :tag "Buffer Name" buffer-name) (const :tag "Buffer Name" buffer-name) (const :tag "Sexp for evaluation" eval) (const :tag "Function" function) (const :tag "Or operation" or) (const :tag "And operation" and)) (repeat sexp))))) :group 'xwem)

;;;***

;;;### (autoloads (xwem-local-set-key xwem-local-map xwem-read-key-sequence xwem-read-key xwem-kbd xwem-global-set-key xwem-define-key) "xwem-keyboard" "lisp/xwem-keyboard.el")

(defcustom xwem-pre-command-hook nil "*Hooks to run just before executing command.\nThis may examine `xwem-this-command' variable to find out which\ncommand is about to be run, or may change it to cause a different\ncommand to run." :type 'hook :group 'xwem-keyboard :group 'xwem-hooks)

(defcustom xwem-post-command-hook nil "*Hooks to run after command execution." :type 'hook :group 'xwem-keyboard :group 'xwem-hooks)

(defcustom xwem-keyboard-echo-keystrokes 1 "*If non-nil than echo unfinished commands in echo area after this many seconds of pause." :type 'number :group 'xwem-keyboard)

(defcustom xwem-quit-key [(hyper ?g)] "Quit command key." :type 'sexp :group 'xwem-keyboard)

(defcustom xwem-quit-command 'xwem-keyboard-quit "Default command to be called when `xwem-quit-key' pressed." :type 'function :group 'xwem-keyboard)

(defcustom xwem-help-key [(hyper ?h)] "Help command key." :type 'sexp :group 'xwem-keyboard)

(defcustom xwem-prefix-help-command 'xwem-describe-prefix-bindings "Default command to be called when `xwem-help-key' pressed." :type 'function :group 'xwem-keys)

(defcustom xwem-universal-key [(hyper ?u)] "Key for universal argument commands." :type 'sexp :group 'xwem-keyboard)

(defcustom xwem-kbd-quit-hook nil "*Hooks to be runned when KBD exits.\nRunned only on \\<xwem-global-map>\\[xwem-kbd-quit], but not on\n\\<xwem-global-map>\\[xwem-keyboard-quit]." :type 'hook :group 'xwem-keyboard :group 'xwem-hooks)

(defcustom xwem-keyboard-init-hook nil "*Hooks called after xwem keyboard initialization." :type 'hook :group 'xwem-keyboard :group 'xwem-hooks)

(defvar xwem-override-map nil "\
Keymap that overrides all other keymaps.
And did not considered as global map.  You should control end of
command execution for yourself if using it.
You should *bind* this, not set it.")

(defvar xwem-override-local-map nil "\
Keymap that overrides all local keymaps.
You should *bind* it, not set it.
Normally you should use `xwem-overriding-local-map' function.")

(defvar xwem-kbd-now-grabbing nil "\
Non-nil indicates that we now grabbing keyboard.
Internal variable, do not modify.")

(autoload 'xwem-define-key "xwem-keyboard" "\
Add KEY to KEYMAP to execute COMMAND and grab KEY on WIN.
When command is `nil', then undefine KEY in KEYMAP and ungrab KEY.

PGRAB-MODE and KGRAB-MODE specifies grabbing mode for pointer and
keyboard respectively." nil nil)

(autoload 'xwem-global-set-key "xwem-keyboard" "\
Define KEY to call COMMAND, when xwem is already run.
If command is `nil' then undefine KEY in `xwem-global-map' and ungrab KEY." nil nil)

(autoload 'xwem-kbd "xwem-keyboard" "\
Just like `kbd' but take into account values of `xwem-hyper-modifier' and `xwem-meta-modifier'." nil nil)

(autoload 'xwem-read-key "xwem-keyboard" "\
Read single key press, prompting PROMPT in `xwem-minibuffer'.
If NO-MINIB-FOCUS-P is non-nil, focus `xwem-minibuffer' while reading." nil nil)

(autoload 'xwem-read-key-sequence "xwem-keyboard" "\
Read key sequence that call command prompting PROMPT." nil nil)

(autoload 'xwem-local-map "xwem-keyboard" "\
Return CL's local keymap." nil nil)

(autoload 'xwem-local-set-key "xwem-keyboard" "\
Set KEY to call COMMAND in CL's local keymap.
If COMMAND is `nil' then undefine KEY in CL's local map and ungrab KEY.
If CL is ommited `xwem-cl-selected' assumed." nil nil)
(autoload 'xwem-undefined-command "xwem-keyboard" "" t)
(autoload 'xwem-self-insert-or-undefined "xwem-keyboard" "" t)
(autoload 'xwem-keyboard-quit "xwem-keyboard" "" t)
(autoload 'xwem-kbd-quit "xwem-keyboard" "" t)
(autoload 'xwem-kbd-quote-command "xwem-keyboard" "" t)

(defvar xwem-prefix-arg nil "\
The value of the prefix argument for this editing command.

It may be a number, or the symbol `-' for just a minus sign as arg, or
a list whose car is a number for just one or more
\\<xwem-global-map>\\[xwem-universal-argument] or `nil' if no argument
has been specified.  This is what `\\(xwem-interactive \"P\"\\)'
returns.")
(autoload 'xwem-universal-argument "xwem-keyboard" "" t)
(autoload 'xwem-universal-more "xwem-keyboard" "" t)
(autoload 'xwem-universal-minus "xwem-keyboard" "" t)
(autoload 'xwem-universal-digit "xwem-keyboard" "" t)
(autoload 'xwem-universal-command "xwem-keyboard" "" t)

;;;***

;;;### (autoloads nil "xwem-keydefs" "lisp/xwem-keydefs.el")

(defvar xwem-default-parent-map (make-sparse-keymap 'XWEM-default-parent) "\
Default parent keymap for all override keymaps.")

(defvar xwem-global-map (make-sparse-keymap 'XWEM-global-map) "\
XWEM's global keymap.

Bindings:
\\{xwem-global-map}.")
(autoload 'xwem-root-prefix "xwem-keydefs" "Keymap for root window." nil 'keymap)
(autoload 'xwem-frame-prefix "xwem-keydefs" "Keymap for frames operations." nil 'keymap)
(autoload 'xwem-user-macros-prefix "xwem-keydefs" nil nil 'keymap)

;;;***

;;;### (autoloads (xwem-keymacro-load-macros xwem-keymacro-save-macros) "xwem-keymacro" "lisp/xwem-keymacro.el")
(autoload 'xwem-keymacro-begin "xwem-keymacro" nil t)
(autoload 'xwem-keymacro-end "xwem-keymacro" nil t)
(autoload 'xwem-keymacro-undefined "xwem-keymacro" nil t)
(autoload 'xwem-keymacro-play-last "xwem-keymacro")
(autoload 'xwem-keymacro-recursive-edit "xwem-keymacro" nil t)
(autoload 'xwem-keymacro-exit-recursive-edit "xwem-keymacro" nil t)

(autoload 'xwem-keymacro-save-macros "xwem-keymacro" "\
Save all defined macros to FILE.
Default value for FILE is ~/.xwem/xwem-macros.el." nil nil)

(autoload 'xwem-keymacro-load-macros "xwem-keymacro" "\
Load macros saved with `xwem-key-save-macros' from FILE.
Default value for FILE is ~/.xwem/xwem-macros.el" nil nil)

;;;***

;;;### (autoloads (xwem-keytt-global-mode) "xwem-keytt" "lisp/xwem-keytt.el")
(autoload 'xwem-turn-on-keytt "xwem-keytt" nil t)
(autoload 'xwem-turn-off-keytt "xwem-keytt" nil t)
(autoload 'xwem-keytt-minor-mode "xwem-keytt" nil t)

(autoload 'xwem-keytt-global-mode "xwem-keytt" "\
Enable global mode.
For each client that have support for keytt minor mode,
xwem-keytt-minor-mode will be enabled at manage time." nil nil)

;;;***

;;;### (autoloads (xwem-launch-button-start xwem-launch-generic-program xwem-execute-program) "xwem-launcher" "lisp/xwem-launcher.el")
(autoload 'xwem-run-program "xwem-launcher" "" t)

(autoload 'xwem-execute-program "xwem-launcher" "\
Execute COMMAND in buffer with BUFFER-NAME.
Unlike `background' do not use shell." nil nil)
(autoload 'xwem-launcher-turn-on-horizontal-split-type "xwem-launcher" "" t)
(autoload 'xwem-launcher-turn-on-vertical-split-type "xwem-launcher" "" t)
(autoload 'xwem-launcher-toggle-split-type "xwem-launcher" "" t)
(autoload 'xwem-launcher-turn-on-normal-frame-type "xwem-launcher" "" t)
(autoload 'xwem-launcher-turn-on-embedded-frame-type "xwem-launcher" "" t)
(autoload 'xwem-launcher-toggle-frame-type "xwem-launcher" "" t)
(autoload 'xwem-launch-program "xwem-launcher" "" t)
(autoload 'xwem-launch-program-other-win "xwem-launcher" "" t)
(autoload 'xwem-launch-program-other-frame "xwem-launcher" "" t)

(autoload 'xwem-launch-generic-program "xwem-launcher" "\
Run generic program CMD with arguments SARG." nil nil)
(autoload 'xwem-launch-xterm "xwem-launcher" "" t)
(autoload 'xwem-launch-xterm-other-win "xwem-launcher" "" t)
(autoload 'xwem-launch-xterm-other-frame "xwem-launcher" "" t)
(autoload 'xwem-launch-lupe "xwem-launcher" "" t)
(autoload 'xwem-launch-lupe-other-win "xwem-launcher" "" t)
(autoload 'xwem-launch-lupe-other-frame "xwem-launcher" "" t)
(autoload 'xwem-launch-xlock "xwem-launcher" "" t)
(autoload 'xwem-launch-dock-down "xwem-launcher" "" t)
(autoload 'xwem-launch-dock-launch "xwem-launcher" "" t)
(autoload 'xwem-launch-dock-menu "xwem-launcher" "" t)

(autoload 'xwem-launch-button-start "xwem-launcher" "\
Create new dockapp button with XPM-FILE image and doing ACTION on click.
ACTION is cons cell wher car is one of 'elisp or 'cmd and cdr is string.
For 'elisp car, cdr is real elisp expression, to evaluate on click.
For 'cmd  car, cdr is cmd to run on click." nil nil)

(defcustom xwem-open-file-commands-alist '(("\\.\\(ps\\|ps_pages\\|eps\\)\\'" . "gv") ("\\.pdf\\'" . "xpdf") ("\\.\\(jpe?g\\|gif\\|png\\)\\'" . "display") ("\\.dvi\\'" . "xdvi") ("\\.chm\\'" . "xchm") ("\\.djvu\\'" . "djview") ("\\.txt\\'" . "xterm -e less")) "*Alist specifying how to view special types of files.\n`xwem-open-file-commands-alist' can be dynamically changed by\n`xwemw-open-file' when registering new file extensions, so we\nrecommend to use `xwem-desktop' package to save/restore\n`xwem-open-file-commands-alist' value between sessions." :group 'xwem-launcher :type '(repeat (cons (string :tag "Regexp") (string :tag "Command"))))
(autoload 'xwem-open-file "xwem-launcher" "Open file with appopriate command" t)

;;;***

;;;### (autoloads (xwem-init) "xwem-main" "lisp/xwem-main.el")

(defcustom xwem-dir (file-name-as-directory (expand-file-name ".xwem" (getenv "HOME"))) "Directory to store XWEM's files." :type 'directory :group 'xwem)

(defcustom xwem-debug-routines '(xwem-cl xwem-event xwem-frame xwem-misc xwem-root xwem-deffered xwem-tray x-misc x-event x-tray x-error x-record) "Routines to debug on." :type '(set (const :tag "XWEM CLients" xwem-cl) (const :tag "XWEM Events" xwem-event) (const :tag "XWEM Frames" xwem-frame) (const :tag "XWEM Misc" xwem-misc) (const :tag "XWEM Root" xwem-root) (const :tag "XWEM Deffered calls" xwem-deffered) (const :tag "XWEM Tray" xwem-tray) (const :tag "X Misc" x-misc) (const :tag "X Event" x-event) (const :tag "X Tray" x-tray) (const :tag "X Error" x-error) (const :tag "X RECORD" x-record)) :group 'xwem)

(defcustom xwem-load-hook nil "*Hooks to call after xwem was load." :type 'hook :group 'xwem-hooks)

(defcustom xwem-config-read-hook nil "*Hooks to call after xwem read config file." :type 'hook :group 'xwem-hooks)

(defcustom xwem-before-init-wins-hook nil "Hooks called before `xwem-init-wins'." :type 'hook :group 'xwem-hooks)

(defcustom xwem-after-init-wins-hook nil "Hooks called after `xwem-init-wins'." :type 'hook :group 'xwem-hooks)

(defcustom xwem-before-init-hook nil "Hooks to be run before xwem initialization." :type 'hook :group 'xwem-hooks)

(defcustom xwem-after-init-hook nil "Hooks to be runned after xwem initialisation." :type 'hook :group 'xwem-hooks)

(defvar xwem-started nil "\
Non-nil when xwem started.
Do not modify!")

(autoload 'xwem-init "xwem-main" "\
Initialization of xwem subsystems." nil nil)
(autoload 'xwem-fini "xwem-main" nil t)

;;;***

;;;### (autoloads nil "xwem-manage" "lisp/xwem-manage.el")

(defcustom xwem-manage-default-properties '(reguard-x-border-width t) "*Default managing properties.\nThese properties are always set in any managing model.\nSupported properties are:\n\n  `reguard-x-border-width' - Reguard border width.\n  `win-support'  - Managing model uses window operations.\n." :type 'list :group 'xwem)

(defcustom xwem-manage-list nil "List where each element in form:\n\n(MANAGE-TYPE CLIENT-PLIST MATCH-SPEC)\n\nMANAGE-TYPE is symbol.\n\nCLIENT-PLIST is list of client properties to set when client manages\nand unset when client changes manage type.  In core supported\nproperties are:\n\n  `noselect' - Non-nil mean client can't be selected, usefull for\n               `rooter' clients.\n\n  `no-minib-overlap' - Non-nil to not overlap xwem minibuffer, usefull\n                       for `fullscreen' clients.\n\n  `xwem-icon-name'   - Icon to use for this client.\n\n  `xwem-focus-mode'  - Specifies client's focus mode.\n\n  `xwem-tab-format'  - Format to use in tabber.\n\n  `xwem-tab-face'    - Face to use in tabber.\n\nMATCH-TYPE is a list of match entries, where each entrie TODO:\ndescribe me." :type 'list :group 'xwem)

(defcustom xwem-applications-alist '(("xemacs" (and (class-inst "^emacs$") (class-name "Emacs$"))) ("xterm" (and (class-inst "^xterm$") (class-name "^XTerm$"))) ("xdvi" (and (class-inst "^xdvi$") (class-name "^XDvi$"))) ("djview" (and (class-inst "^djview$") (class-name "^Djview$"))) ("rdesktop" (and (class-inst "^rdesktop$") (class-name "^rdesktop$"))) ("vncviewer" (and (class-inst "^vncviewer$") (class-name "^Vncviewer$"))) ("display" (and (class-inst "^display$") (class-name "^[dD]isplay$"))) ("xv" (and (class-inst "^xv$") (class-name "^XV"))) ("xcalc" (and (class-inst "^xcalc$") (class-name "^XCalc$"))) ("xclock" (and (class-inst "^xclock$") (class-name "^[Xx][cC]lock$"))) ("xload" (and (class-inst "^xload$") (class-name "^XLoad$"))) ("xkeycaps" (and (class-inst "^xkeycaps$") (class-name "^XKeyCaps$"))) ("gimp_startup" (and (class-inst "^gimp_startup$") (class-name "^Gimp$"))) ("gv" (and (class-inst "^gv$") (class-name "^GV$"))) ("ghostview" (and (class-inst "^ghostview$") (class-name "^Ghostview$"))) ("xfd" (and (class-inst "^xfd$") (class-name "^Xfd$"))) ("xfontsel" (and (class-inst "^xfontsel$") (class-name "^XFontSel$"))) ("gnumeric" (and (class-inst "^gnumeric$") (class-name "^Gnumeric$"))) ("ethereal" (and (class-inst "^ethereal$") (class-name "^Ethereal$"))) ("gkrellm" (and (class-inst "gkrellm") (class-name "Gkrellm"))) ("gdesklets" (and (class-inst "^gDesklets$") (class-name "^Gdesklets$"))) ("gdeskcal" (and (class-inst "^gdeskcal$") (class-name "^Gdeskcal$"))) ("links" (and (class-inst "^Links$") (class-name "^Links$"))) ("licq" (and (class-inst "^licq$") (class-name "^Licq$"))) ("mozilla" (or (class-name "^[mM]ozilla") (class-inst "^[mM]ozilla"))) ("xmms" (class-name "^[Xx]mms$")) ("xine" (class-name "^xine$")) ("mplayer" (class-name "^MPlayer$")) ("xchat" (class-name "^X-Chat$")) ("gimp" (class-name "^Gimp$")) ("ddd" (class-name "^Ddd$")) ("firefox" (class-name "^Firefox")) ("opera" (class-name "^Opera$")) ("xpdf" (class-name "^Xpdf$")) ("acroread" (class-name "^AcroRead$")) ("gnuplot" (name "^Gnuplot$")) ("xchm" (name "^xCHM"))) "Alist of known applications.\nCAR is appllication name, CDR is match-spec.\n\nUse `xwem-appcollect' to create `xwem-applications-alist'." :type '(cons string sexp) :group 'xwem)

(defvar xwem-manage-expectances nil "\
List of expectances in `xwem-manage-list' format.
The difference from `xwem-manage-list' is that, when matching occurs
in `xwem-manage-expectances', matched entry removed from
`xwem-manage-expectances' list.")

;;;***

;;;### (autoloads (xwem-minibuffer-init) "xwem-minibuffer" "lisp/xwem-minibuffer.el")

(defcustom xwem-minibuffer-focusin-hook nil "*Hooks called when xwem minibuffer got focus." :type 'hook :group 'xwem-minibuffer :group 'xwem-hooks)

(defcustom xwem-minibuffer-focusout-hook nil "*Hooks called when xwem minibuffer lose focus." :type 'hook :group 'xwem-minibuffer :group 'xwem-hooks)
(autoload 'xwem-minibuffer-activate "xwem-minibuffer" "" t)

(autoload 'xwem-minibuffer-init "xwem-minibuffer" "\
Initialize xwem minibuffer." nil nil)
(autoload 'xwem-minib-resize-mode "xwem-minibuffer" "" t)
(autoload 'xwem-modeline-enable "xwem-minibuffer" nil t)
(autoload 'xwem-modeline-disable "xwem-minibuffer" nil t)

;;;***

;;;### (autoloads (xwem-misc-profiling-results xwem-misc-start-profiling) "xwem-misc" "lisp/xwem-misc.el")

(defcustom xwem-messages-ignore-labels '(prompt progress nolog) "*List of message labels to ignore putting them into xwem message log buffer." :type '(repeat (choice (symbol :tag "Custom label") (const :tag "Alarm" alarm) (const :tag "Error" error) (const :tag "Warning" warning) (const :tag "Info" info) (const :tag "Note" note) (const :tag "TODO" todo) (const :tag "Prompt" prompt) (const :tag "Progress" progress) (const :tag "NoLog" nolog))) :group 'xwem-misc)
(autoload 'xwem-show-message-log "xwem-misc" nil t)
(autoload 'xwem-ignore-command "xwem-misc" nil t)
(autoload 'xwem-eval-expression "xwem-misc" nil t)
(autoload 'xwem-execute-extended-command "xwem-misc" nil t)
(autoload 'xwem-shell-command "xwem-misc" nil t)
(autoload 'xwem-mini-calc "xwem-misc" nil t)
(autoload 'xwem-misc-make-screenshot "xwem-misc" nil t)
(autoload 'xwem-misc-pause "xwem-misc" nil t)

(autoload 'xwem-misc-start-profiling "xwem-misc" "\
Start profiling critical xlib/xwem functions." t nil)

(autoload 'xwem-misc-profiling-results "xwem-misc" "\
Show xlib/xwem profiling results." t nil)

;;;***

;;;### (autoloads (xwem-popup-menu xwem-mouse-ungrab xwem-mouse-grab) "xwem-mouse" "lisp/xwem-mouse.el")

(autoload 'xwem-mouse-grab "xwem-mouse" "\
Begin to grab mouse, showing CURSOR in WIN using event mask MASK.
Default WIN is root window.
Default MASK is capturing ButtonPress or ButtonRelease events." nil nil)

(autoload 'xwem-mouse-ungrab "xwem-mouse" "\
Stop grabing mouse.
If FLUSH-P is non-nil, mouse is ungrabbed imediately." nil nil)

(autoload 'xwem-popup-menu "xwem-mouse" "\
Popup MENU.
MENU and EVENT is same as for `popup-menu'." nil nil)
(autoload 'xwem-popup-clients-menu "xwem-mouse" nil t)
(autoload 'xwem-popup-auto-menu "xwem-mouse" nil t)

;;;***

;;;### (autoloads (xwem-manage-fullscreen) "xwem-netwm" "lisp/xwem-netwm.el")
(autoload 'xwem-fullscreen-mode "xwem-netwm" nil t)

(autoload 'xwem-manage-fullscreen "xwem-netwm" "\
Manage method for fullscreen client CL." nil nil)
(put 'manage 'fullscreen 'xwem-manage-fullscreen)
(autoload 'xwem-toggle-fullscreen "xwem-netwm" nil t)
(autoload 'xwem-switch-to-fullscreen-cl "xwem-netwm" nil t)

;;;***

;;;### (autoloads (xwem-osd-create-dock xwem-osd-create) "xwem-osd" "lisp/xwem-osd.el")

(autoload 'xwem-osd-create "xwem-osd" "\
On X display XDPY create new xwem osd context with +X+Y/WIDTHxHEIGHT geometry on X-PARENT.
PROPERTIES is a plist for osd.  Supported properties are:
 
 'keymap     - Keymap for OSD.
 'stack-rank - Rank of OSD in windows stack." nil nil)

(autoload 'xwem-osd-create-dock "xwem-osd" "\
Create docked osd instance.
XDPY - Display.
X, Y, WIDTH, HEIGHT - OSD Geometry." nil nil)

;;;***

;;;### (autoloads (xwem-pager-install-bindings xwem-pager-make-frames xwem-pager) "xwem-pager" "lisp/xwem-pager.el")

(autoload 'xwem-pager "xwem-pager" "\
Start xwem pager dockapp.
DOCKID, DOCKGROUP and DOCKALIGN specifies pager placement in xwem
tray." t nil)

(autoload 'xwem-pager-make-frames "xwem-pager" "\
Make the frames, call from XWEM-AFTER-INIT-HOOK!" nil nil)
(autoload 'xwem-pager-move-up "xwem-pager" nil t)
(autoload 'xwem-pager-move-down "xwem-pager" nil t)
(autoload 'xwem-pager-move-left "xwem-pager" nil t)
(autoload 'xwem-pager-move-right "xwem-pager" nil t)

(autoload 'xwem-pager-install-bindings "xwem-pager" "\
Install default bindings for 2D frames commands." nil nil)

;;;***

;;;### (autoloads nil "xwem-recover" "lisp/xwem-recover.el")
(autoload 'xwem-recover-do-recover "xwem-recover" "" t)
(autoload 'xwem-recover-turn-on "xwem-recover" "" t)
(autoload 'xwem-recover-turn-off "xwem-recover" "" t)
(autoload 'xwem-recover-toggle "xwem-recover" "" t)

;;;***

;;;### (autoloads nil "xwem-register" "lisp/xwem-register.el")
(autoload 'xwem-register-client "xwem-register" "" t)
(autoload 'xwem-register-win-config "xwem-register" "" t)
(autoload 'xwem-register-frame-config "xwem-register" "" t)
(autoload 'xwem-register-jump "xwem-register" "" t)

;;;***

;;;### (autoloads (xwem-report-bug) "xwem-report" "lisp/xwem-report.el")

(autoload 'xwem-report-bug "xwem-report" "\
Submit a bug report for XWEM.
Optional argument BLURB is a string that adds a preamble to the bug report.
Optional argument NO-CONFIRM if 't' will not ask for confirmation." t nil)

;;;***

;;;### (autoloads (xwem-root-events-handler xwem-root-refresh xwem-fini-root) "xwem-root" "lisp/xwem-root.el")

(autoload 'xwem-fini-root "xwem-root" nil nil nil)

(autoload 'xwem-root-refresh "xwem-root" "\
Refresh area WIDTHxHEIGHT+X+Y.
Probably will not work if backing store enabled in some window." nil nil)

(autoload 'xwem-root-events-handler "xwem-root" "\
Events handler for root window." nil nil)

;;;***

;;;### (autoloads (xwem-manage-rooter) "xwem-rooter" "lisp/xwem-rooter.el")
(autoload 'xwem-rooter-raise "xwem-rooter" nil t)
(autoload 'xwem-rooter-lower "xwem-rooter" nil t)

(autoload 'xwem-manage-rooter "xwem-rooter" "\
Manage rooter client CL." nil nil)
(put 'manage 'rooter 'xwem-manage-rooter)

;;;***

;;;### (autoloads nil "xwem-selections" "lisp/xwem-selections.el")
(autoload 'xwem-help-cutbuffers "xwem-selections" "Display help about cutbuffers." t)
(autoload 'xwem-copy-cutbuffer "xwem-selections" "Copy CUTBUFFER0 to `xwem-selections'." t)
(autoload 'xwem-paste-cutbuffer "xwem-selections" "Paste CUTBUFFER0 to `xwem-selections'." t)
(autoload 'xwem-copy-region-as-cutbuffer "xwem-selections" "Copy region to `xwem-selections'." t)

;;;***

;;;### (autoloads nil "xwem-smartmods" "lisp/xwem-smartmods.el")
(autoload 'xwem-sm-mode "xwem-smartmods" nil t)
(autoload 'xwem-sm-global-mode "xwem-smartmods" nil t)

;;;***

;;;### (autoloads (xwem-sound-load-default xwem-play-sound) "xwem-sound" "lisp/xwem-sound.el")

(defcustom xwem-sound-list '((xwem-sound-file-load "bass-snap" 'bass 100) (xwem-sound-file-load "drum-beep" 'drum 100) (xwem-sound-file-load "quiet-beep" 'quiet 100) (xwem-sound-file-load "cuckoo" 'cuckoo 100) (xwem-sound-file-load "clink" 'clink 100) (xwem-sound-file-load "bong" 'bong 100) (xwem-sound-file-load "say-beep" 'say-beep 100)) "A list of calls to `xwem-sound-file-load' to be processed by `xwem-sound-load-default'.\nReference `xwem-sound-file-load' for detailed information." :type '(repeat (sexp :tag "Sound")) :group 'xwem-sound)

(defvar xwem-sound-alist nil "\
Sound alist for use by XWEM.
Format is identical as for `sound-alist'.
Error symbols are:
  default -- When nothing else matches.
  quit -- After \\<xwem-global-map>\\[xwem-kbd-quit]
  undefined-key -- Keybinding undefined.
  command-fail -- When execution of command failed.
  warning -- Some one warnings you.
  error -- Some one reports you an error.
  ready -- Time consumed task has been done.
  alarm -- Used by reminders.")

(autoload 'xwem-play-sound "xwem-sound" "\
Play a sound of provided SOUND type.
If VOLUME is specified, it overrides the value specified in
`xwem-sound-alist'." nil nil)

(autoload 'xwem-sound-load-default "xwem-sound" "\
Loads and install `xwem-sound-default-alist'.
If X-BEEP is non-nil, `xwem-sound-beeping-alist' will be loaded." nil nil)

;;;***

;;;### (autoloads (xwem-manage-emacs-special) "xwem-special" "lisp/xwem-special.el")

(autoload 'xwem-manage-emacs-special "xwem-special" "\
Manage method for special emacs frame client CL." nil nil)

;;;***

;;;### (autoloads nil "xwem-strokes" "lisp/xwem-strokes.el")
(autoload 'xwem-strokes-define "xwem-strokes" "" t)
(autoload 'xwem-strokes-ibutton1 "xwem-strokes" "" t)
(autoload 'xwem-strokes-idescribe "xwem-strokes" "" t)
(autoload 'xwem-strokes-ibutton1up "xwem-strokes" "" t)
(autoload 'xwem-strokes-ibutton3 "xwem-strokes" "" t)
(autoload 'xwem-strokes-nocmd "xwem-strokes" "" t)
(autoload 'xwem-strokes-begin "xwem-strokes" "" t)
(autoload 'xwem-strokes-cmplx-begin "xwem-strokes" "" t)
(autoload 'xwem-strokes-unset-last-stroke "xwem-strokes" "" t)
(autoload 'xwem-strokes-list "xwem-strokes" "" t)

;;;***

;;;### (autoloads nil "xwem-tabbing" "lisp/xwem-tabbing.el")

(defvar xwem-tabber-click-frame nil "\
Will be binded to frame when tabber clicked.")

(defvar xwem-tabber-click-cl nil "\
Will be binded to cl when tabber clicked.")
(autoload 'xwem-tabber-switch-cl "xwem-tabber" "" t)
(autoload 'xwem-tabber-popup-cl-menu "xwem-tabber" "" t)

;;;***

;;;### (autoloads nil "xwem-theme" "lisp/xwem-theme.el")
(autoload 'xwem-theme-set "xwem-theme" nil t)

;;;***

;;;### (autoloads (xwem-time) "xwem-time" "lisp/xwem-time.el")

(autoload 'xwem-time "xwem-time" "\
Start xwem time window in system tray." t nil)

;;;***

;;;### (autoloads (xwem-manage-systray xwem-tray-delimeter) "xwem-tray" "lisp/xwem-tray.el")

(autoload 'xwem-tray-delimeter "xwem-tray" "\
Add delimiter to dockapp.
W and H specifies delimiter width and height.
BGCOL - background color." nil nil)

(autoload 'xwem-manage-systray "xwem-tray" "\
Manage method for systray dockaps." nil nil)

;;;***

;;;### (autoloads nil "xwem-version" "lisp/xwem-version.el")

(defconst xwem-version "lg@xwem.org--2005/xwem--main--2.1--versionfix-1")

;;;***

;;;### (autoloads nil "xwem-vline" "lisp/xwem-vline.el")
(autoload 'xwem-turn-on-vline "xwem-vline" nil t)
(autoload 'xwem-turn-off-vline "xwem-vline" nil t)
(autoload 'xwem-vline-minor-mode "xwem-vline" nil t)

;;;***

;;;### (autoloads (xwem-weather-init) "xwem-weather" "lisp/xwem-weather.el")
(autoload 'xwem-weather-prefix "xwem-weather" nil nil 'keymap)
(autoload 'xwem-weather-update "xwem-weather" nil t)
(autoload 'xwem-weather-show-details "xwem-weather" nil t)
(autoload 'xwem-weather-popup-remove "xwem-weather" nil t)
(autoload 'xwem-weather-popup-menu "xwem-weather" nil t)

(autoload 'xwem-weather-init "xwem-weather" "\
Initialise the weather dock." nil nil)

;;;***

;;;### (autoloads (xwem-win-new) "xwem-win" "lisp/xwem-win.el")

(defcustom xwem-win-min-width 80 "*Minimal width for window" :type 'number :group 'xwem-win)

(defcustom xwem-win-min-height 80 "*Minimal height for window" :type 'number :group 'xwem-win)

(defcustom xwem-win-split-hook nil "Hook to be called after window split.\nFunctions will be called with two arguments: SPLIT-WIN, NEW-WIN." :type 'hook :group 'xwem-hooks)

(autoload 'xwem-win-new "xwem-win" "\
Create new window with properties PROPS." nil nil)
(autoload 'xwem-other-window "xwem-win" "Switch to other window." t)
(autoload 'xwem-winmove-up "xwem-win" "" t)
(autoload 'xwem-winmove-down "xwem-win" "" t)
(autoload 'xwem-winmove-left "xwem-win" "" t)
(autoload 'xwem-winmove-right "xwem-win" "" t)
(autoload 'xwem-window-delete "xwem-win" "Delete selected WINDOW." t)
(autoload 'xwem-window-delete-others "xwem-win" nil t)
(autoload 'xwem-balance-windows "xwem-win" "" t)
(autoload 'xwem-window-split-horizontally "xwem-win" nil t)
(autoload 'xwem-window-split-vertically "xwem-win" nil t)
(autoload 'xwem-window-enlarge-horizontally "xwem-win" nil t)
(autoload 'xwem-window-enlarge-vertically "xwem-win" nil t)

;;;***

;;;### (autoloads (xwem-worklog-start-dockapp) "xwem-worklog" "lisp/xwem-worklog.el")

(defcustom xwem-worklog-load-hook nil "*Hooks to run when `xwem-worklog' loaded." :type 'hook :group 'xwem-worklog)

(defcustom xwem-worklog-task-start-hook nil "*Hooks to run when new task just started." :type 'hook :group 'xwem-worklog)

(defcustom xwem-worklog-task-stop-hook nil "*Hooks to run when task just stoped." :type 'hook :group 'xwem-worklog)

(defcustom xwem-worklog-task-pause-hook nil "*Hooks to run when task is paused." :type 'hook :group 'xwem-worklog)

(defcustom xwem-worklog-task-resume-hook nil "*Hooks to run when task is resumed." :type 'hook :group 'xwem-worklog)

(defcustom xwem-worklog-login-hook nil "*Hooks to run when login." :type 'hook :group 'xwem-worklog)

(defcustom xwem-worklog-logout-hook nil "*Hooks to run when logout." :type 'hook :group 'xwem-worklog)

(defcustom xwem-worklog-tasks-description '(("Web browsing" (:key [(hyper ?w)] :color "dodgerblue" :cost 0) (or (application "mozilla") (application "firefox") (application "links") (buffer-major-mode w3m-mode) (and (application "xemacs") (name "\\*w3m\\*")))) ("Mail reading" (:key [(hyper ?m) ?r] :color "blue1" :cost 0) (or (buffer-major-mode gnus-group-mode) (buffer-major-mode gnus-article-mode) (buffer-major-mode gnus-summary-mode) (and (application "xemacs") (name "\\*\\(Group\\|Summary\\|Article\\)")))) ("Mail writing" (:key [(hyper ?m) ?w] :color "blue4" :cost 0) (or (buffer-major-mode message-mode) (buffer-major-mode bbdb-mode) (and (application "xemacs") (name "\\*\\(BBDB\\*\\|mail\\*\\|wide reply\\|reply\\)")))) ("Chating" (:key [?C] :color "palegreen" :cost 0) (or (buffer-major-mode erc-mode) (buffer-major-mode eicq-buddy-mode) (buffer-major-mode eicq-log-mode) (and (application "xemacs") (or (name "\\*Status\\*") (name "\\(#eicq\\|#xemacs\\|#sxemacs\\|irc\\.freenode\\.org\\)"))) (application "licq") (name "[LlMmVv][Ii][Cc][Qq]"))) ("Info/man reading" (:key [(hyper ?i)] :color "cyan" :cost 10) (or (buffer-major-mode Manual-mode) (buffer-major-mode Info-mode) (buffer-major-mode hyper-apropos-mode) (and (application "xemacs") (name "\\(\\*info\\*\\|Man: \\|\\*Help\\*\\|\\*Hyper Apropos\\*\\)")) (class-name "Xman"))) ("Emacs lisping" (:key [(hyper ?e)] :color "yellow2" :cost 0) (or (buffer-major-mode emacs-lisp-mode) (buffer-major-mode lisp-interaction-mode) (and (application "xemacs") (name "\\(\\*scratch\\*\\|\\.el\\)")))) ("C for fun" (:key [(hyper ?f)] :color "tomato" :cost 0)) ("C for profit" (:key [(hyper ?p)] :color "magenta" :cost 100) (or (buffer-major-mode cvs-mode) (buffer-major-mode c-mode) (buffer-major-mode gdb-mode) (application "ddd") (and (or (application "xemacs") (and (class-inst "^.term$") (class-name "^.Term$"))) (name "\\(gdb\\|\\*cvs\\*\\|\\.[ch]\\)")))) ("WorkProject" (:key [(hyper ?c)] :color "green2" :cost 200)) ("Administrativa" (:key [(hyper ?a)] :color "lightblue" :cost 150) (or (application "ethereal") (and (application "xterm") (name "\\(tcpdump\\|ssh\\)")))) ("Windows remote" (:color "lightcyan") (application "rdesktop")) ("Smoke" (:key [(hyper ?s)] :color "red3" :cost -50)) ("Nothing" (:key [(hyper ?n)] :color "gray80" :cost 50)) ("Unknown" (:color "gray50" :cost 0) (eval t))) "List of task descriptions in `xwem-manage-list' format.\n\nSupported properties are:\n\n  :key   - Key to bind task in `xwem-worklog-map'.\n  :color - Color to use when drawing some task related info.\n  :cost  - Task cost in $/hour. (not implemented)\n  :image - Use image instead of :color. (not implemented)\n\nYou could define your own properties, which you will handle for\nyourself.\n" :type '(repeat sexp) :group 'xwem-worklog)
(autoload 'xwem-worklog-prefix "xwem-worklog" nil nil 'keymap)
(autoload 'xwem-worklog-login "xwem-worklog" nil t)
(autoload 'xwem-worklog-logout "xwem-worklog" nil t)

(autoload 'xwem-worklog-start-dockapp "xwem-worklog" "\
Start xwem worklog dockapp." nil nil)

;;;***

(provide 'xwem-autoloads)
