/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import jde.debugger.CommandStream;
import jde.debugger.Jdebug;
import jde.debugger.Protocol;

public class JDE
implements Protocol {
    BufferedReader in;
    PrintWriter out;
    CommandStream commandStream;
    private static JDE jde = new JDE();

    private JDE() {
    }

    public void init() {
        this.out = new PrintWriter(System.out);
        this.in = new BufferedReader(new InputStreamReader(System.in));
        this.commandStream = new CommandStream(this.in);
    }

    public List nextCommand() {
        return this.commandStream.nextCommand();
    }

    public String stringRep(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof String) {
            return "\"" + obj.toString() + "\"";
        }
        if (obj instanceof List) {
            StringBuffer returnString = new StringBuffer("");
            Iterator it = ((List)obj).iterator();
            while (it.hasNext()) {
                returnString.append(this.stringRep(it.next()) + " ");
            }
            return Protocol.BR + returnString.toString().trim();
        }
        return obj.toString();
    }

    public synchronized void signal(Integer app_id, String type, Object obj) {
        String strRep = this.stringRep(obj);
        if (strRep.equals("")) {
            System.out.println(Protocol.BR + "(" + "jde-dbo-" + type + " " + app_id + ")" + Protocol.BR);
        } else {
            String temp = "(jde-dbo-" + type + Protocol.BR + app_id + " " + this.stringRep(obj) + ")";
            if (temp.length() <= 80) {
                System.out.println(Protocol.BR + "(" + "jde-dbo-" + type + " " + app_id + " " + this.stringRep(obj) + ")" + Protocol.BR);
            } else {
                System.out.println(Protocol.BR + temp + Protocol.BR);
            }
        }
        System.out.flush();
    }

    private synchronized void signalReply(Integer app_id, Integer cmd_id, Object obj, String type) {
        String strRep = this.stringRep(obj);
        if (strRep.equals("")) {
            System.out.println(Protocol.BR + "(" + type + " " + cmd_id + ")" + Protocol.BR);
        } else {
            String temp = "(" + type + Protocol.BR + cmd_id + " " + strRep + ")";
            if (temp.length() <= 80) {
                System.out.println(Protocol.BR + "(" + type + " " + cmd_id + " " + strRep + ")" + Protocol.BR);
            } else {
                System.out.println(Protocol.BR + temp + Protocol.BR);
            }
        }
        System.out.flush();
    }

    public void signalCommandResult(Integer app_id, Integer cmd_id) {
        this.signalCommandResult(app_id, cmd_id, null);
    }

    public void signalDebug(String msg) {
        this.signal(Jdebug.debuggerID, "message", msg);
    }

    public synchronized void signalCommandResult(Integer app_id, Integer cmd_id, Object obj) {
        this.signalReply(app_id, cmd_id, obj, "jde-dbo-command-result");
    }

    public synchronized void signalCommandError(Integer app_id, Integer cmd_id, Object obj) {
        this.signalReply(app_id, cmd_id, obj, "jde-dbo-command-error");
    }

    public static JDE getJDE() {
        return jde;
    }
}

