/*
 * Copyright (C) 1999, 2000, 2001  Lorenzo Bettini <bettini@gnu.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* 
 * src/envmapper.c -- maps QUERY_STRING environment to argv
 *
 * 06.04.2001 [SPX] completed initial revision
 * 05.04.2001 [SPX] initial revision
 *
 * written by Robert Wetzel <rw8@mail.inf.tu-dresden.de>
 */

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "envmapper.h"

char *
__get_option_string(char *token)
{
  char *new_token;

  new_token = (char*)calloc(strlen(token)+3, 1);
  sprintf(new_token, "--%s", token);
  return new_token;
}

char **
map_environment(int *argc, char **argv)
{
  char *query_string, *token;
  char **new_argv;

  // check first, if CGI environment exists
  query_string = getenv("QUERY_STRING");
  if (!query_string)
    return argv;
  // ok. assume this is run as a CGI program...
  // allocate memory for the new argv which may hold up to 128 options
  new_argv = (char**)calloc(MAX_PARAM_AMOUNT, sizeof argv);
  // 'copy' parameter strings
  memcpy(new_argv, argv, *argc * sizeof argv);
  token = strtok(query_string, "&");
  do {
    new_argv[(*argc)++] = __get_option_string(token);
  }
  while ((token = strtok(NULL, "&")));
  return new_argv;
}
