"======================================================================
|
|   Smalltalk Tk-based GUI building blocks (hand-written part).
|
 ======================================================================"


"======================================================================
|
| Copyright 2001, 2003 Free Software Foundation, Inc.
| Written by Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"

Smalltalk addSubspace: #GTK!
Namespace current: GTK!

DLD addLibrary: 'libglib-2.0'.
DLD addLibrary: 'libpango-1.0'.
DLD addLibrary: 'libpangox-1.0'.
DLD addLibrary: 'libgdk-x11-2.0'.
DLD addLibrary: 'libgtk-x11-2.0'.
DLD addModule: 'blox-gtk'!

Object subclass: #Pango
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Gtk'!

Object subclass: #Gdk
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Gtk'!

Object subclass: #Gtk
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Gtk'!

Object subclass: #Atk
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Gtk'!

Object subclass: #GLib
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Gtk'!

FileStream fileIn: 'Structs.st'!
FileStream fileIn: 'Enums.st'!
FileStream fileIn: 'Funcs.st'!

Gtk class defineCFunc: 'bloxGtkInit'
	withSelectorArgs: 'bloxGtkInit'
	returning: #void
	args: #()!

"These differ from the standard implementation in that they run
 until all events are done.  We also need to redefine them so that
 they are asynchronous"
Gtk
	defineAsyncCFunc: 'bloxGtkMainIteration'
	withSelectorArgs: 'mainIteration'
	args: #( )!

Gtk
	defineAsyncCFunc: 'bloxGtkMainIterationDo'
	withSelectorArgs: 'mainIterationDo: blocking'
	args: #( #boolean )!

Gtk
	defineCFunc: 'bloxGtkShouldQuit'
	withSelectorArgs: 'shouldQuit'
	returning: #boolean
	args: #( )!

GObject
	defineCFunc: 'bloxGtkConnectSignal'
	withSelectorArgs: 'connectSignal: name to: handler userData: userData'
	returning: #void
	args: #( #selfSmalltalk #string #smalltalk #smalltalk )!


!GtkRequisition class methodsFor: 'instance creation'!

fromPoint: point
    | ba |
    ba := (CShortType arrayType: 2) new.
    ba at: 0 put: point x.
    ba at: 1 put: point y.
    ^(ba castTo: self type) addToBeFinalized; yourself! !

!GtkRequisition methodsFor: 'accessing'!

x
    | ba |
    ba := self castTo: (CShortType arrayType: 4).
    ^ba at: 0!

y
    | ba |
    ba := self castTo: (CShortType arrayType: 4).
    ^ba at: 1! !

!GtkRequisition methodsFor: 'conversion'!

asPoint
    | ba |
    ba := self castTo: (CShortType arrayType: 4).
    ^(ba at: 0) @ (ba at: 1)!

!GdkRectangle class methodsFor: 'instance creation'!

fromRectangle: rect
    | ba |
    ba := (CShortType arrayType: 4) new.
    ba at: 0 put: rect left.
    ba at: 1 put: rect top.
    ba at: 2 put: rect width.
    ba at: 3 put: rect height.
    ^(ba castTo: self type) addToBeFinalized; yourself! !

!GdkRectangle methodsFor: 'accessing'!

left
    | ba |
    ba := self castTo: (CShortType arrayType: 4).
    ^ba at: 0!

top
    | ba |
    ba := self castTo: (CShortType arrayType: 4).
    ^ba at: 1!

right
    | ba |
    ba := self castTo: (CShortType arrayType: 4).
    ^(ba at: 0) + (ba at: 2)!

bottom
    | ba |
    ba := self castTo: (CShortType arrayType: 4).
    ^(ba at: 1) + (ba at: 3)!

width
    | ba |
    ba := self castTo: (CShortType arrayType: 4).
    ^ba at: 2!

height
    | ba |
    ba := self castTo: (CShortType arrayType: 4).
    ^ba at: 3!

origin
    | ba |
    ba := self castTo: (CShortType arrayType: 4).
    ^(ba at: 0) @ (ba at: 1)!

extent
    | ba |
    ba := self castTo: (CShortType arrayType: 4).
    ^(ba at: 2) @ (ba at: 3)!

corner
    | ba |
    ba := self castTo: (CShortType arrayType: 4).
    ^((ba at: 0) + (ba at: 2)) @ ((ba at: 1) + (ba at: 3))! !

!GdkRectangle methodsFor: 'conversion'!

asRectangle
    | ba |
    ba := self castTo: (CShortType arrayType: 4).
    ^(ba at: 0) @ (ba at: 1) extent:
        (ba at: 2) @ (ba at: 3)! !

Namespace current: Smalltalk!
