/* A Bison parser, made by GNU Bison 3.6.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2020 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Bison version.  */
#define YYBISON_VERSION "3.6.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 1

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1

/* Substitute the type names.  */
#define YYSTYPE         STRUCTURED_STYPE
#define YYLTYPE         STRUCTURED_LTYPE
/* Substitute the variable and function names.  */
#define yyparse         structured_parse
#define yylex           structured_lex
#define yyerror         structured_error
#define yydebug         structured_debug
#define yynerrs         structured_nerrs

/* First part of user prologue.  */
#line 24 "../../jitter/example-vms/structured/structured.y"

#include <stdio.h>
#include <ctype.h>
#include <jitter/jitter-malloc.h>
#include <jitter/jitter-fatal.h>
#include <jitter/jitter-parse-int.h>
#include <jitter/jitter-string.h>

#include "structured-syntax.h"
#include "structured-parser.h"
#include "structured-scanner.h"

/* This is currently a fatal error.  I could longjmp away instead. */
static void
structured_error (YYLTYPE *locp, struct structured_program *p,
                  yyscan_t scanner, char *message)
  __attribute__ ((noreturn));

#define STRUCTURED_PARSE_ERROR(message)                            \
  do                                                               \
    {                                                              \
      structured_error (structured_get_lloc (structured_scanner),  \
                        p, structured_scanner, message);           \
    }                                                              \
  while (false)

/* What would be yytext in a non-reentrant scanner. */
#define STRUCTURED_TEXT \
  (structured_get_text (structured_scanner))

 /* What would be yylineno in a non-reentrant scanner. */
#define STRUCTURED_LINENO \
  (structured_get_lineno (structured_scanner))

/* A copy of what would be yytext in a non-reentrant scanner. */
#define STRUCTURED_TEXT_COPY \
  (jitter_clone_string (STRUCTURED_TEXT))

/* Return a pointer to a fresh malloc-allocated expression of the given case.
   No field is initialized but case_. */
static struct structured_expression*
structured_make_expression (enum structured_expression_case case_)
{
  struct structured_expression *res
    = jitter_xmalloc (sizeof (struct structured_expression));
  res->case_ = case_;

  return res;
}

/* Return a pointer to a fresh malloc-allocated expression of the primitive
   case, with the given binary primitive and operands.  Every field is
   initalized. */
static struct structured_expression*
structured_make_binary (enum structured_primitive primitive,
                        struct structured_expression *operand_0,
                        struct structured_expression *operand_1)
{
  struct structured_expression *res
    = structured_make_expression (structured_expression_case_primitive);
  res->primitive = primitive;
  res->primitive_operand_0 = operand_0;
  res->primitive_operand_1 = operand_1;
  return res;
}

/* Return a pointer to a fresh malloc-allocated expression of the primitive
   case, with the given nullary primitive.  Every field is initalized. */
static struct structured_expression*
structured_make_nullary (enum structured_primitive primitive)
{
  return structured_make_binary (primitive, NULL, NULL);
}

/* Return a pointer to a fresh malloc-allocated expression of the primitive
   case, with the given unary primitive and operand.  Every field is
   initalized. */
static struct structured_expression*
structured_make_unary (enum structured_primitive primitive,
                       struct structured_expression *operand_0)
{
  return structured_make_binary (primitive, operand_0, NULL);
}

/* Return a pointer to a fresh malloc-allocated statement of the given case.
   No field is initialized but case_. */
static struct structured_statement*
structured_make_statement (enum structured_statement_case case_)
{
  struct structured_statement *res
    = jitter_xmalloc (sizeof (struct structured_statement));
  res->case_ = case_;

  return res;
}

/* If the pointed expressions is non-NULL return a pointer to a fresh
   malloc-allocated statement containing a sequence setting the given variable
   to the pointed expression, and then the pointed statement.  If the expression
   pointer is NULL just return the pointed body without allocating anything
   more. */
static struct structured_statement*
structured_with_optional_initialization (structured_variable v,
                                         struct structured_expression *e,
                                         struct structured_statement *body)
{
  if (e == NULL)
    return body;
  else
    {
      struct structured_statement *sequence
        = structured_make_statement (structured_statement_case_sequence);
      struct structured_statement *assignment
        = structured_make_statement (structured_statement_case_assignment);
      assignment->assignment_variable = v;
      assignment->assignment_expression = e;
      sequence->sequence_statement_0 = assignment;
      sequence->sequence_statement_1 = body;
      return sequence;
    }
}


#line 202 "../../jitter/example-vms/structured/structured-parser.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

/* Use api.header.include to #include this header
   instead of duplicating it here.  */
#ifndef YY_STRUCTURED_JITTER_EXAMPLE_VMS_STRUCTURED_STRUCTURED_PARSER_H_INCLUDED
# define YY_STRUCTURED_JITTER_EXAMPLE_VMS_STRUCTURED_STRUCTURED_PARSER_H_INCLUDED
/* Debug traces.  */
#ifndef STRUCTURED_DEBUG
# if defined YYDEBUG
#if YYDEBUG
#   define STRUCTURED_DEBUG 1
#  else
#   define STRUCTURED_DEBUG 0
#  endif
# else /* ! defined YYDEBUG */
#  define STRUCTURED_DEBUG 0
# endif /* ! defined YYDEBUG */
#endif  /* ! defined STRUCTURED_DEBUG */
#if STRUCTURED_DEBUG
extern int structured_debug;
#endif
/* "%code requires" blocks.  */
#line 178 "../../jitter/example-vms/structured/structured.y"

/* Simplified error-reporting facilities calling structured_error, suitable to be
   called from the scanner and the parser without the complicated and
   irrelevant parameters needed by structured_error . */
void
structured_scan_error (void *structured_scanner) __attribute__ ((noreturn));

struct structured_program *
structured_parse_file_star (FILE *input_file);

struct structured_program *
structured_parse_file (const char *input_file_name);

#line 259 "../../jitter/example-vms/structured/structured-parser.c"

/* Token kinds.  */
#ifndef STRUCTURED_TOKENTYPE
# define STRUCTURED_TOKENTYPE
  enum structured_tokentype
  {
    STRUCTURED_EMPTY = -2,
    STRUCTURED_EOF = 0,            /* "end of file"  */
    STRUCTURED_error = 256,        /* error  */
    STRUCTURED_UNDEF = 257,        /* "invalid token"  */
    BEGIN_ = 258,                  /* BEGIN_  */
    END = 259,                     /* END  */
    SKIP = 260,                    /* SKIP  */
    VAR = 261,                     /* VAR  */
    PRINT = 262,                   /* PRINT  */
    INPUT = 263,                   /* INPUT  */
    SET_TO = 264,                  /* SET_TO  */
    SEMICOLON = 265,               /* SEMICOLON  */
    COMMA = 266,                   /* COMMA  */
    IF = 267,                      /* IF  */
    THEN = 268,                    /* THEN  */
    ELSE = 269,                    /* ELSE  */
    ELIF = 270,                    /* ELIF  */
    WHILE = 271,                   /* WHILE  */
    DO = 272,                      /* DO  */
    REPEAT = 273,                  /* REPEAT  */
    UNTIL = 274,                   /* UNTIL  */
    OPEN_PAREN = 275,              /* OPEN_PAREN  */
    CLOSE_PAREN = 276,             /* CLOSE_PAREN  */
    VARIABLE = 277,                /* VARIABLE  */
    DECIMAL_LITERAL = 278,         /* DECIMAL_LITERAL  */
    TRUE = 279,                    /* TRUE  */
    FALSE = 280,                   /* FALSE  */
    PLUS = 281,                    /* PLUS  */
    MINUS = 282,                   /* MINUS  */
    TIMES = 283,                   /* TIMES  */
    DIVIDED = 284,                 /* DIVIDED  */
    REMAINDER = 285,               /* REMAINDER  */
    EQUAL = 286,                   /* EQUAL  */
    DIFFERENT = 287,               /* DIFFERENT  */
    LESS = 288,                    /* LESS  */
    LESS_OR_EQUAL = 289,           /* LESS_OR_EQUAL  */
    GREATER = 290,                 /* GREATER  */
    GREATER_OR_EQUAL = 291,        /* GREATER_OR_EQUAL  */
    LOGICAL_OR = 292,              /* LOGICAL_OR  */
    LOGICAL_AND = 293,             /* LOGICAL_AND  */
    LOGICAL_NOT = 294,             /* LOGICAL_NOT  */
    UNARY_MINUS = 295              /* UNARY_MINUS  */
  };
  typedef enum structured_tokentype structured_token_kind_t;
#endif
/* Token kinds.  */
#define STRUCTURED_EOF 0
#define STRUCTURED_error 256
#define STRUCTURED_UNDEF 257
#define BEGIN_ 258
#define END 259
#define SKIP 260
#define VAR 261
#define PRINT 262
#define INPUT 263
#define SET_TO 264
#define SEMICOLON 265
#define COMMA 266
#define IF 267
#define THEN 268
#define ELSE 269
#define ELIF 270
#define WHILE 271
#define DO 272
#define REPEAT 273
#define UNTIL 274
#define OPEN_PAREN 275
#define CLOSE_PAREN 276
#define VARIABLE 277
#define DECIMAL_LITERAL 278
#define TRUE 279
#define FALSE 280
#define PLUS 281
#define MINUS 282
#define TIMES 283
#define DIVIDED 284
#define REMAINDER 285
#define EQUAL 286
#define DIFFERENT 287
#define LESS 288
#define LESS_OR_EQUAL 289
#define GREATER 290
#define GREATER_OR_EQUAL 291
#define LOGICAL_OR 292
#define LOGICAL_AND 293
#define LOGICAL_NOT 294
#define UNARY_MINUS 295

/* Value type.  */
#if ! defined STRUCTURED_STYPE && ! defined STRUCTURED_STYPE_IS_DECLARED
union STRUCTURED_STYPE
{
#line 193 "../../jitter/example-vms/structured/structured.y"

  jitter_int literal;
  structured_variable variable;
  struct structured_expression *expression;
  struct structured_statement *statement;

#line 365 "../../jitter/example-vms/structured/structured-parser.c"

};
typedef union STRUCTURED_STYPE STRUCTURED_STYPE;
# define STRUCTURED_STYPE_IS_TRIVIAL 1
# define STRUCTURED_STYPE_IS_DECLARED 1
#endif

/* Location type.  */
#if ! defined STRUCTURED_LTYPE && ! defined STRUCTURED_LTYPE_IS_DECLARED
typedef struct STRUCTURED_LTYPE STRUCTURED_LTYPE;
struct STRUCTURED_LTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
};
# define STRUCTURED_LTYPE_IS_DECLARED 1
# define STRUCTURED_LTYPE_IS_TRIVIAL 1
#endif



int structured_parse (struct structured_program *p, void* structured_scanner);

#endif /* !YY_STRUCTURED_JITTER_EXAMPLE_VMS_STRUCTURED_STRUCTURED_PARSER_H_INCLUDED  */
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_BEGIN_ = 3,                     /* BEGIN_  */
  YYSYMBOL_END = 4,                        /* END  */
  YYSYMBOL_SKIP = 5,                       /* SKIP  */
  YYSYMBOL_VAR = 6,                        /* VAR  */
  YYSYMBOL_PRINT = 7,                      /* PRINT  */
  YYSYMBOL_INPUT = 8,                      /* INPUT  */
  YYSYMBOL_SET_TO = 9,                     /* SET_TO  */
  YYSYMBOL_SEMICOLON = 10,                 /* SEMICOLON  */
  YYSYMBOL_COMMA = 11,                     /* COMMA  */
  YYSYMBOL_IF = 12,                        /* IF  */
  YYSYMBOL_THEN = 13,                      /* THEN  */
  YYSYMBOL_ELSE = 14,                      /* ELSE  */
  YYSYMBOL_ELIF = 15,                      /* ELIF  */
  YYSYMBOL_WHILE = 16,                     /* WHILE  */
  YYSYMBOL_DO = 17,                        /* DO  */
  YYSYMBOL_REPEAT = 18,                    /* REPEAT  */
  YYSYMBOL_UNTIL = 19,                     /* UNTIL  */
  YYSYMBOL_OPEN_PAREN = 20,                /* OPEN_PAREN  */
  YYSYMBOL_CLOSE_PAREN = 21,               /* CLOSE_PAREN  */
  YYSYMBOL_VARIABLE = 22,                  /* VARIABLE  */
  YYSYMBOL_DECIMAL_LITERAL = 23,           /* DECIMAL_LITERAL  */
  YYSYMBOL_TRUE = 24,                      /* TRUE  */
  YYSYMBOL_FALSE = 25,                     /* FALSE  */
  YYSYMBOL_PLUS = 26,                      /* PLUS  */
  YYSYMBOL_MINUS = 27,                     /* MINUS  */
  YYSYMBOL_TIMES = 28,                     /* TIMES  */
  YYSYMBOL_DIVIDED = 29,                   /* DIVIDED  */
  YYSYMBOL_REMAINDER = 30,                 /* REMAINDER  */
  YYSYMBOL_EQUAL = 31,                     /* EQUAL  */
  YYSYMBOL_DIFFERENT = 32,                 /* DIFFERENT  */
  YYSYMBOL_LESS = 33,                      /* LESS  */
  YYSYMBOL_LESS_OR_EQUAL = 34,             /* LESS_OR_EQUAL  */
  YYSYMBOL_GREATER = 35,                   /* GREATER  */
  YYSYMBOL_GREATER_OR_EQUAL = 36,          /* GREATER_OR_EQUAL  */
  YYSYMBOL_LOGICAL_OR = 37,                /* LOGICAL_OR  */
  YYSYMBOL_LOGICAL_AND = 38,               /* LOGICAL_AND  */
  YYSYMBOL_LOGICAL_NOT = 39,               /* LOGICAL_NOT  */
  YYSYMBOL_UNARY_MINUS = 40,               /* UNARY_MINUS  */
  YYSYMBOL_YYACCEPT = 41,                  /* $accept  */
  YYSYMBOL_program = 42,                   /* program  */
  YYSYMBOL_statement = 43,                 /* statement  */
  YYSYMBOL_if_statement = 44,              /* if_statement  */
  YYSYMBOL_if_statement_rest = 45,         /* if_statement_rest  */
  YYSYMBOL_statements = 46,                /* statements  */
  YYSYMBOL_one_or_more_statements = 47,    /* one_or_more_statements  */
  YYSYMBOL_block = 48,                     /* block  */
  YYSYMBOL_block_rest = 49,                /* block_rest  */
  YYSYMBOL_optional_initialization = 50,   /* optional_initialization  */
  YYSYMBOL_expression = 51,                /* expression  */
  YYSYMBOL_if_expression = 52,             /* if_expression  */
  YYSYMBOL_if_expression_rest = 53,        /* if_expression_rest  */
  YYSYMBOL_literal = 54,                   /* literal  */
  YYSYMBOL_variable = 55,                  /* variable  */
  YYSYMBOL_optional_skip = 56,             /* optional_skip  */
  YYSYMBOL_begin = 57,                     /* begin  */
  YYSYMBOL_end = 58                        /* end  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YYUSE(E) ((void) (E))
#else
# define YYUSE(E) /* empty */
#endif

#if defined __GNUC__ && ! defined __ICC && 407 <= __GNUC__ * 100 + __GNUC_MINOR__
/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                            \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined STRUCTURED_LTYPE_IS_TRIVIAL && STRUCTURED_LTYPE_IS_TRIVIAL \
             && defined STRUCTURED_STYPE_IS_TRIVIAL && STRUCTURED_STYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
  YYLTYPE yyls_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE) \
             + YYSIZEOF (YYLTYPE)) \
      + 2 * YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  33
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   396

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  41
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  18
/* YYNRULES -- Number of rules.  */
#define YYNRULES  54
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  112

#define YYMAXUTOK   295


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40
};

#if STRUCTURED_DEBUG
  /* YYRLINEYYN -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   241,   241,   246,   248,   252,   255,   257,   259,   274,
     281,   289,   292,   297,   303,   304,   309,   311,   315,   320,
     327,   329,   335,   336,   341,   344,   347,   349,   351,   353,
     355,   357,   359,   361,   363,   365,   367,   369,   371,   373,
     375,   383,   391,   393,   398,   408,   413,   418,   420,   422,
     427,   431,   433,   439,   446
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if STRUCTURED_DEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "BEGIN_", "END",
  "SKIP", "VAR", "PRINT", "INPUT", "SET_TO", "SEMICOLON", "COMMA", "IF",
  "THEN", "ELSE", "ELIF", "WHILE", "DO", "REPEAT", "UNTIL", "OPEN_PAREN",
  "CLOSE_PAREN", "VARIABLE", "DECIMAL_LITERAL", "TRUE", "FALSE", "PLUS",
  "MINUS", "TIMES", "DIVIDED", "REMAINDER", "EQUAL", "DIFFERENT", "LESS",
  "LESS_OR_EQUAL", "GREATER", "GREATER_OR_EQUAL", "LOGICAL_OR",
  "LOGICAL_AND", "LOGICAL_NOT", "UNARY_MINUS", "$accept", "program",
  "statement", "if_statement", "if_statement_rest", "statements",
  "one_or_more_statements", "block", "block_rest",
  "optional_initialization", "expression", "if_expression",
  "if_expression_rest", "literal", "variable", "optional_skip", "begin",
  "end", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#ifdef YYPRINT
/* YYTOKNUM[NUM] -- (External) token number corresponding to the
   (internal) symbol number NUM (which must be that of a token).  */
static const yytype_int16 yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295
};
#endif

#define YYPACT_NINF (-83)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-52)

#define yytable_value_is_error(Yyn) \
  0

  /* YYPACTSTATE-NUM -- Index in YYTABLE of the portion describing
     STATE-NUM.  */
static const yytype_int16 yypact[] =
{
      90,   -83,   -83,   -14,    10,    10,    10,    90,   -83,    14,
      90,   -83,   -83,     7,    11,    90,   -83,   -12,   -83,    10,
      10,   -83,   -83,   -83,    10,    10,   118,   -83,   -83,   -83,
     186,   311,    -2,   -83,   -83,    10,   -83,    16,    10,     1,
     212,   -83,   345,   -83,   -83,   -83,    10,    10,    10,    10,
      10,    10,    10,    10,    10,    10,    10,    10,    10,    90,
      90,    10,   147,   -83,   -83,   358,   347,   -14,   -83,    10,
     -83,   130,   130,   171,   195,   195,   -33,   -33,   -33,   -33,
     -33,   -33,   -13,   -83,     9,    16,   160,   -83,   -83,   -83,
     289,    90,    10,   -83,   -83,   -83,   -83,    10,    10,   -83,
      16,   238,   105,   264,   -83,    90,   -83,    10,     9,   289,
     -83,   -83
};

  /* YYDEFACTSTATE-NUM -- Default reduction number in state STATE-NUM.
     Performed when YYTABLE does not specify something else to do.  Zero
     means the default is an error.  */
static const yytype_int8 yydefact[] =
{
      14,    53,    52,     0,     0,     0,     0,    14,    50,     0,
      16,     2,    15,     0,     0,    14,    18,    22,    43,     0,
       0,    47,    48,    49,     0,     0,     0,    24,    25,     7,
       0,     0,     0,     1,    17,     0,     3,     0,     0,     0,
       0,    27,     0,    30,    42,     5,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    14,
      14,     0,     0,    54,     6,    23,    51,     0,    19,     0,
      26,    28,    29,    31,    32,    33,    34,    35,    36,    37,
      38,    39,    41,    40,     0,     0,     0,     4,    20,    21,
       0,    14,     0,    10,    11,     8,     9,     0,     0,    44,
       0,     0,     0,     0,    13,    14,    46,     0,     0,     0,
      12,    45
};

  /* YYPGOTONTERM-NUM.  */
static const yytype_int8 yypgoto[] =
{
     -83,   -83,   -83,   -83,   -82,    -6,    -4,   -40,   -83,   -83,
      23,   -83,   -78,   -83,     0,   -83,   -83,   -35
};

  /* YYDEFGOTONTERM-NUM.  */
static const yytype_int8 yydefgoto[] =
{
      -1,     9,    10,    29,    93,    11,    12,    16,    68,    39,
      26,    41,    99,    27,    28,    14,    15,    94
};

  /* YYTABLEYYPACT[STATE-NUM] -- What to do in state STATE-NUM.  If
     positive, shift that token.  If negative, reduce the rule whose
     number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int8 yytable[] =
{
      13,    32,    64,    17,    57,    58,    34,    13,     8,    37,
      13,    66,    67,    63,    33,    13,    35,    61,    18,    38,
      63,    36,    19,    91,    92,    58,   110,    89,    30,    31,
      20,   111,     8,    21,    22,    23,     0,    24,     0,     0,
       0,     0,    40,    42,     0,     0,     0,    43,    44,    25,
      95,     0,     0,    84,    85,     0,     0,     0,    62,    13,
      13,    65,    88,     0,     0,   104,    13,    17,     0,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,     0,     0,    86,   100,     0,     0,     0,     0,
       0,    13,    90,     1,     0,     2,     3,     4,     0,   108,
     -51,     0,     5,     0,     0,    13,     6,     0,     7,   106,
       0,     0,     8,     0,     0,   101,     0,     0,     0,     0,
     102,   103,     0,     0,     0,     0,     0,     0,    45,     0,
     109,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    87,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,     0,
      96,     0,     0,    46,    47,    48,    49,    50,    51,    52,
      53,    54,    55,    56,    57,    58,    46,    47,    48,    49,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
       0,     0,    46,    47,    48,    49,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    69,    51,    52,    53,    54,
      55,    56,    57,    58,     0,     0,     0,     0,    46,    47,
      48,    49,    50,    51,    52,    53,    54,    55,    56,    57,
      58,   105,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,   107,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      46,    47,    48,    49,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    97,    98,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    46,    47,    48,    49,    50,
      51,    52,    53,    54,    55,    56,    57,    58,    60,     0,
       0,     0,     0,     0,     0,     0,     0,    46,    47,    48,
      49,    50,    51,    52,    53,    54,    55,    56,    57,    58,
       1,     0,     2,     3,     4,     0,     0,     0,     0,     5,
       0,     0,     0,     6,     0,     7,    70,     0,     0,     8,
       0,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58
};

static const yytype_int8 yycheck[] =
{
       0,     7,    37,     3,    37,    38,    10,     7,    22,    15,
      10,    10,    11,     4,     0,    15,     9,    19,     8,    31,
       4,    10,    12,    14,    15,    38,   108,    67,     5,     6,
      20,   109,    22,    23,    24,    25,    -1,    27,    -1,    -1,
      -1,    -1,    19,    20,    -1,    -1,    -1,    24,    25,    39,
      85,    -1,    -1,    59,    60,    -1,    -1,    -1,    35,    59,
      60,    38,    66,    -1,    -1,   100,    66,    67,    -1,    46,
      47,    48,    49,    50,    51,    52,    53,    54,    55,    56,
      57,    58,    -1,    -1,    61,    91,    -1,    -1,    -1,    -1,
      -1,    91,    69,     3,    -1,     5,     6,     7,    -1,   105,
      10,    -1,    12,    -1,    -1,   105,    16,    -1,    18,     4,
      -1,    -1,    22,    -1,    -1,    92,    -1,    -1,    -1,    -1,
      97,    98,    -1,    -1,    -1,    -1,    -1,    -1,    10,    -1,
     107,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    10,    28,    29,
      30,    31,    32,    33,    34,    35,    36,    37,    38,    -1,
      10,    -1,    -1,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    36,    37,    38,    13,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    38,
      -1,    -1,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    13,    31,    32,    33,    34,
      35,    36,    37,    38,    -1,    -1,    -1,    -1,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    13,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    13,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      26,    27,    28,    29,    30,    31,    32,    33,    34,    35,
      36,    37,    38,    14,    15,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    26,    27,    28,    29,    30,
      31,    32,    33,    34,    35,    36,    37,    38,    17,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    37,    38,
       3,    -1,     5,     6,     7,    -1,    -1,    -1,    -1,    12,
      -1,    -1,    -1,    16,    -1,    18,    21,    -1,    -1,    22,
      -1,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    36,    37,    38
};

  /* YYSTOSSTATE-NUM -- The (internal number of the) accessing
     symbol of state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,     3,     5,     6,     7,    12,    16,    18,    22,    42,
      43,    46,    47,    55,    56,    57,    48,    55,     8,    12,
      20,    23,    24,    25,    27,    39,    51,    54,    55,    44,
      51,    51,    46,     0,    47,     9,    10,    46,    31,    50,
      51,    52,    51,    51,    51,    10,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,    36,    37,    38,    13,
      17,    19,    51,     4,    58,    51,    10,    11,    49,    13,
      21,    51,    51,    51,    51,    51,    51,    51,    51,    51,
      51,    51,    51,    51,    46,    46,    51,    10,    47,    48,
      51,    14,    15,    45,    58,    58,    10,    14,    15,    53,
      46,    51,    51,    51,    58,    13,     4,    13,    46,    51,
      45,    53
};

  /* YYR1YYN -- Symbol number of symbol that rule YYN derives.  */
static const yytype_int8 yyr1[] =
{
       0,    41,    42,    43,    43,    43,    43,    43,    43,    43,
      44,    45,    45,    45,    46,    46,    47,    47,    47,    48,
      49,    49,    50,    50,    51,    51,    51,    51,    51,    51,
      51,    51,    51,    51,    51,    51,    51,    51,    51,    51,
      51,    51,    51,    51,    52,    53,    53,    54,    54,    54,
      55,    56,    56,    57,    58
};

  /* YYR2YYN -- Number of symbols on the right hand side of rule YYN.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     2,     4,     3,     3,     2,     5,     5,
       4,     1,     5,     3,     0,     1,     1,     2,     2,     3,
       2,     2,     0,     2,     1,     1,     3,     2,     3,     3,
       2,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     2,     1,     4,     5,     3,     1,     1,     1,
       1,     0,     1,     1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = STRUCTURED_EMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == STRUCTURED_EMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (&yylloc, p, structured_scanner, YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use STRUCTURED_error or STRUCTURED_UNDEF. */
#define YYERRCODE STRUCTURED_UNDEF

/* YYLLOC_DEFAULT -- Set CURRENT to span from RHS[1] to RHS[N].
   If N is 0, then set CURRENT to the empty location which ends
   the previous symbol: RHS[0] (always defined).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)                                \
    do                                                                  \
      if (N)                                                            \
        {                                                               \
          (Current).first_line   = YYRHSLOC (Rhs, 1).first_line;        \
          (Current).first_column = YYRHSLOC (Rhs, 1).first_column;      \
          (Current).last_line    = YYRHSLOC (Rhs, N).last_line;         \
          (Current).last_column  = YYRHSLOC (Rhs, N).last_column;       \
        }                                                               \
      else                                                              \
        {                                                               \
          (Current).first_line   = (Current).last_line   =              \
            YYRHSLOC (Rhs, 0).last_line;                                \
          (Current).first_column = (Current).last_column =              \
            YYRHSLOC (Rhs, 0).last_column;                              \
        }                                                               \
    while (0)
#endif

#define YYRHSLOC(Rhs, K) ((Rhs)[K])


/* Enable debugging if requested.  */
#if STRUCTURED_DEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)


/* YY_LOCATION_PRINT -- Print the location on the stream.
   This macro was not mandated originally: define only if we know
   we won't break user code: when these are the locations we know.  */

# ifndef YY_LOCATION_PRINT
#  if defined STRUCTURED_LTYPE_IS_TRIVIAL && STRUCTURED_LTYPE_IS_TRIVIAL

/* Print *YYLOCP on YYO.  Private, do not rely on its existence. */

YY_ATTRIBUTE_UNUSED
static int
yy_location_print_ (FILE *yyo, YYLTYPE const * const yylocp)
{
  int res = 0;
  int end_col = 0 != yylocp->last_column ? yylocp->last_column - 1 : 0;
  if (0 <= yylocp->first_line)
    {
      res += YYFPRINTF (yyo, "%d", yylocp->first_line);
      if (0 <= yylocp->first_column)
        res += YYFPRINTF (yyo, ".%d", yylocp->first_column);
    }
  if (0 <= yylocp->last_line)
    {
      if (yylocp->first_line < yylocp->last_line)
        {
          res += YYFPRINTF (yyo, "-%d", yylocp->last_line);
          if (0 <= end_col)
            res += YYFPRINTF (yyo, ".%d", end_col);
        }
      else if (0 <= end_col && yylocp->first_column < end_col)
        res += YYFPRINTF (yyo, "-%d", end_col);
    }
  return res;
 }

#   define YY_LOCATION_PRINT(File, Loc)          \
  yy_location_print_ (File, &(Loc))

#  else
#   define YY_LOCATION_PRINT(File, Loc) ((void) 0)
#  endif
# endif /* !defined YY_LOCATION_PRINT */


# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value, Location, p, structured_scanner); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, struct structured_program *p, void* structured_scanner)
{
  FILE *yyoutput = yyo;
  YYUSE (yyoutput);
  YYUSE (yylocationp);
  YYUSE (p);
  YYUSE (structured_scanner);
  if (!yyvaluep)
    return;
# ifdef YYPRINT
  if (yykind < YYNTOKENS)
    YYPRINT (yyo, yytoknum[yykind], *yyvaluep);
# endif
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep, YYLTYPE const * const yylocationp, struct structured_program *p, void* structured_scanner)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  YY_LOCATION_PRINT (yyo, *yylocationp);
  YYFPRINTF (yyo, ": ");
  yy_symbol_value_print (yyo, yykind, yyvaluep, yylocationp, p, structured_scanner);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp, YYLTYPE *yylsp,
                 int yyrule, struct structured_program *p, void* structured_scanner)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)],
                       &(yylsp[(yyi + 1) - (yynrhs)]), p, structured_scanner);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, yylsp, Rule, p, structured_scanner); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !STRUCTURED_DEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !STRUCTURED_DEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep, YYLTYPE *yylocationp, struct structured_program *p, void* structured_scanner)
{
  YYUSE (yyvaluep);
  YYUSE (yylocationp);
  YYUSE (p);
  YYUSE (structured_scanner);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YYUSE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}






/*----------.
| yyparse.  |
`----------*/

int
yyparse (struct structured_program *p, void* structured_scanner)
{
/* The lookahead symbol.  */
int yychar;


/* The semantic value of the lookahead symbol.  */
/* Default value used for initialization, for pacifying older GCCs
   or non-GCC compilers.  */
YY_INITIAL_VALUE (static YYSTYPE yyval_default;)
YYSTYPE yylval YY_INITIAL_VALUE (= yyval_default);

/* Location data for the lookahead symbol.  */
static YYLTYPE yyloc_default
# if defined STRUCTURED_LTYPE_IS_TRIVIAL && STRUCTURED_LTYPE_IS_TRIVIAL
  = { 1, 1, 1, 1 }
# endif
;
YYLTYPE yylloc = yyloc_default;

    /* Number of syntax errors so far.  */
    int yynerrs;

    yy_state_fast_t yystate;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus;

    /* The stacks and their tools:
       'yyss': related to states.
       'yyvs': related to semantic values.
       'yyls': related to locations.

       Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize;

    /* The state stack.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss;
    yy_state_t *yyssp;

    /* The semantic value stack.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs;
    YYSTYPE *yyvsp;

    /* The location stack.  */
    YYLTYPE yylsa[YYINITDEPTH];
    YYLTYPE *yyls;
    YYLTYPE *yylsp;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead token as an internal (translated) token number.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;
  YYLTYPE yyloc;

  /* The locations where the error started and ended.  */
  YYLTYPE yyerror_range[3];



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N), yylsp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  yynerrs = 0;
  yystate = 0;
  yyerrstatus = 0;

  yystacksize = YYINITDEPTH;
  yyssp = yyss = yyssa;
  yyvsp = yyvs = yyvsa;
  yylsp = yyls = yylsa;


  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = STRUCTURED_EMPTY; /* Cause a token to be read.  */
  yylsp[0] = yylloc;
  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    goto yyexhaustedlab;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;
        YYLTYPE *yyls1 = yyls;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yyls1, yysize * YYSIZEOF (*yylsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
        yyls = yyls1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        goto yyexhaustedlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          goto yyexhaustedlab;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
        YYSTACK_RELOCATE (yyls_alloc, yyls);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;
      yylsp = yyls + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */

  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == STRUCTURED_EMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex (&yylval, &yylloc, structured_scanner);
    }

  if (yychar <= STRUCTURED_EOF)
    {
      yychar = STRUCTURED_EOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == STRUCTURED_error)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = STRUCTURED_UNDEF;
      yytoken = YYSYMBOL_YYerror;
      yyerror_range[1] = yylloc;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END
  *++yylsp = yylloc;

  /* Discard the shifted token.  */
  yychar = STRUCTURED_EMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];

  /* Default location. */
  YYLLOC_DEFAULT (yyloc, (yylsp - yylen), yylen);
  yyerror_range[1] = yyloc;
  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2:
#line 242 "../../jitter/example-vms/structured/structured.y"
  { p->main_statement = (yyvsp[0].statement); }
#line 1664 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 3:
#line 247 "../../jitter/example-vms/structured/structured.y"
  { (yyval.statement) = structured_make_statement (structured_statement_case_skip); }
#line 1670 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 4:
#line 249 "../../jitter/example-vms/structured/structured.y"
  { (yyval.statement) = structured_make_statement (structured_statement_case_assignment);
    (yyval.statement)->assignment_variable = (yyvsp[-3].variable);
    (yyval.statement)->assignment_expression = (yyvsp[-1].expression); }
#line 1678 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 5:
#line 253 "../../jitter/example-vms/structured/structured.y"
  { (yyval.statement) = structured_make_statement (structured_statement_case_print);
    (yyval.statement)->print_expression = (yyvsp[-1].expression); }
#line 1685 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 6:
#line 256 "../../jitter/example-vms/structured/structured.y"
  { (yyval.statement) = (yyvsp[-1].statement); }
#line 1691 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 7:
#line 258 "../../jitter/example-vms/structured/structured.y"
  { (yyval.statement) = (yyvsp[0].statement); }
#line 1697 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 8:
#line 260 "../../jitter/example-vms/structured/structured.y"
  { /* Parse "while A do B end" as "if A then repeat B until not A else
       skip". */
    struct structured_statement *r
      = structured_make_statement (structured_statement_case_repeat_until);
    r->repeat_until_body = (yyvsp[-1].statement);
    /* FIXME: clone $2 into a separate heap object, if I want to be able to free
       ASTs. */
    r->repeat_until_guard
      = structured_make_unary (structured_primitive_logical_not, (yyvsp[-3].expression));
    (yyval.statement) = structured_make_statement (structured_statement_case_if_then_else);
    (yyval.statement)->if_then_else_condition = (yyvsp[-3].expression);
    (yyval.statement)->if_then_else_then_branch = r;
    (yyval.statement)->if_then_else_else_branch
      = structured_make_statement (structured_statement_case_skip); }
#line 1716 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 9:
#line 275 "../../jitter/example-vms/structured/structured.y"
  { (yyval.statement) = structured_make_statement (structured_statement_case_repeat_until);
    (yyval.statement)->repeat_until_body = (yyvsp[-3].statement);
    (yyval.statement)->repeat_until_guard = (yyvsp[-1].expression); }
#line 1724 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 10:
#line 282 "../../jitter/example-vms/structured/structured.y"
  { (yyval.statement) = structured_make_statement (structured_statement_case_if_then_else);
    (yyval.statement)->if_then_else_condition = (yyvsp[-3].expression);
    (yyval.statement)->if_then_else_then_branch = (yyvsp[-1].statement);
    (yyval.statement)->if_then_else_else_branch = (yyvsp[0].statement); }
#line 1733 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 11:
#line 290 "../../jitter/example-vms/structured/structured.y"
  { /* Parse "if A then B end" as "if A then B else skip end". */
    (yyval.statement) = structured_make_statement (structured_statement_case_skip); }
#line 1740 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 12:
#line 293 "../../jitter/example-vms/structured/structured.y"
  { (yyval.statement) = structured_make_statement (structured_statement_case_if_then_else);
    (yyval.statement)->if_then_else_condition = (yyvsp[-3].expression);
    (yyval.statement)->if_then_else_then_branch = (yyvsp[-1].statement);
    (yyval.statement)->if_then_else_else_branch = (yyvsp[0].statement); }
#line 1749 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 13:
#line 298 "../../jitter/example-vms/structured/structured.y"
  { (yyval.statement) = (yyvsp[-1].statement); }
#line 1755 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 14:
#line 303 "../../jitter/example-vms/structured/structured.y"
  { (yyval.statement) = structured_make_statement (structured_statement_case_skip); }
#line 1761 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 15:
#line 305 "../../jitter/example-vms/structured/structured.y"
  { (yyval.statement) = (yyvsp[0].statement); }
#line 1767 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 16:
#line 310 "../../jitter/example-vms/structured/structured.y"
  { (yyval.statement) = (yyvsp[0].statement); }
#line 1773 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 17:
#line 312 "../../jitter/example-vms/structured/structured.y"
  { (yyval.statement) = structured_make_statement (structured_statement_case_sequence);
    (yyval.statement)->sequence_statement_0 = (yyvsp[-1].statement);
    (yyval.statement)->sequence_statement_1 = (yyvsp[0].statement); }
#line 1781 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 18:
#line 316 "../../jitter/example-vms/structured/structured.y"
  { (yyval.statement) = (yyvsp[0].statement); }
#line 1787 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 19:
#line 321 "../../jitter/example-vms/structured/structured.y"
  { (yyval.statement) = structured_make_statement (structured_statement_case_block);
    (yyval.statement)->block_variable = (yyvsp[-2].variable);
    (yyval.statement)->block_body = structured_with_optional_initialization ((yyvsp[-2].variable), (yyvsp[-1].expression), (yyvsp[0].statement)); }
#line 1795 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 20:
#line 328 "../../jitter/example-vms/structured/structured.y"
  { (yyval.statement) = (yyvsp[0].statement); }
#line 1801 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 21:
#line 330 "../../jitter/example-vms/structured/structured.y"
  { (yyval.statement) = (yyvsp[0].statement); }
#line 1807 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 22:
#line 335 "../../jitter/example-vms/structured/structured.y"
  { (yyval.expression) = NULL; }
#line 1813 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 23:
#line 337 "../../jitter/example-vms/structured/structured.y"
  { (yyval.expression) = (yyvsp[0].expression); }
#line 1819 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 24:
#line 342 "../../jitter/example-vms/structured/structured.y"
  { (yyval.expression) = structured_make_expression (structured_expression_case_literal);
    (yyval.expression)->literal = (yyvsp[0].literal); }
#line 1826 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 25:
#line 345 "../../jitter/example-vms/structured/structured.y"
  { (yyval.expression) = structured_make_expression (structured_expression_case_variable);
    (yyval.expression)->variable = (yyvsp[0].variable); }
#line 1833 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 26:
#line 348 "../../jitter/example-vms/structured/structured.y"
  { (yyval.expression) = (yyvsp[-1].expression); }
#line 1839 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 27:
#line 350 "../../jitter/example-vms/structured/structured.y"
  { (yyval.expression) = (yyvsp[0].expression); }
#line 1845 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 28:
#line 352 "../../jitter/example-vms/structured/structured.y"
  { (yyval.expression) = structured_make_binary (structured_primitive_plus, (yyvsp[-2].expression), (yyvsp[0].expression)); }
#line 1851 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 29:
#line 354 "../../jitter/example-vms/structured/structured.y"
  { (yyval.expression) = structured_make_binary (structured_primitive_minus, (yyvsp[-2].expression), (yyvsp[0].expression)); }
#line 1857 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 30:
#line 356 "../../jitter/example-vms/structured/structured.y"
  { (yyval.expression) = structured_make_unary (structured_primitive_unary_minus, (yyvsp[0].expression)); }
#line 1863 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 31:
#line 358 "../../jitter/example-vms/structured/structured.y"
  { (yyval.expression) = structured_make_binary (structured_primitive_times, (yyvsp[-2].expression), (yyvsp[0].expression)); }
#line 1869 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 32:
#line 360 "../../jitter/example-vms/structured/structured.y"
  { (yyval.expression) = structured_make_binary (structured_primitive_divided, (yyvsp[-2].expression), (yyvsp[0].expression)); }
#line 1875 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 33:
#line 362 "../../jitter/example-vms/structured/structured.y"
  { (yyval.expression) = structured_make_binary (structured_primitive_remainder, (yyvsp[-2].expression), (yyvsp[0].expression)); }
#line 1881 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 34:
#line 364 "../../jitter/example-vms/structured/structured.y"
  { (yyval.expression) = structured_make_binary (structured_primitive_equal, (yyvsp[-2].expression), (yyvsp[0].expression)); }
#line 1887 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 35:
#line 366 "../../jitter/example-vms/structured/structured.y"
  { (yyval.expression) = structured_make_binary (structured_primitive_different, (yyvsp[-2].expression), (yyvsp[0].expression)); }
#line 1893 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 36:
#line 368 "../../jitter/example-vms/structured/structured.y"
  { (yyval.expression) = structured_make_binary (structured_primitive_less, (yyvsp[-2].expression), (yyvsp[0].expression)); }
#line 1899 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 37:
#line 370 "../../jitter/example-vms/structured/structured.y"
  { (yyval.expression) = structured_make_binary (structured_primitive_less_or_equal, (yyvsp[-2].expression), (yyvsp[0].expression)); }
#line 1905 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 38:
#line 372 "../../jitter/example-vms/structured/structured.y"
  { (yyval.expression) = structured_make_binary (structured_primitive_greater, (yyvsp[-2].expression), (yyvsp[0].expression)); }
#line 1911 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 39:
#line 374 "../../jitter/example-vms/structured/structured.y"
  { (yyval.expression) = structured_make_binary (structured_primitive_greater_or_equal, (yyvsp[-2].expression), (yyvsp[0].expression)); }
#line 1917 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 40:
#line 376 "../../jitter/example-vms/structured/structured.y"
  { /* Parse "A and B" as "if A then B else false end". */
    (yyval.expression) = structured_make_expression (structured_expression_case_if_then_else);
    (yyval.expression)->if_then_else_condition = (yyvsp[-2].expression);
    (yyval.expression)->if_then_else_then_branch = (yyvsp[0].expression);
    (yyval.expression)->if_then_else_else_branch
      = structured_make_expression (structured_expression_case_literal);
    (yyval.expression)->if_then_else_else_branch->literal = 0; }
#line 1929 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 41:
#line 384 "../../jitter/example-vms/structured/structured.y"
  { /* Parse "A or B" as "if A then true else B end". */
    (yyval.expression) = structured_make_expression (structured_expression_case_if_then_else);
    (yyval.expression)->if_then_else_condition = (yyvsp[-2].expression);
    (yyval.expression)->if_then_else_then_branch
      = structured_make_expression (structured_expression_case_literal);
    (yyval.expression)->if_then_else_then_branch->literal = 1;
    (yyval.expression)->if_then_else_else_branch = (yyvsp[0].expression); }
#line 1941 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 42:
#line 392 "../../jitter/example-vms/structured/structured.y"
  { (yyval.expression) = structured_make_unary (structured_primitive_logical_not, (yyvsp[0].expression)); }
#line 1947 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 43:
#line 394 "../../jitter/example-vms/structured/structured.y"
  { (yyval.expression) = structured_make_nullary (structured_primitive_input); }
#line 1953 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 44:
#line 399 "../../jitter/example-vms/structured/structured.y"
  { (yyval.expression) = structured_make_expression (structured_expression_case_if_then_else);
    (yyval.expression)->if_then_else_condition = (yyvsp[-3].expression);
    (yyval.expression)->if_then_else_then_branch = (yyvsp[-1].expression);
    (yyval.expression)->if_then_else_else_branch = (yyvsp[0].expression); }
#line 1962 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 45:
#line 409 "../../jitter/example-vms/structured/structured.y"
  { (yyval.expression) = structured_make_expression (structured_expression_case_if_then_else);
    (yyval.expression)->if_then_else_condition = (yyvsp[-3].expression);
    (yyval.expression)->if_then_else_then_branch = (yyvsp[-1].expression);
    (yyval.expression)->if_then_else_else_branch = (yyvsp[0].expression); }
#line 1971 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 46:
#line 414 "../../jitter/example-vms/structured/structured.y"
  { (yyval.expression) = (yyvsp[-1].expression); }
#line 1977 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 47:
#line 419 "../../jitter/example-vms/structured/structured.y"
  { (yyval.literal) = jitter_string_to_long_long_unsafe (STRUCTURED_TEXT); }
#line 1983 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 48:
#line 421 "../../jitter/example-vms/structured/structured.y"
  { (yyval.literal) = 1; }
#line 1989 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 49:
#line 423 "../../jitter/example-vms/structured/structured.y"
  { (yyval.literal) = 0; }
#line 1995 "../../jitter/example-vms/structured/structured-parser.c"
    break;

  case 50:
#line 428 "../../jitter/example-vms/structured/structured.y"
  { (yyval.variable) = STRUCTURED_TEXT_COPY; }
#line 2001 "../../jitter/example-vms/structured/structured-parser.c"
    break;


#line 2005 "../../jitter/example-vms/structured/structured-parser.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;
  *++yylsp = yyloc;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == STRUCTURED_EMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (&yylloc, p, structured_scanner, YY_("syntax error"));
    }

  yyerror_range[1] = yylloc;
  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= STRUCTURED_EOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == STRUCTURED_EOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval, &yylloc, p, structured_scanner);
          yychar = STRUCTURED_EMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;

      yyerror_range[1] = *yylsp;
      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp, yylsp, p, structured_scanner);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  yyerror_range[2] = yylloc;
  ++yylsp;
  YYLLOC_DEFAULT (*yylsp, yyerror_range, 2);

  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;


#if !defined yyoverflow
/*-------------------------------------------------.
| yyexhaustedlab -- memory exhaustion comes here.  |
`-------------------------------------------------*/
yyexhaustedlab:
  yyerror (&yylloc, p, structured_scanner, YY_("memory exhausted"));
  yyresult = 2;
  /* Fall through.  */
#endif


/*-----------------------------------------------------.
| yyreturn -- parsing is finished, return the result.  |
`-----------------------------------------------------*/
yyreturn:
  if (yychar != STRUCTURED_EMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval, &yylloc, p, structured_scanner);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp, yylsp, p, structured_scanner);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 450 "../../jitter/example-vms/structured/structured.y"


void
structured_error (YYLTYPE *locp, struct structured_program *p, yyscan_t structured_scanner,
                 char *message)
{
  printf ("%s:%i: %s near \"%s\".\n",
          (p != NULL) ? p->source_file_name : "<INPUT>",
          structured_get_lineno (structured_scanner), message, STRUCTURED_TEXT);
  exit (EXIT_FAILURE);
}

void
structured_scan_error (void *structured_scanner)
{
  struct structured_program *p = NULL; /* A little hack to have p in scope. */
  STRUCTURED_PARSE_ERROR("scan error");
}

static struct structured_program *
structured_parse_file_star_with_name (FILE *input_file, const char *file_name)
{
  yyscan_t scanner;
  structured_lex_init (&scanner);
  structured_set_in (input_file, scanner);

  struct structured_program *res
    = jitter_xmalloc (sizeof (struct structured_program));
  res->source_file_name = jitter_clone_string (file_name);
  /* FIXME: if I ever make parsing errors non-fatal, call structured_lex_destroy before
     returning, and finalize the program -- which might be incomplete! */
  if (structured_parse (res, scanner))
    structured_error (structured_get_lloc (scanner), res, scanner, "parse error");
  structured_set_in (NULL, scanner);
  structured_lex_destroy (scanner);

  return res;
}

struct structured_program *
structured_parse_file_star (FILE *input_file)
{
  return structured_parse_file_star_with_name (input_file, "<stdin>");
}

struct structured_program *
structured_parse_file (const char *input_file_name)
{
  FILE *f;
  if ((f = fopen (input_file_name, "r")) == NULL)
    jitter_fatal ("failed opening file %s", input_file_name);

  /* FIXME: if I ever make parse errors non-fatal, I'll need to close the file
     before returning. */
  struct structured_program *res
    = structured_parse_file_star_with_name (f, input_file_name);
  fclose (f);
  return res;
}
