
;;; (simbad-patch--parse-current-line)
;;; Foo.java:123
(defun simbad-patch--parse-current-line ()
  (save-excursion
    (if (re-search-forward "\\.java" (point-at-eol) t)
        (let (p p1 p2)
          (setq p (point))
          (skip-chars-backward "a-z" (point-at-bol)) ;;; skips java
          (skip-chars-backward "."   (point-at-bol)) ;;; skips .
          (skip-chars-backward "a-zA-Z0-9_" (point-at-bol))
          (setq p1 (point))
          (goto-char p)
          (skip-chars-forward ":" (point-at-eol))
          (skip-chars-forward "0-9" (point-at-eol))
          (setq p2 (point))
          (buffer-substring-no-properties p1 p2)))))

;;; (simbad-patch--split-file-line (setq file-line "Foo.java:123"))
(defun simbad-patch--split-file-line (file-line)
 (if (and file-line (string-match "\\(.*\\):\\(.*\\)" file-line))
     (let ((file (substring file-line (match-beginning 1) (match-end 1)))
           (line (read-str (substring file-line (match-beginning 2) (match-end 2)))))
       (cons file line))))

(require 'compile)

(defadvice compile-goto-error (around simbad-patch activate)
 (interactive)
 ;;(d-foo)
 (if (string-match (expand-file-name "~/tmp-project/") (expand-file-name default-directory))
    (let* ((fl (simbad-patch--split-file-line (simbad-patch--parse-current-line)))
           (f   (car fl))
           (l   (cdr fl)))
      (cond
       ((not fl)
        (error "File is nil"))

       ((and f l (file-exists-p (setq f2 (concat "~/workspace/project/src/BusinessLogic/" f))))
        (find-file f2)
        (goto-line l))

       ((and f l (file-exists-p (setq f2 (concat "~/workspace/project/src/ClientServer/" f))))
        (find-file f2)
        (goto-line l))

       ((and f l (file-exists-p (setq f2 (concat "~/workspace/project/src/Gui/" f))))
        (find-file f2)
        (goto-line l))

       ((and f l (file-exists-p (setq f2 (concat "~/workspace/project/src/Testers/" f))))
        (find-file f2)
        (goto-line l))

       ((and f l (file-exists-p (setq f2 (concat "~/workspace/project/src/Util/" f))))
        (find-file f2)
        (goto-line l))

       ((and f l (file-exists-p (setq f2 (concat "~/workspace/project/src/XML/" f))))
        (find-file f2)
        (goto-line l))

       ((file-exists-p f)
        (d-beep "Warning file %s not found in workspace" f)
        (find-file f)
        (goto-line l))

       (t
        ad-do-it)
        ;;(error "File %s not found" f)

        )))
  ad-do-it)
;;(define-key compilation-mode-map [return] 'simbad-patch--compile-goto-error)

(defadvice d-find-file (around simbad-patch activate)
 (let (done)
   (if (string= (buffer-file-name) filename)
       (progn
         ;;(d-beeps "filename=%s (buffer-file-name)=%s" filename (buffer-file-name))
         ;;(d-foo)
         (dired (file-name-directory filename))
         (setq done t))

     (when (string-match (expand-file-name "~/tmp-project/.+") (expand-file-name filename))
       (let ((fnd (file-name-nondirectory filename))
             (f2  nil))
         (cond

          ((string= fnd "")
           ad-do-it
           (setq done t))

          ((file-exists-p (setq f2 (concat "~/workspace/project/src/BusinessLogic/" fnd)))
           (find-file f2)
           (setq done t))
          ((file-exists-p (setq f2 (concat "~/workspace/project/src/ClientServer/" fnd)))
           (find-file f2)
           (setq done t))
          ((file-exists-p (setq f2 (concat "~/workspace/project/src/Gui/" fnd)))
           (find-file f2)
           (setq done t))
          ((file-exists-p (setq f2 (concat "~/workspace/project/src/Testers/" fnd)))
           (find-file f2)
           (setq done t))
          ((file-exists-p (setq f2 (concat "~/workspace/project/src/Util/" fnd)))
           (find-file f2)
           (setq done t))
          ((file-exists-p (setq f2 (concat "~/workspace/project/src/XML/" fnd)))
           (find-file f2)
           (setq done t))
          (t
           (d-beep "Warning file %s not found in workspace" fnd)
           ad-do-it
           (setq done t))))))
   (if (not done)
       ad-do-it)))

(defadvice d-f9 (around simbad-patch activate)

  (if (not (file-exists-p "~/tmp-project/"))
      (make-directory "~/tmp-project/"))

  (if (string-match "^c:/Documents and Settings/Davin Pearson/My Documents/" (expand-file-name default-directory))
      (dired "~/tmp-project/"))

  (if (string-match (expand-file-name "~/Superwiki") (expand-file-name default-directory))
      (dired "~/tmp-project/"))

  (if (string= (expand-file-name "~/") (expand-file-name default-directory))
      (dired "~/tmp-project/"))

  (if (string-match (concat "^" (expand-file-name "~/tmp-project/")) (expand-file-name default-directory))
      (dired "~/tmp-project/"))

  (if (string-match (concat "^" (expand-file-name "~/workspace/")) (expand-file-name default-directory))
      (dired "~/tmp-project/"))
  (delete-other-windows)
  ad-do-it
  )

(defadvice d-shift-f9 (around simbad-patch activate)

  (if (not (file-exists-p "~/tmp-project/"))
      (make-directory "~/tmp-project/"))

  (if (string-match "^c:/Documents and Settings/Davin Pearson/My Documents/" (expand-file-name default-directory))
      (dired "~/tmp-project/"))

  (if (string-match (expand-file-name "~/Superwiki") (expand-file-name default-directory))
      (dired "~/tmp-project/"))

  (if (string= (expand-file-name "~/") (expand-file-name default-directory))
      (dired "~/tmp-project/"))

  (if (string-match (concat "^" (expand-file-name "~/tmp-project/")) (expand-file-name default-directory))
      (dired "~/tmp-project/"))

  (if (string-match (concat "^" (expand-file-name "~/workspace/")) (expand-file-name default-directory))
      (dired "~/tmp-project/"))
  ad-do-it
  )

(setq completion-ignored-extensions (append (list ".cfg"
                                                  ".wik") completion-ignored-extensions))
(setq auto-mode-alist (append '( ("\\.cfg$"   . hexl-mode)
                                 ("\\.wik$"   . hexl-mode)) auto-mode-alist))

(setq d-files-list--unimportant (remove "bak" d-files-list--unimportant))
(setq d-files-regexp--unimportant (d-dired--make-choice-regexp d-files-list--unimportant))

(setq compile-history (cons "make simbad-clean copy gui tar" compile-history))

(defun simbad-make-depend ()
  (save-window-excursion
    (let* (list ptr)
      (setq list (directory-files-deep "~/tmp-project/" t "\\.java$"))
      (setq ptr list)
      (find-file "~/tmp-project/Makefile.mk")
      (erase-buffer)
      (while ptr
        (insert (concat "Gui/Gui.run: " (substring (car ptr) 37 (- (length (car ptr)) 5)) ".class\n"))
        (setq ptr (cdr ptr)))
      (save-buffer)
      (kill-buffer nil))))

(defun simbad-mode ()
  (interactive)
  (if (or (not (boundp 'simbad-mode)) (not simbad-mode))
      (progn
        (setq simbad-mode t)
        (setq-default c-basic-offset 4)
        (message "Simbad Mode On"))
    (setq simbad-mode nil)
    (setq-default c-basic-offset 3)
    (message "Simbad Mode Off")))

(simbad-mode)

;;(setq minor-mode-alist (cons '(simbad-mode " SIMBAD") minor-mode-alist))

;;;
;;; BETTER:
;;;
(setcar (last minor-mode-alist) (cons '(simbad-mode " SIMBAD") nil))

;;(setq list '(1 2 3))
;;(last list)
;;(setcdr (last list) (cons 44 nil))

(provide 'simbad-patch)

